/*
 *				c s l e s s . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	csless	Remove an Element From a Cset
index		Remove an element from a cset

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 CSET *
	 csless(cs,c)
	 CSET *cs;
	 int c;

description

	The element c, which is generally a character, is removed from the
	cset cs if it is a member.  If c is not a member, cs is unchanged.
	This call modifies the actual cset cs, whatever the value of csunique.

	cs itself is returned.

	Note:  c is not validated; c < 0 or c >= cs may cause random bits
	in memory to be changed.  However, csmask is used to control unwanted
	sign extension - see cset().

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=00
 * Edit history
 * 0.0 16-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif

CSET *
csless(cs,c)
register CSET *cs;
int c;
{
	if ((int)cs & 1)			/* Complemented cset	*/
		return(cscomp(cswith(cscomp(cs),c)));
						/* Use DeMorgan's law	*/
	cs->table[c & csmask] &= ~cs->mask;	/* Remove it		*/
	return(cs);
}
                                                                                                                                                                                                                                                                                                                                                                                    