	PROGRAM COM				!Rev 8209.051
C
C	'COM' is a program that uses the modem driver MO: to provide
C	communication between a PDP-11 running under TSX and a remote
C	VAX running under VMS.
C
C	'COM' has three states:  transparent, command, and transmit.
C	In transparent mode the user terminal looks like it is attached
C	directly to the remote VAX.  In command mode the user may give
C	specific commands to 'COM' to send files, ask for help, or exit
C	to TSX.  In transmit mode 'COM' is in the process of transmitting
C	a file from one computer to the other.
C
C	'COM' starts up in the transparent mode.  To enter the command
C	mode, type <CTRL-A>.  In the command mode the following single
C	letter commands may be typed:
C		E - Exit to TSX
C		R - Receive  a file from the VAX
C		T - Transmit a file to   the VAX
C	The Receive and Transmit commands will cause the program to
C	prompt you for more information.
C
C	Author:	Robert Walraven
C			Applied Science, University of California
C			Davis, CA  95616,           (916)752-0360
C
C----------------------------------------------------------------------
C
	INTEGER NONE, CMND, EXIT, RECV, TRAN, REPLY
	DATA    NONE, CMND, EXIT, RECV, TRAN
     1       /-1  ,   0 , 'E' , 'R' , 'T' /
C
C...................Do one time only stuff.............................
C
	CALL 		START P!rocedures for program
C
C..........................Main loop...................................
C
			WRITE (5,100)
   10	CALL		READ MO!dem
	CALL		READ TE!rminal
     1		(REPLY)
			IF (REPLY .LE. NONE) GO TO 10
			IF (REPLY .EQ. CMND) GO TO 20
	CALL		WRITE M!odem
     1		(REPLY)
			GO TO 10
C
   20			WRITE (5,30)
   30	FORMAT		(' $$$ <COMMAND MODE> $$$'/
     1			 '  E - Exit to TSX'/
     2			 '  R - Receive from VAX'/
     3			 '  T - Transmit to VAX'/
     4			 '  any other char - Transparent mode'/)
   40	CALL		READ TE!rminal
     1		(REPLY)
			IF (REPLY .LE. NONE) GO TO 40
			REPLY = (REPLY.OR."20000) .AND."177737
			IF (REPLY .EQ. EXIT) GO TO 1000
			IF (REPLY .EQ. RECV) CALL RECEIV!e file from VAX
			IF (REPLY .EQ. TRAN) CALL TRANSM!it file to  VAX
			WRITE (5,100)
  100	FORMAT 		(' $$$ <TRANSPARENT MODE> $$$'/)
			GO TO 10
C
C......................................................................
C
 1000	CALL	QUIT
	END
	SUBROUTINE START Procedures for program
C
	COMMON /MO/ MODBLK(4),IMOCHN,NMOBLK,INMO(80),OUTMO(80)
	BYTE INMO,OUTMO
	BYTE SET TSX (6)
	DATA MODBLK /3RMO ,3R   ,3R   ,3R   /
	DATA SET TSX /29,'S',29,'U',29,'M'/
C
C....................Get channel for the modem.........................
C
	NMOBLK = 1
	IMOCHN = IGETC()
	IF (IMOCHN.LT.0) STOP 'No channel available for MO:'
	IF (IFETCH(MODBLK).NE.0) STOP 'Fatal error on fetch of MO:'
	IF (LOOKUP(IMOCHN,MODBLK).LT.0) STOP 'Bad lookup on MO:'
C
C....Set single character activation and non-wait TTY input testing.....
C
	CALL IPOKE ("44,"50100)
C
C.....................Issue TSX commands................................
C
	WRITE (5,10) SET TSX
   10	FORMAT (1H+,6A1,$)
C
C......................Disable control-C................................
C
	IFLAG = 0
	CALL SCCA (IFLAG)
C
C.................Set MO driver to special mode........................
C
	I = ISPFN ("377,IMOCHN)
C
C..................Tell the user we are here..........................
C
	WRITE (5,20)
   20	FORMAT (' COM communications program.  Version 1.0'/
     1	' Type <CTRL-A> to enter command mode.'/)
C
C.....................................................................
C
	RETURN
	END
	SUBROUTINE READ TErminal input (REPLY)
C
	INTEGER CTRLA,CMND,REPLY,LF,NONE
	DATA CTRLA,CMND,LF,NONE /1,0,"12,-1/
C
	REPLY = ITTINR()
	IF (REPLY .LE. 0    ) RETURN
	IF (REPLY .EQ. LF   ) REPLY = NONE
	IF (REPLY .EQ. CTRLA) REPLY = CMND
	RETURN	
C
	END
	SUBROUTINE READ MOdem input
C
	COMMON /MO/ MODBLK(4),IMOCHN,NMOBLK,INMO(80),OUTMO(80)
	BYTE INMO,OUTMO
C
	J = IREADW (40,INMO,NMOBLK,IMOCHN)
	IF (INMO(1).EQ.0) GO TO 20
		I = ITTOUR ("007)	!Ring bell
		WRITE (5,10)
   10		FORMAT (' ?COM-W-Modem read buffer overflow.'/)
   20	J = INMO(2)
	IF (J.EQ.0) RETURN
	J = J+2
	DO 30 I=3,J
		K = ITTOUR(INMO(I))
   30	CONTINUE
C
	RETURN
	END
	SUBROUTINE WRITE Modem output (REPLY)
C
	INTEGER REPLY
C
	COMMON /MO/ MODBLK(4),IMOCHN,NMOBLK,INMO(80),OUTMO(80)
	BYTE INMO,OUTMO
	DATA IANS /0/
C
	OUTMO(1) = REPLY
	OUTMO(2) = 0
   10	J = ISPFN ("375,IMOCHN,1,IANS,0)
	IF (IANS.NE.0) GO TO 10
	J = IWRITE (1,OUTMO,NMOBLK,IMOCHN)
C
	RETURN
	END
	SUBROUTINE QUIT
C
	I = ISPFN ("376,IMOCHN)	!Turn off modem communications
	CALL SCCA			!Turn control-c back on
	WRITE (5,10)
   10	FORMAT (' $$$ <EXITING COM> $$$'/)
	CALL EXIT
C
	END
	SUBROUTINE TRANSMit file to VAX
C
	COMMON /MO/ MODBLK(4),IMOCHN,NMOBLK,INMO(80),OUTMO(80)
	BYTE INMO,OUTMO
	COMMON /TRANS/ NAME(40), STRING(81), CTRLZ(2)
	BYTE NAME, CTRLZ, STRING
	INTEGER REPLY
	DATA CTRLZ /26,0/
	DATA IANS /0/
C
C......................Tell user where we are......................
C
	I = IPOKE ("44,0)	!Clear the JSW bits
	WRITE (5,10)
   10	FORMAT (' $$$ <TRANSMISSION MODE> $$$'/
     1	' Transmit RT file to VAX')
C
C.................Get the RT file name to transmit................
C
   20	WRITE (5,30)
   30	FORMAT (' RT file to transmit: ',$)
	READ (5,40) N,NAME
   40	FORMAT (Q,40A1)
	IF (N .EQ. 0) GO TO 2000
	OPEN (UNIT=3,NAME=NAME,TYPE='OLD',ERR=50)
	GO TO 70
   50		WRITE (5,60)
   60		FORMAT (' ?COM-W-could not open RT file.  Try again.')
		GO TO 20
C
   70	WRITE (5,80)
   80	FORMAT (' VAX file name to receive transmission: ',$)
	READ (5,90) N,NAME
   90	FORMAT (Q,40A1)
	IF (N.EQ.0) GO TO 1000
	I = IPOKE ("44,"50100)		!Restore JSW bits
C
C.................Send COPY TT: <filename>.........................
C
	ENCODE (49,100,OUTMO) NAME
  100	FORMAT ('COPY TT: ',40A1)
	N = 10+N
	OUTMO (N) = "15
	NN = (N+1)/2
	IF (NN*2 .NE. N) OUTMO(N+1) = 0
  110	J = ISPFN ("375,IMOCHN,1,IANS,0)
	IF (IANS .NE. 0) GO TO 110
	J = IWRITE (NN,OUTMO,NMOBLK,IMOCHN)
	CALL READ MO!dem
C
C====================== M A I N   L O O P ========================
C
  300	READ (3,310,END = 500) N,STRING
  310	FORMAT (Q,81A1)
	STRING(N+1) = "15
	N = N+1
	NN = (N+1)/2
	IF (NN*2 .NE. N) STRING (N+1) = 0
  320	J = ISPFN ("375,IMOCHN,1,IANS,0)
	IF (IANS .NE. 0) GO TO 320
	J = IWRITE (NN,STRING,NMOBLK,IMOCHN)
	CALL READ MO!dem input
	CALL READ TE (REPLY)
	IF (REPLY .EQ. "101) GO TO 500
	GO TO 300
C
C....................Wrap up with a ctrl-Z........................
C
  500	J = ISPFN ("375,IMOCHN,1,IANS,0)
	IF (IANS .NE. 0) GO TO 500
  520	J = IWRITE (1,CTRLZ,NMOBLK,IMOCHN)
C
C.................................................................
C
 1000	CLOSE (UNIT=3)
 2000	CALL IPOKE ("44,"50100)		!Restore JSW bits
	RETURN
	END
	SUBROUTINE RECEIVe file from VAX
C
	COMMON /MO/ MODBLK(4),IMOCHN,NMOBLK,INMO(80),OUTMO(80)
	BYTE INMO,OUTMO
	COMMON /TRANS/ NAME(40), STRING(128), CTRLZ(2)
	INTEGER*2 TOUT(64)
	BYTE NAME, CTRLZ, STRING
	EQUIVALENCE (TOUT(1),STRING(1))
	INTEGER REPLY
	LOGICAL FLAG
	DATA CTRLZ /26,0/
	DATA IANS /0/
C
C....................Tell the user where we are....................
C
	I = IPOKE ("44,0)		!Disable JSW bits
	WRITE (5,10)
   10	FORMAT (' $$$ <TRANSMISSION MODE> $$$'/
     1	' Transmit VAX file to RT')
C
C..............Get RT file name to receive transmission...........
C
   20	WRITE (5,30)
   30	FORMAT (' RT file to receive transmission: ',$)
	READ (5,40) N,NAME
   40	FORMAT (Q,40A1)
	IF (N .EQ. 0) GO TO 2000
	CALL ASSIGN (3,NAME,0)
C******************************************************************
C	Currently a 200 block tentative file is opened on the
C	specified RT device.  To change this, modify the next line.
C******************************************************************
	NSIZE = 300
	M = NSIZE*4
	DEFINE FILE 3 (M,64,U,IASSOC)
	NREC = 1
	GO TO 70
   50		WRITE (5,60)
   60		FORMAT (' ?COM-W-could not open RT file.  Try again.')
		GO TO 20
C
C....................Get VAX file name to transmit.................
C
   70	WRITE (5,80)
   80	FORMAT (' VAX file to transmit: ',$)
	READ (5,90) N,NAME
   90	FORMAT (Q,40A1)
	IF (N.EQ.0) GO TO 1000
C
C....................Send TYPE <filename>.........................
C
	I = IPOKE ("44,"50100)		!Reset JSW bits
	ENCODE (45,100,OUTMO) NAME
  100	FORMAT ('TYPE ',40A1)
	N = 6+N
	OUTMO (N) = "15
	NN = (N+1)/2
	IF (NN*2 .NE. N) OUTMO(N+1) = 0
  110	J = ISPFN ("375,IMOCHN,1,IANS,0)
	IF (IANS .NE. 0) GO TO 110
	J = IWRITE (NN,OUTMO,NMOBLK,IMOCHN)
C
C=================== M A I N   L O O P ===========================
C
	K = 0
	FLAG = .FALSE.
	JCOUNT = 0
	ISTART = 0
  300	J = IREADW (40,INMO,NMOBLK,IMOCHN)
	IF (INMO(1).EQ.0) GO TO 320
	WRITE (5,310)
  310	FORMAT (' ?COM-W-modem read buffer overflow')
  320	J = INMO(2)
	JCOUNT = JCOUNT + 1
	IF (J.EQ.0) GO TO 370
	JCOUNT = 0
	DO 360 I=3,J+2
		II = ITTOUR (INMO(I))
		IF (ISTART.EQ.2) GO TO 330
			IF (ISTART.EQ.1) ISTART=2
			IF (INMO(I).EQ."12) ISTART=1
			GO TO 360
  330		IF (K.LT.128) GO TO 350
		WRITE (3'NREC,END=2000) TOUT
		NREC = NREC + 1
		K = 0
  350		K = K+1
		STRING(K) = INMO(I)
  360	CONTINUE
  370	IF (JCOUNT.EQ.500) GO TO 400
		CALL READ TE (REPLY)
		IF (REPLY .EQ. "101) GO TO 1000		!A - Abort
		IF (REPLY .EQ. "103) GO TO  500		!C - Close file
		GO TO 300
  400	JCOUNT = 0
	WRITE (5,410)
  410	FORMAT (' *** <Type C to close file> ***')
	GO TO 300
C
C.....................Strip off last three characters................
C
  500	IF (K .GE. 3) GO TO 504
		K = K + 125
		NREC = NREC-1
		READ (3'NREC) TOUT
		DO 502 I=K,128
			STRING(I) = 0
  502		CONTINUE
		WRITE (3'NREC,END=2000) TOUT
		GO TO 520
  504	IF (K.EQ.3) GO TO 520
		K = K-3
		DO 510 I=K+1,128
			STRING(I) = 0
  510		CONTINUE
		WRITE (3'NREC,END=2000) TOUT
C
C....................Write the last record.........................
C
  520	NBLKS = NREC/4
	IF (NBLKS*4 .EQ. NREC) GO TO 2000
		N = 4 - (NREC - NBLKS*4)
		DO 600 I=1,128
			STRING(I) = 0
  600		CONTINUE
		DO 700 I=1,N
			NREC = NREC + 1
			WRITE (3'NREC,END=2000) TOUT
  700		CONTINUE
		GO TO 2000
C
C......................Abort transfer............................
C
 1000	J = IWRITE (1,CTRLZ,NMOBLK,IMOCHN)
	CLOSE (UNIT=3,DISPOSE='DELETE')
	GO TO 3000
C
C......................Finish up.................................
C
 2000	CLOSE (UNIT=3)
 3000	CALL IPOKE ("44,"50100)
C
	RETURN
	END
                                                                                                                                                                                                         