  PROGRAM BENBYX;
 
  (*$A-  Array  bounds  checking. *)
  (*$T-  Stack overflow checking. *)
 
  (*
   BENchmark BYte Sort.
 
   This benchmark program is used for measuring the  relative  speeds
   computers, under different compiler options, for  byte operations.
 
   The program:
                 (1) Reads a file of 80-column aphorisms, APHORI.DAT;
                 (2) Sorts it in alphabetic order,  using the classic
                     bubble-sort algorithm with data interchange; and
                 (3) Displays the sorted results on the console.
 
   Note:  The bubble sort algorithm with interchange of data is a not
          an efficient algorithm.   It was chosen here to ensure that
          many byte comparisons and copys are done  in  a  relatively
          short program.
 
   Program by Harry M. Murphy,  18 June 1982.
   *)
 
CONST
  APHFIL= 'APHORI.DAT';
  BLANK = ' ';
  NDIM  = 300;
  
TYPE
  LINE = ARRAY[1..80] OF CHAR;
 
VAR
  APHOR : ARRAY [1..NDIM] OF LINE;
  HILINE: LINE;
  I     : INTEGER;
  INP   : TEXT;
  J     : INTEGER;
  LAST  : INTEGER;
  LIM   : INTEGER;
  LOLINE: LINE;
  NREC  : INTEGER;
  SWAP  : BOOLEAN;
  TEMP  : CHAR;
  TOTAL : REAL;
  TREAD : REAL;
  TSHOW : REAL;
  TSORT : REAL;
  T1    : REAL;
  T2    : REAL;
  T3    : REAL;
  T4    : REAL;
 
 
 BEGIN (* BENchmark BYte Sort *)
   RESET(INP,APHFIL);
   WRITELN;
   WRITELN('B E N B Y S   (BENchmark BYte Sort)');
   WRITELN('Pascal');
   WRITELN;
   WRITELN('Reading now.');
   T1:=TIME;
   J:=0;
 
    REPEAT  (* Reading the input file. *)
     J:=J+1;
     I:=0;
     WHILE (NOT EOLN(INP)) AND (I<80) DO
      BEGIN
        I:=I+1;
        READ(INP,LOLINE[I]);
      END;
     READLN(INP);
     WHILE I<80 DO
      BEGIN
        I:=I+1;
        LOLINE[I]:=BLANK
      END;
      APHOR[J]:=LOLINE
    UNTIL EOF(INP) OR (J=NDIM);
 
   IF EOF(INP)
    THEN NREC:=J-1
    ELSE NREC:=J;
   CLOSE(INP);
   WRITELN('Sorting',NREC:4,' records now.');
   T2:=TIME;
 
   LAST:=NREC;
 
    REPEAT  (* Bubble-sort. *)
     LIM:=LAST-1;
     LAST:=0;
     FOR J:=1 TO LIM DO
      BEGIN
        LOLINE:=APHOR[J];
        HILINE:=APHOR[J+1];
        I:=0;
         REPEAT
          I:=I+1
         UNTIL (LOLINE[I]<>HILINE[I]) OR (I=80);
        IF LOLINE[I]>HILINE[I]
         THEN
          BEGIN
            LAST:=J;
            APHOR[J]:=HILINE;
            APHOR[J+1]:=LOLINE
          END
      END
    UNTIL LAST=0;
 
   WRITELN('Sorted output:');
   WRITELN;
   T3:=TIME;
   FOR J:=1 TO NREC DO
    BEGIN
      LOLINE:=APHOR[J];
      FOR I:=1 TO 80 DO WRITE(LOLINE[I]);
      WRITELN
    END;
   T4:=TIME;
 
   TREAD:=(T2-T1)*3600.0;
   TSORT:=(T3-T2)*3600.0;
   TSHOW:=(T4-T3)*3600.0;
   TOTAL:=(T4-T1)*3600.0;
 
   WRITELN;
   WRITELN('Lines sorted =',NREC:4);
   WRITELN('   Read time =',TREAD:6:1,' seconds.');
   WRITELN('   Sort time =',TSORT:6:1,' seconds.');
   WRITELN('   Show time =',TSHOW:6:1,' seconds.');
   WRITELN('  Total time =',TOTAL:6:1,' seconds.');
   WRITELN;
   WRITELN('Pascal BENchmark BYte Sort.');
   WRITELN
 END.
                                                                                                                                                                                                                                                                                                                                                                                                              