C******************************************************************************
C
C      Neither First Chicago Corporation, the First National Bank of Chicago,
C nor any of its employees makes any warranty, either expressed or implied,
C assumes any legal liability, nor any responsibility for the accuracy,
C completeness or usefulness of any information, product or process disclosed.
C Neither does First Chicago Corportion, the First National Bank of Chicago,nor
C any of its employees represent that use of this material would not infringe
C privately owned rights.
C
C******************************************************************************
C
C
C
C	CHAREX.FOR   MAIN PROGRAM FOR CONVERTING A FSA FILE
C                    TO A TY4 FILE.
C
C ***********************************************************************
C ***********************************************************************
C
C WRITTEN BY:  SUE COOK, DOUGLAS BOHRER
C	   PERSONNEL DEPARTMENT, THE FIRST NATIONAL BANK OF CHICAGO
C	   1 FIRST NATIONAL PLAZA, 22ND FLOOR
C	   CHICAGO, ILLINOIS 60670
C
C DATE:	       17-MAR-81
C
C PURPOSE: A PROGRAM TO READ FILES OF CHARACTER DATA WRITTEN IN FORTRAN ASCII 
C          SEQUENTIAL FORMAT AND CONVERT THE DATA TO SINGLE PRECISION FLOATING
C          POINT NUMBERS WITH APL STRUCTURAL DATA IN THE FIRST 24 BYTES ON
C          THE OUTPUT FILE.
C
C************************************************************************
C
	REAL*8 FTYP,ROWS,COLS
	REAL*4 BUFS(40)
	REAL*8 BUFD(20)
C EQUIVALENT SINGLE AND DOUBLE PRECISION VERSIONS OF THE SAME INFORMATION
	EQUIVALENCE(BUFD,BUFS)
C GIVE ONE BYTE TO THE BUG.  FILNAM MUST BE (15).
	LOGICAL*1 INF(14), FILNAM(15), FMAT(130)
C ASK THE USER FOR INPUT
	TYPE *, ' INPUT FILE NAME'
	READ(5,113) (INF(I), I=1,14)
113	FORMAT(14A1)
	OPEN(UNIT=2, NAME=INF, ACCESS='SEQUENTIAL', FORM='FORMATTED',
	1TYPE='OLD')
C READ IN EACH FIELD'S FORMAT SPECIFICATION.  EACH F WILL BE COUNTED
C TO FIND THE NUMBER OF COLUMNS.
	TYPE *,' FORMAT SPECIFICATION (DO NOT USE REPEAT COUNTS)'
	READ(5,213) (FMAT(I),I=1,130)
 213	FORMAT(130A1)
	TYPE *, ' OUTPUT FILE NAME'
	READ(5,113) (FILNAM(I),I=1,14)
C COUNT THE NUMBER OF FORMATS.  THE TOTAL, LENOUT, IS THE LENGTH    .
C OF THE OUTPUT RECORD.
	LENOUT=0
	DO 100 L100=1,130
	IF (FMAT(L100).EQ.'F') LENOUT=LENOUT+1
 100	CONTINUE
C SET UP TWICE THE SINGLE PRECISION LENGTH FOR WORD LENGTH
	LEOW=2*LENOUT
	DEFINE FILE 1 (32000,LEOW,U,IPOS1)
	OPEN(UNIT=1,NAME=FILNAM,TYPE='NEW',ACCESS='DIRECT',
	1FORM='UNFORMATTED',RECORDSIZE=LENOUT,INITIALSIZE=-1,
	1ASSOCIATEVARIABLE=IPOS1,CARRIAGECONTROL='NONE')
	FTYP=4.0
	ROWS=0.0
	COLS=DBLE(FLOAT(LENOUT))
	BUFD(1)=FTYP
	BUFD(2)=ROWS
	BUFD(3)=COLS
C THE FIRST 24 BYTES HOLD THREE REAL*8 AND SIX REAL*4 INFORMATION
C THE FIRST SIX POSITIONS OF BUFS ARE NOW FILLED.
	IUP=LENOUT+6
C FOR EACH RECORD,IUP IS THE LAST BUFS POSITION INTO WHICH DATA 
C WILL BE READ.
	FIND(1'1)
C READ DATA INTO POSITIONS 7 THROUGH IUP. POSITIONS 1 THROUGH 6 ARE FILLED.
 200	READ(2,FMAT,END=299)(BUFS(I),I=7,IUP)
	ROWS=ROWS+1.0
C WRITE A RECORD, STARTING WITH THE FIRST POSITION OF THE BUFFER.
	WRITE(1'IPOS1)(BUFS(I),I=1,LENOUT)
C SHIFT THE DATA THAT WAS READ, BUT NOT WRITTEN,INTO THE FIRST  
C SIX BUFFER POSITIONS.  (DO LOOP 210)
	DO 210 J=1,6
	II=J+LENOUT
	BUFS(J)=BUFS(II)
 210	CONTINUE
	GO TO 200
 299	CONTINUE
C CLEAR ANY REMAINING DATA FROM THE BUFFER. WRITE IT TO THE FILE.
	DO 300 J=1,6,LENOUT
	II=MIN0(6,J-1+LENOUT)
	WRITE(1'IPOS1)(BUFS(I),I=J,II)
 300	CONTINUE
	FIND(1'1)
C READ ENOUGH RECORDS TO GET AT LEAST SIX SINGLE PRECISION NUMBERS,
C THE STRUCTURAL INFORMATION FOR THE FILE.  (DO LOOP 400)
	DO 400 J=1,6,LENOUT
	II=J+LENOUT-1
	READ(1'IPOS1)(BUFS(I),I=J,II)
 400	CONTINUE
	FIND(1'1)
C SET THE ROW COUNT.
	BUFD(2)=ROWS
C WRITE OUT THE STRUCTURAL INFORMATION.
	DO 500 J=1,6,LENOUT
	II=J+LENOUT-1
	WRITE(1'IPOS1)(BUFS(I),I=J,II)
 500	CONTINUE
C THE UPDATED STRUCTURAL INORMATION IS NOW ON FILE.
	CLOSE(UNIT=1,DISP='SAVE')
	CLOSE(UNIT=2, DISP='SAVE')
	STOP
	END
    