  program verifypassone (input, output, scratch);

  {**************************************************************}
  {                                                              }
  { Copyright (c) 1982            Bob Schor                      }
  {                               Rockefeller University         }
  {                               1230 York Ave                  }
  {                               New York, NY   10021           }
  {                                                              }
  { All rights reserved.  May not be copied without this notice. }
  {                                                              }
  {**************************************************************}

  { first pass of program to compare two devices }

CONST
  devicelength = 3;
  filelength = 14;
  namelength = 10;
TYPE
  devicetype = PACKED ARRAY [1 .. devicelength] OF char;
  filenametype = PACKED ARRAY [1 .. filelength] OF char;
  nametype = PACKED ARRAY [1 .. namelength] OF char;
VAR
  firstdevice, seconddevice : devicetype;
  scratchfile : filenametype;
  scratch : text;

  PROCEDURE checkdevicename (VAR device : devicetype);

  VAR
    index : integer;

    PROCEDURE capitalize (VAR device : devicetype);

    VAR
      index : integer;

     BEGIN   { capitalize }
       FOR index := 1 TO devicelength DO
       IF ('a' <= device[index]) AND (device[index] <= 'z')
	THEN device[index] := chr (ord(device[index]) - ord('a') + ord('A'))
     END;

   BEGIN   { checkdevicename}
     capitalize (device);
     FOR index := 1 TO devicelength DO
     IF NOT (device[index] IN ['A' .. 'Z', '0' .. '9'])
      THEN device[index] := ' ';
     IF device = '   '
      THEN device := 'DK '
   END;

  PROCEDURE makefilename (device : devicetype; name : nametype;
			  VAR filename : filenametype);

  VAR
    index : integer;

   BEGIN   { makefilename }
     FOR index := 1 TO devicelength DO
     filename[index] := device[index];
     filename[devicelength+1] := ':';
     FOR index := 1 TO namelength DO
     filename[devicelength+1+index] := name[index]
   END;

 BEGIN   { verifypassone }
   writeln ('VERIFY -- compare files on two devices');
   writeln;
   writeln ('The default device (DK:) will be used for scratch files!');
   writeln;
   write ('Enter first device  -- ');
   readln (firstdevice);
   write ('Enter second device -- ');
   readln (seconddevice);
   checkdevicename (firstdevice);
   checkdevicename (seconddevice);
   makefilename ('DK ', 'VERIF1.COM', scratchfile);
   rewrite (scratch, scratchfile);
   writeln (scratch, 'ASSIGN ', firstdevice, ' ONE');
   writeln (scratch, 'ASSIGN ', seconddevice, ' TWO');
   writeln (scratch, 'DIRECTORY/OUTPUT:ONE/SORT:NAME/COL:1/VOL ONE:');
   writeln (scratch, 'DIRECTORY/OUTPUT:TWO/SORT:NAME/COL:1/VOL TWO:');
   writeln (scratch, 'R VERIF2');
   writeln (scratch, 'DELETE/NOQ (ONE,TWO).DIR');
   writeln (scratch, 'DELETE/NOQ VERIF1.COM');
   close (scratch)
 END.
                  