	PROGRAM VTEST2

C-----------------------------------------------------------------------------
C
C	This program shell sorts a duplicate virtual and core
C	array of double precision random numbers and then
C	compares for identical results.
C
C-----------------------------------------------------------------------------

	PARAMETER ( NSIZE = 4000 )

	INTEGER*2 II, JJ
	INTEGER*4 ACCESSES ,FAULTS
	DOUBLE PRECISION  X,Y,T
	DIMENSION Y(NSIZE)
	VIRTUAL   X(NSIZE)

	COMMON /VCOUNT/  ACCESSES, FAULTS

C...... Initialize statistics

	ACCESSES = 0
	FAULTS   = 0

C...... Get number of elements to sort

	WRITE (5,*) ' '
	WRITE (5,*) 'TEST DISK BASED VIRTUAL ARRAYS:'
	WRITE (5,*) ' '
	WRITE (5,*) 'Up to 4000 elements of duplicate virtual and core'
	WRITE (5,*) 'arrays are shell sorted, and the results are compared.'
	WRITE (5,*) ' '

10	WRITE (5,*) 'How many elements to you want to sort? '
	READ  (5,*) NUMBER

	IF ( NUMBER .GT. NSIZE ) THEN
	   WRITE (5,*) 'Maximum number of elements allowed is ',NSIZE
	   GO TO 10
	ENDIF

C...... Fill arrays with data

	DO 30 L=1,NUMBER
	   T = RAN(II,JJ) * RAN(II,JJ)
	   X(L) = T
	   Y(L) = T
30	CONTINUE

C......	Shell sort the core array

	WRITE (5,*) 'Sorting core array'
	IM1=NUMBER

42	IM1=IM1/2
	IF ( IM1 .NE. 0 ) THEN
	   K=NUMBER-IM1
	   J=1
44	   I=J

46	   IF ( Y(I) .GT. Y(I+IM1) ) THEN
	      T=Y(I)
	      Y(I)=Y(I+IM1)
	      Y(I+IM1)=T
	      I=I-IM1
	      IF (I .GT. 0) GOTO 46
	   ENDIF

	   J=J+1
	   IF (J.GT.K) GOTO 42
	   GOTO 44
	ENDIF

C...... Shell sort the virtual array

	WRITE (5,*) 'Sorting virtual array'
	IM1=NUMBER

32	IM1=IM1/2
	IF ( IM1 .NE. 0 ) THEN
	   K=NUMBER-IM1
	   J=1
34	   I=J

36	   IF ( X(I) .GT. X(I+IM1) ) THEN
	      T=X(I)
	      X(I)=X(I+IM1)
	      X(I+IM1)=T
	      I=I-IM1
	      IF (I.GT.0) GO TO 36
	   ENDIF

	   J=J+1
	   IF (J.GT.K) GO TO 32
	   GO TO 34
	ENDIF

C...... Compare results

	WRITE (5,*) 'Comparing results'
	DO 50 L=1,NUMBER
	   IF (X(L) .NE. Y(L))  TYPE '(I5,2D12.8)', L,X(L),Y(L)
50	CONTINUE

C...... Print statistics

	TYPE 70, ACCESSES, FAULTS
70	FORMAT(/' Number of accesses     = ',I10/
     1	        ' Number of block faults = ',I10)

	RATE = 100.0 * ( 1.0-FLOAT(FAULTS)/FLOAT(ACCESSES) )
	TYPE 80, RATE
80	FORMAT(' Hit rate = ',F5.2,'%'/)

	END
                                                                                                                                                                                  