program memmap;

var memadd, staadd, fndflg, tstflg: 0..65535;

procedure testmemory;
   begin
(*$C
	mov	@#4,-(sp)	;remove system trap handler
	mov	@#6,-(sp)
	mov	#nxmint,@#4	;install our trap handler
	mov	#^O340,@#6
	clr	fndflg(r5)
	br	tstme2
nxmint:	inc	tstflg(r5)
	rti
tstmem:	add	#2,memadd(r5)
	beq	tstme4
tstme2:	clr	tstflg(r5)
	mov	@memadd(r5),r0	;get first location
	mov	tstflg(r5),r0
	bne	tstmem
	inc	fndflg(r5)
	mov	memadd(r5),staadd(r5) ;starting address
tstme3:	add	#2,memadd(r5)	;go to next location
	beq	tstme4
	mov	@memadd(r5),r0	;get last location
	mov	tstflg(r5),r0
	beq	tstme3
tstme4:	mov	(sp)+,@#6	;restore system trap handler
	mov	(sp)+,@#4
*)
   end;

begin
writeln('
MEMMAP 32 KW Memory Mapper
Andromeda Systems Incorporated

    From       To    Words    Vectors   Description
   ------    ------   ----   ---  ---   -------------------------------');
memadd:=0;
   repeat
   testmemory;
   if fndflg<>0 then
      begin
      write(staadd: -9);
      if memadd-staadd>2 then write(' ..', memadd-2: -7)
      else write('          ');
      if staadd<160000B then
         write((memadd-staadd) and 174000B div 4000B and 37B: 6,
            'K              MEM11/MSV11 memory')
      else
         begin write((memadd-staadd) div 2: 6, '. ');

if staadd=160150B then
   write('  420..434   IBV11-A instrument bus interface') else
if (staadd>=167700B) and (staadd<170000B) then
   repeat
   write('   ?    ?    DRV11 parallel line unit');
   staadd:=staadd+10B;
   if (staadd<memadd) and (staadd<170000B) then write('
                           ')
   until (staadd>=memadd) or (staadd>=170000B) else
if staadd=170400B then
   write('  400  404   ADC11/ADV11 A/D converter') else
if staadd=170420B then
   write('  440  444   PRTC11/KWV11 real time clock') else
if (staadd>=170440B) and (staadd<170500B) then
   write('             DAC11/AAV11 D/A converter') else
if staadd=170500B then
   write('             WDC11 maintainance registers') else
if staadd=170700B then
   write('  170  174   DFDC11 floppy disk') else
if (staadd>=171400B) and (staadd<171500B) then
   write('             DIO11 parallel interface') else
if (staadd=172300B) or (staadd=172340B) or (staadd=177640B) then
   write('             KT11 memory management') else
if (staadd>=172410B) and (staadd<172440B) then
   write('  124        DRV11-B DMA interface') else
if staadd=172516B then
   begin
   write('             KT11 memory management');
   if memadd>172520B then write('
                             224        TM11 magnetic tape')
   end else
if staadd=172520B then
   write('  224        TM11 magnetic tape') else
if staadd=173000B then
   write('             PROM11/BDV11 bootstrap ROM') else
if staadd=174400B then
   write('  160        RL01 hard disk') else
if (staadd>=176500B) and (staadd<176700B) then
   repeat
   write('   ?    ?    MSI11/DLV11 serial interface');
   staadd:=staadd+10B;
   if (staadd<memadd) and (staadd<176700B) then write('
                           ')
   until (staadd>=memadd) or (staadd>=176700B) else
if staadd=177170B then
   write('  264        FDC11/RX01/RX02 floppy disk') else
if staadd=177200B then
   write('             MDC11 mini-floppy disk') else
if staadd=177400B then
   write('  220        RK05 hard disk') else
if (staadd>=177510B) and (staadd<177520B) then 
   begin
   if staadd=177510B then write('  204  200')
   else write('  200     ');
   write('   MSI11P/LPI11/LPV11 line printer');
   if memadd>177520B then write('
                                        BDV11 diagnostic')
   end else
if staadd=177520B then
   write('             BDV11 diagnostic') else
if staadd=177546B then
   write('  100        BDV11 line time clock') else
if staadd=177560B then
   write('   60   64   MSI11/DLV11 console terminal') else
if staadd=177572B then
   write('  250        KT11 memory management') else
if staadd=177776B then
   write('             KDF11 processor status register')

         end;
      writeln
      end
   until memadd=0
end.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      