	PROGRAM EXPGEN
C
C	Generates exponential decay data for demonstration
C	program EXPFIT.
C
	WRITE (5,10)
10	FORMAT (' EXPGEN: Generates exponential decay data.')
C
	OPEN (UNIT=2,NAME='EXP.DAT',TYPE='NEW',CARRIAGECONTROL='LIST')
C
20	CONTINUE
	WRITE (5,30)
30	FORMAT (' Enter the number of model parameters: ',$)
	READ (5,*) NMODEL
	IF (NMODEL.GE.2 .AND. NMODEL.LE.5) GO TO 50
	    WRITE (5,40)
40	    FORMAT (' Number of model parameters must be between 2 and 5.')
	    GO TO 20
50	CONTINUE
C
60	CONTINUE
	WRITE (5,70)
70	FORMAT (' Enter the number of data points: ',$)
	READ (5,*) NDATA
	IF (NDATA .GT. NMODEL) GO TO 90
	    WRITE (5,80)
80	    FORMAT (' Must be greater than number of model parameters.')
	    GO TO 60
90	CONTINUE
C
100	WRITE (5,110)
110	FORMAT (' Enter amount of noise between 0. and 1.: ',$)
	READ (5,*) ANOISE
	IF (ANOISE.LT.0. .OR. ANOISE.GT.1.) GO TO 100
C
C	Decay constant = 3 for x = ndata.
C
	DECAY = -3.
	DECAY1 = DECAY
C
C	Background equals exponential in magnitude
C
	AMP1   = 1.
	BACKGR = AMP1
	IF (NMODEL.EQ.2 .OR. NMODEL.EQ.4) BACKGR = 0.
	ANOISE = ANOISE * AMP1
C
C	If two exponentials, adjust constants.
C
	AMP2 = 0.
	DECAY2 = 0.
	IF (NMODEL .LE. 3) GO TO 120
	    DECAY2 = DECAY1 * 1.3	
	    DECAY1 = DECAY1 * 0.7
	    AMP1 = AMP1 / 2.
	    AMP2 = AMP1
120	CONTINUE
C
C	Write out the constants
C
	WRITE (2,121) NMODEL, NDATA, ANOISE
	WRITE (2,122) AMP1, DECAY1, AMP2, DECAY2, BACKGR
121	FORMAT (1X,2I10,F10.5)
122	FORMAT (1X,5F10.5)
C
C	Generate data
C
	DO 200 I=1,NDATA
	    X = FLOAT(I-1) / FLOAT(NDATA-1)
	    Y = AMP1 * EXP(DECAY1*X) + AMP2 * EXP(DECAY2*X) + BACKGR
	    SUM = 0.
	    DO 130 J=1,12
	        SUM = SUM + RAN(II,JJ)
130	    CONTINUE
	    Y = Y + ANOISE * (SUM-6.)/2.
	    WRITE (2,140) X,Y
140	    FORMAT (1X,2F10.5)
200	CONTINUE
C
	CLOSE (UNIT=2)
C
	END
                                                                                                                                                            