	PROGRAM EXPFIT
C
C	NLFIT demonstration program to fit exponential data
C	generated by EXPGEN.
C
	DIMENSION X(100), Y(100), DY(100), A(5), DA(5)
	DOUBLE PRECISION B(5)
	DATA LUNOUT /3/
C
	OPEN (UNIT=2,NAME='EXP.DAT',TYPE='OLD',CARRIAGECONTROL='LIST')
	OPEN (UNIT=3,NAME='EXP.FIT',TYPE='NEW',CARRIAGECONTROL='LIST')
C
	READ  (2,*)  NMODEL, NDATA, ANOISE
	WRITE (LUNOUT,10) NMODEL, NDATA, ANOISE
10	FORMAT (1X'! ',2I10,F10.5)
	IF (NDATA .GT. 100) STOP '?-F-EXPFIT-more than 100 data points'
C
	READ  (2,*)  AMP1, DECAY1, AMP2, DECAY2, BACKGR
	WRITE (LUNOUT,20) AMP1, DECAY1, AMP2, DECAY2, BACKGR
20	FORMAT (1X'! ',5F10.5)
C
	DO 40 I=1,NDATA
	    READ (2,*) X(I),Y(I)
	    WRITE (LUNOUT,30) X(I),Y(I)
30	    FORMAT (1X,2F10.5)
40	CONTINUE
C
50	WRITE (5,60)
60	FORMAT (' How many parameters do you want in the fit? ',$)
	READ (5,*) NPARAM
	IF (NPARAM.GE.2 .AND. NPARAM.LE.5) GO TO 80
	    WRITE (5,70)
70	    FORMAT (' Must be between 2 and 5.')
	    GO TO 50
80	CONTINUE
C
	DO 90 I=1,NDATA
	    DY(I) = ANOISE/2.
90	CONTINUE
C
	GO TO (120,130,120,130), NPARAM+1
C
120	A(1) = Y(1)
	A(2) = ALOG(Y(NDATA/2)/Y(1))/(X(NDATA)/2.)
	A(3) = 0.
	GO TO 140
C
130	A(1) = Y(1)-Y(NDATA)
	ANORM = ALOG(EXP(1.))*X(NDATA)/2.
	A(2) = ALOG((Y(NDATA/2)-Y(NDATA))/(Y(1)-Y(NDATA)))/ANORM
	A(3) = Y(NDATA)
C
140	CONTINUE
	NN = NPARAM
	IF (NN.GT.3) NN=NN-2
	FLAMDA = 0.01
	CHISQ = 1E31
150	CALL NLFIT (NDATA, X, Y, DY, NN, A, DA, CHISQR, FLAMDA)
	DEL = CHISQ - CHISQR
160	IF (DEL .LE. 0.0001*CHISQR) GO TO 170
	    CHISQ = CHISQR
	    GO TO 150
170	IF (NN.EQ.NPARAM) GO TO 200
	    NN = NPARAM
	    A(1) = A(1)/2
	    A(5) = A(3)
	    A(3) = A(1)
	    TEMP = A(2)
	    A(2) = 0.7*TEMP
	    A(4) = 1.3*TEMP
	    CHISQ = 1E31
	    GO TO 150
C
200	DO 220 I=1,NN
	    WRITE (LUNOUT,210) I,A(I),DA(I)
210	    FORMAT (' ! ',I1,2F13.8)
220	CONTINUE
	WRITE (LUNOUT,230) CHISQR
230	FORMAT (' ! CHISQR = 'F8.1)
C
	DO 240 I=1,NMODEL
	    B(I) = A(I)
240	CONTINUE
C
	DO 260 I=1,NDATA
	    YMODEL = FUNCTN(X(I),B,NMODEL)
	    WRITE (LUNOUT,250) X(I),YMODEL
250	    FORMAT (1X,2F8.5)
260	CONTINUE
C
1000	CLOSE (UNIT=2)
	CLOSE (UNIT=3)
C
	END
                                                                                                                                                                                                                                                                                                                                                                             