.; MAKPAR.CMD
	.IF P1 NE "?" .GOTO BEGIN
	.IF P2 NE "" .GOTO EGS
; MAKPAR.CMD creates a partition or checks its existance and optionally
;	loads a driver or common. The partition is created if neccessary
;	by moving the top of GEN down and creating partition there.
;	Use REMPAR.CMD to remove the partition so created.
;
; SYNTAX:
;	@LB:[1,2]MAKPAR name[/op] size [type [erract]]
;		name	partition name
;		op	dv:	device to load into partition
;				(":" must be last character)
;			task	task to install into partition (MCR
;				switches (eg., /TASK) may be present).
;		size	size required in 32.-word blocks (octal).
;		type	partition type (COM normal default; TASK
;				default if device being loaded)
;		erract	error action (for call from external file)
;				one or more of	Abort/Pause/Ignore
;				separated by "/". If multiple, user
;				is queried for action, with first as default.
;
; Type @LB:[1,2]MAKPAR ? EG for examples.
	.EXIT		! after @MAKPAR ?
.EGS:
; MAKPAR.CMD SYNTAX:
;	@LB:[1,2]MAKPAR name[/op] size [type [erract]]
;
; EXAMPLES:
;
;  load PR: into partition PRPAR
;	@LB:[1,2]MAKPAR PRPAR/PR: 3 TASK
;
;  install RSX-11M V4.1C RMSRES from within a LB:[1,2] command file:
;	@/LB:MAKPAR RMSRES/LB:[1,1]RMSRESSUB.TSK 553 COM
;  similar with some alternatives after error:
;	@/LB:MAKPAR RMSRES/LB:[1,1]RMSRESSUB.TSK 553 COM ABORT/PAUSE
;
	.EXIT		! after	@MAKPAR ? EG
.; P.J.Spencer, Capricornia Electricity Board, Rockhampton, Qld, AUSTRALIA
.;	Set error prefix while can still use "'"
.BEGIN:	.SETS ERRPFX "Can't "
	.SETN EXSTS <SUCCES>	! exit status
	.SETS DFTYP "COM"	! normal default type
	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
.;	ensure MCR and privileged
	@/LB:USRCHK MAKPAR/MCR PRIV
.; Is there something to load?
	.PARSE P1 "/" P1 LDEV
	.IF LDEV = "" .GOTO CKNUL
	.TEST LDEV ":"
	.SETN CPL <STRLEN>		! set colon position
	.TEST LDEV
	.IF CPL = <STRLEN> .GOTO 0LOA	! if : last, is device
	.SETS LT "INS"			! else is task install
.;	(too hard to test task, since there can be funnees such as $)
	.GOTO CKNUL
	
.0LOA:	.SETS LT "LOA"			! device load
	.SETS DFTYP "TASK"		! default if loading driver
	.TESTDEVICE 'LDEV'		! must be unloaded device
	.TEST <EXSTRI> "UNL"
	.IF <STRLEN> NE 0 .GOTO CKNUL
	DEV 'LDEV'
	.GOSUB ERR load 'LDEV'
.; Must have name and length
.CKNUL:	.IF P1 = "" .OR .IF P2 = "" .GOSUB ERR proceed - need name & size
	.IF P3 = "" .GOTO MP00
	.IF P3 = "TASK" .OR .IF P3 = "SYS" .GOTO MP00
	.IF P3 = "COM" .GOTO MP00
	.IF P3 = "DEV" .GOSUB ERR create device partition out of GEN
	.GOSUB ERR recognise type 'P3'
.MP00:
	.TESTPARTITION 'P1'
	.PARSE <EXSTRI> "," X SPBAS SPSIZ SPSTAT X
	.IF SPSTAT NE "NSP" .GOTO CHKPAR
		.TESTPARTITION GEN
		.PARSE <EXSTRI> "," X GBAS GSIZ GSTAT X
		.IF GSTAT NE "SYS" .GOSUB ERR find system GEN
		.SETN PBAS 'GSIZ'-'P2'		! find new GEN size
		.IF PBAS < 340	.GOSUB ERR fit with 14KW GEN
		.SETN PBAS 'GBAS'+PBAS		! set partition base
		SET /TOP=GEN:-'P2'
		.IF <EXSTAT> NE <SUCCES> .GOSUB ERR lower GEN top
		.IF P3 = "" .SETS P3 DFTYP
		SET /MAIN='P1':'PBAS':'P2':'P3'
		.IF <EXSTAT> NE <SUCCES> .GOSUB ERR create 'P1'
		.IFENABLED MCR	.GOTO MP00	! check created OK
		; (end create phase - creation test skipped)
		.GOTO 0DL
.CHKPAR:.SETS ERRPFX "Existing 'P1' is wrong "
	.IF P2 NE SPSIZ .GOSUB ERR size
	.IF P3 EQ "TASK" .OR .IF P3 EQ "COM" .SETS P3 "USR"
	.IF P3 NE "" .IF P3 NE SPSTAT .GOSUB ERR type
.0DL:	.SETS ERRPFX ""
	.IF LDEV = "" .GOTO XIT
	'LT' 'LDEV'/PAR='P1'
	.IF <EXSTAT> NE <SUCCES> .GOSUB ERR Failed to 'LT' 'LDEV'
	.GOTO XIT
.ERR:	; MAKPAR -- Error: 'ERRPFX''COMMAN'
	;
	.SETN EXSTS <ERROR>
.XIT:	.IF $CLI NE "MCR" SET /CLI=TI:'$CLI'
	.IF EXSTS = <SUCCES>	.EXIT EXSTS
	.IF P4 = ""		.STOP
	.SETS ACT P4				! ACT is a tempory here
	.SETS CACT ""				! Choice of actions
.0C0:
	.PARSE ACT "/" X ACT
	.SETS CACT CACT+X[1:1]
	.IF ACT NE "" .GOTO 0C0
	.SETS DACT P4[1:1]			! Do action default
	.TEST P4 "/"				! Choice?
	.IF <STRLEN> = 0 .GOTO 0CAS		! No
	.DISABLE LOWERCASE			! to simplify matching tests
	.ASKS ACT 'P4' - which? <'DACT'>
	.IF ACT NE "" .SETS ACT ACT[1:1]
	.TEST CACT ACT				! Legal choice?
	.IF <STRLEN> NE 0 .SETS DACT ACT	! (ignore if not)
.0CAS:	.TEST "API" DACT
	.GOTO CAS'<STRLEN>'
.CAS0:	; MAKPAR - Illegal error action - Abort assumed
.CAS1:	.STOP					! Abort
.CAS2:	.PAUSE					! Pause continues to ..
.CAS3:	.EXIT EXSTS				! Ignore
                                                                                                                                              