	.IF P1 NE "?" .GOTO BEGIN
; ERRACT.CMD		take action on error
;		[1,2] Command file subroutine only!
;
; SYNTAX:	@LB:[1,2]ERRACT action message
;		@/LB:ERRACT action message  ! LB:[1,2] command files only!
;
;	message	a message to be output (possibly blank).
;
;	action	one or more action choices, seperated by "/" with
;			NO EMBEDDED BLANKS! 
;		If there is one choice, ERRACT will take that action.
;		Otherwise, the user will be asked to make a choice, with
;		the first action the default. ONLY THE FIRST LETTER of
;		each choice is checked - ensure they are unique!
;
;		ABORT	- ERRACT will .STOP after resetting CLI
;		PAUSE	- ERRACT will .PAUSE and .EXIT
;		other	- ERRACT will .EXIT
;		 eg: RETRY/IGNORE
;
;	If ERRACT does an .EXIT, <EXSTAT> will be set to the number
;		of the choice (1,2,..) taken by the user.
;
; EXAMPLES:	@[1,2]ERRACT PAUSE/RETRY/ABORT SOMETHING WRONG ..
;				(default PAUSE)
;		@[1,2]ERRACT /ABORT/PAUSE SOMETHING ELSE WRONG
;				(no default action)
;		@[1,2]ERRACT ABORT SOMETHING BADLY WRONG
;				an awfully complicated way to do
;					; SOMETHING BADLY WRONG
;					 (reset CLI to $CLI)
;					.STOP
;
; ASSUMES:
;	$CLI		set to users CLI if CLI reset wanted
;
; LIMITATION:	Message will always be uppercase, due to limitations
;		of CLI interface.
;
.; This is adapted from an extract of [1,2]MAKPAR.CMD
.; It works, but is probably better adapted and used as a .GOSUB target,
.; within the calling command file, with RETURNS for the .EXITs.
.;	PJS 26-SEP-85 Original ERRACTION.CMD
.;	PJS 21-APR-86 RSX V4.2 won't allow @/LB:ERRACTION syntax - fix comment.
.;	PJS 05-AUG-86 rename to ERRACT to re-allow @/LB:ERRACT
.;			add .IFNDF $CLI ..
	.EXIT		! after ERRACTION ?
.BEGIN:	.ENABLE SUBSTITUTION
	.PARSE COMMAN " " X X P2		! P2 to "rest of command"
	.IF P1 = ""		.GOTO CAS1	! Abort if null "choices"
	.SETF QU
	.IFENABLED QUIET	.SETT QU
	.IFT QU			.DISABLE QUIET
	.IF P2 NE ""		; 'P2'
	.IFT QU			.ENABLE QUIET
	.SETN ERRX 1				! assume exit at first choice
	.SETS DACT P1[1:1]			! Do action default
	.IF DACT EQ "/" .SETS P1 P1[2:*]	! Discard "no default" /
	.IF DACT EQ "/" .SETS DACT ""		! (No default if / first)
	.IF DACT NE ""	.SETS DACT "<'DACT'>"	! Otherwise pretty it up
	.SETS ACT P1				! ACT is a tempory here
	.SETS CACT ""				! Choice of actions
.0C0:
	.PARSE ACT "/" X ACT
	.SETS CACT CACT+X[1:1]
	.IF ACT NE "" .GOTO 0C0
	.TEST CACT
	.IF <STRLEN> EQ 0	.GOTO CAS1	! Assume abort if "/" only
	.SETS ACT CACT[1:1]			! In case we take next branch
	.IF <STRLEN> EQ 1	.GOTO 0CAS	! No choices
	.DISABLE LOWERCASE			! to simplify matching tests
.0C3:
	.ASKS ACT 'P1' - which? 'DACT'
	.IF ACT NE "" .SETS ACT ACT[1:1]
	.IF ACT EQ "" .SETS ACT DACT[2:2]
	.TEST CACT ACT				! Legal choice?
	.IF <STRLEN> = 0	.GOTO 0C3	! No
	.SETN ERRX <STRLEN>
	.ENABLE LOWERCASE
.0CAS:	.TEST "AP" ACT
	.GOTO CAS'<STRLEN>'
.CAS0:	.EXIT ERRX
.CAS1:	.IFNDF $CLI		.STOP
	.IF <CLI> = $CLI	.STOP
	.SETS ACT ""
	.IF <CLI> NE "MCR"	.SETS ACT "MCR"
	'ACT' SET /CLI=TI:'$CLI'
	.STOP
.CAS2:	.PAUSE
	.EXIT ERRX
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          