
C
C			BitPat
C
C		By Paul S. Drobny
C		University of California, Davis
C		Department of Applied Science
C		Written September 11, 1985
C		Last Edited September 17, 1985
C
C	This program gives you the bit fiddling capabilities you need to debug
C	hardware which will reside on the I/O bus of a PDP-11 computer running
C	RT-11. I wrote this to debug some wiring in an instrumentation 
C       box we built for a real-time exercise.
C       This was written for use with a DLV11 board, but any parallel 
C	interface should respond the same .. its conceivable you might want to
C       use it with a serial port as well. In fact you might want to use it
C       for any memory address, but especially I/O page. Notice that if you 
C       input the CSR of a DLV11 that it automatically increments the address
C       by two. You might want to change that to be the actual address you
C       wish to fiddle, not the write port.
C	For the most part, the pattern is written anew each time you choose to
C	act, but selection 'G' toggles only the bit you choose, not the others
C	and can therefore be used to trace particular line problems without
C	disturbing the state of the other lines. When used in conjunction 
C	with the 'P' option, one can arrange the bus state in any way, then 
C	toggle one particular signal line only. Caution must be used with 
C	this program since the state of your device is known only by you, 
C	and some bit patterns may generate illegal or destructive device 
C       states (like be sure about your disk and tape device locations in the
C       I/O page before you slip up and destroy something you want/need
C       ... psd


	PROGRAM bitpat

	BYTE         CHAR
	INTEGER*2    Address, First, Pattern, Clear, Set, TheBit, ComPat
	INTEGER*2    SetBits (16), ZeroBit (16)

	PARAMETER ( Clear = '000000'O )
	PARAMETER ( Set = '177777'O )
	PARAMETER ( First = '173772'O )

	COMMON /BLK1/ Address, Pattern, TheBit, ComPat, SetBits, ZeroBit

	Char = '?'
	Address = First
	Pattern = Clear

	DATA SetBits / "1, "2, "4, "10, "20, "40, "100, "200, "400, "1000,  
     1		"2000, "4000, "10000, "20000, "40000, "100000 /

	DATA ZeroBit / "177776, "177775, "177773, "177767, "177757, "177737,
     2			"177677, "177577, "177377, "176777, "175777, "173777,
     2			 "167777, "157777, "137777, "077777 /

C...... Print one time header

	WRITE (5,*) ' '
	WRITE (5,*) 'Parallel Card Bit Exerciser'
	CALL BELL
	WRITE (5,*) ' '
	WRITE (5,*) 'CAUTION ... User assumes responsibilities for all' 
	WRITE (5,*) 'devices connected to ports addressed by'
	WRITE (5,*) 'this exercisor ... some bit patterns may generate'
	WRITE (5,*) 'illegal, destructive or useless device states'
	WRITE (5,*) '		KNOW YOUR DEVICES! '
	WRITE (5,*) ' '
	   Do 7 Stall=1, 100000
	      I= I + 1
7	CONTINUE

C...... Print command descriptions

10	WRITE (5,*) ' '
	WRITE (5,12) Address
12	FORMAT (' Current Parallel Address is', O7.6)
	WRITE (5,14) Pattern
14	FORMAT (' Current Bus Pattern is', O7.6)
	WRITE (5,*) ' '
	WRITE (5,*) 'Recognized commands are:'
	WRITE (5,*) ' '
	WRITE (5,*) 'A - Set DLV11 Address'
	WRITE (5,*) 'B - Set Bit On'
	WRITE (5,*) 'C - Turn Bit Off'
	WRITE (5,*) 'D - Set All Bits On'
	WRITE (5,*) 'E - Turn All Bits Off'
	WRITE (5,*) 'G - Toggle Bit On, Off Continuously'
	WRITE (5,*) 'H - Help -- Information'
	WRITE (5,*) 'N - Toggle All Bits Continuously'
	WRITE (5,*) 'O - Walk Bit Across Bus'
	WRITE (5,*) 'P - Set Bit Pattern on Bus'
	WRITE (5,*) 'X - EXIT Program'

C...... Get the command

20	WRITE (5,*) ' '
	WRITE (5,*) 'Command?'
	READ  (5,'(A1)') CHAR

C...... Process the command

	IF ( CHAR .EQ. 'A' ) THEN

	   WRITE (5,*) 'Type CSR of DLV11 You Wish To Excercise (Octal)?'
	   WRITE (5,*) ' '
	   READ  (5,'(O6)') Address
	   Address = Address + 2
	   
	ELSE IF ( CHAR .EQ. 'B' ) THEN

	   WRITE (5,*) 'Which Bit to Set (1-16)?'
	   READ (5,'(I1)') TheBit
	   ComPat = SetBits(TheBit)
	   Pattern = ( IPEEK(Address) .OR. ComPat )
	   CALL IPOKE( Address, Pattern )

	ELSE IF ( CHAR .EQ. 'C' ) THEN

	   WRITE (5,*) 'Which Bit to Clear (1-16)?'
	   READ (5,'(I1)') TheBit
	   ComPat = ZeroBit(TheBit)
	   Pattern = ( IPEEK(Address) .AND. ComPat )
	   CALL IPOKE( Address, Pattern )

	ELSE IF ( CHAR .EQ. 'D' ) THEN

	   WRITE (5,*) '	All Bits On'
	   Pattern = Set
	   CALL IPOKE (Address, Pattern)

	ELSE IF ( CHAR .EQ. 'E' ) THEN

	   WRITE (5,*) '	All Bits Off'
	   Pattern = Clear
	   CALL IPOKE (Address, Pattern)

	ELSE IF ( CHAR .EQ. 'G' ) THEN

	   CALL OneToggle

	ELSE IF ( CHAR .EQ. 'H' ) THEN

	   GO TO 10

	ELSE IF ( CHAR .EQ. 'N' ) THEN

	   CALL AllToggle

	ELSE IF ( CHAR .EQ. 'O' ) THEN

	   CALL Walk

	ELSE IF ( CHAR .EQ. 'P' ) THEN

	   WRITE (5,*) '  Enter Bit Pattern in Octal (177777)'
	   READ (5,'(O6)') Pattern

	write (5,15) address
15	format (' Address = ', O7.6 )
	write (5,16) pattern
16	format (' Pattern = ', O7.6 )

	   CALL IPOKE (Address, Pattern)

	ELSE IF ( CHAR .EQ. 'X' ) THEN

	   CALL EXIT

	ELSE

	   WRITE (5,*) ' '
	   WRITE (5,*) '....What?....'
	   WRITE (5,*) ' '

	ENDIF

	GO TO 20

	END

C-----------------------------------------------------------------------------

	SUBROUTINE BELL

	BYTE DING DONG
	PARAMETER (DING DONG = 7)

	WRITE (5,'(1X,A1)') DING DONG

	END

C----------------------------------------------------------------------------
C.....  Set Bit 12 of JSW to return from key when none touched 

	SUBROUTINE SpecTerm

	CALL IPOKE ( "44, "10000 .OR. IPEEK ("44) )

	END

C----------------------------------------------------------------------------
C.....	Clear Special Terminal Mode (bit 12 of JSW)

	SUBROUTINE ClrSpTerm

	CALL IPOKE ( "44, "167777 .AND. IPEEK ("44) )

	END

C---------------------------------------------------------------------------

	SUBROUTINE AllToggle

	INTEGER*2	Stall, I, Done
	INTEGER*2    Address, Pattern, Clear, Set, TheBit, ComPat
	INTEGER*2    SetBits (16), ZeroBit (16)

	PARAMETER ( Clear = '000000'O )
	PARAMETER ( Set = '177777'O )

	COMMON /BLK1/ Address, Pattern, TheBit, ComPat, SetBits, ZeroBit

	WRITE (5,*) ' '
	WRITE (5,*) 'Entire Bus Now Toggling .. Space Bar to Escape'
	WRITE (5,*) ' '
	CALL SpecTerm 
50	Pattern = Set
	CALL IPOKE (Address, Pattern)

	  Do 100 Stall=1, 5000
	      I=I + 1
100	CONTINUE
	Pattern = Clear
	CALL IPOKE (Address, Pattern)

	   Do 110 Stall=1, 5000
	      I=I + 1
110	CONTINUE
	Done = ITTINR ()

	IF (Done .LT. 0) THEN
	  GO TO 50
	ENDIF

150	CALL ClrSpTerm

	END
C---------------------------------------------------------------------------

	SUBROUTINE OneToggle

	INTEGER*2	Stall, I, Done
	INTEGER*2    Address, Pattern, Clear, Set, TheBit, ComPat
	INTEGER*2    SetBits (16), ZeroBit (16)

	PARAMETER ( Clear = '000000'O )
	PARAMETER ( Set = '177777'O )

	COMMON /BLK1/ Address, Pattern, TheBit, ComPat, SetBits, ZeroBit

	WRITE (5,*) 'Which Bit do you Wish to Toggle (1-16)?'
	READ (5,'(I1)') TheBit

	WRITE (5,*) ' '
	WRITE (5,*) TheBit, ' Bit Now Toggling .. Space Bar to Escape'
	WRITE (5,*) ' '
	CALL SpecTerm 
155	ComPat = SetBits(TheBit)
	Pattern = ( IPEEK (Address) .OR. ComPat )
	CALL IPOKE (Address, Pattern)

	  Do 200 Stall=1, 5000
	      I=I + 1
200	CONTINUE
	ComPat = ZeroBit(TheBit)
	Pattern = ( IPEEK(Address) .AND. ComPat )
	CALL IPOKE (Address, Pattern)

	   Do 210 Stall=1, 5000
	      I=I + 1
210	CONTINUE
	Done = ITTINR ()

	IF (Done .LT. 0) THEN

	  GO TO 155

	ENDIF

250	CALL ClrSpTerm

	END

C---------------------------------------------------------------------------

	SUBROUTINE Walk

	INTEGER*2	Stall, I, Done
	INTEGER*2    Address, Pattern, Clear, Set, TheBit, ComPat
	INTEGER*2    SetBits (16), ZeroBit (16)
	INTEGER*4	WalkNum

	PARAMETER ( Clear = '000000'O )
	PARAMETER ( Set = '177777'O )

	COMMON /BLK1/ Address, Pattern, TheBit, ComPat, SetBits, ZeroBit

	NumWalk = 0

	WRITE (5,*) ' '
	WRITE (5,*) 'Single Bit Walking Across Bus .. Space Bar to Escape'
	WRITE (5,*) ' '
	CALL SpecTerm 
255	TheBit = (MOD (WalkNum, 16)) + 1
	Pattern = SetBits(TheBit)
	CALL IPOKE (Address, Pattern)

	  Do 300 Stall=1, 5000
	      I=I + 1
300	CONTINUE
	Pattern = Clear
	CALL IPOKE (Address, Pattern)

	   Do 310 Stall=1, 5000
	      I=I + 1
310	CONTINUE
	WalkNum = WalkNum + 1
	Done = ITTINR ()

	IF (Done .LT. 0) THEN

	  GO TO 255

	ENDIF

350	CALL ClrSpTerm

	END


S
                                                                                                           