	PROGRAM ED
C
CCC	Program to determine terminal type and set the
CCC	proper editor
C
CCC	Version 1	Jun 10/85
CCC	Set KED for VT100 for RT or TSX
CCC
CCC	Version 2	Apr 14/86
CCC	Set K52 for VT52 for TSX
CCC
CCC	Version 3	Apr 21/86
CCC	Set editor for RT or TSX
CCC	Written for F77
CCC
CCC	Version 3.1	Aug 20/86
CCC	Add a routine to first flush the buffer
CCC
CCC	Version 3.2	Aug 21/86
CCC	Combine the F77 and FORT versions into one copy
CCC	To compile for a specific Fortran, uncomment the
CCC	required code and comment the other
CCC
CCC		F77 CODE     - CF77
CCC		FORTRAN CODE - CFORT
C
CCC	Three terminal/editor types are recognized:
CCC
CCC		1 - VT100 - KED
CCC		2 - VT52  - KED (K52)
CCC		3 - CRT   - EDIT
CCC
C
CCC	The escape sequence used to identify the terminal type
CCC	is <ESC>Z, as <ESC>[c will hang a VT52
CCC
CCC	Response from a VT100 is        <ESC>[?1;Psc   (Ps = 0 -> 7)
CCC	Response from a VT52 is         <ESC>/Ps       (Ps = K, L, M)
CCC	Response from a CRT is          null (time-out)
C
CCC	Depending what the second character sent back is,
CCC	the appropriate EDITOR is set during the startup file
CCC
CCC      TERMINAL   COMMAND EXECUTED              OS
CCC
CCC	 CRT      SET EDIT EDIT			(RT/TSX)
CCC	 VT52     SET EDIT KED			(RT11)
CCC	 VT100    SET EDIT KED			(RT11)
CCC	 VT52     SET TERM VT52 / SET EDIT KED	(TSX)
CCC	 VT100    SET TERM VT100 / SET EDIT KED	(TSX)
CCC
C
CCC	Additional commands can be added later, as the command
CCC	string is defined as 132. bytes
CCC
C
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
	INTEGER*2 ICHAR
C
	BYTE	ASK(2), RESVT1(5), RESVT5(3)
	BYTE	S1(13), S2(13), S3(13), S4(28), S5(29)
	BYTE	CHAR(6), M1(2), M2(2), M4(2)
	BYTE	CMD(132), NULL(1)
C
	LOGICAL	TSX, RT11, CRT, VT52, VT100
CCC
CCC
	DATA	TSX/.FALSE./
	DATA	RT11/.FALSE./
	DATA	CRT /.FALSE./
	DATA	VT52 /.FALSE./
	DATA	VT100 /.FALSE./
CCC
CCC    Question and Answer
CCC
	DATA	ASK/"33,'Z'/				! Who are you?
	DATA	RESVT1/"33,'[','?','1',';'/		! VT100
	DATA	RESVT5/"33,'/','K'/			! VT52
C
	DATA	CMD/132*"0/
	DATA	NULL/"0/
CCC
CCC    SET commands
CCC
	DATA    S1/'S','E','T',' ','E','D','I','T',' ','E','D','I',"0/
	DATA    S2/'S','E','T',' ','E','D','I','T',' ','K','5','2',"0/
	DATA    S3/'S','E','T',' ','E','D','I','T',' ','K','E','D',"0/
	DATA    S4/'S','E','T',' ','T','E','R','M',' ','V','T','5','2',
     +	"15,"12,
     +	'S','E','T',' ','E','D','I','T',' ','K','E','D',"0/
	DATA    S5/'S','E','T',' ','T','E','R','M',' ','V','T','1','0',
     +	'0',
     +	"15,"12,
     +	'S','E','T',' ','E','D','I','T',' ','K','E','D',"0/
CCC
CCC    Special TSX characters
CCC
	DATA	M1/"35,'S'/			! TSX SINGLE CHAR ACTIVATION
	DATA	M2/"35,'U'/			! TSX NON TT WAIT
	DATA	M4/"35,'N'/			! TSX DATA FROM TERMINAL
CCC
CCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCC
CCC
	CALL IPOKE("44,"50100.OR.IPEEK("44))	! Set the JSW
CCC
CCC	Check if we are running under RT-11 or TSX
CCC
	IVER=ISPY("372)				! TSX or RT11
CCCCF77
CCCCF77         FORTRAN 77 CODE
CCCCF77
CF77	IF (IVER.LT.0) THEN			! Bit 15 =1 for TSX
CF77	   TSX=.TRUE.				! Running under TSX
CF77	   TYPE 500,M1				! Set special
CF77	   TYPE 500,M2				!  paramaters
CF77	   TYPE 500,M4				!  for TSX
CF77	ELSE
CF77	   RT11=.TRUE.				! Running under RT-11
CF77	END IF
CCCCF77
CCCCF77         END OF FORTRAN 77 CODE
CCCCF77
CCCCFORT
CCCCFORT        FORTRAN CODE
CCCCFORT
	IF (IVER.GE.0) GO TO 800		! Bit 15 =1 for TSX
	   TSX=.TRUE.				! Running under TSX
	   TYPE 500,M1				! Set special
	   TYPE 500,M2				!  paramaters
	   TYPE 500,M4				!  for TSX
	GO TO 801
 800	RT11=.TRUE.				! Running under RT-11
CCCCFORT
CCCCFORT        END OF FORTRAN CODE
CCCCFORT
CCC
CCC	This is a counter to first flush the input buffer of
CCC	impatient user who bang away at the keys
CCC
 801	CALL ISLEEP(0,0,1,0)			! Wait 1 sec.
        DO 99 K=1,256				! Set up a counter
	ICHAR = ITTINR()			! Flush the input buffer
        IF(ICHAR.LT.0) GO TO 999		! Any response? - NO
 99     CONTINUE
C
 999	TYPE 500,ASK				! WHO ARE YOU?
C
	I=0					! Set up a counter
        DO 10 J=1,1000				! TIMED LOOP
	ICHAR = ITTINR()
        IF(ICHAR.LT.0) GO TO 10			! Any response? - NO
	I=I+1
	CHAR(I)=ICHAR				! Save the response
 10     CONTINUE
C	IF (I.LT.2) GO TO 10			! Check the second res.
C
CCCCF77
CCCCF77         FORTRAN 77 CODE
CCCCF77
CF77	IF (CHAR(2).EQ.RESVT1(2)) THEN		! Is it '['? YES = VT100
CF77	   VT100=.TRUE.
CF77	ELSE IF (CHAR(2).EQ.RESVT5(2)) THEN	! Is it '/'? YES = VT52
CF77	   VT52=.TRUE.
CF77	ELSE
CF77	   CRT=.TRUE.
CF77	END IF
CCCCF77
CCCCF77         END OF FORTRAN 77 CODE
CCCCF77
CCC
CCCCFORT
CCCCFORT        FORTRAN CODE
CCCCFORT
	IF (CHAR(2).NE.RESVT1(2)) GO TO 810	! Is it '['? YES = VT100
	   VT100=.TRUE.
	   GO TO 812
 810	IF (CHAR(2).NE.RESVT5(2)) GO TO 811	! Is it '/'? YES = VT52
	   VT52=.TRUE.
	   GO TO 812
 811	CRT=.TRUE.
CCCCFORT
CCCCFORT        END OF FORTRAN CODE
CCCCFORT
C
CCCCF77
CCCCF77         FORTRAN 77 CODE
CCCCF77
CF77	IF (RT11.AND.VT52) THEN
CF77	   CALL CONCAT(S2,NULL,CMD)
CF77	ELSE IF (RT11.AND.VT100) THEN
CF77	   CALL CONCAT(S3,NULL,CMD)
CF77	ELSE IF (TSX.AND.VT52) THEN
CF77	   CALL CONCAT(S4,NULL,CMD)
CF77	ELSE IF	(TSX.AND.VT100) THEN
CF77	   CALL CONCAT(S5,NULL,CMD)
CF77	ELSE
CF77	   CALL CONCAT(S1,NULL,CMD)
CF77	END IF
CCCCF77
CCCCF77         END OF FORTRAN 77 CODE
CCCCF77
CCC
CCCCFORT
CCCCFORT        FORTRAN CODE
CCCCFORT
 812	IF (.NOT.(RT11.AND.VT52)) GO TO 813
	   CALL CONCAT(S2,NULL,CMD)
	   GO TO 820
 813	IF (.NOT.(RT11.AND.VT100)) GO TO 814
	   CALL CONCAT(S3,NULL,CMD)
	   GO TO 820
 814	IF (.NOT.(TSX.AND.VT52)) GO TO 815
	   CALL CONCAT(S4,NULL,CMD)
	   GO TO 820
 815	IF (.NOT.(TSX.AND.VT100)) GO TO 816
	   CALL CONCAT(S5,NULL,CMD)
	   GO TO 820
 816	   CALL CONCAT(S1,NULL,CMD)
CCCCFORT
CCCCFORT        END OF FORTRAN CODE
CCCCFORT
C
 820	DO 13 J=1,256				! FLUSH THE BUFFER
 13	ICHAR=ITTINR()
C
	CALL SETCMD(CMD)			! Execute the command
	CALL EXIT
CCC
CCC	FORMAT STATEMENTS
CCC
 500	FORMAT(1X,2A1,$)
C
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                     