	Program SPIRAL
c
c	Author: R N Caffin
c
c	Test routine for Plotter, HVPLOT Library.
c	Draws a labelled axis and a double spiral.
c
	real	x(1050),y(1050)
	character*80	string			!Required by the Plot Library

350	type 1000
1000	format(x,'What size steps in spiral (1-20)?:',$)
	accept *,istep
	if(istep.lt.1.or.istep.gt.20)goto 350

c	Initialise the system

	call init()			!Basic set-up and select device
	call select(1)			!Choose pen
	call scale(-12.,+12.,-12.,+12.)	!Set up the scale

c	Draw the axis and write the big labels

	call axis(0.,0.,2.,2.)
	string='Y Axis'
	call labexy(-1.0,5.,0.2,90.0,string)
	string='X Axis'
	call labexy(5.,-1.5,0.2,00.0,string)

	string='Spiral Demonstration'
	call text(-5.,10.5,0.5,0.,string)
	string='R N Caffin & S L Hewett'
	call text(-11.5,-9.0,0.25,0.,string)
	string='CSIRO Textile Physics'
	call text(-11.5,-10.0,0.25,0.,string)

c	Label X axis

	call size(0.15,0.22)
	do 200 i=-10,10,2
	  call jump(float(i),-0.5)
	  if(i.ne.0)call labeln(i)
200	  continue

c	Label Y axis

	do 300 i=-10,10,2
	  call jump(-0.8,float(i))
	  if(i.ne.0)call labeln(i)
300	  continue

c	Change pen

	call select(2)

c	Calculate the spiral

	lim=1021
	do 100 j=1,lim
	  x(j)=(0.01*j)*sin(0.02*j)
	  y(j)=(0.01*j)*cos(0.02*j)
100	  continue

c	Plot the double spiral

	call jump(x(lim),y(lim))
	do 400 j=lim,1,-istep
	  call draw(x(j),y(j))
400	  continue
	do 410 j=1,lim,istep
	  call draw(-x(j),-y(j))
410	  continue

c	Clean up

	call home			!Return pen to holder and eject paper
	call ploff			!Disable the plotter

	stop
	end
                                                                                                                                                                                                                                                                                                                                                                                                                               