c		HVPLOT(TSX) Part 0
c
c	Control Subroutines for HVPLOT
c
c	Dr R N Caffin and S L Hewett
c	CSIRO Div of Textile Physics
c	338 Blaxland Rd
c	Ryde  N S W  2112
c	Australia
c
c	21-Sep-84
c
c	Amended for the Vax 31-1-85
c	Amended for Tsx 17-6-85
c
c
c******	Full initialization returning the plotter's graphic conditions to
c	the initial power on state. Also initailizing the RS-232 
c	environment.

	Subroutine INIT						!INIT

	include 'HV.INC'

	data		hv,plonsw,flh,flv,flsh,flsv/6*.false./
	data		xminv,xmaxv,yminv,ymaxv/0.,767.,0.,479./
	data		xmul,ymul/1.0,1.0/
	data		etx,si,so,esc/"003,"017,"016,"033/
	data		EPp/'   '/,Ebsl/'  '/

c	Choose which output device.

10	type 1000
1000	format(x,'Output device? Plotter (H) or VT125 (V)',$)
	accept 1010,ans
1010	format(a)
	if(ans.eq.'h')ans='H'
	if(ans.eq.'v')ans='V'
	if(ans.ne.'H'.and.ans.ne.'V')goto 10

	hv=(ans.eq.'V')

	if(hv)goto 500

	plonsw=.true.
	flh=.true.
c
	open(unit=9, name='PL:', type= 'NEW', carriagecontrol='LIST')
 
20	write(9,1020) esc,esc,esc
1020	format(A,'.Y', 'IN', A,'.I100;;17:', A,'.N;19:')

	goto 999

c***    To initialize the VT125 for plotting

500	flv=.true.
	EPp(1:1)=esc			!Init VT125 command codes
	EPp(2:3)='Pp'
	Ebsl(1:1)=esc
	Ebsl(2:2)='\'
	type 5010,esc,esc,Ebsl
5010	format('+', A,'[2J', A,'P0p', a)	!Clear text scrn, enter REGIS
	call vtclr			!Clear the screen.

999	return
	end

c****** To enable switching between devices

	Subroutine DEVSWT(flag)

	include 'HV.INC'
	character*1	flag

	if(flag.eq.'H'.and.flh)hv=.false.
	if(flag.eq.'V'.and.flv)hv=.true.
	return
	end


c****** Returns plotter to default conditions

	Subroutine RESTOR					!RESTOR

	include 'HV.INC'

	if(hv)goto 500

10	if(.not.plonsw)goto 999		!Check for already off

	write(9,1000)
1000	format('DF;')
	goto 999

c***	Not implemented on VT125

500	continue

999	return
	end

c******	Establishes a user-unit coordinate system by mapping values onto
c	the scaling points P1 and P2.

	Subroutine SCALE(xmn,xmx,ymn,ymx)			!SCALE

	include 'HV.INC'

	if(hv)goto 500

10	if(.not.plonsw)goto 999		!Check for already off
	flsh=.true.
	xmin=xmn
	xmax=xmx
	ymin=ymn
	ymax=ymx
	write(9,1000) xmin,xmax,ymin,ymax
1000	format('SC ',4(x,f10.3),';')
	goto 999

c***	To establish the user-unit coordinate system for use in SCL.

500	flsv=.true.
	xminv=xmn
	xmaxv=xmx
	yminv=ymn
	ymaxv=ymx
	xmul=0.99*769./(xmaxv-xminv)		!.99 to avoid very grotty
	ymul=0.99*479./(ymaxv-yminv)		! behaviour on overflow!
999	return
	end

c******	To select and/or store one of two pens.
c	0....to store the pen.
c	Odd number for the left pen.
c	Even number for the righthand pen.

	Subroutine SELECT(n)					!SELECT(n)

	include 'HV.INC'

	if(hv)goto 500

10	if(.not.plonsw)goto 999		!Check for already off

	write(9,1000) n
1000	format('SP ',I1,';')
	goto 999

c***	To alter the standard character set, to a loadable one.
c	I don't think this is going to be of any use!!!
c	For variable character sets, you are better off using VT100 mode.


500	continue

999	return
	end

c*****	To turn the plotter OFF after a plot.
c	This helps to avoid a whole lot of garbage left in the Fortran buffer
c	 from being executed. Under RT-11 the special bit also kills the
c	 interupt enables on the serial port, thereby improving the life and
c	 welfare of the entire system.

	Subroutine PLOFF()					!PLOFF

	include 'HV.INC'

	if(hv)goto 500

10	if(.not.plonsw)goto 999		!Check for already off

	call select(0)			!Put pen away
	write(9,1000) esc
1000	format(A,'.Z')
	rewind 9			!Force output at this stage.
	plonsw=.false.
c
	goto 999

c***    To switch off REGIS mode.

500	type 5000,Ebsl
5000	format('+',A)

999	return
	end

c******	To turn the plotter ON after PLOFF has turned it off, and to
c	 load pen i.

	Subroutine PLON(i)				!PLON

	include 'HV.INC'

	if(hv)goto 500

10	if(plonsw)goto 999		!On already?

	write(9,1000) esc
1000	format(A,'.Y')
	call select(i)
	rewind 9			!Force output again.
	plonsw=.true.
	goto 999

c***    To switch back to REGIS mode.

500	type 5000,EPp
5000	format('+',a)

999	return
	end


c***	To totally zap the graphics screen

	Subroutine VTCLR					!VTCLR

	include 'HV.INC'

	if(hv)goto 500
c	Not required for plotter
	goto 999

500	type 5000,EPp,Ebsl			!Clear the screen
5000	format('+',A,'S(e)',A)

999	return
	end


c	VT125 auxilary routines used inside the package


c***	To move n pixels in direction ii.

	Subroutine PICK(ii,n)					!PICK

	include 'HV.INC'

	if(hv)goto 500

c	Not required for plotter
	goto 999

500	if(ii.lt.0.or.ii.gt.7)return
	type 5000,EPp			!	    2
5000	format('+',A,'P')		!	  3   1
	do 510 i=1,n			!	4   .	0
	  type 5010,ii			!	  5   7
5010	  format('+',I1)		!	    6
510	  continue
	type 5020,Ebsl
5020	format('+',A)

999	return
	end


c***	To scale the location chosen to screen coordinates.
c	User space is (xx,yy); VT125 space is (x,y)

	Subroutine SCL(xx,yy,x,y)				!SCL

	include 'HV.INC'

	if(hv)goto 500

c	Not required by plotter
	goto 999

500	if(.not.(flv.and.flsv))stop 'Call INIT and SCALE first'

	x=(xx-xminv)*xmul
	y=479.-(yy-yminv)*ymul

999	return
	end


c***	To draw n pixels in direction ii.

	Subroutine TICK(ii,n)					!TICK

	include 'HV.INC'

	if(hv)goto 500

c	Not required by plotter
	goto 999

500	if(ii.lt.0.or.ii.gt.7)return
	type 5000,EPp
5000	format('+',a,'V')
	do 510 i=1,n
	  type 5010,ii
5010	  format('+',I1)
510	  continue
	type 5020,Ebsl
5020	format('+',A)

999	return
	end

c***	To draw the ticks on the axis.
c	false= vert
c	true=horiz
	Subroutine ATICK(flag)

	include 'HV.INC'

	logical*1	flag
	character*1	char1,char2

	if(hv)goto 500

c	Not required by plotter
	goto 999

500	char1='4'		!Assume flag false
	char2='0'
	if(flag)char1='6'
	if(flag)char2='2'
	type 5000,EPp,(char1,i=1,4),(char2,i=1,9),Ebsl
5000	format('+',a,'P',4a,'V',9a,a)

999	return
	end
                                  