C	File Name:  UNMACR.FOR			!Rev 8302.051
C
C************************ MAIN MODULE FOR UNMAC ************************
C
	PROGRAM UNMAC				!Rev 8301.291
C
C*********************** UNMAC Version 1.0 *****************************
C
C	'UNMAC' decodes an RT-11 or RSX-11 object file into an assembly
C	language source or listing as desired.  The input object file
C	may be in library format, and also may contain several object
C	modules.
C
C	Decoding is performed by making two passes through each object
C	module of the input file.  The first pass gathers information
C	about globals and how to assign addresses and allocate memory.
C	The second pass completes the decoding.
C
C	NOTE:  This program was written as an attempt to provide better
C	       tools to span all of DEC's operating systems.  Since
C	       decoding is not likely to be performed very often, the
C	       intent of this program is not to provide the fastest
C	       possible program  (which would probably result in a
C	       difficult to read MACRO source), but to provide a
C	       thouroughly documented and well structured program in a
C	       high-level language so that others may easily be able
C	       to understand what is involved in the decoding process.
C	       If you are able to improve this code in any way, send
C	       me a listing of your changes and I will see that they
C	       get installed in future releases.
C
C	Written by Robert Walraven
C	           Dept. of Applied Science
C	           University of California
C	           Davis, CA 95616
C	           916/752-0360
C
C**********************************************************************
C
	CALL ONCE				!Once-only initialization
	CALL QUERY				!Find out what user wants to do.
	IF (LIB FND ()) CALL GET DIR	!If input is a library file,
C						!  get the library directory.
   10	CALL MD INIT			!Initialize module data.
	CALL PASS1				!Scan module first time.
	CALL PASS2				!Then again.
	CALL NXT MOD			!Reset pointers for next module
	GO TO 10
C
	END
	SUBROUTINE MD INIT			!Rev 8302.031
C
C=======>> Initialize parameters for the next object module <<=======
C
	IMPLICIT INTEGER (A-Z)
C
C------------------------------ COMMONS -----------------------------
C
	COMMON /FPI/ RFLAG,IFLAG
	LOGICAL RFLAG,IFLAG
	COMMON /GLOBLS/ NGLBLS, GNAME(2,400), GFLAGS(400), GVALUE(400),
     1		GPSECT(400)
	BYTE GFLAGS, GPSECT
	COMMON /INPUT/ BLOCK, COUNT, INPUT(512)
	BYTE INPUT
	COMMON /LABELS/ NLABEL, LABL PS(2,1000), LABL OF(1000),
     1		PL NAME(2), L OFF
	COMMON /MACRO/ MACRO
	LOGICAL MACRO
	COMMON /PSECTS/ NPSECT, PSNAME(2,100), PSFLAG(100), PSVALU(100)
	BYTE PSFLAG
	COMMON /RECORD/ LEN, NXT CHR, RECORD(256)
	BYTE RECORD
	COMMON /SAVE/ SAV BLK, SAV CNT
	COMMON /SYSTEM/ SYSTEM, RT, RSX
	COMMON /XFR/ XFR ADR, XFR NAM(2), STARTF
	LOGICAL STARTF
C
D	COMMON /DEBUG/ DEBUG(50)
D	LOGICAL DEBUG
C
C---------------------- LOCAL VARIABLES AND DATA -----------------------
C
	DATA SAV BLK/1/, SAV CNT/0/	!Start of current module
	DATA BLOCK/0/, COUNT/513/	!These values force an initial read
	DATA RT/1/, RSX/2/		!System codes
C
C=======================================================================
C
C BEGIN DEBUG
D	IF (DEBUG(1)) CALL NEWLIN
D	IF (DEBUG(1)) CALL OUT TXT (';MDINIT called')
C END DEBUG
C
	LEN = 0				!Empty record buffer
	N GLBLS = 0				!No GLOBLS found yet
	N LABEL = 0				!No labels found yet
	N PSECT = 0				!No PSECTS found yet
	DO 10 I=1,100			!Zero psect switches
		PS VALU (I) = 0
   10	CONTINUE
C
C......................... Floating Point Flags .........................
C
	RFLAG = .TRUE.			!TRUE = REAL,    FALSE = DOUBLE
	IFLAG = .TRUE.			!TRUE = INTEGER, FALSE = LOGICAL
C
	RETURN
	END
	SUBROUTINE NXT MOD				!Rev 8302.051
C
C==============> Set pointers to start of next module <==============
C
	IMPLICIT INTEGER (A-Z)
C
C----------------------------- COMMONS ------------------------------
C
	COMMON /LIB/ FND LIB
	LOGICAL FND LIB
	COMMON /INPUT/ BLOCK, COUNT, INPUT(512)
	BYTE INPUT
	COMMON /SAVE/ SAV BLK, SAV CNT
C
D	COMMON /DEBUG/ DEBUG(50)
D	LOGICAL DEBUG
D	COMMON /REWIND/ RWND FL, DO RWND
D	LOGICAL RWND FL, DO RWND
C
C===================================================================
C
C BEGIN DEBUG
D	IF (DEBUG(2)) CALL NEWLIN
D	IF (DEBUG(2)) CALL OUT TXT (';NXT MOD - Reset pointers ')
D	IF (DEBUG(2)) CALL OUT TXT ('for next module')
D	CALL CRLF
D	IF (RWND FL) DO RWND = .TRUE.
C END DEBUG
C
	SAV CNT = COUNT
	SAV BLK = BLOCK
C
	RETURN
	END
                              