/*--- EDIT # 0078	17 Apr 1982    0:33:10	DB1:[21,6]GETHDR.C;123  */
/*--- PREVIOUS EDIT	18 Jan 1982    9:35:00	DB0:[310,105]GETHDR.C;122  */
/* routine to read in a file-header. This is done by reading the
index file in block-mode. */
/* called with the directory file open. The index-file is re-opened on
	this fp */

#include <stdio.h>
#include <hdr.h>


unsigned int index_offset = 0;	/* block number of fid=(1,1) */

gethdr (ib, fnum, fseq, dir)
struct hdr *ib;
unsigned int fnum, fseq;
FILE *dir;
{
   int n;
   char ixf_name [35];
   char *d, *f;
   long int file_pos;
/* 1st word of home block is index bitmap size */

   if (!index_offset) {
/* get the device name, then the rest of the filename */
      iovtoa (dir, ixf_name);
      d = ixf_name;
      while (*d++ != ':') ;
      f = "[0,0]INDEXF.SYS";
      while (*d++ = *f++);
/*fprintf (stderr,"Opening: %s\n", ixf_name);*/
      if (!freopen(ixf_name, "runb", dir))
	 return (-1);	/* can't open the index-file */
/* For the INDEX file, kludge up the fdb */
/* The 1st word of the home-block (2nd block of the index-file) tells
the number of blocks in the index bitmap, which is the offset for the
file-headers. i can't quite figure out how to share the definition of
"ib" betewwn the header and an array of words, so I did it this way,
knowing that it will always be a small number. You should be able to
just read 2 bytes into an integer, but virtual disks can't do that */
      dir->io_fdb[2] = dir->io_fdb[4] = 077777;
      fseek (dir,01000l, 0);	/* read the home block */
      n = fget (ib, sizeof *ib, dir);
      index_offset = 1 + ib->h_idof;
   }

   /* read the desired file-header */
   file_pos = 01000l * (index_offset + fnum);
   fseek (dir, file_pos, 0);
   n = fget (ib, sizeof *ib, dir);
   if ((ib->h_fnum == fnum) &&
	(ib->h_fseq == fseq))	return (0);
   printf ("index_offset=%d\n", index_offset);
   printf ("req, got: %o,%o   %o,%o\n", fnum, fseq, ib->h_fnum, ib->h_fseq);
   return (-36);
}
         