  program whetstonebenchmark;
(*$A-,T-   Turn off array bounds checking and stack overflow checking*)
(* This Pascal program is a translation of the algorithm
  described in "A Synthetic Benchmark" , H.J. Curnow and
  B.A. Wichmann.  Vol 19, number 1, The Computer Journal.
*)

TYPE
  array4real = ARRAY[1..4] OF real;
VAR
  t,t1,t2,x,y,z:real;
  i,j,k,l,n1,n2,n3,n4,n5,n6,n7,n8,n9,n10,n11,n12:integer;
  x1,x2,x3,x4:real;
  e1 : array4real;

  PROCEDURE pa(VAR e:array4real);
   VAR j : Integer;
   BEGIN
     FOR j := 0 to 6 DO BEGIN
	e[1]:=(e[1]+e[2]+e[3]-e[4])*t;
	e[2]:=(e[1]+e[2]-e[3]+e[4])*t;
	e[3]:=(e[1]-e[2]+e[3]+e[4])*t;
	e[4]:=(-e[1]+e[2]+e[3]+e[4])/t2;
      END
   END;

  PROCEDURE p0;
   BEGIN
     e1[j]:=e1[k]; e1[k]:= e1[l]; e1[l]:= e1[j]
   END;

  PROCEDURE p3(x,y:real; VAR z:real);
  VAR
    x1,y1:real;
   BEGIN
     x1:=x; y1:=y;
     x1:= t*(x1+y1);
     y1 := t*(x1+y1);
     z:=(x1+y1)/t2
   END;



 BEGIN(*main*)
(*
initialize series approximation constants and loop counter
*)
   t := 0.499975; t1 := 0.50025; t2 := 2.0;
   write('Iterations ?');
   read(i);

   (* establish execution frequencies *)
   n1 := 0 ;
   n2 := 12*i;
   n3 := 14*i;
   n4 := 345*i;
   n5 := 0;
   n6 := 210*i;
   n7 := 32*i;
   n8 := 899*i;
   n9 := 616*i;
   n10:= 0;
   n11:= 93*i;
n12 :=0;
   (*
    module 1: simple identifiers
    *)
   x1 := 1.0;
   x2 :=-1.0;
   x3 :=-1.0;
   x4 :=-1.0;
   FOR i := 1 TO n1 DO BEGIN
      x1 := (x1+x2+x3-x4)*t;
      x2 := (x1+x2-x3+x4)*t;
      x3 := (x1-x2+x3+x4)*t;
      x4 := (-x1+x2+x3+x4)*t
    END;
   (*
    module 2: array elements
    *)
   e1[1] := 1.0;
   e1[2] :=-1.0;
   e1[3] :=-1.0;
   e1[4] :=-1.0;
   FOR i := 1 TO n2 DO BEGIN
      e1[1] := (e1[1]+e1[2]+e1[3]-e1[4])*t;
      e1[2] := (e1[1]+e1[2]-e1[3]+e1[4])*t;
      e1[3] := (e1[1]-e1[2]+e1[3]+e1[4])*t;
      e1[4] := (-e1[1]+e1[2]+e1[3]+e1[4])*t
    END;

   (*
    module 3:  array as parameter
    *)
   FOR i := 1 TO n3 DO pa(e1);
(*
  module 4: conditional jumps
    *)
   j:= 1;
   FOR i := 1 TO n4 DO BEGIN
      IF j=1 THEN j := 2 ELSE j := 3;
      IF j>2 THEN j := 0 ELSE j := 1;
      IF j<1 THEN j := 1 ELSE j := 0
    END;
   (*
    module 5: omitted
    *)
   (*
    module 6: integer arithmetic
    *)
   j := 1;
   k := 2;
   l := 3;
   FOR i := 1 TO n6 DO BEGIN
      j := j*(k-j)*(l-k);
      k := l*k-(l-j)*k;
      l := (l-k)*(k+j);
      e1[l-1] := j+k+l;
      e1[k-1] := j*k*l
    END;
   (*
    module 7: trig functions
    *)
   x := 0.5;
   y := 0.5;
   FOR i := 1 TO n7 DO BEGIN
      x := arctan(t2*sin(x)*cos(x)/(cos(x+y)+cos(x-y)-1.0))*t;
      y := arctan(t2*sin(y)*cos(y)/(cos(x+y)+cos(x-y)-1.0))*t
    END;
   (*
    module 8: procedure calls
    *)
   x := 1.0;
   y := 1.0;
   z := 1.0;
   FOR i := 1 TO n8 DO p3(x,y,z);
   (*
    module 9: array references
    *)
   j := 1;
   k := 2;
   l := 3;
   e1[1] := 1.0;
   e1[2] := 2.0;
   e1[3] := 3.0;
   FOR i := 1 TO n9 DO p0;
   (*
    module 10: integer arithmetic
    *)
   j := 2;
   k := 3;
   FOR i := 1 TO n10 DO BEGIN
      j := j+k;
      k := j+k;
      j := k-j;
      k := k-j-j
    END;
   (*
    module 11: standard functions
    *)
   x := 0.75;
   FOR i := 1 TO n11 DO x := sqrt(exp(ln(x)/t1));
 END.
                                                                                                                                                                                               