	SUBROUTINE GRPNTS(IBUF,MODE,X,Y,IGR)
C
C
C	J. LISCOUSKI  DIGITAL EQUIPMENT CORPORATION
C	NOV. 9, 1979
C
C	THIS SUBROUTINE WILL PERMIT GRAPHS TO BE DRAWS GIVEN
C	A FEW ARGUMENTS.
C
C	NOTE: IF SHADING IS DESIRED THEN THE GRSHAD SUBROUTINE
C	      SHOULD BE USED
C
C	IBUF	IS THE INFORMATION BUFFER DIMENSIONED BY THE
C		USER FOR 28 WORDS.
C
C	MODE    INCLUDED FOR COMPATABILITY WITH GRPNTM
C
C	X	IS THE COORDINATE FOR THE X-AXIS.
C
C	Y	IS THE COORDINATE FOR THE Y-AXIS.
C
C
C	IGR	IS THE GRAPH NUMBER (0/1) FOR PLOTTING, THE DEFAULT IS 0.
C
C	NOTE: ALL ARGUMENTS ARE NEEDED, EITHER BY DEFAULT OR BY USER
C	      DEFINITION.  IF ANY ARE MISSING, A TRAP TO 4 MAY RESULT.
C
	DIMENSION IBUF(1),TEMP(4),ITEMP(8),IRB(2,3),IB(2)
	BYTE CMD(11),ENTRGR(3),EXITGR(3),IGCODE(2)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),XMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),XMAX)	!FROM IBUF INTO THE APPROPRIATE
	EQUIVALENCE (TEMP(3),YMIN)	!REAL VARIABLES
	EQUIVALENCE (TEMP(4),YMAX)
	DATA IRB/239,150,129,50,239,50/ !REGION BOUNDS
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	DATA IGCODE/'B','J'/
	DATA IB/10,18/
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. SUBROUTINE
C
C	BEGINNING OF EXECUTABLE CODE
C
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRPNTS - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).EQ."52525)GOTO 4 !GRINIT CALLED?
	CALL ERRMSG('?GRPNTS - GRINIT not called')
	CALL EXIT
	RETURN
4	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 3	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRPNTS - graph not assigned to region')
	CALL EXIT
	RETURN
3	CALL IDFLT(IMODE,0,MODE)	!CHECK DEFAULT ON MODE
C
C	GET SCALING VALUES FOR X AND Y AXIS
C
	IBASE=IB(IGRAPH+1)
10	IF(IBUF(2+IGRAPH).NE.0)GOTO 12	!HAVE SCALED VALUES BEEN ENTERED?
	CALL ERRMSG('?GRPNTS - scaling has not been provided for graph')
	CALL EXIT
	RETURN
12	DO 15 I=1,8
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
C	(40)	NOW LOAD GRAPHICS
C
40	IF((IBUF(4).AND.1).NE.0)GOTO 45	!DISPLAY GRAPHICS ENABLED?
	IBUF(4)=IBUF(4).OR.1
45	CALL OUTSTR(ENTRGR) !ENTER GRAPHICS MODE
	I=2	!ENABLE GRAPHICS FOR APPROPRIATE GRAPH
	IF(IGRAPH.EQ.1)I=4
	IF((IBUF(4).AND.I).NE.0)GOTO 50 !SKIP OVER THE NEXT FEW LINES
C                                       !IF THE GRAPH ENABLE IS DONE
	IBUF(4)=IBUF(4).OR.I	!SET BITS
	CMD(1)='A'
	CMD(2)=IBUF(4)
	CMD(3)=IBUF(5)
	CALL OUTSTR(CMD,3) !SET UP REGISTER IN VT105
C
C NOW (FINALLY) PUT UP THE POINT
C
50	RANGE=IRB(1,IRGN)-IRB(2,IRGN) !# OF DOTS ON Y-AXIS
	IX=INT(F(X,XMAX,XMIN)*511.)
C
C	CHECK FOR X OUT OF RANGE
C
	IF(IX.LT.0)IX=0
	IF(IX.GT.511)IX=511
C
	CMD(1)='H'
	CMD(2)=32+("37 .AND. IX)
	CMD(3)=32+(("740 .AND. IX)/32)
	IY=F(Y,YMAX,YMIN)*RANGE
D	IF(IY.LE.IRB(1,IRGN))GOTO 2000
D	CALL OUTSTR(EXITGR)
D	CALL VTMCUR(1,1)
D	WRITE(7,1900)YMAX,YMIN,Y,IY,IRB(1,IRGN),IRB(2,IRGN)
D1900	FORMAT(' YMAX=',E13.6,'  YMIN=',E13.6,'   Y=',E13.6,/,
D    1	       ' IY=',I7,'  IRB(1,IRGN)=',I7,'  IRB(2,IRGN)=',I7)
D	PAUSE 'hit <cr> to continue'
D	CALL OUTSTR(ENTRGR)
2000	IF(((IX/128)*128) .EQ. IX)IY=0 !LEAVE TICK MARKS ALONE
	IY=IY+IRB(2,IRGN)	!ADD OFFSET FOR BOTTOM OF GRAPH
C
C	CHECK FOR Y OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(4)=IGCODE(IGRAPH+1)
	CMD(5)=32+("37 .AND. IY)
	CMD(6)=32+(("340 .AND. IY)/32)
	CALL OUTSTR(CMD,6)
	CALL OUTSTR(EXITGR)	!EXIT GRAPHICS MODE
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             