	SUBROUTINE GRPNTM(IBUF,MODE,X,Y,IGR,FACTOR)
C
C
C	J. LISCOUSKI  DIGITAL EQUIPMENT CORPORATION
C	NOV. 9, 1979
C
C	THIS SUBROUTINE WILL PERMIT GRAPHS TO BE DRAWS GIVEN
C	A FEW ARGUMENTS. IF SHADING IS DESIRED, THEN THE
C	SUBROUTINE GRSHAD SHOULD BE USED.
C
C	IBUF	IS THE INFORMATION BUFFER DIMENSIONED BY THE
C		USER FOR 28 WORDS.
C
C	MODE	MODE IS USED TO ENABLE OR DISABLE CERTAIN DISPLAY
C		FEATURE OF THE SYSTEM.  SOME COMBINATIONS OF MODES
C		CAN BE EFFECTED BY SUMMING THE VALUES FOR THE VARIOUS
C		TYPES:
C		OPTION		VALUE (IF ENABLED)
C		-----		-----------------
C		MOVE		       16
C
C
C	X	IS THE ARRAY FOR THE HORIZONTAL AXIS, IT MAY BE DEFAULTED.
C		IF THE DEFAULT IS CHOSEN, A COUNTER FROM 1 TO NPTS WILL BE
C		USED IN ITS PLACE.
C
C	Y	IS THE ARRAY FOR THE VERTICAL AXIS AND IS MANDITORY.
C
C
C	IGR	IS THE GRAPH NUMBER (0/1) FOR PLOTTING, THE DEFAULT IS 0.
C
C	FACTOR  IS A MULTIPLIER USED T PROVIDE AOME SCALING FOR THE
C		HORIZONTAL AXIS WHILE IN STRIPCHART MODE.  THE CALCULATION
C		IS (number of points)*(factor)
C
C	NOTE: ALL ARGUMENTS ARE NEEDED, EITHER BY DEFAULT OR BY USER
C	      DEFINITION.  IF ANY ARE MISSING, A TRAP TO 4 MAY RESULT.
C
	DIMENSION IBUF(1),TEMP(4),ITEMP(8),IRB(2,3),IB(2),IROW(3)
	BYTE CMD(11),ENTRGR(3),EXITGR(3),IGCODE(2)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),XMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),XMAX)	!FROM IBUF INTO THE APPROPRIATE
	EQUIVALENCE (TEMP(3),YMIN)	!REAL VARIABLES
	EQUIVALENCE (TEMP(4),YMAX)
	DATA IRB/239,150,129,50,239,50/ !REGION BOUNDS
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	DATA IGCODE/'B','J'/
	DATA IB/10,18/
	DATA IROW/10,20,20/ !ROW #'S FOR LABLEING X-AXIS
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. SUBROUTINE
C
C	BEGINNING OF EXECUTABLE CODE
C
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRPNTM - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).EQ."52525)GOTO 2 !GRINIT CALLED?
	CALL ERRMSG('?GRPNTM - GRINIT has not been called')
	CALL EXIT
	RETURN
2	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 4	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRPNTM - graph not assigned to region')
	CALL EXIT
	RETURN
4	CALL IDFLT(IMODE,227,MODE)	!CHECK DEFAULT ON MODE
C
C	HAS THE GRAPH BEEN SCALED?
C
	IF(IBUF(2+IGRAPH).NE.0)GOTO 6
	CALL ERRMSG('?GRPNTM - scaling has not been provided for graph')
	CALL EXIT
	RETURN
6	IBASE=IB(IGRAPH+1)
	DO 15 I=1,8
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
C	(40)	NOW LOAD GRAPHICS
C
40	IF((IBUF(4).AND.1).NE.0)GOTO 45	!DISPLAY GRAPHICS ENABLED?
	IBUF(4)=IBUF(4).OR.1
45	CALL OUTSTR(ENTRGR) !ENTER GRAPHICS MODE
	I=2	!ENABLE GRAPHICS FOR APPROPRIATE GRAPH
	IF(IGRAPH.EQ.1)I=4
	IF((IBUF(4).AND.I).NE.0)GOTO 50 !SKIP OVER THE NEXT FEW LINES
C                                       !OF CODE IF THE GRAPH IS SET
	IBUF(4)=IBUF(4).OR.I	!SET BITS
C
C	SET BIT IF STRIP CHART MODE IS REQUIRED
C
	IF((IMODE.AND.16).NE.0)IBUF(5)=IBUF(5).OR."10 !3RD CHAR., REG. 0
	CMD(1)='A'
	CMD(2)=IBUF(4)
	CMD(3)=IBUF(5)
	CALL OUTSTR(CMD,3)
C
C NOW (FINALLY) PUT UP THE GRAPH
C
50	IF((IMODE.AND.16).NE.0)GOTO 200	!TEST FOR STRIP CHARTING
	RANGE=IRB(1,IRGN)-IRB(2,IRGN) !# OF DOTS ON Y-AXIS
	IX=INT(F(X,XMAX,XMIN)*511.)
C
C	CHECK FOR X OUT OF RANGE
C
	IF(IX.LT.0)IX=0
	IF(IX.GT.511)IX=511
C
	CMD(1)='H'
	CMD(2)=32+("37 .AND. IX)
	CMD(3)=32+(("740 .AND. IX)/32)
	IY=INT(F(Y,YMAX,YMIN)*RANGE)
	IF(((IX/128)*128) .EQ. IX)IY=0 !LEAVE TICK MARKS ALONE
	IY=IY+IRB(2,IRGN)	!ADD OFFSET FOR BOTTOM OF GRAPH
C
C	CHECK FOR Y OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(4)=IGCODE(IGRAPH+1)
	CMD(5)=32+("37 .AND. IY)
	CMD(6)=32+(("340 .AND. IY)/32)
	CALL OUTSTR(CMD,6)
	GOTO 500
C
C	THE FOLLOWING SECTION OF CODE IS FOR STRIP CHART MODE
C
200	CALL DFLTCK(FACTR,1.,FACTOR) !DEFAULT FACTOR IS 1.
	IF(IBUF(29).NE.0)GOTO 210
	CALL OUTSTR('H  ')	!MOVE X TO LOWER LEFT CORNER
C
C	THE FOLLOWING IF STATEMENT AND SUBROUTINE CALL ARE
C	USED TO FORM THE INITIAL LABLE ON THE X AXIS
C
	IF((IMODE.AND.64).NE.0)CALL GRLM(IBUF(30),IROW(IRGN),FACTR)
210	IBUF(29)=IBUF(29)+1	!UPDATE COUNTER
	RANGE=IRB(1,IRGN)-IRB(2,IRGN)
	CMD(1)=IGCODE(IGRAPH+1) !DESIGNATE X VALUE
	IY=INT(F(Y,YMAX,YMIN)*RANGE)
	IF(MOD(IBUF(29),128) .NE. 1)GOTO 260 !NEED TO SKIP A POINT?
	IY=0	!RESET TO BASELINE
	IF((IMODE.AND.64).EQ.0)GOTO 260 !UNITS SELECTED?
	CALL GRLM(IBUF(30),IROW(IRGN),FACTR)
260	IY=IY+IRB(2,IRGN)
C
C	CHECK FOR Y OUT OF RANGE
C
	IF(IY.GT.IRB(1,IRGN))IY=IRB(1,IRGN)
	IF(IY.LT.IRB(2,IRGN))IY=IRB(2,IRGN)
C
	CMD(2)=32+("37.AND.IY)
	CMD(3)=32+(("340.AND.IY)/32)
	CALL OUTSTR(CMD,3)
500	CALL OUTSTR(EXITGR)	!EXIT GRAPHICS MODE
	RETURN
	END
                                                                                                                                                                                                                                              