C	SIGNAL SORT PROGRAM, LOCATED IN FILE "HARNES.FOR"
C
C	THIS PROGRAM TAKES INPUT OF THE FORM:
C
C		40 CHARACTER INPUT LINE (1)
C		40 CHARACTER INPUT LINE (2)
C		40 CHARACTER INPUT LINE (3)
C		DECK NAME		NUMBER OF PINS
C		PIN NUMBER		SIGNAL NAME
C		PIN NUMBER		SIGNAL NAME
C		  ...			  ...
C		PIN NUMBER		SIGNAL NAME
C		DECK NAME		NUMBER OF PINS
C		PIN NUMBER		SIGNAL NAME
C		 ...			  ...
C
C	AND FINDS THE OCCURENCE OF EACH SIGNAL NAME FOR
C	EACH OF THE DECKS, PRINTING OUT THAT OCCURENCE BY
C	THE ORIGINAL SIGNAL NAME AND PIN NUMBER ==> I.E.
C	IT SORTS THE SIGNAL NAMES
C
C
	INTEGER*2 DKNUMB,SIGNUM(50),SIGNDX,PAGE,LINES
	INTEGER*2 LIMIT,SUM,DKINDX,DKEDGE,DKPTR
	LOGICAL*1 FILE(16),SPACE(2),HEADER(40,3),WHEN(8),FIRST
	LOGICAL*1 DECK(8,50),PIN(2,1500),SIGNAL(20,1500)
C
	DATA DKNUMB/0/, SIGNDX/0/, DKEDGE/0/
	DATA DKPTR/0/, DKINDX/0/
C
	CALL GTLIN(FILE,'ENTER INPUT FILE NAME')
	OPEN(UNIT=2,NAME=FILE,TYPE='UNKNOWN')
C
	DO 40 I=1,3
	READ (2,20) (HEADER(J,I),J=1,40)
20	FORMAT(40A1)
40	CONTINUE
C
	CALL IDATE(IMONTH,IDAY,IYEAR)
	CALL TIME(WHEN)
C
	TYPE 60, HEADER,IMONTH,IDAY,IYEAR,WHEN,FILE
60	FORMAT(10X,42('*'),/,10X,'*',T52,'*'
	1,3(/,10X,'*',40A1),/,10X,'*'
	2,T52,'*',/,10X,42('*'),/,'0',/,'0',/,'0'
	3,10X,'DATE:',1X,2(I2,'/'),I2
	4,/,'0',10X,'TIME:',1X,8A1
	5,/,'0',10X,'FILE:',1X,16A1
	6,/,'0',/,'0',10X,'HARNES V02.01    CDL 03APR78')
C
C
80	DKNUMB = DKNUMB + 1
C
	READ (2,100,ERR=600,END=140) (DECK(J,DKNUMB),J=1,8),SIGNUM(DKNUMB)
100	FORMAT(8A1,1X,I2)
C
	DO 120 I=1,SIGNUM(DKNUMB)
C
	SIGNDX = SIGNDX + 1
	READ (2,115,ERR=500,END=500) (PIN(J,SIGNDX),J=1,2)
	1,(SIGNAL(K,SIGNDX),K=1,20)
115	FORMAT(2A1,1X,20A1)
C
120	CONTINUE
C
	GO TO 80
C
C
C
140	PRINT 145, HEADER,IMONTH,IDAY,IYEAR,WHEN,FILE
145	FORMAT('1',4(/,'0'),9X,42('*'),/,10X,'*',T52,'*'
	1,3(/,10X,'*',40A1,/,'+',T52,'*'),/,10X,'*',T52
	2,'*',/,10X,42('*'),/,'0',/,'0',/,'0'
	3,10X,'DATE:',1X,2(I2,'/'),I2
	4,/,'0',10X,'TIME:',1X,8A1
	5,/,'0',10X,'FILE:',1X,16A1
	6,/,'0',/,'0',10X,'HARNES V02.01    CDL 03APR78')
C
	LIMIT = DKNUMB - 1
	DO 400 I1=1,SIGNDX
C
C	FIRST CHECK TO SEE IF WE HAVE CROSSED
C	A DECK BOUNDARY, IF SO GO TO 146
C	WHERE DECK INITIALIZATION TAKES PLACE
C
	IF(I1.GT.DKEDGE) GO TO 146
C
C	SINCE WE HAVEN'T CROSSED A DECK BOUNDARY
C	CHECK TO SEE IF WE WILL BE CROSSING A PAGE
C	BOUNDARY. IF NOT, JUMP DOWN TO 160 AND OUTPUT
C	THE PIN AND SIGNAL NAME, OTHERWISE INCREMENT
C	PAGE COUNT AND START NEW PAGE
C
	LINES = LINES + 2
	IF (LINES.LE.50) GO TO 160
	PAGE = PAGE + 1
	GO TO 147
C
146	DKPTR = DKPTR + 1
	DKEDGE = DKEDGE + SIGNUM(DKPTR)
	PAGE = 1
C
147	LINES = 0
C
	PRINT 150, IMONTH,IDAY,IYEAR,DKPTR,(DECK(J,DKPTR)
	1,J=1,8),WHEN,PAGE
C
150	FORMAT('1',10X,'CONNECTOR LIST FOR:',T35,'DATE: '
	1,2(I2,'/'),I2,5X,'CONNECTOR ',I2,/,11X,'*** '
	2,8A1,' ***',T35,'TIME: ',8A1,10X,'PAGE ',I2
	3,/,'0',10X,'PIN',2X,'SIGNAL',16X,'LINK TO:')
C
C
160	PRINT 165, (PIN(J,I1),J=1,2),(SIGNAL(K,I1),K=1,20)
165	FORMAT('0',11X,2A1,1X,20A1)
C
180	IF(SIGNAL(1,I1) .EQ. '*') GO TO 400
C
	FIRST = .TRUE.
C
C
	DO 400 I2=1,SIGNDX
C
	IF (I1 .EQ. I2) GO TO 400
C
	DO 190 J=1,20
	IF(SIGNAL(J,I1).NE.SIGNAL(J,I2)) GO TO 400
190	CONTINUE
C
C	WE HAVE A MATCHING SIGNAL, TIME TO FIND WHICH
C	DECK IT IS FROM ...
C
	SUM = 0
C
	DO 200 I=1,LIMIT
	SUM = SUM + SIGNUM(I)
	IF (SUM .GE. I2) GO TO 210
200	CONTINUE
C
210	DKINDX = I
C
	IF (.NOT. FIRST) GO TO 230
C
	PRINT 220, (DECK(J,DKINDX),J=1,8),(PIN(K,I2),K=1,2)
220	FORMAT('+',T37,8A1,'-',2A1)
	FIRST = .FALSE.
	GO TO 400
C
230	LINES = LINES + 1
	IF (LINES.LE.50) GO TO 310
C
	LINES = 0
	PAGE = PAGE + 1
C
C
	PRINT 280, IMONTH,IDAY,IYEAR,DKPTR,(DECK(J,DKPTR)
	1,J=1,8),WHEN,PAGE
C
280	FORMAT('1',10X,'CONNECTOR LIST FOR:',T35,'DATE: '
	1,2(I2,'/'),I2,5X,'CONNECTOR ',I2,/,11X,'*** '
	2,8A1,' ***',T35,'TIME: ',8A1,10X,'PAGE ',I2
	3,/,'0',10X,'PIN',2X,'SIGNAL',16X,'LINK TO:')
C
290	PRINT 295, (PIN(J,I1),J=1,2),(SIGNAL(K,I1),K=1,20)
295	FORMAT('0',11X,2A1,1X,20A1,T37,'(CONTINUED)')
C
C
310	PRINT 315, (DECK(J,DKINDX),J=1,8),(PIN(K,I2),K=1,2)
315	FORMAT(' ',T37,8A1,'-',2A1)
C
C
400	CONTINUE
C
C
C	PROCESSING COMPLETED AT THIS POINT, SO OUTPUT
C	A TRAILER PAGE WITH SOME NEAT INFO AND QUIT!
C
C
	PRINT 410, FILE,IMONTH,IDAY,IYEAR
410	FORMAT('1',T10,'HARNES V02.01   *** SUMMARY ***'
	1,3X,'FILE: ',16A1,2X,2(I2,'/'),I2
	2,/,T15,'CONNECTOR',T30,'CONNECTOR',T45,' #PINS'
	3,/,T15,' NUMBER  ',T30,'  NAME   ',T45,'DEFINED'
	4,/,' ')
C
C
	DO 450 I1=1,LIMIT
C
	PRINT 440, I1,(DECK(J,I1),J=1,8),SIGNUM(I1)
440	FORMAT(T18,I2,T30,8A1,T47,I2)
C
450	CONTINUE
C
	PRINT 460, LIMIT,SIGNDX,WHEN
460	FORMAT('0',T10,'TOTAL NUMBER OF CONNECTORS:   '
	1,I4,5X,'MAXIMUM ALLOWED:   50'
	2,/,T10,'TOTAL NUMBER OF PINS DEFINED: ',I4
	3,5X,'MAXIMUM ALLOWED: 1500'
	4,/,'0',T10,'PROCESSING STARTED: ',8A1)
C
	CALL TIME(WHEN)
C
	PRINT 470, WHEN
470	FORMAT('+',T49,'COMPLETED: ',8A1)
C
	STOP 'SUCCESS ?'
C
C
500	LIMIT = I-1
	TYPE 510, (DECK(J,DKNUMB),J=1,8),I,(PIN(J,LIMIT),J=1,2)
	1,(SIGNAL(J,LIMIT),J=1,20)
510	FORMAT(' UNEXPECTED PIN NAME ',/,' ERROR OCCURED ON LINE'
	1,I2,' AFTER DECK: ',8A1
	2,' PREVIOUS PIN AND SIGNAL NAME:'
	3,1X,2A1,1X,20A1)
C
	STOP 'OOPS'
C
600	DKNUMB = DKNUMB - 1
	TYPE 610, (DECK(J,DKNUMB),J=1,8),(PIN(J,SIGNDX),J=1,2)
	1,(SIGNAL(J,SIGNDX),J=1,20)
610	FORMAT(' UNEXPECTED DECK NAME',/,' PREVIOUS DECK WAS:'
	1,8A1,/,' LAST PIN AND SIGNAL NAME WAS:',2A1,1X,20A1)
C
	STOP 'TRY AGAIN?'
C
	END
                                                                                                          