
C** RENUM ** PROGRAM TO RE-STATEMENT NUMBER AND CROSS REF FORTRAN PROGS
C
C
	DIMENSION ISPEC(39),JSPEC(5,3),KSPEC(4,6),IDEFXT(4)
	DIMENSION ISWT(4,8),IDEVBL(8)
	LOGICAL*1 IPRINT,JPRINT,COUNT(140),DEBUG,NBLK
	LOGICAL*1 HEADER(106),NAME(6,140)
	LOGICAL*1 IFILE,FUNCR,FUNCX,JNAME(15),LOST
	EQUIVALENCE (ISPEC,JSPEC),(KSPEC,ISPEC(16))
	DATA HEADER/102*' ','P','A','G','E'/
	DATA ISWT(1,1)/'S'/,ISWT(1,2)/'R'/,ISWT(1,3)/'X'/,ISWT(1,4)/'D'/
	1,ISWT(1,5)/'H'/,ISWT(1,6)/'I'/,ISWT(1,7)/'B'/,ISWT(1,8)/'?'/
	DATA IDEFXT/3RFOR,3RFOR,3RLST,0/			!DEFAULT EXTENSIONS
	DATA ILP/2RLP/			!RAD50 FOR LP
	DATA IBAK/3ROLD/		!RAD50 FOR OLD
	DATA ITEMP/3RTMP/		!RAD50 FOR TMP
	DATA NBLK/' '/
	COMMON LINEN,MAXLIN,IPAGE,INC,IERROR,IBEGIN,ICOUNT,DEBUG,LOST,
	$ NUMBER(140,30),NAME,HEADER,COUNT,IPRINT,JPRINT
C
C	THIS PROGRAM IS INTENDED TO AID FORTRAN PROGRAM DOCUMENTATION
C	AND MAINTENANCE BY RE-STATEMENT NUMBERING AND
C	CROSS REFERENCING THE VARIABLES IN RT-11 FORTRAN SOURCE FILES,
C	AS CREATED ON CARDS OR BY THE EDITOR. IT ASSUMES THE SOURCE
C	CODE IS VALID.  THE LINE NUMBERS USED FOR REFERENCING VARIABLES
C	AGREE WITH THOSE ON A COMPILER-GENERATED LISTING.  THIS PROGRAM
C	RUNS ONLY UNDER V2B OR LATER AND REQUIRES SYSLIB.
C	COMMAND LINE SYNTAX AND DEFAULTS ARE SAME AS RT-11 SYSTEM
C	PROGRAMS BECAUSE THEY ARE PROCESSED BY CSI.
C
C	CAPACITY: 499 STATEMENT NUMBERS (RENUM ABORTS IF EXCEEDED),
C	140 VARIABLE NAMES WITH UP TO 30 REFERENCES EACH (RENUM
C	IGNORES EXCESS REFERENCES AND ISSUES MESSAGE). 
C	REDUCING VARIABLE CAPACITY FOR THE CROSS REFERENCE TABLE WILL
C	SIGNIFICANTLY REDUCE CORE NEEDED. 
C	THIS VERSION OF RENUM DOES NOT SUPPORT FORTRAN 4 PLUS- SPECIFIC
C	KEYWORDS.
C	TO CHANGE THE VARIABLE NAME CAPACITY CHANGE 'COUNT', 'NAME',
C	'NUMBER' HERE AND IN XREF1 & XREF2. NO CHANGES NEEDED
C	IN RENUM1 & RENUM2.
C
C		V2M3, MAR 76
C		V4M1, MAY 76
C
C	DAVID P. SYKES
C	MEAD TECH LABS
C	3481 DAYTON-XENIA RD.
C	DAYTON, OH 45432
C
C COMMAND LINE--
C	*RENUMBERED OUTPUT FILE,LISTING FILE=IN1,...IN6/SWITCHES
C    THE OUTPUT FILE SPECIFICATION IS A DUMMY USED ONLY TO INDICATE
C    THE DESIRE FOR A PERMINATE RENUMBERED SOURCE CODE OUTPUT
C    FILE.  THE ACTUAL OUTPUT FILE(S) ALWAYS HAVE THE SAME NAME(S)
C    AS THE ORIGINAL INPUT FILE(S) BUT ARE ON THE SPECIFIED OUTPUT
C    DEVICE. DEFAULT DEVICE IS DK. DEFAULT EXTENSIONS ARE 
C    .LST FOR THE LISTING FILE AND .FOR FOR THE INPUT/OUTPUT FILES.
C
C  SWITCHES MAY APPEAR ANYWHERE IN THE COMMAND LINE AND APPLY TO ALL
C    INPUT OR OUTPUT FILES
C  /S = LIST ONLY CROSS REVERENCE TABLE IF LUN 6 IS SPECIFIED 
C  /R = DO RENUM ONLY (INTO LUN2, IF SPECIFIED; ELSE DUMMY)
C  /X = DO XREF ONLY (OF LUN1), LIST XREF TABLE IF LUN 6 IS SPECIFIED
C  /D = TREAT DEBUG LINES AS VALID CODE, ELSE AS COMMENTS
C  /H & /? = GIVE HELP ON TT: AND NOTHING ELSE
C  /I!N = SET INCREMENT BETWEEN STATEMENT NUMBERS TO N.
C  /B!N = MAKE N THE FIRST OF THE NEW STATEMENT NUMBERS.
C          NO SWITCH = /R+/X+/I:2+/B:2
C   SWITCHES APPLY FOR THE PROCESSING OF A SINGLE COMMAND LINE ONLY.
C   ALL LOGICAL COMBINATIONS OF INPUT/OUTPUT/SWITCHES ARE POSSIBLE:
C	IF /X IS NOT SPECIFIED AND NO OUTPUT FILE SPECIFICATION IS 
C	GIVEN, THE LISTING WILL BE OF A TEMPORARY RENUMBERED FILE
C	WHICH WILL BE DELETED (USEFUL TO SEE WHAT IT LOOKS LIKE).
C
C   IF A NEW OUTPUT FILE IS CREATED DURING RENUM, THE ORIGINAL
C     SOURCE FILE'S EXTENSION IS CHANGED TO .OLD
C  IF THE FIRST LINE OF THE SOURCE CODE CONTAINS "C** " IN COL
C    1-4, IT WILL BE PRINTED AS A HEADER ON EACH PAGE OF OUTPUT.
C  MULTIPLE SOURCE MODULES IN THE SAME INPUT FILE ARE NOT ALLOWED,
C    UNLESS THE MULTIPLE MODULES MAKE UP A SET OF RELATED PROGRAMS
C    WITH NO DUPLICATED STATEMENT NUMBERS, BECAUSE THEY WILL BE
C    RENUMBERED AND CROSS REFERENCED AS A GROUP.
C	EACH MODULE MAY HAVE A HEADER LINE (C** ).
C    RENUM CHECKS FOR DUPLICATE STATEMENT NUMBERS AND ABORTS IF
C       IT FINDS ANY.
C   THE USE OF FORTRAN KEYWORDS AS VARIABLE NAMES MAY CONFUSE THE
C    SCANS IN UNPREDICTABLE WAYS AND IS BEST AVOIDED.
C PROGRAMS BEING RENUMBERED:
C      CANNOT HAVE STATEMENT NUMBERS WHICH EXTEND FROM THE END OF A
C         LINE ONTO A CONTINUATION LINE.
C      CAN HAVE STATEMENT NUMBERS ON CONTINUATION LINES ONLY IN
C        'IF' AND 'GO TO' STATEMENTS, AND WHEN THEY FOLLOW A LOGICAL IF.
C      ANY DATA IN COL 73-80 (EXCEPT COMMENTS) WILL BE DELETED WHEN A PROGRAM
C      IS RENUMBERED.  THE FORTRAN KEYWORD AND CERTAIN SYNTAX ELEMENTS MUST 
C         BE ON A SINGLE LINE (THE FIRST, EXCEPT PERHAPS AFTER A LOGICAL IF
C         THIS LIMITS UNREASONABLE USE OF INBEDDED BLANKS.
C         REASONABLY FORMATTED LINES WILL PRESENT NO PROBLEM.
C    IF A LINE EXTENDS PAST COL 72 BECAUSE THE NEW STATEMENT
C         NUMBERS ARE LONGER THEN THE OLD ONES, THE EXCESS IS MOVED TO
C         THE NEXT LINE (IF IT IS A CONTINUATION) OR A NEW
C         CONTINUATION LINE IS CREATED FOR IT.  EXCEPT THAT END-OF-LINE
C         COMMENTS (!) ARE DELETED (BEYOND COL 80) RATHER THEN MOVED.
C    STATEMENT NUMBERS UP TO 99999 ARE ALLOWED IN THE INPUT CODE, THE
C         OUTPUT STATEMENT NUMBERS WILL BE SPACED BY 2, (OR BY THE ARGUMENT
C	OF THE /I SWITCH); BEGINNING AT 2 (OR AT THE ARGUMENT OF
C	THE /B SWITCH, IF ANY).
C
C    ONE ERROR MESSAGE IS POSSIBLE AND IS OUTPUT TO THE NEW SOURCE
C	FILE AS A COMMENT LINE: A POSSIBLE CONVERSION ERROR. IT HAPPENS
C	IF: (1) RENUM FINDS A STATEMENT NUMBER IN A STATEMENT THAT 
C	IT DID NOT FIND AS A LABEL; OR (2) RENUM FINDS THE KEYWORD
C	OF A STATEMENT THAT SHOULD CONTAIN A STATEMENT NUMBER BUT
C	CANNOT FIND A NUMBER BECAUSE THE STATEMENT'S SYNTAX  IS NOT AS
C	EXPECTED (EITHER THE KEYWORD WAS REALLY A VARIABLE NAME OR 
C	THE STATEMENT IS NOT SYNTATICLY COMPLETE ON 1 LINE).
C   THE /D SWITCH MUST BE USED CAREFULLY SINCE IT IS EASY TO CAUSE
C       MULTIPLE STATEMENT NUMBERS WHICH CAUSE NO PROBLEM UNTIL
C       SOME LATER TIME WHEN THE FORTRAN COMPILER IS GIVEN A /D.
C
C--LUN1 = INPUT FORTRAN SOURCE FILE
C--LUN2 = OUTPUT (RENUMBERED) FORTRAN SOURCE FILE/INPUT TO XREF
C--LUN6 = LISTING FILE. DUE TO A FORTRAN BUG, ONCE ASSIGNED TO TT:, IT C
C	BE CHANGED TO ANOTHER DEVICE WITHOUT RERUNNING THE PROG.
C	IT CAN BE REASSIGNED AMONG NOT-TT: DEVICES.
C
	MAXLIN=50			!**LINES PER PAGE (LV11)
	ICHAN=IGETC()
	CALL DATE (HEADER(82))
C
5	FUNCX=.TRUE.		!**XREF?
	FUNCR=.TRUE.		!**RENUM?
	DEBUG=.FALSE.
	IPRINT=.TRUE.		!**LIST SOURCE CODE
	JPRINT=.TRUE.		!**LIST CROSS REFERENCE TABLE
	NFILE=0
	IFILE=.TRUE.		!**CREATE NEW SOURCE FILE?
C
10	I=ICSI (ISPEC,IDEFXT,,ISWT,8)			!GET COMMAND STRING
	IF (I .EQ. 0) GO TO 20
	WRITE (5,15)
15	FORMAT ('+*SYNTAX ERROR*'/)
	GO TO 10
C
C--GIVE OPERATOR HELP ON TT: IF /H WAS USED (DO NOTHING ELSE)
C
20	IF (ISWT(2,5) .EQ. 0 .AND. ISWT(2,8) .EQ. 0) GO TO 25
	CALL HELPR
	GO TO 10
C
C--IS OUTPUT DISK FILE WANTED??
C
25	IF (JSPEC(2,1) .EQ. 0) IFILE=.FALSE.
C
C--IF A /S IS PRESENT, DO NOT PRINT SOURCE CODE
C
	IF (ISWT(2,1) .GT. 0) IPRINT=.FALSE.
C
C--IF /D IS PRESENT, XREF DEBUG LINES
C
	IF (ISWT(2,4) .GT. 0) DEBUG=.TRUE.
C
C--IF A /I WAS ENTERED, SET THE INCREMENT BETWEEN STATEMENT NUMBERS
C
	INC=2					!**DEFAULT
	IF (ISWT(4,6) .GT. 0) INC=ISWT(4,6)
C
C--IF A /B WAS ENTERED, SET THE STARTING STATEMENT NUMBER
C
	IBEGIN=INC				!**DEFAULT
	IF (ISWT(4,7) .GT. 0) IBEGIN=ISWT(4,7)
	IBEGIN=IBEGIN-INC
C
C--SET UP OUTPUT OPTIONS
C
	IF (ISWT (2,2) .EQ. 0 .AND. ISWT(2,3) .EQ. 0) GO TO 30
	FUNCX=.FALSE.
	FUNCR=.FALSE.
C
C--IS RENUM OUTPUT ONLY DESIRED??
C
	IF (ISWT(2,2) .GT. 0) FUNCR=.TRUE.
C
C--IS XREF OUTPUT ONLY DESIRED??
C
	IF (ISWT(2,3) .GT. 0) FUNCX=.TRUE.
30	IF (.NOT. FUNCX) JPRINT=.FALSE.
C
C--SET UP LISTING FILE OUTPUT, IF ANY
C
	IF (JSPEC(1,2) .EQ. 0) GO TO 35
	IF (JSPEC(1,2) .NE. 0 .AND. JSPEC(2,2) .EQ. 0) JSPEC(2,2)=ILP
	CALL IASIGN (6,JSPEC(1,2),JSPEC(2,2),0,9)
	GO TO 40
C
35	CONTINUE			!CAN'T DO ANY LISTING
	JPRINT=.FALSE.
	IPRINT=.FALSE.
	FUNCX=.FALSE.
C
C=========GET (NEXT) INPUT FILE
C
40	CONTINUE
	NFILE=NFILE+1
	IF (NFILE .LE. 6 .AND. KSPEC(1,NFILE) .NE. 0) GO TO 45
	IF (JPRINT .OR. IPRINT) CALL CLOSE (6)		!CLOSE LISTING FILE
	GO TO 5
C
45	DO 50 I=1,81			!CLEAR THE HEADER
	HEADER(I)=NBLK
50	CONTINUE
	CALL TIME (HEADER(92))
	IPAGE=1
C
C--CHECK TO SEE IF THE INPUT FILE EXISTS
C
	I=LOOKUP(ICHAN,KSPEC(1,NFILE))
	CALL CLOSEC(ICHAN)
	IF (I .GT. 0) GO TO 60
	WRITE (5,55) NFILE
55	FORMAT (' **INPUT FILE',I2,' NOT FOUND**'/)
	GO TO 40
C
C====================== GO DO STATEMENT RENUMBERING =======
C
C--CREATE A PERMINATE OUTPUT FILE ON THE SPECIFIED DEVICE OR A
C   SCRATCH FILE ON THE INPUT DEVICE, USE A TEMP NAME TO
C   BESURE THE ORIGINAL FILE IS NOT DELETED UNTIL THE NEW FILE IS SAFE.
C
60	CONTINUE
	IF (.NOT. FUNCR) GO TO 80
	DO 65 I=1,4
	IDEVBL(I)=KSPEC(I,NFILE)
	IDEVBL(I+4)=KSPEC(I,NFILE)
65	CONTINUE
C
	CALL IASIGN (1,KSPEC(1,NFILE),KSPEC(2,NFILE))	!INPUT FILE
	KSPEC(4,NFILE)=ITEMP
	IF (JSPEC(1,1) .NE. 0) KSPEC(1,NFILE)=JSPEC(1,1)
	CALL IASIGN (2,KSPEC(1,1),KSPEC(2,NFILE),0,1)		!DOUBLE BUFFER
C
70	CALL RENUM1			!SCAN FOR STATEMENT LABLES
	REWIND 1
C
	CALL RENUM2				!INSERT NEW NUMBERS
	CALL CLOSE (1)
	CALL CLOSE (2)
	IF (IERROR .GT. 0) WRITE (5,75) IERROR
75	FORMAT (' POSSIBLE ERRORS DETECTED:',I3)
C
	IF (.NOT. IFILE) GO TO 80
	CALL LOCK			!THIS SPEEDS THINGS UP
	IDEVBL(8)=IBAK
	CALL IRENAM (ICHAN,IDEVBL)		!ORIGINAL FILE TO .OLD
	CALL CLOSEC (ICHAN)
C
	IDEVBL(8)=IDEVBL(4)
	IDEVBL(4)=ITEMP
	IDEVBL(1)=JSPEC(1,1)
	IDEVBL(5)=JSPEC(1,1)			!OUTPUT DEVICE
	CALL IRENAM (ICHAN,IDEVBL)		!GIVE NEW FILE ORIG.NAME
	CALL CLOSEC (ICHAN)
	CALL UNLOCK
	KSPEC(4,NFILE)=IDEVBL(8)
C
C======= GO DO THE CROSS REFERENCE INDEX AND PRODUCE LISTINGS
C
80	IF (.NOT. FUNCX .AND. .NOT. IPRINT) GO TO 85
	CALL IASIGN (2,KSPEC(1,NFILE),KSPEC(2,NFILE),0,32)
	ICOUNT=0
C
	IF (IPRINT .OR. JPRINT) CALL XREF1		!SCAN FOR NAMES
C
	IF (JPRINT .AND. ICOUNT .GT. 0) CALL XREF2		!PRINT INDEX
C
	CALL CLOSE (2)
C
C=================CLEAN UP RENUMBERED FILE, IF ONE WAS CREATED
C
C
C--DELETE THE SCRATCH FILE
C
85	IF (.NOT. FUNCR .OR. IFILE) GO TO 40
	KSPEC(4,NFILE)=ITEMP
	I=IDELET (ICHAN,KSPEC(1,NFILE),KSPEC(2,NFILE))
	GO TO 40
	END

C** MOVEB ** SUBROUTINE TO MOVE CHARACTERS FROM 1 ARRAY TO ANOTHER ****
C                   RT11/DOS
C
C
	SUBROUTINE MOVEB (SARAY, FROM, TO, OBARAY, START,N)
C
	INTEGER FROM, TO, START
	LOGICAL*1 SARAY(TO),OBARAY(N)
C
	STAR=START
	DO 90 I=FROM, TO
	OBARAY(STAR)=SARAY(I)
90	STAR=STAR+1
	RETURN
	END
C** CHARB ** SUBROUTINE TO CAN AN ARRAY FOR A GIVEN CHARACTER ****
C                        RT11
C
C
	SUBROUTINE CHARB (ICTL, IARAY, IFIRST, ILAST, ICHR, ICOL)
C
C--THIS SUBROUTINE SCANS AN ARRAY (IARAY) FROM IFIRST TO ILAST
C--IF ICTL IS POSITIVE; OR FROM ILAST TO IFIRST IF ICTL IS NON POSITIVE
C--AND RETURNS IN ICOL THE NUMBER OF THE ARRAY ELEMENT THAT MATCHES 
C--THE CHARACTER SPECIFIED IN ICHR.
C--IF NO MATCH IS FOUND ICOL IS RETURNED AS -1.
C
	LOGICAL*1 IARAY(ILAST), ICHR
	IF (IFIRST .GT. ILAST ) GO TO 100
	IF (ICTRL .LE. 0) GO TO 115
C
C--FORWARD SEARCH
C
	DO 95 I=IFIRST,ILAST
	IF (ICHR .EQ. IARAY(I)) GO TO 105
95	CONTINUE
100	ICOL=-1
	RETURN
105	ICOL=I
110	RETURN
C
C--BACKWARD SEARCH
C
115	DO 120 ICOL=ILAST,IFIRST,-1
	IF (ICHAR .EQ. IARAY(ICOL)) GO TO 110
120	CONTINUE
	GO TO 100
	END
C** BLANKB ** SUBROUTINE TO FIND THE FIRST NON BLANK CHAR IN AN ARRAY **
C                         RT11
C
C--THIS ROUTINE SEARCHES AN ALPHA ARRAY IN A1 FORMAT FROM THE RIGHT,
C--IF ICTL IS NEGATIVE, OR FROM THE LEFT, IF ICTL IS POSITIVE
C---AND RETURNS IN IFOUND THE ELEMENT NUMBER OF THE FIRST NON-
C----BLANK CHARACTER FOUND. IF THE WHOLE ARRAY IS BLANK, IFOUND
C-----IS RETURNED AS -1.
C
C
	SUBROUTINE BLANKB (ICTL, IARAY, IFIRST, ILAST, IFOUND)
C
	LOGICAL*1 IARAY(ILAST), NBLK
	DATA NBLK/' '/
	IFOUND=-1
	IF (IFIRST .GE. ILAST)RETURN
	IF (ICTRL .GE. 0) GO TO 130
C--BACKWARDS SEARCH
	DO 125 ICOL=ILAST,IFIRST,-1
	IF (IARAY(ICOL) .NE. NBLK) GO TO 140
125	CONTINUE
	RETURN
C---FORWARD SEARCH
130	DO 135 ICOL=IFIRST,ILAST
	IF (IARAY(ICOL) .NE. NBLK) GO TO 140
135	CONTINUE
	RETURN
140	IFOUND=ICOL
	RETURN
	END
C** COMPAR ** MYLIB SUBROUTINE TO LOOK FOR A KEYWORD
C
C
	SUBROUTINE COMPAR (KEYWD,PACK,ISTART,IEND,ITYPE)
C
C
	LOGICAL*1 PACK(1),KEYWD(1)
C
C	STARTING IN THE ISTART POSITION OF PACK, PACK IS SEARCHED
C	TO SEE IF A VARIABLE LENGTH KEYWORD, AS CONTAINED
C	IN KEYWD, IS IN PACK.  KEYWORDS OF VARYING
C	LENGTH ARE DEFINED IN KEYWD, EACH PRECEEDED BY THE NUMBER OF
C	LETTERS IN IT. KEYWD IS TERMINATED BY A
C	0 BYTE. EG... DATA KEYWD/3,'I','T','S',2,'I','M',0/
C	IF A KEYWD DOES START AT PACK(1), IEND IS RETURNED
C	WITH THE COL NUMBER OF THE LAST LETTER OF THE KEYWORD AND ITYPE
C	IS RETURNED WITH THE NUMBER OF THE KEYWORD FOUND (1, 2, ETC).
C	IF NO KEYWORD IS FOUND, ITYPE IS RETURNED AS 0 AND IEND
C	IS UNDEFINED.
C
C
	ITYPE=0
	L=0
145	M=L+2
	IF (KEYWD(L+1) .EQ. 0) GO TO 155
	L=KEYWD(L+1)+M-1
	ITYPE=ITYPE+1
	IEND=ISTART
D	WRITE (6,996) (KEYWD(NN),NN=M,L)
D996	FORMAT (1X,20A1)
	DO 150 I=M,L
	IF (PACK(IEND) .NE. KEYWD(I)) GO TO 145
	IEND=IEND+1
150	CONTINUE
C
	IEND=IEND-1			!FOUND A MATCH
	RETURN
C
155	ITYPE=0			!NO MATCH ANYWHERE
	RETURN
	END
C** OLDNUM ** FUNCTION TO GET A STATEMENT NUMBER FOR RENUM
C
C
	FUNCTION OLDNUM (LINE,IEND,ISTART,ISTOP)
C
	LOGICAL*1 NBLK,LINE(1),HOLD(6),TAB,DOT
	DATA NBLK/' '/,TAB/"11/,DOT/'.'/
C
C	FIRST LOOK FOR THE NEXT DIGIT IN 'LINE', STARTING AT 'ISTART'
C	THEN LOOK FOR THE NEXT NON-DIGIT: THAT DEFINES THE 
C	LOCATION OF THE NUMBER WE SEEK.
C	NOW PACK THE NUMBER IGNORING INBEDDED BLANKS AND
C	DECODE IT.
C
C--FIND THE START OF THE NUMBER (1ST DIGIT)
C
	IF (ISTART .GT. IEND) GO TO 165
	J=ISTART
	DO 160 ISTART=J,IEND
	IF (LINE(ISTART) .EQ. TAB) GO TO 165
	IF (LINE(ISTART) .GE. "60 .AND. LINE(ISTART) .LE. "71) GO TO 170
160	CONTINUE
165	OLDNUM=0.
	RETURN
C
C--NOW FIND A NON-DIGIT (OTHER THEN BLANK) TO TERMINATE THE NUMBER
C
170	CONTINUE
	DO 175 ISTOP=ISTART,IEND
	IF (LINE(ISTOP) .EQ. NBLK) GO TO 175
	IF (LINE(ISTOP) .LT. "60 .OR. LINE(ISTOP) .GT. "71) GO TO 180
175	CONTINUE
	ISTOP=IEND+1
180	ISTOP=ISTOP-1
	IF (LINE(ISTOP) .EQ. NBLK) ISTOP=ISTOP-1
C
C--PACK THE NUMBER INTO AN ARRAY FOR DECODEING, RIGHT JUSTIFY
C
	J=5
	DO 185 I=ISTOP,ISTART,-1
	IF (LINE(I) .EQ. NBLK) GO TO 185
	HOLD(J)=LINE(I)
	J=J-1
185	CONTINUE
C
C--CLEAR REST OF HOLD
C
	IF (J .EQ. 0) GO TO 195
	DO 190 I=J,1,-1
	HOLD(I)=NBLK
190	CONTINUE
C
195	HOLD(6)=DOT			!"."
	DECODE (6,200,HOLD) X
200	FORMAT (F6.0)
	OLDNUM=X
C
	RETURN
	END

                                                                                                                              