/*+
 * VOID tfrput(keywrd, nrclr)
 *     TEXT  *keywrd;
 *     COUNT nrclr;
 *
 * Description  : Routine to display fix fields and update fields with data
 *                from the current field copy record.
 * Arguments    : keywrd = STRING containing a keyword:
 *                         'ALL'  - display fix, display-only and update field
 *                         'FIX'  - display fix fields
 *                         'DON'  - display blank display-only fields
 *                         'UPD'  - display update fields
 *                         'VAR'  - display blank displ.-only and update field
 *                nrclr  = INTEGER containing the row number from which the
 *                         screen must be cleared before displaying any data
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRPUT.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrput.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrput(keywrd, nrclr)
    TEXT  *keywrd;
    COUNT nrclr;

    {
    IMPORT TFRCOM t;

#include <dondef.h>
#include <upddef.h>

    LOCAL TEXT  cc[] = "+$",
                lf[] = "\n";

    FAST i;

    COUNT ikey, irec;
    COUNT *pf;

    pf = &t.frec;
/*
 *    check keyword
 */
    scvtlu(keywrd);
    if(cmpstr(keywrd, "FIX"))
        {
        ikey = 1;
        }
    else if(cmpstr(keywrd, "DON"))
        {
        ikey = 2;
        }
    else if(cmpstr(keywrd, "UPD"))
        {
        ikey = 4;
        }
    else if(cmpstr(keywrd, "VAR"))
        {
        ikey = 6;
        }
    else if(cmpstr(keywrd, "ALL"))
        {
        ikey = 7;
        }
    else
        {
        error("TFRPUT", "-Invalid keyword argument");
        }
/*
 *    clear screen by row
 */
    if(nrclr > 0)
        {
        swrite(t.iscr, cc, &t.homstr, NULL);
        for(i = 1; i < nrclr; swrite(t.iscr, cc, lf, NULL), ++i);
        swrite(t.iscr, cc, &t.natstr, &t.clrstr, NULL);
        }
/*
 *    display fix fields
 */
    irec = t.nrfffr;
    if((ikey & 1)  ==  1)
        {
        while(irec  &&  irec <= t.nrlffr)
            {
            tfrfs(&irec);
            swrite(t.iscr, cc, &t.sbuf, NULL);
            ++irec;
            }
        }
/*
 *    display blank display-only fields
 */
    if((ikey & 2) == 2)
        {
        if(t.nrfdfr)
            {
            for(i = t.nrfdfr; i <= t.nrldfr; ++i)
                {
                tfrru(i, "VAR");         /* read display-only field record */
                swrite(t.iscr, cc, &pf->donesc, NULL);
                rswrit(t.iscr, cc, pf->lendon, " ");
                }
            }
        }
/*
 *    display update fields
 */
    if((ikey & 4) == 4)
        {
        if(t.nrfufr)
            {
            for(i = t.nrfufr; i <= t.nrlufr; ++i)
                {
                tfrru(i, "ALL");       /* read update field record and FCR */
                swrite(t.iscr, cc, &pf->updesc, &t.fcr[pf->npfcr], NULL);
                }
            }
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                              