/*+
 * VOID tfrdef(field, dfault)
 *     TEXT *field, *dfault;
 *
 * Description  : Routine to reset a field default value
 *
 * Arguments    : field  = STRING containing the field name
 *                dfault = STRING containing default value for the field
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRDEF.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrdef.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrdef(field, dfault)
    TEXT *field, *dfault;

    {

    IMPORT TFRCOM t;

#include <upddef.h>

    COUNT i, j, *pf;

    pf = &t.frec;
/*
 *    determine field copy record and fill with new default
 */
    if(t.nrfufr)
        {
        scvtlu(field);
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "VAR");              /* read update field record */
            if(cmpstr(field, &pf->updfld))
                {
                tfrru(i, "FCR");          /* read field copy record */
                if((j = lenstr(dfault)) < pf->lenupd)
                    {
                    cpystr(&t.fcr[pf->npfcr], dfault, NULL);
                    t.fcr[pf->npfcr+j] = ' ';
                    }
                else
                    {
                    cpybuf(&t.fcr[pf->npfcr], dfault, pf->lenupd);
                    }
                return;
                }
            }
        }
    error("TFRDEF", "Field not found");
    }
         