/*+
 * COUNT rcwrit(unit, recnum, reclen, recbuf)
 *     COUNT unit, recnum, reclen;
 *     TEXT  *recbuf;
 *
 * Description  : This routine provides direct access for simulated fortran
 *                I/O.
 *
 * Arguments    : unit   = unit number to write to.
 *                recnum = record number to be written.
 *                reclen = record length of file records.
 *                recbuf = buffer to be written - must be reclen long.
 *
 * Returns      : > 0 if successful(number of char written s/b RECLEN).
 *                = 0 if end of file.
 *                -1 or RT11 error or'd with 0400 if failed.
 *
 * Author       : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : rcwrit.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <fortio.h>

COUNT rcwrit(unit, recnum, reclen, recbuf)
    COUNT unit, recnum, reclen;
    TEXT  *recbuf;

    {
    IMPORT FIO fortio[NFCHNL];

    COUNT rcwrit;

    --unit;
    if((rcwrit = lseek(fortio[unit]._fd, (LONG)((recnum-1)*reclen), 0)) < 0)
        {
        return(rcwrit);
        }
    return(fwrite(fortio[unit]._fd, recbuf, reclen));
    }
                                                                           