/*+
 * VOID mprgf(comstr)
 *     TEXT *comstr;
 *
 * Description  : Routine to get one or more functions from screen
 *                This routine is reserved for MPR-subroutines only
 *
 * Arguments    : comstr  = STRING returning the rest of the command string
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.1      Date : 10-FEB-1983
 *
 * Module name  : MPRGF.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : daee                 tepqaed     deqapaptaed 0 @ A Aaaaaaa          P1 1                   A@Q@ apaqaa`p aapa` pa aaaaa`       Paqpappa` `q 0 @ Q  Aapqa`q``                   Apaaaa A`apaq a` Aa`a`a                   Q`apaq`a`` @qa`aap Paqaapa` Aqp                    Pa`aqa  Aa`apa`a  Aa`a`a                   `pa`a`0 Paa``aaa` Qappaaaq        Papqaa`      0 P1 0      @apa 0 00!AAP!01       Aa`q`a `aaa  0 appa` a       Paaaaaa      0 PPAAPA       Qp`apaq      0 `aaa                 papqaa`  *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprgf(comstr)
    TEXT *comstr;

    {
    VOID  swrite(), mprcm();

    IMPORT MPRCOM m;

    LOCAL TEXT  cc[] =  "+$",
                cc1[] = "+",
                cc2[] = " $",
                bel[] = "\007";

    TEXT  ncmstr[61], resstr[60];
    COUNT err;
    BOOL  success;

/*
 *    when 'break-through': do not read from screen
 */
    cpybuf(ncmstr, comstr, 60);
    ncmstr[60] = NULL;    
    if(!m.ibtflg)
        {
        ncmstr[0] = NULL;
        success = FALSE;
        }
    else
        {
        success = TRUE;
        }
/*
 *    position and ask for command-string
 */
    FOREVER
        {
        while(!success)
            {
            swrite(m.iscr, cc, &m.fngpos, &m.erlstr, &m.flsvat, NULL);
            cread(m.iscr, ncmstr, 59);
            ncmstr[59] = NULL;
            success = TRUE;
            }
        success = mprtgf(comstr, ncmstr, resstr, lenstr(ncmstr));
        if(success)
            {
            break;
            }
        }
    }

BOOL mprtgf(comstr, ncmstr, resstr, err)
  TEXT  *comstr, *ncmstr, *resstr;
  COUNT err;
  {
  VOID  swrite(), scvtlu(), mprcm();
  COUNT index();
  BOOL  gsubs();

  IMPORT MPRCOM m;

  LOCAL TEXT  cc[] =  "+$",
              cc1[] = "+",
              cc2[] = " $",
              bel[] = "\007";

  COUNT ipos, ix;
  BOOL  ieos;

  if(!m.ibtflg)
    {
    if(m.imesfl)
        {
        mprcm();                       /* clear message field */
        }
/*
 *    check input return-code
 */
    if(err > 59  ||  err == 0)
        {
        swrite(m.iscr, cc, &m.mespat, "Illegal function", bel, NULL);
        m.imesfl = TRUE;
        return(FAIL);
        }
/*
 *    check for questionmark (explanation wanted)
 */
    if(fcall(&index, 2, ncmstr, "?"))
        {
        swrite(m.iscr, cc1, &m.mespat, &m.clrvat, "Enter ", &m.flsvat,
               "KEY", &m.clrvat, "-characters to select function", NULL);
        swrite(m.iscr, cc2, "Special keys: ", NULL);
        if(m.nrnrcm == m.nrmmr)
            {
            swrite(m.iscr, cc, &m.flsvat, "EX", &m.clrvat,
                    "IT = quit program, ", NULL);
            }
        else
            {
            swrite(m.iscr, cc, &m.flsvat, ".", &m.clrvat, " = former menu, ",
                           &m.flsvat, "<", &m.clrvat, " = main-menu, ", NULL);
            }
        swrite(m.iscr, cc1, &m.flsvat, "?", &m.clrvat, " = this text", NULL);
        swrite(m.iscr, cc2,"For 'break-through', separate keys with comma's",
                 NULL);
        m.imesfl = 3;
        return(FAIL);
        }
/*
 *    fill command-string
 */
    cpystr(comstr, ncmstr, NULL);
/*
 *    decode command-string
 */
    }
  ipos = 0;
  ieos = gsubs(ncmstr, &ipos, ",", resstr, 59);
  cpystr(comstr, &ncmstr[ipos], NULL);
  scvtlu(resstr);
  m.ifunct = 999;
  if(m.nrnrcm == m.nrmmr  &&
     fcall(&index, 2, "EXIT", resstr) == 1 &&
     lenstr(resstr) >= 2)
      {
      m.ifunct = -3;
      }
  ix = fcall(&index, 2, "<.", resstr);
  if(m.nrnrcm != m.nrmmr  &&
     lenstr(resstr)  &&
     ix > 0)
      {
      m.ifunct = -ix;
      }
if(m.ifunct > 0)
      {
      for(ix = 0; ix < m.nrfun; ++ix)
          {
          if(cmpstr(resstr, &m.funtab[ix]))
              {
              if(m.typtab[ix] == 'F'  &&  !ieos)
                  {
                  if(m.ibtflg)
                      {
                      mprdm(3);
                      }
                  if(m.imesfl)
                      {
                      mprcm();             /* clear message field */
                      }
                  swrite(m.iscr, cc, &m.mespat,
                              "Can't pass data to function", bel, NULL);
                  m.imesfl = 1;
                  return(FAIL);
                  }
              else
                  {
                  m.ifunct = ix;
                  break;
                  }
              }
          }
      if(ix == m.nrfun)
          {
          if(m.ibtflg)
              {
              mprdm(3);
              }
          if(m.imesfl)
              {
              mprcm();                 /* clear message field */
              }
          swrite(m.iscr, cc, &m.mespat, "Invalid function for this menu",
                 bel, NULL);
          m.imesfl = 1;
          return(FAIL);
          }            
      }
/*
 *   check for 'break-through'
 */
  m.ibtflg = FALSE;
  if(lenstr(comstr))
      {
      m.ibtflg = TRUE;
      }
  swrite(m.iscr, cc, &m.clrvat, NULL);
  return(SUCCEED);
  }
                                                                                                                                                                                                                                                                                                                                                                                      