/*+
 * VOID header( cstr , rstr , outstr )
 *   TEXT *cstr, *rstr, *outstr;
 *
 * Description  : Builds a HEADER string of 79 characters with the following
 *                format : CSTR padded or truncated to 53 characters + blank
 *                         RSTR padded or truncated to  9 characters + blank
 *                         9 character date string + blank
 *                         5 character time string + zero-byte
 *
 * Arguments    : cstr   = STRING of free text
 *                rstr   = STRING containing (sub)routine information
 *                outstr = STRING returning the constructed HEADER
 *
 * Author       : T.Pijl
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 7-jan-83
 *
 * Module name  : HEADER.FOR
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : header.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>

VOID header( cstr , rstr , outstr )
    TEXT *cstr, *rstr, *outstr;

    {
    VOID  sbuild(), date(), time();

    TEXT  day[10];

    cpybuf(outstr,cstr,53);
    outstr[53] = NULL;
    padstr(outstr, 54);
    sbuild(outstr, 63, rstr, NULL);
    padstr(outstr, 64);
    fcall(&date, 1, day);
    day[9] = NULL;
    sbuild(outstr, 79, day, " ", NULL);
    fcall(&time, 1, day);
    day[5] = NULL;
    sbuild(outstr, 79, day, NULL);
    }
                                                                                                                                                                                                                                                                        