/*+
 * VOID tfrfld(field, text)
 *     TEXT *field, *text;
 *
 * Description  : Routine to display a text in a specified field and (in
 *                case of an update field) change the field copy record
 *
 * Arguments    : field  = STRING containing the field name
 *                text   = STRING containing (new) contents for the field
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.1      Date : 7-JUL-83
 *
 * Module name  : TFRFLD.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *                R.Beetz              V1.1
 *  description : cleaning update and don fields
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrfld.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrfld(field, text)
    TEXT *field, *text;

    {
    IMPORT TFRCOM t;

#include <dondef.h>
#include <upddef.h>

    LOCAL TEXT  cc[] = "+$";

    COUNT i, j, ltx;
    COUNT *pf;

    pf = &t.frec;
/*
 *    search update field with specified name
 */
    ltx = lenstr(text);
    scvtlu(field);
    if(t.nrfufr)
        {
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "VAR");            /* read update field record */
            if(cmpstr(field, &pf->updfld))
                {
                tfrru(i, "FCR");        /* read field copy record */
                if(ltx < pf->lenupd)
                    {
                    cpystr(&t.fcr[pf->npfcr], text, NULL);
                    for(j = pf->npfcr+ltx;
                        j <= pf->npfcr+pf->lenupd-1;
                        t.fcr[j++] = ' ');
                    }
                else
                    {
                    cpybuf(&t.fcr[pf->npfcr], text, pf->lenupd);
                    t.fcr[pf->npfcr+pf->lenupd] = NULL;
                    }
                swrite(t.iscr, cc, &pf->updesc, &t.fcr[pf->npfcr], NULL);
                return;
                }
            }
        }
/*
 *    search display-only field with specified name
 */
    if(t.nrfdfr)
        {
        for(i = t.nrfdfr; i <= t.nrldfr; ++i)
            {
            tfrru(i, "VAR");            /* read dipslay-only field record */
            if(cmpstr(field, &pf->donfld))
                {
                if(!ltx)
                    {
                    swrite(t.iscr, cc, &pf->donesc, &t.natstr, NULL);
                    rswrit(t.iscr, cc, pf->lendon, " ");
                    return;
                    }
                else
                    {
                    if(ltx < pf->lendon)
                        {
                        cpystr(&t.sbuf, text, NULL);
                        rswrit(t.iscr, cc, pf->lendon-ltx, " ");
                        }
                    else
                        {
                        cpybuf(&t.sbuf, text, pf->lendon);
                        t.sbuf[pf->lendon] = NULL;
                        }
                    swrite(t.iscr, cc, &pf->donesc, &t.sbuf, NULL);
                    if(ltx < pf->lendon)
                        {
                        rswrit(t.iscr, cc, pf->lendon-ltx, " ");
                        }
                    return;
                    }
                }
            }
        }
    error("TFRFLD", "-Field not found");
    }
                                                                                                                                                                                                                                                                                                                                    