/*+
 * VOID tfrend()
 *
 * Description  : Routine to close the TFR files
 *
 * Arguments    : none
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.1      Date : 8-NOV-83
 *
 * Module name  : TFREND.FOR
 *
 * Package      : TFR
 *
 * Updates      : name                 version
 *                R. Beetz             V1.1
 *  description : video attributes off
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrend.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrend()

    {
    VOID swrite(), cclose();

    IMPORT TFRCOM t;

    swrite(t.iscr, "+$", &t.natstr, NULL);
    if(t.nunit)
        {
        cclose(t.nunit);
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    