        PROGRAM MULPLT
C
C	EDIT HISTORY:	Version 3.02,21-NOV-86
C			Log axis mods,5-DEC-86
C
C			Tony Euser
C			Physical Metallurgy Research Labs
C			Canada Center for Mineral and Energy Technology
C			Department of Energy,Mines and Resources
C			Government of Canada
C			568 Booth Street
C			Ottawa, Ontario, Canada K1A 0G1	
C			613-990-0440
C	
	LOGICAL*1 ERR
	LOGICAL*1 SET(24),YLABEL(30),XLABEL(30),TITLE(54),ILEGND(20,24)
        REAL XLE(5),YLE(5),X(200),Y(200)
	INTEGER XLEN,YLEN,NLEN,I,IND,TLEN,KC,HPOS,IPOS
	DIMENSION ISYM1(1),IV(20),IP(20)
C
C =====================================================================
C
C		Initialization of variables
C
	INC=1		!when scaling data values are increasing
	ISCX=0		!default is linear X-axis
	ISCY=0		!default is linear Y-axis
	IAT=1		!default is for legend plotting
	LTYPE=0		!default line type (solid)
	IPEN=1		!default pen number
	ISYM1(1)=0	!default symbol number
	KC=1		!counter for the number of data sets
	IFLTYP=0	!default is no fill for bar graphs
	IGRTYP=1	!default is line graph
	LTY=-1		!default for line graph is using symbols only
	IHSET=1		!default is for 1 subset for bar graphs
	IVSET=1		!default is for no stacked bar graphs
	IBSP=1		!default is for horizontal space bars
	AXLENX=8.	!default X axis length
	AXLENY=8.	!default Y axis length
	XORIG=0.	!default X origin
	YORIG=2.	!default Y origin
C
C ===========================================================================
C
C
C ======================================================================
C
C	  Write the menu options on the screen
C
	TYPE 5,27
5	FORMAT('$'A1'[62;1"p')	!VT200 mode
10	TYPE 11,27,27,27
11	FORMAT(' 'A1'[0m'A1'[H'A1'[J')	!clear screen
	CALL BITSET("44,"40000)	!turn on bit 12 JSW for lowercase input
	TYPE *,' '		!print the menu on the screen
	TYPE 15,27,27
15	FORMAT('      LINE GRAPH',T65,A1'[7mDATA SET #'A1'[0m')
	TYPE *,'     BAR CHART'
	TYPE *,'     PIE CHART'
	TYPE *,' Linetype:       Symbol:'
	TYPE *,' Graph origin X:       in. Y:      in:  Scale factor:'
	TYPE *,' Graph title:'
	TYPE *,' Data filename(DEV:NAME.EXT):'
	TYPE *,' Axis length:  X:       in. LINEAR    Y:       in.  
     +LINEAR'
	TYPE *,' X-axis:  Minimum:             Maximum:'
	TYPE *,' Y-axis:  Minimum:             Maximum:'
	TYPE *,' X-axis label:'
	TYPE *,' Y-axis label:'
	TYPE *,' Shading:'
	TYPE *,'     1: LEGEND:  Outside,upper right'
	TYPE *,'     2: LEGEND:  Inside,lower right'
	TYPE *,'     3:	LEGEND:  Inside,upper right'
C
C ========================================================================
C	
C	now let's draw a box around the menu
C	if you have DECUS TTLIB you can replace the following code
C	with TTLIB calls:
C	CALL	TTGRPH
C	CALL	TTBOLD
C	CALL	LTBOX(2,1,20,79)
C	CALL	TTNV
C	CALL	TTASCI
C
	type 18,27,27
18	format(' 'A1'[1m'A1'(0')
	type 19,27
19	format(' 'A1'[2;1Hlqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
     +qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqk')
     	do 20 i=3,9
	type 21,27,i,27,i
21	format(' 'A1'['I1';1Hx'A1'['I1';79Hx')
20	continue
     	do 22 i=10,19
	type 23,27,i,27,i
23	format(' 'A1'['I2';1Hx'A1'['I2';79Hx')
22	continue
	type 25,27
25	format(' 'A1'[20;1Hmqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
     +qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqj')
	type 28,27,27
28	format(' 'A1'(B'A1'[0m')
	TYPE 30,27,27		!position the cursor row 1 column 31
30	FORMAT('$'A1'[1;15H'A1'#6MULPLT 3.2')
C
C ============================================================================
C
C
40	CALL CPOS		!display information at bottom of screen
	type 50,27
50	format('$'A1'[?25l')	!don't display the cursor
	TYPE 60,27,27,KC,27	!position cursor and print current set number
60	FORMAT('$'A1'[3;76H'A1'[1m'I2,A1'[0m')
C
C ============================================================================
C
	IF(KC.GT.1)GOTO 100	!if not 1st set,don't ask for graph type
C
C ============================================================================
C
C		Select the type of plot: line,bar,or pie
C
C			1 = Line graph
C			2 = Bar chart
C			3 = Pie chart
C
	IPOS=IGRTYP+2
	CALL ARROW(3,5,2,IPOS)
90	IGRTYP=IPOS-2			!set graph type flag
C
C ============================================================================
C
100	IF(IGRTYP.NE.1)GOTO 200		!if not line graph branch
C
C ============================================================================
C
C	If line plot,choose between line only,symbol only, or both
C
C			-1 = Symbols only
C			 0 = Line only
C			 1 = Line plot with symbols at each data point
C
	TYPE 110,27,27,27
110	FORMAT('$'A1'[3;24HSymbol plot only'
     +A1'[4;24HLine plot only'
     +A1'[5;24HLine plot with symbol at each point')
	IPOS=LTY+4
	CALL ARROW(3,5,20,IPOS)
	LTY=IPOS-4			!set line graph type flag
	GOTO 220
C
C ============================================================================
C
200	IF(KC.GT.1.OR.IGRTYP.EQ.3)GOTO 260
C
C ============================================================================
C
C	If bar chart,choose the type of bar spacing
C
C			0 = Combined horizontal and vertical bars
C			1 = Horizontal bars only
C			2 = Vertical bars(stacked) only
C
	TYPE 210,27,27,27
210	FORMAT('$'A1'[3;24HCombined horizontal-vertical'
     +A1'[4;24HHorizontal spaced only'
     +A1'[5;24HVertical stacked only')
	IPOS=IBSP+3
	CALL ARROW(3,5,20,IPOS)
	IBSP=IPOS-3		!flag for bar spacing
220	TYPE 50,27		!0 = both   1 = horizontal  2 = vertical
C
C ============================================================================
C
	IF(IGRTYP.NE.1)GOTO 260	!if bar chart,don't ask for linetype,symbol
C
C ============================================================================
C
C	Choose linetype,symbol
C
230	IF(LTY.EQ.-1)GOTO 240	!if symbol plot only,don't ask for linetype
	CALL IOBOX(LTYPE,1,6,11,9,0,1)
240	IF(LTY.EQ.0)GOTO 260	!if line plot only,don't ask for symbol type
	CALL IOBOX(ISYM1(1),2,6,25,14,0,1)
C
C ============================================================================
C
260	TYPE 270,27,27
270	FORMAT('$'A1'[23;1H'A1'[K')	!erase information line at bottom
	type 280,27
280	format('$'A1'[?25h')		!turn cursor back on
C
C ============================================================================
C
	IF(KC.GT.1)GOTO 560
C
C ============================================================================
C
C	Get the origin co-ordinates
C
	type 282,27,27,1,27
282	FORMAT('$'A1'[7;15H'A1'['I1'mX:',A1'[0m')
	ACCEPT *,XORIG
283	type 282,27,27,0,27
	type 284,27,27,1,27
284	FORMAT('$'A1'[7;28H'A1'['I1'mY:',A1'[0m')
	ACCEPT *,YORIG
285	TYPE 284,27,27,0,27
C
C	Ask for scaling factor 
C
290	TYPE 295,27,27,27
295	FORMAT('$'A1'[7;54H'A1'[4X'A1'[7;54H')
	TYPE 300,27,27,1,27		!prompt for scaling factor
300	FORMAT('$'A1'[7;41H'A1'['I1'mScale factor:'A1'[0m')
	READ(5,*,ERR=290)FACT
	TYPE 300,27,27,0,27	
C
C ============================================================================
C
C	Get the graph title
C
540	TYPE 550,27,27,1,27
550	FORMAT('$'A1'[8;2H'A1'['I1'mGraph title:'A1'[0m')
	CALL GETSTR(5,TITLE,53,ERR)
	TLEN=LEN(TITLE)
	TYPE 550,27,27,0,27
C
C ============================================================================
C
C	Get the data filename,read the data, and determine the no. of points
C
560	I=1
	type 280,27		!turn on the cursor
	TYPE 565,27,27,1,27
565	FORMAT('$'A1'[9;2H'A1'['I1'mData filename(DEV:NAME.EXT):'A1'[0m')
570	TYPE 580,27,27,27	!prompt for the input data filename
580	FORMAT('$'A1'[9;30H'A1'[20X'A1'[9;30H')
	CALL ASSIGN(11,'dummy',-6,'old')
590	IF(IGRTYP.NE.3)READ(11,*,END=600,ERR=570)X(I),Y(I)
	IF(IGRTYP.EQ.3)READ(11,595,END=600,ERR=570)
     +	(ILEGND(I,J),J=1,23),Y(I)
595	FORMAT(23A1,F10.2)
	I=I+1
	GOTO 590
600	CLOSE(UNIT=11)
	NPTS=I-1
	TYPE 565,27,27,0,27
C
C ============================================================================
C
	IF(IGRTYP.EQ.3.OR.KC.GT.1)GOTO 710	!if pie chart don't use axes
C
C ============================================================================
C
C	Get the axis length and ask whether LOG or LINEAR
C
610	TYPE 615,27,27,27	
615	FORMAT('$'A1'[10;20H'A1'[5X'A1'[10;20H')
	TYPE 620,27,27,1,27	!get axes lengths
620	FORMAT('$'A1'[10;16H'A1'['I1'mX: 'A1'[0m')
	READ(5,*,ERR=610)AXLENX
	TYPE 620,27,27,0,27
	CALL CPOS
	TYPE 50,27
	TYPE 630,27,29,27,1,27		!toggle between linear/log axis
630	FORMAT('$'A1'[10;'I2'H'A1'['I1'mLINEAR'A1'[0m')
640	FORMAT('$'A1'[10;'I2'H'A1'['I1'mLOG   'A1'[0m')
650	CALL CURSOR(ICHAR)	!use special terminal input mode
	IF(ICHAR.EQ.67.OR.ICHAR.EQ.68)GOTO 660 !left/right arrows branch out
	IF(ICHAR.EQ.65)ICSX=ICSX+1			!log axis
	IF(ICHAR.EQ.66)ICSX=ICSX-1			!linear axis
	IF(ICSX.GT.1)ICSX=0
	IF(ICSX.LT.0)ICSX=1
	IF(ICSX.EQ.0)TYPE 630,27,29,27,1,27
	IF(ICSX.EQ.1)TYPE 640,27,29,27,1,27
	GOTO 650					!loop back
660	IF(ICSX.EQ.0)TYPE 630,27,29,27,0,27
	IF(ICSX.EQ.1)TYPE 640,27,29,27,0,27
	IF(ICSX.EQ.1)TYPE 815,27,27,0,27
	TYPE 280,27
	TYPE 270,27,27
670	TYPE 675,27,27,27
675	FORMAT('$'A1'[10;43H'A1'[5X'A1'[10;43H')
	TYPE 680,27,27,1,27
680	FORMAT('$'A1'[10;39H'A1'['I1'mY: 'A1'[0m')
	READ(5,*,ERR=670)AXLENY
	TYPE 680,27,27,0,27
	CALL CPOS
	TYPE 50,27
	TYPE 630,27,53,27,1,27		!toggle between LOG/LINEAR AXIS
690	CALL CURSOR(ICHAR)	!use special terminal input mode
	IF(ICHAR.EQ.67.OR.ICHAR.EQ.68)GOTO 700 !left/right arrows branch out
	IF(ICHAR.EQ.65)ICSY=ICSY+1		!log axis
	IF(ICHAR.EQ.66)ICSY=ICSY-1		!linear axis
	IF(ICSY.EQ.0)TYPE 630,27,53,27,1,27
	IF(ICSY.EQ.1)TYPE 640,27,53,27,1,27
	GOTO 690					!loop back
700	IF(ICSY.EQ.0)TYPE 630,27,53,27,0,27
	IF(ICSY.EQ.1)TYPE 640,27,53,27,0,27
	IF(ICSY.EQ.1)TYPE 855,27,27,0,27
	TYPE 280,27
	TYPE 270,27,27
C
C ============================================================================
C
C	Auto scale the data  
C
C	*** The logarithmic scaling routines must be called for each set of
C	    data since the routine transforms the linear values into log 
C	    equivalents.
C
710	IF(ICSX.EQ.0)CALL SCALE(X,AXLENX,NPTS,INC)	!scale the data LINEAR
	IF(ICSX.EQ.1)CALL SCALG(X,AXLENX,NPTS,INC)	!scale the data LOG
	IF(ICSY.EQ.0)CALL SCALE(Y,AXLENY,NPTS,INC)
	IF(ICSY.EQ.1)CALL SCALG(Y,AXLENY,NPTS,INC)
	IF(KC.GT.1)GOTO 890		!if > 2nd log set branch always
	XMIN=X(NPTS+1)
	DX=X(NPTS+2)
	YMIN=Y(NPTS+1)
	DY=Y(NPTS+2)
	XMAX=XMIN+DX*AXLENX
	IF(ICSX.EQ.1)XMAX=DX
	YMAX=YMIN+DY*AXLENY
	IF(ICSY.EQ.1)YMAX=DY
C
C ============================================================================
C
	IF(IGRTYP.EQ.3)GOTO 890
C
C ============================================================================
C
	TYPE 720,27,27,27,XMIN		!print the autoscaled data
720	FORMAT('$'A1'[11;20H'A1'[10X'A1'[11;20H',F10.2)
	TYPE 730,27,27,27,XMAX
730	FORMAT('$'A1'[11;41H'A1'[10X'A1'[11;41H',F10.2)
	TYPE 740,27,27,27,YMIN
740	FORMAT('$'A1'[12;20H'A1'[10X'A1'[12;20H',F10.2)
	TYPE 750,27,27,27,YMAX
750	FORMAT('$'A1'[12;41H'A1'[10X'A1'[12;41H',F10.2)
C
C ============================================================================
C
C	Ask for new axis min. and max. if auto-scaled values not wanted
C
	TYPE 770,27,27,27		!display info for changing max,min
770	FORMAT('$'A1'[11;60H'A1'[7m Type R to retain 'A1'[0m')
	TYPE 780,27,27,27
780	FORMAT('$'A1'[12;60H'A1'[7mthe current values'A1'[0m')
	TYPE 790,27,27,1,27		!move cursor to minimum
790	FORMAT('$'A1'[11;11H'A1'['I1'mMinimum: 'A1'[0m')
	READ(5,*,ERR=800)XMIN		!if not R <CR> read new value
800	TYPE 790,27,27,0,27
	TYPE 720,27,27,27,XMIN
	IF(ICSX.EQ.0)TYPE 810,27,27,1,27
	IF(ICSX.EQ.1)TYPE 815,27,27,1,27
810	FORMAT('$'A1'[11;32H'A1'['I1'mMaximum: 'A1'[0m')
815	FORMAT('$'A1'[11;32H'A1'['I1'mDecades: 'A1'[0m')
	READ(5,*,ERR=820)XMAX		!if not R <CR> read new value
820	IF(ICSX.EQ.0)TYPE 810,27,27,0,27
	IF(ICSX.EQ.1)TYPE 815,27,27,0,27
	TYPE 730,27,27,27,XMAX
	TYPE 830,27,27,1,27
830	FORMAT('$'A1'[12;11H'A1'['I1'mMinimum: 'A1'[0m')
	READ(5,*,ERR=840)YMIN		!if not R <CR> read new value
840	TYPE 830,27,27,0,27	
	TYPE 740,27,27,27,YMIN
	IF(ICSY.EQ.0)TYPE 850,27,27,1,27
	IF(ICSY.EQ.1)TYPE 855,27,27,1,27
850	FORMAT('$'A1'[12;32H'A1'['I1'mMaximum: 'A1'[0m')
855	FORMAT('$'A1'[12;32H'A1'['I1'mDecades: 'A1'[0m')
	READ(5,*,ERR=860)YMAX		!if not R <CR> read new value
860	IF(ICSY.EQ.0)TYPE 850,27,27,0,27
	IF(ICSY.EQ.1)TYPE 855,27,27,0,27
	TYPE 750,27,27,27,YMAX
C
C ============================================================================
C
	dx=(xmax-xmin)/axlenx		!define linear axis increments
	if(icsx.eq.1)dx=xmax		!log axis # of decades
	dy=(ymax-ymin)/axleny	
	if(icsy.eq.1)dy=ymax
C
C ============================================================================
C
C	Get the labels for the X and Y axes
C
	TYPE 870,27,27,1,27
870	FORMAT('$'A1'[13;2H'A1'['I1'mX-axis label:'A1'[0m')
	CALL GETSTR(5,XLABEL,29,ERR)
	XLEN=LEN(XLABEL)
	TYPE 870,27,27,0,27
	TYPE 880,27,27,1,27
880	FORMAT('$'A1'[14;2H'A1'['I1'mY-axis label:'A1'[0m')
	CALL GETSTR(5,YLABEL,29,ERR)
	YLEN=LEN(YLABEL)
	TYPE 880,27,27,0,27
C
C ============================================================================
C
	IF(IGRTYP.EQ.1)GOTO 890	   !don't ask bar chart info if line graph
C
C ===========================================================================
C
	TYPE 1120,27,27			!this is for bar charts only
1120	FORMAT('$'A1'[19;2H'A1'[1mEnter the number of horizontal bars
     +/per X value: ',$)
	ACCEPT *,IHSET
	TYPE 1130,27,27,27			!delete the prompt line
1130	FORMAT('$'A1'[0m'A1'[19;2H'A1'[60X')
C
C ============================================================================
C
1140	IF(IBSP.EQ.1)GOTO 1160		!if horizontal bars only,branch
C
C ============================================================================
C
1145	TYPE 1130,27,27,27			!delete the prompt line
	TYPE 1150,27,27			!this is for bar charts only
1150	FORMAT('$'A1'[19;2H'A1'[1mEnter the number of bars to stack: ',$)
	ACCEPT *,IVSET
1160	TYPE 1130,27,27,27			!delete the prompt line

C
C ============================================================================
C
890	CALL CPOS
	IF(IGRTYP.EQ.3)IVSET=NPTS	!for pie charts only
	DO 1070 I=1,IVSET
	TYPE 900,27,27,1,27
900	FORMAT('$'A1'[15;2H'A1'['I1'mShading:'A1'[0m')
	TYPE 50,27		!turn off the cursor
	IFLTYP=0
	IF(IGRTYP.EQ.1)GOTO 1015
	TYPE 910,27,27,1,I,27
910	FORMAT('$'A1'[15;11H'A1'['I1'mSET #',I2,': 'A1'[0m')
	IF(IFLTYP.EQ.0)TYPE 920,27,27,1,27
	IF(IFLTYP.EQ.1)TYPE 930,27,27,1,27
	IF(IFLTYP.EQ.2)TYPE 940,27,27,1,27
	IF(IFLTYP.EQ.3)TYPE 950,27,27,1,27
	IF(IFLTYP.EQ.4)TYPE 960,27,27,1,27
	IF(IFLTYP.EQ.5)TYPE 970,27,27,1,27
	IF(IFLTYP.EQ.6)TYPE 980,27,27,1,27
	IF(IFLTYP.EQ.7)TYPE 990,27,27,1,27
920	FORMAT('$'A1'[15;22H'A1'['I1'mNONE           'A1'[0m')
930	FORMAT('$'A1'[15;22H'A1'['I1'mSOLID          'A1'[0m')
940	FORMAT('$'A1'[15;22H'A1'['I1'mHORIZONTAL     'A1'[0m')
950	FORMAT('$'A1'[15;22H'A1'['I1'mVERTICAL       'A1'[0m')
960	FORMAT('$'A1'[15;22H'A1'['I1'mLEFT DIAGONAL  'A1'[0m')
970	FORMAT('$'A1'[15;22H'A1'['I1'mRIGHT DIAGONAL 'A1'[0m')
980	FORMAT('$'A1'[15;22H'A1'['I1'mVERTICAL CROSS 'A1'[0m')
990	FORMAT('$'A1'[15;22H'A1'['I1'mDIAGONAL CROSS 'A1'[0m')
1000	CALL CURSOR(ICHAR)	!use special terminal input mode
	IF(ICHAR.EQ.67.OR.ICHAR.EQ.68)GOTO 1010 !left/right arrows branch out
	IF(ICHAR.EQ.65)IFLTYP=IFLTYP+1		!landscape mode
	IF(ICHAR.EQ.66)IFLTYP=IFLTYP-1		!portrait
	IF(IFLTYP.GT.7)IFLTYP=0
	IF(IFLTYP.LT.0)IFLTYP=7
	IF(IFLTYP.EQ.0)TYPE 920,27,27,1,27
	IF(IFLTYP.EQ.1)TYPE 930,27,27,1,27
	IF(IFLTYP.EQ.2)TYPE 940,27,27,1,27
	IF(IFLTYP.EQ.3)TYPE 950,27,27,1,27
	IF(IFLTYP.EQ.4)TYPE 960,27,27,1,27
	IF(IFLTYP.EQ.5)TYPE 970,27,27,1,27
	IF(IFLTYP.EQ.6)TYPE 980,27,27,1,27
	IF(IFLTYP.EQ.7)TYPE 990,27,27,1,27
	GOTO 1000					!loop back
1010	IV(I)=IFLTYP
	IF(IFLTYP.EQ.0)TYPE 920,27,27,0,27
	IF(IFLTYP.EQ.1)TYPE 930,27,27,0,27
	IF(IFLTYP.EQ.2)TYPE 940,27,27,0,27
	IF(IFLTYP.EQ.3)TYPE 950,27,27,0,27
	IF(IFLTYP.EQ.4)TYPE 960,27,27,0,27
	IF(IFLTYP.EQ.5)TYPE 970,27,27,0,27
	IF(IFLTYP.EQ.6)TYPE 980,27,27,0,27
	IF(IFLTYP.EQ.7)TYPE 990,27,27,0,27
1015	TYPE 900,27,27,0,27
C
C ============================================================================
C
	TYPE 1020,27,27,1,27
1020	FORMAT('$'A1'[15;40H'A1'['I1'mPEN:'A1'[0m')
	CALL IOBOX(IPEN,1,15,45,8,1,1)
	IP(I)=IPEN
	TYPE 1020,27,27,0,27
C
C ============================================================================
C
	IF(IGRTYP.EQ.3)GOTO 1070		!if pie chart branch
C
C ============================================================================
C
	TYPE 280,27			!turn the cursor on
	TYPE 1030,27,27,1,27		!label for current data set
1030	FORMAT('$'A1'[15;48H'A1'['I1'mLabel:'A1'[0m')
	TYPE 1040,27,27,27,27
1040	FORMAT('$'A1'[15;55H'A1'[24X'A1'[15;55H')
	CALL GETSTR(5,SET,23,ERR)
	NLEN=LEN(SET)
	IF(NLEN.NE.0)GOTO 1050
	IAT=0
	TYPE 1045,27,27,27
1045	FORMAT('$'A1'[15;55H'A1'[7mNO LABEL'A1'[0m')
	GOTO 1060
1050	DO 1055 K=1,23
1055	ILEGND(I,K)=SET(K)
1060	IF(IAT.NE.0)TYPE 1040,27,27,0,27
	TYPE 1030,27,27,0,27
C
C ============================================================================
C
1070	CONTINUE
	TYPE 910,27,27,0,IVSET,27	!turn off bold for data SET #
C
C ============================================================================
C
	IF(KC.GT.1.OR.IGRTYP.NE.1.OR.IAT.EQ.0)GOTO 1080
C
C ============================================================================
C
C	If legend wanted, ask for its position on the graph
C
	CALL CPOS
	type 50,27
	IPOS=16
	CALL ARROW(16,18,2,IPOS)
	LEGND=IPOS-15
	TYPE 270,27,27
	IF(LEGND.EQ.1)YSET=AXLENY+.25
	IF(LEGND.EQ.2)YSET=.25
	IF(LEGND.EQ.2.AND.ICSX.EQ.1)YSET=YSET+.25
	IF(LEGND.EQ.3)YSET=AXLENY-.25
	TYPE 280,27		!turn the cursor back on
C
C ============================================================================
C
1080	IF(IGRTYP.NE.1)GOTO 1170	!if not line graph branch
C
C ============================================================================
C
C
1170	x(npts+1)=xmin	!put the minimum and increment back into arrays
	x(npts+2)=dx	!subroutine LINE needs them in these positions
	y(npts+1)=ymin	!so does BAR
	y(npts+2)=dy
C
C ============================================================================
C
	IF(KC.GT.1)GOTO 1190	!skip next few line if plot #>1
C
C ============================================================================
C
C	The next two lines determine whether to plot a decimal point
C	or whether integers can be used instead.
C
	IF(XMIN.EQ.AINT(XMIN).AND.DX.EQ.AINT(DX))AXLENX=-AXLENX
	IF(YMIN.EQ.AINT(YMIN).AND.DY.EQ.AINT(DY))AXLENY=-AXLENY
C
C ============================================================================
C
C	The actual plotting routines for the program mulplt
C	
	XOFF=0.
	IF(IGRTYP.EQ.2.OR.(IABS(LTY).EQ.1.AND.(X(1).EQ.XMIN.OR.X(NPTS)
     +	.EQ.XMAX)))XOFF=-.5
        XLEN=-XLEN    !needed by call to axis to write label on cw side
	CALL PLOTS(-2,-200,2)  		!initialize plotter
        CALL PLOT(XORIG,YORIG,-3)	!move it to some point,set origin
	CALL FACTOR(FACT)
	IF(IGRTYP.EQ.3)GOTO 1210
	IF(ICSX.EQ.0)CALL AXIS(0.,0.,XLABEL,XLEN,AXLENX,0.,XMIN,DX)
	IF(ICSX.EQ.1)CALL LGAXS(0.,0.,XLABEL,XLEN,AXLENX,0.,XMIN,DX)
	IF(ICSY.EQ.0)CALL AXIS(XOFF,0.,YLABEL,YLEN,AXLENY,-90.,YMIN,DY)
	IF(ICSY.EQ.1)CALL LGAXS(XOFF,0.,YLABEL,YLEN,AXLENY,90.,YMIN,DY)
	AXLENX=ABS(AXLENX)
	AXLENY=ABS(AXLENY)
C
C ============================================================================
C
C	Draw a frame around the graph
C
1180    CALL RECTS(XOFF,0.0,AXLENX+ABS(XOFF*2.),AXLENY)
	CALL RECTS(XOFF+.01,.01,AXLENX+ABS(XOFF*2.)-.02,AXLENY-.02)
	CALL RECTS(XOFF-.01,-.01,AXLENX+ABS(XOFF*2.)+.02,AXLENY+.02)
C
C ============================================================================
C
1190	IF(IAT.EQ.0)GOTO 1210		!if no legend wanted,branch
C
C ============================================================================
C
C	The following values represent the plotting co-ordinates
C	for placing the legend on the graph.  The current line-type
C	or symbol is plotted along with the label.
C
	XLE(1)=AXLENX-3.4
	XLE(2)=AXLENX-3.4
	XLE(3)=AXLENX-3.4
C
C ============================================================================
C
	IF(LTY.LT.0)GOTO 1200	!if symbols only branch
C
C ============================================================================
C
	XLE(1)=AXLENX-3.6
	XLE(2)=AXLENX-3.4
	XLE(3)=AXLENX-3.2
1200	XLE(4)=0.0
	XLE(5)=1.0
	YLE(1)=YSET
	YLE(2)=YSET
	YLE(3)=YSET
	YLE(4)=0.0
	YLE(5)=1.0
C
C ============================================================================
C
1210	IF(IGRTYP.EQ.2)CALL BAR(X,Y,NPTS,IHSET,IVSET,AXLENX,AXLENY,KC,
     +IV,IP,ILEGND)
	IF(IGRTYP.EQ.3)CALL PIE(Y,NPTS,IV,IP,ILEGND)
	IF(IGRTYP.EQ.2)GOTO 1250	!bar chart
	IF(IGRTYP.EQ.3)GOTO 1310	!pie chart
	IF(IPEN.NE.1)CALL NEWPEN(IPEN)
	CALL LINTYP(LTYPE)
	IF(ICSX.EQ.1)X(NPTS+2)=DX/AXLENX
	IF(ICSY.EQ.1)Y(NPTS+2)=DY/AXLENY
	CALL LINE(X,Y,NPTS,1,LTY,ISYM1)	!plot the data
1240	CALL LINTYP(LTYPE)
	NLEN=LEN(SET)
	IF(IAT.EQ.0)GOTO 1245
        IF(LTY.EQ.1)GOTO 1242
        CALL LINE(XLE,YLE,3,1,LTY,ISYM1)!plot legend marker 
	GOTO 1244
1242    CALL LINE(XLE,YLE,3,1,0,0)	!draw a line
        CALL LINTYP(0)
	CALL SYMBOL(XLE(2),YLE(2),.14,ISYM1,0.,-1) !and the symbol
1244	CALL SYMBOL(AXLENX-3.0,YSET-.075,0.14,SET,0.,NLEN)
1245	CALL LINTYP(LTYPE)		!reset line-type
1250	CALL NEWPEN(1)
C
C ============================================================================
C
	KC=KC+1		!increment data set counter even if it's the last
	IF(IGRTYP.EQ.2.AND.KC.LE.IABS(IHSET))GOTO 1280
	IF(IGRTYP.EQ.2.AND.KC.GT.IABS(IHSET))GOTO 1320
C
C ============================================================================
C
1260	CALL BITCLR("44,"40000)		!allow only uppercase input
	TYPE 1270,27,27,27,27
1270	FORMAT('$'A1'[22;24H'A1'[7m'A1'[?25hWould you like to plot
     + another set ?'A1'[0m',$)
	CALL SINGLE(IAN)
	CALL BITSET("44,"40000)		!enable lowercase input again
	IF(IAN.EQ.30)GOTO 1310
1280	TYPE 1290,27,27
1290	FORMAT('$'A1'[22;1H'A1'[K')
C
C ============================================================================
C
	DO 1300 I=1,NPTS		!zero the arrays
	X(I)=0.0
1300	Y(I)=0.0
	IF(LEGND.EQ.1)YSET=YSET+.25
	IF(LEGND.EQ.2)YSET=YSET+.25
	IF(LEGND.EQ.3)YSET=YSET-.25
	GOTO 40
C
C ============================================================================
C
1310    CALL NEWPEN(1)			!use pen #1 to plot title
	CALL LINTYP(0)
	IF(IAT.EQ.0.OR.IGRTYP.NE.1)GOTO 1320
	IF(LEGND.EQ.2)CALL RECTS(AXLENX-3.75,0.,
     +	3.75+ABS(XOFF),(KC+1)*.25)
	IF(LEGND.EQ.3)CALL RECTS(AXLENX-3.75,AXLENY,
     +	3.75+ABS(XOFF),-((KC+1)*.25))
1320	AXLENX=ABS(AXLENX)		!a redundancy for pie charts only!
	AXLENY=ABS(AXLENY)
	IF(TLEN.EQ.0)GOTO 1400
	HAFWAY=AXLENX/2.
	CALL SYMBOL(HAFWAY,AXLENY+.2,-.25,TITLE,0.,TLEN)
1400	CALL PLOT(0.0,0.0,999)		!final dumping of buffer
	CALL BITCLR("44,"40000)		!turn off lowercase input
	TYPE 280,27			!turn the cursor on
	TYPE 1500,27,27,27,27,27
1500	FORMAT('$'A1'[23;1H'A1'[78X'A1'[22;1H'A1'[78X'A1'[0m')
	END
                                                                                                                                                                                                                                                                                                                                                                             