C PROGRAM TO CONVERT PROLOG ASCII HEX TO TEKTRONIX FORMAT.
C ASSUMES THAT THE PROLOG INPUT FILE HAS EXACTLY 16 BYTES/LINE, SEPARATED
C  BY A SPACE.
C FILED--15-JAN-80, G. BEVER.
C MODIFIED TO TAKE CARE OF 'TEKLD' XFER PROBLEM (DUMMY BYTE ON END OF
C  RECORD).  TO PREVENT PROBLEMS, SPECIFY EXACT BYTE COUNT.
C CHECKS FOR '*' & '/' AS 1ST CHARS ON LINE ADDED--16-JAN-80, G. BEVER.
C CHECKS FOR END OF FILE, OUTPUT FILE SIZE, <16 BYTES/LINE--27-NOV-84, G. BEVER.
C
C COMPILE AS FOLLOWS:
C
C      .COMPILE PROTEK
C
C LINK AS FOLLOWS:
C
C      .LINK PROTEK,HEX,IHEXBN
C
      DIMENSION ISTRT(41),NUMB(41),ICHKSM(2),ITMP(2)
      INTEGER*2 ISPEC(39),JSWI(4,1)
      REAL*4 EXT(2)
      LOGICAL*1 IBUF(50),JBUF(150),IPRMPT(2)
      DATA EXT/6RPROTEK,6RDATDAT/
      DATA JSWI/'M',3*0/
      DATA JBUF/150*"60/
	DATA IPRMPT/'#',"200/
C
C GET INPUT & OUTPUT FILE NAMES.
    5 IF(ICSI(ISPEC,EXT,,JSWI,1).NE.0) GO TO 5
C ASSIGN INPUT LOGICAL UNIT.
      CALL IASIGN(10,ISPEC(16),ISPEC(17),0,0)
C ASSIGN OUTPUT LOGICAL UNIT.
      CALL IASIGN(11,ISPEC(1),ISPEC(2),ISPEC(5),16)
C
      TYPE 101
  101 FORMAT(' ENTER # OF BYTES (4 DIGITS IN HEX) '$)
      CALL GTLIN(NUMB,IPRMPT)
      TYPE 103
  103 FORMAT(' ENTER START ADDRESS (4 DIGITS IN HEX) '$)
      CALL GTLIN(ISTRT,IPRMPT)
C CONVERT ASCII HEX #S INTO BINARY.
      JSTRT=IHEXB2(ISTRT)
      JNUMB=IHEXB2(NUMB)
C CALCULATE END ADDRESS.
      JEND=JSTRT+JNUMB-1
C
C READ PROLOG FORMAT LINE
   10 READ(10,105,END=35)(IBUF(I),I=1,47)
  105 FORMAT(100A1)
C
C IF NOTHING ON LINE, SKIP IT & READ ANOTHER.
      IF(IBUF(1).EQ."40) GO TO 10
C IF 1ST CHARACTER IS '*', SKIP IT & READ ANOTHER LINE.
      IF(IBUF(1).EQ."52) GO TO 10
C IF 1ST CHARACTER IS '/', XFER TERMINATOR BLOCK & END.
      IF(IBUF(1).EQ."57) GO TO 35
C
C CALCULATE CHECKSUM.
      KCHKSM=0
      DO 20 I=1,2
   20 KCHKSM=KCHKSM+ICKSM(ISTRT(I))
      KCHKSM=KCHKSM+2
C CONVERT CHECKSUM TO ASCII HEX.
      CALL HEX(KCHKSM,ICHKSM)
C FILL IN TEKTRONIX FORMAT LINE HEADER.
      K=1
      JBUF(K)="57
      JBUF(K+1)=ISTRT(1)
      JBUF(K+2)=IRAM(ISTRT,8,"377)
      JBUF(K+3)=ISTRT(2)
      JBUF(K+4)=IRAM(ISTRT(2),8,"377)
      JBUF(K+5)="61
      JBUF(K+6)="61
      JBUF(K+7)=ICHKSM(2)
      JBUF(K+8)=IRAM(ICHKSM(2),8,"377)
C SET UP START ADDRESS FOR NEXT LINE.
      JSTRT=JSTRT+16
C CONVERT IT TO ASCII HEX.
      CALL HEX(JSTRT,ISTRT)
      JCHKSM=0
      L=1
C XFER DATA.
      K=K+9
      DO 30 I=1,16
      JBUF(K)=IBUF(L)
      JBUF(K+1)=IBUF(L+1)
C FORM INTEGER FROM SINGLE BYTE VARIABLES.
      IN=JBUF(K)
      IN1=JBUF(K+1)
      IN=IOR(IAND(IN,"377),IRAM(IN1,8,"177400))
	IF(IN.NE.'  ') GO TO 27	! IF DATA STILL ON LINE, GO TO 27.
C RESET CHECKSUM.
	CALL HEX(I,ITMP)	! CONVERT # BYTES ON LINE TO ASCII HEX.
	JBUF(6)=IAND(ITMP(2),"377)	! CHANGE # BYTES/LINE IN TEK OUTPUT LINE.
	JBUF(7)=IRAM(ITMP(2),8,"377)
	JSTRT=JSTRT-(16-(I-1))	! CHANGE STARTING ADDRESS FOR NEXT LINE.
	CALL HEX(JSTRT,ISTRT)	! CONVERT IT TO ASCII HEX.
	KCHKSM=KCHKSM-2		! REMOVE CHARACTER COUNT FROM 1ST CHECKSUM.
	KCHKSM=KCHKSM+ICKSM(ITMP(2))
C CONVERT CHECKSUM TO ASCII HEX.
      CALL HEX(KCHKSM,ICHKSM)
      JBUF(8)=ICHKSM(2)
      JBUF(9)=IRAM(ICHKSM(2),8,"377)
	GO TO 31		! ABORT LOOP.
27    JCHKSM=JCHKSM+ICKSM(IN)
      K=K+2
   30 L=L+3
C CONVERT CHECKSUM TO ASCII HEX.
31    CALL HEX(JCHKSM,ICHKSM)
C XFER CHECKSUM.
      JBUF(K)="60
      JBUF(K+1)="60
      K=K+2
      JBUF(K)=ICHKSM(2)
      JBUF(K+1)=IRAM(ICHKSM(2),8,"377)
      K=K+1
      L=L+2
C OUTPUT TEKTRONIX FORMAT LINE.
      WRITE(11,105)(JBUF(I),I=1,K)
C IF MORE DATA, GO TO 10.
C     IF(JSTRT.LE.JEND) GO TO 10
	GO TO 10
C ALL DONE, XFER TERMINATOR BLOCK.
   35 K=1
      JBUF(K)="57
      K=K+1
      DO 40 I=1,8
      JBUF(K)="60
   40 K=K+1
      JBUF(K)="15
      JBUF(K+1)="12
      K=K+1
C OUTPUT TERMINATOR BLOCK.
      WRITE(11,105)(JBUF(I),I=1,K)
C
      STOP
      END
C
      FUNCTION ICKSM(IN)
C FUNCTION TO CALCULATE TEKTRONIX CHECKSUM OF 2 ASCII HEX DIGITS.
      LSB=IOR(IAND(IN,"177400),"60)
      MSB=IOR(IRAM(IN,8,"177400),"60)
      ILSB=IHEXBN(LSB)
      IMSB=IHEXBN(MSB)
      ICKSM=ILSB+IMSB
      RETURN
      END
C
      FUNCTION IHEXB2(IN)
C FUNCTION TO CONVERT A 2 WORD ARRAY (4 ASCII HEX DIGITS) TO BINARY.
      DIMENSION IN(2)
      MSB=IHEXBN(IN(1))
      LSB=IHEXBN(IN(2))
      IHEXB2=IOR(IRAM(MSB,8,"177400),IAND(LSB,"377))
      RETURN
      END
                                                                                                       