x/*+
 * VOID tfrru(nrec, keywrd)
 *     COUNT nrec;
 *     TEXT  *keywrd;
 *
 * Description  : Routine to read a display-only/update field record and/or
 *                its FCR (for update field records only).
 *                This routine is reserved for TFR-subroutines only
 *
 * Arguments    : nrec   = INTEGER record number
 *                keywrd = STRING containing a keyword:
 *                         'VAR'   - read display-only/update field record
 *                         'FCR'   - read field copy record
 *                         'ALL'   - read update field record and FCR
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRRU.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrru.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrru(nrec, keywrd)
    COUNT nrec;
    TEXT  *keywrd;

    {
    IMPORT TFRCOM t;

#include <dondef.h>
#include <upddef.h>

    LOCAL TEXT  prog[] = "TFRRU";

    COUNT ikey;
    COUNT *pf;

    pf = &t.frec;
/*
 *    check keyword
 */
    if(cmpstr(keywrd, "VAR"))
        {
        ikey = 1;
        }
    else if(cmpstr(keywrd, "FCR"))
        {
        ikey = 2;
        }
    else if(cmpstr(keywrd, "ALL"))
        {
        ikey = 3;
        }
    else
        {
        error(prog, "-Invalid keyword argument");
        }
/*
 *    read display-only/update field record
 */
    if((ikey & 1) == 1)
        {
        rcread(t.nunit, nrec, t.maxbuf, &t.frec);
        --(pf->npfcr);
        }
/*
 *    read field copy record
 */
    if((ikey & 2) == 2  &&  pf->nrfcr != t.nlfcr)
        {
        if(t.nlfcr)
            {
            rcwrit(t.nunit, t.nlfcr, t.maxbuf, &t.fcr); /*write last FCR(s) */
            if(t.llfld >= t.maxbuf)
                {
                rcwrit(t.nunit, t.nlfcr+1, t.maxbuf, &t.fcr[t.maxbuf]);
                }
            }
        rcread(t.nunit, pf->nrfcr, t.maxbuf, &t.fcr); /* read new FCR(s) */
        if(pf->lenupd >= t.maxbuf)
            {
            rcread(t.nunit, pf->nrfcr+1, t.maxbuf, &t.fcr[t.maxbuf]);
            }
        t.nlfcr = pf->nrfcr;
        t.llfld = pf->lenupd;
        }
    }
                                                                                                                                                                                                                                                                                                          