/*+
 * VOID rswrit(iunit, cc, nr, string)
 *     TEXT  *string, *cc;
 *     COUNT iunit, nr;
 *
 * Description  : This is a repeated string write. It writes a concatination
 *                of NR times STRING to unit IUNIT with the given Fortran
 *                control characters
 *
 * Arguments    : iunit   = unit number to write to (default terminal)
 *                cc     = control characters (default ' ')
 *                nr     = repeat count
 *                string = the string to be written
 * Author       : R. Beetz
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 16-dec-82
 *
 * Module name  : RSWRIT.FOR
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : rswrit.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>

VOID rswrit(iunit, cc, nr, string)
    TEXT  *string, *cc;
    COUNT iunit, nr;

    {
    TEXT hc[3], c1, c2;
    COUNT iu, i;
    
    iu = iunit;
    c1 = ' ';
    c2 = NULL;
    hc[2] = NULL;
    if(cc[0] != NULL)
        {
        if(cc[0] == '$')
            {
            c2 = '$';
            }
        c1 = cc[0];
        if(cc[1])
            {
            c2 = cc[1];
            }
        }
    for(i = 0; i < nr; ++i)
        {
        if(nr == 1)
            {
            hc[0] = c1;
            hc[1] = c2;
            }
        else if(i == 1)
            {
            hc[0] = c1;
            hc[1] = '$';
            }
        else if(i < nr-1)
            {
            hc[0] = '+';
            hc[1] = '$';
            }
        else
            {
            hc[0] = '+';
            hc[1] = c2;
            }
        swrits(iu, hc, string);
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                           