/*+
 * METACH igtchr()
 *
 * Description  : Get a character out the input ringbuffer. Mode of input
 *                follows the JSW. See description of routine INPMOD.
 *                If no char is available in the buffer and mode is NOWAIT
 *                -1 is returned.
 *
 * Arguments    : none
 *
 * Author       : R. Beetz
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 24-dec-82
 *
 * Module name  : IGTCHR
 *
 * Package      : RT11-LIBRARY
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : igtchr.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/


#include <local.h>

METACH igtchr()

    {
    METACH ittinr();

    METACH igtchr;
    BOOL   ibit6;

    ibit6 = JSW & 0100;
    while((igtchr = fcall(&ittinr, 0)) <= 0)
        {
        if(ibit6)
            {
            return(EOF);
            }
        }
    return(igtchr);
    }
                                                                                                                                                                                                  