/*+
 * VOID mprmn(inwpag)
 *     BOOL inwpag;
 *
 * Description  : Routine of the MPR-subroutine package that controls
 *                menu processing according users commands
 *                This routine is reserved for MPR-subroutines only
 *
 * Arguments    : inwpag = INTEGER to indicate whether the menu must be 
 *                         (re-)displayed or not (1 or 0) 
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.1      Date : 22-JUL-83
 *
 * Module name  : MPRMN.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *                R.Beetz              V1.1
 *  description : breakthrough bug solved
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprmn.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprmn(inwpag)
    BOOL inwpag;

    {
    VOID  mprpm(), mprdm(), mprgf(), mprps(), swrite();
    COUNT mprexe(), mprpp();

    IMPORT MPRCOM m;

    LOCAL TEXT prog[] = "MPRMN";

    TEXT  comstr[60];
    COUNT ipcl, iret;
    BOOL  iwbt;

    ipcl = inwpag % 2;
/*
 *    init menu and display eventually
 */
    FOREVER
        {
        mprpm(m.inrec);
        mprdm(ipcl);
        iwbt = m.ibtflg;
        mprgf(comstr);
/*
 *    examine IFUNCT
 */
        switch(m.ifunct)
            {
        case -3:
            return;               /* "EXIT" entered, return to main-program */
        case -1:
            ipcl = 2;             /* "<" entered */
            while((m.inrec = mprpp()));       /* unroll stack */
            m.inrec = m.nrmmr;
            continue;
        case -2:
            ipcl = 2;             /* "." entered */
            m.inrec = mprpp();            /* get former menu or clear screen
                                               and return to main menu */
            continue;                           
            }
/*
 *    positive value for IFUNCT
 */
        if(m.typtab[m.ifunct] == 'M')     /* next menu wanted */
            {
            mprps();
            m.inrec = m.nrttab[m.ifunct];
            if(m.ibtflg)
                {
                ipcl = 0;
                }
            continue;
            }
        iret = mprexe(&m.mfttab[m.ifunct]);
        if(iret < 0  ||
          (m.typtab[m.ifunct] == 'F'  &&  iret > 1)  ||
          (m.typtab[m.ifunct] == 'S'  &&  iret > 3))
            {                          /* Invalid return code */
            swrite(m.iscr, " ", &m.mespat, &m.clrvat, &m.erlstr, NULL);
            swrite(m.iscr, " ", &m.erlstr, "?", prog, "-I-",
                   &m.mfttab[m.ifunct]);
            error(prog, "-Invalid return-code from function");
            }
        ipcl = iret % 2;
        if(m.typtab[m.ifunct] == 'F')
            {
            if(!ipcl  &&  iwbt)
                {
                ipcl = 2;
                }
            continue;
            }
        else
            {
            if(iret > 1)
                {
                ipcl = iret - 2;
                if(!ipcl  &&  iwbt)
                    {
                    ipcl = 2;
                    }
                continue;
                }
            else
                {
                mprps();
                m.inrec = m.nrttab[m.ifunct];
                ipcl = 2 - iret;
                continue;
                }
            }
        }
    }
                                                                                                                                                                                                                                                                     