.disable suffix,prefix
.;REGLIB Documentation
;[0m[H[J
;[1;30HRELEASE NOTES
;
; REGLIB is library of FORTRAN IV callable subroutines that are used
;for graphics output to DEC's VT12- and VT24- series terminals and
;compatibles. The calling and argument structure of the subroutines has
;been modelled after the CALCOMP HOST COMPUTER BASIC SOFTWARE so that
;existing code written for CALCOMP devices need not be modified to
;drive REGIS devices. 
;
;		The 10 basic subroutines are:
;
;AXIS  .FOR  which generates a labelled axis with tick marks
;FACTOR.FOR  which set a scaling factor for the entire graph
;LINE  .FOR  which plot a set of data using a line,points or both
;NEWPEN.FOR  which changes the beam color
;NUMBER.FOR  which outputs numerical values in ASCII form
;PLOT  .FOR  which handles all screen output
;PLOTS .FOR  which initializes the REGIS device
;SCALE .FOR  which scales a set set of data for the LINE subroutine
;SYMBOL.FOR  which places text as well as plotting symbols on the screen
;WHERE .FOR  which returns the current beam position and scaling factor

.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;			Other routines included are:
;
;ARC6  .FOR  which generates an arc
;CIRCLE.FOR  which generates a circle
;CSLANT.FOR  which changes the text slant (eg. to italics)
;LGAXS .FOR  which generates a labelled logarithmic axis with tick marks
;LINTYP.FOR  which set the line type pattern (solid,dotted,dashed,etc.)
;OFFSET.FOR  which sets an plotting offset
;PENDN .FOR  which turns the beam on
;PENUP .FOR  which turns the beam off
;RECTS .FOR  which generates rectangles,squares
;SCALG .FOR  which converts linear data into base10 logs and scales it 
;SPMODE.FOR  which sets relative or absolute coordinate addressing
;WINDOW.FOR  which establishes the frame for viewing the data


.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;A FEW NOTES:
;
;  I haven't cleaned up the output.  There are still many spaces and extra 
;CR/LF combinations and I haven't made use of relative positioning for a 
;single axis eg.( P[,Y]).

.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;			SUBROUTINE DESCRIPTION
;
;CALL PLOTS(IMODE,IRES,ILUN) 
;
; This must be the first routine called. It shifts the terminal into
;REGIS mode and establishes some default parameters. Of the three
;arguments, the first two (IMODE and IRES) are dummy arguments and have
;been retained for compatibility reasons with other CALCOMP-like
;libraries, so you can set them to whatever you like. However the value
;of ILUN sets the logical output device. I usually set it to 6. Then
;before I use any of the routines I issue an ASSIGN TT 6 command to
;KMON (or if I want to save to disk ASS DK 6) and then run the program.
;eg.call plots(1,1,6)
;
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL PLOT(X,Y,IPEN)
;
; This subroutine controls the pen movement and position. X and Y must
;be real variables in inches ( or centimeters if you using a scaling
;factor of 2.54). IPEN values and effects:
;
;	< 0 (ie.negative)  the beam is off,it moves to X,Y and the origin is
; 			   set at X,Y  eg.call plot(3.,2.,-3)
;        = 0   		   redefine the current position as X,Y
;	= 2		   turn on the beam,then move to X,Y (ie.draw vector)
;	= 3 		   turn the beam off,then move to X,Y
;        = 999		   terminate the plot,exit REGIS mode 
;			   eg.call plot(0.,0.,999)

.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL FACTOR(FACT)
;
; This subroutine set the scaling factor for the entire plot. Because
;of size of the REGIS terminals compared to CALCOMP plotters, this
;routine is needed to map the coordinates into a smaller frame. eg.
;call factor(0.6)
;
;CALL WHERE(X,Y,FACT)
;
; The subroutine PLOT keeps track of the current beam position as well
;as the current scaling factor. This routine simply returns those
;values.
;
;CALL NEWPEN(IPEN)
;
; This subroutine allows the user the change to color used to generate
;the graph. **** I've only succeeded in using 4 of the many colors
;available on the VT241. There are 4 output map RAM locations, and I've
;tried using the HLS system (see the VT240 series Programmer Reference
;Manual EK-VT240-RM-001). If you find out how to get the additional
;colors let me know please.
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL SYMBOL(X,Y,HEIGHT,ISTRING,ANGLE,NPTS)
; 
; This is the subroutine to put text or one of the 15 plotting symbols
;on the screen. 
;X,Y 	are the starting location coordinates 
;HEIGHT 	is the height of text/symbol
;	if negative then center ISTRING about X,Y
;ISTRING is the HOLLERITH string representing the text or the numerical value 
;	of the symbol to use 
;ANGLE 	is the angle in degrees which to rotate the text 
;NPTS 	is the number of characters in ISTRING 
;     	or if NPTS is negative then use the special symbols. 
;Note: because REGIS uses a 2:1 vertical aspect ratio ,certain angles result
;in a change of character width and height. I have not done anything to handle
;this especially when using the axis subroutine. It really is a nuisance.
;However,I hope not too many of you generate axes other than 0,90,180,270 
;and 360 degrees.
.asks ok [23;29H[1mHit return to continue[0m
;P1p S(I0,E)  S(A[0,479][799,0])P[176.50,176.50]P[-0.0000084,+48.]
;T(I0)T(D0,S4)V T'TEST'T(A0)\
;[1;1H
;eg.call symbol(2.,2.,.5,4HTEST,0.,4) 
;prints 'TEST' 2 inches to the right and 2 inches up from 
;the current origin, using .5 inch high characters 
;(or at least the closest value since REGIS has a very finite 
;step size) and the text is written at a 0 degree angle above
;the positive X axis.
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])P[176.50,176.50]
;P[-90.0000076,+0.0000000];P[-0.0000084,+48.0000000]T(I0)T(D0,S4)V
;T'TEST1'T(A0)\
;[1;1Hcall symbol(2.,2.,-.2,5Htest1,0.,5) does the above except that the
;string is centered about X,Y
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])P[176.50,176.50]
;P[-180.0000000,-0.0001348]P[-0.0000168,+48.0000076]T(I0)T(D0,S4)V
;T'TEST1'T(A0)\
;[1;1Hcall symbol(2.,2.,.5,5HTEST1,-360.,5) the text ends at X,Y
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])P[176.50,176.50]
;P[-90.0000000,-0.0000674]T(I0)T(D0,S4)V T'TEST1'T(A0)\
;[1;1Hcall symbol(2.,2.,-.2,5Htest1,-360.,5) the text is now centered at X,Y
;but below the line 
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;The special symbols are numbered from 0 to 14.
;Here is an example program to call all the special symbols:
;
;	dimension isym(1)
;	integer i		!just to get rid of the warning
;	x=2.
;	y=1.
;	call plots(1,1,7)	!initialize the device
;	call plot(0.,0.,-3)	!define the origin
;	do 10 i=1,15
;	isym(1)=i-1
;	call symbol(x,y,.3,isym(1),0.,-1) 
;	y=y+1.
;	if(y.gt.5.)x=x+2.
;	if(y.gt.5.)y=1.
;10	continue
;	call plot(0.,0.,999)	!finish
;	stop
;	end
;	
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])
;P[176.50,88.25]P[-0.0000042,+24.0000000]T(I0)T(D0,S2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,FF,81,81,81,FF,00,00,00;
;T(A3)'S'T(A0)P[176.50,176.50]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,7E,81,81,81,7E,00,00,00;
;T(A3)'S'T(A0)P[176.50,264.75]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,18,24,42,81,FF,00,00,00;
;T(A3)'S'T(A0)P[176.50,353.00]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,18,18,FF,FF,18,18,00,00,00;
;T(A3)'S'T(A0)P[176.50,441.25]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,C3,66,3C,18,3C,66,C3,00,00;
;T(A3)'S'T(A0)P[353.00,88.25]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,10,28,44,82,44,28,10,00,00;
;T(A3)'S'T(A0)P[353.00,176.50]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,18,24,42,81,FF,10,10,00;
;T(A3)'S'T(A0)P[353.00,264.75]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,FF,44,28,10,28,44,82,00;
;T(A3)'S'T(A0)P[353.00,353.00]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,FF,FE,0C,18,30,7F,FF,00,00;
;T(A3)'S'T(A0)P[353.00,441.25]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,C3,66,3C,18,18,18,18,00,00;
;T(A3)'S'T(A0)P[529.50,88.25]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,81,7E,42,7E,81,00,00,00;
;T(A3)'S'T(A0)P[529.50,176.50]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,49,2A,1C,7F,1C,2A,49,00,00;
;T(A3)'S'T(A0)P[529.50,264.75]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,7E,44,28,10,28,44,7E,00;
;T(A3)'S'T(A0)P[529.50,353.00]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,18,18,18,18,18,18,18,00,00;
;T(A3)'S'T(A0)P[529.50,441.25]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;P[-8.0000000,-10.0000000]L(A3)"S"00,00,10,FF,42,FF,10,00,00,00;
;T(A3)'S'T(A0)\
;
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL NUMBER(X,Y,HEIGHT,FLOATN,ANGLE,NDEC)
;
; This subroutine converts a number into an ASCII string for printing
;to the screen. It is similar to SYMBOL.
;X,Y are the starting coordinates of the numerical string
;HEIGHT is the character height. If negative then center the string
;FLOATN is the number to be converted to a string
;ANGLE is the angle of rotation of the string. If negative use in centering
;NDEC is the number of decimal places to use
;     if 0 then no fractional values are plotted,but the decimal point is.
;     if -1 then only integers are plotted (no decimal point)
;
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])P[176.50,176.50]
;P[-0.0000084,+48.0000000]T(I 0)T(D  0,S 4)V T'123.46'T(A0)\
;[1;1Heg. call number(2.,2.,.5,123.456789,0.,2) 
;Draws a .5 inch character string containing the number 123.45. N=2
;specifies rouding to 2 decimal places. String placement is controlled
;by the signs of HEIGHT and ANGLE
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL AXIS(X,Y,LABEL,NCH,AXLEN,ANGLE,AXMIN,DELTA)
;
; This subroutine draws a labelled axis of length AXLEN starting at X,Y
;, with the initial value being AXMIN and tick marks at every DELTA.
;The axis is rotated ANGLE degrees and has the label LABEL.
;
;X,Y are the starting coordinates of the axis.
;LABEL is the Hollerith string containing the axis label.
;NCH is the number of characters in the string LABEL.
;    If NCH is positive then the label,scale and tick marks are on the CCW side
;    of the axis. If NCH is negative, then the CW side is used.
;AXLEN is the length of the axis in inches. If negative, then use integers only
;    when printing the axis scale.
;ANGLE is the angle in degrees from the positive X axis. Thus ANGLE=0. 
;    generates a horizontal axis, and ANGLE=90. generates a vertical axis.
;    The axis values at the tick marks are plotted parallel to the axis if this
;    variable is positive, and plotted perpendicular to the axis if negative
;    (eg.-360.0 will generate a horizontal axis with perpendicular tick labels)
;AXMIN is the minimum value shown on the axis.
;DELTA is the increment per inch on the scale.
; 
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])
;P[80,71]V[80,80]V[80,71]V[160,71]V[160,80]V[160,71]V[240,71]V[240,80]V[240,71]
;V[320,71]V[320,80]V[320,71]V[400,71]V[400,80]V[400,71]V[480,71]V[480,80]
;V[480,71]V[560,71]V[560,80]V[560,71]V[640,71]V[640,80]V[640,71]P[80,84]
;P[- 18,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'0.00'T(A0)P[160,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'10.00'T(A0)P[240,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'20.00'T(A0)P[320,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'30.00'T(A0)P[400,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'40.00'T(A0)P[480,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'50.00'T(A0)P[560,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'60.00'T(A0)P[640,84]P[- 22,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 1)V
;T'70.00'T(A0)P[360,123]P[- 45,+  0]P[+  0,+ 15]T(I 0)T(D  0,S 2)V
;T'test1'T(A0)\
;[1;1Heg. call axis(0.,0.,5htest1,5,7.,0.,0.,10.)
;
;result: horizontal axis,labels on CCW side(above axis),perpendicular 
;        tick mark labels with 2 decimal points
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])
;P[80,142]V[80,134]V[80,142]V[160,142]V[160,134]V[160,142]V[240,142]
;V[240,134]V[240,142]V[320,142]V[320,134]V[320,142]V[400,142]V[400,134]
;V[400,142]V[480,142]V[480,134]V[480,142]V[560,142]V[560,134]V[560,142]
;V[640,142]V[640,134]V[640,142]P[80,129]P[-18,+0]T(I0)T(D0,S1)V
;T'0.00'T(A0)P[160,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'10.00'T(A0)P[240,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'20.00'T(A0)P[320,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'30.00'T(A0)P[400,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'40.00'T(A0)P[480,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'50.00'T(A0)P[560,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'60.00'T(A0)P[640,129]P[- 22,+0]T(I 0)T(D  0,S 1)V
;T'70.00'T(A0)P[360,90]P[- 45,+0]T(I 0)T(D  0,S 2)V
;T'test1'T(A0)\
;[1;1Heg. call axis(0.,0.,5htest1,-5,7.,0.,0.,10.)
;
;result: horizontal axis,labels on CW side(below axis),perpendicular 
;        tick mark labels with 2 decimal points
;
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])
;P[176.50,88.25]V[176.50,98.84]V[176.50,88.25]V[264.75,88.25]V[264.75,98.84]
;V[264.75,88.25]V[353.00,88.25]V[353.00,98.84]V[353.00,88.25]V[441.25,88.25]
;V[441.25,98.84]V[441.25,88.25]V[529.50,88.25]V[529.50,98.84]V[529.50,88.25]
;V[617.75,88.25]V[617.75,98.84]V[617.75,88.25]P[176.50,104.14]
;P[+0.0000472,+36.0000000]P[+12.0000000,-0.0000090]T(I 0)T(D270,S 1)V
;T'0.00'T(A0)P[264.75,104.14]P[+0.0000708,+54.0000000]
;P[+12.0000000,-0.0000090]T(I 0)T(D270,S 1)V T'100.00'T(A0)P[353.00,104.14]
;P[+0.0000708,+54.0000000]P[+12.0000000,-0.0000090]T(I0)T(D270,S1)V
;T'200.00'T(A0)P[441.25,104.14]P[+0.0000708,+54.0000000]
;P[+12.0000000,-0.0000090]T(I0)T(D270,S1)V
;T'300.00'T(A0)P[529.50,104.14]P[+0.0000708,+54.0000000]
;P[+12.0000000,-0.0000090]T(I0)T(D270,S1)V T'400.00'T(A0)P[617.75,104.14]
;P[+0.0000708,+54.0000000]P[+12.0000000,-0.0000090]T(I0)T(D270,S1)V
;T'500.00'T(A0)P[397.13,172.97]P[-90.0000000,+0.0000506]
;P[-0.0000011,+24.0000038]T(I0)T(D360,S2)V T'TEST1 x 10'T(A0)P[+0.00,+0.00]
;P[+0.0000000,+0.0000000]T(I0)T(D360,S 1)VT'1'T(A0)P[+0.00,+0.00]\
;[1;1Heg. call axis(2.,2.,4HTEST,4,5.,-360.,0.,1000.)
;
;Draws an axis starting with X = 2.,Y = 2.,with the label TEST which
;has 4 characters in it. The axis is 5 inches long,and is rotated 0
;(360) degrees. Because of the negative sign,the numbers are perpendicular
;to the axis.  The axis is increment is 1000. which results in the use of
;exponents.
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])
;P[176.50,88.25]V[176.50,79.42]V[176.50,88.25]V[264.75,88.25]V[264.75,79.43]
;V[264.75,88.25]V[353.00,88.25]V[353.00,79.43]V[353.00,88.25]V[441.25,88.25]
;V[441.25,79.43]V[441.25,88.25]V[529.50,88.25]V[529.50,79.43]V[529.50,88.25]
;V[617.75,88.25]V[617.75,79.43]V[617.75,88.25]P[176.50,70.60]
;P[-18.0000000,-0.0000135]P[+0.0000000,+0.0000000]T(I0)T(D0,S1)V
;T'0.00'T(A0)P[264.75,70.60]P[-27.0000000,-0.0000202]P[+0.0000000,+0.0000000]
;T(I0)T(D0,S1)V T'100.00'T(A0)P[353.00,70.60]P[-27.0000000,-0.0000202]
;P[+0.0000000,+0.0000000]T(I0)T(D0,S1)V T'200.00'T(A0)P[441.25,70.60]
;P[-27.0000000,-0.0000202]P[+0.0000000,+0.0000000]T(I 0)T(D  0,S 1)V
;T'300.00'T(A0)P[529.50,70.60]P[-27.0000000,-0.0000202]P[+0.0000000,+0.000000]
;T(I 0)T(D  0,S 1)V
;T'400.00'T(A0)P[   617.75,    70.60]P[-     27.0000000,-      0.0000202]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D  0,S 1)V
;T'500.00'T(A0)P[   397.13,    45.89]P[-    135.0000000,-      0.0001011]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D  0,S 2)V
;T'NCH is negative'T(A0)P[   617.75,    88.25]V[   626.58,    88.25]
;V[   617.75,    88.25]V[   617.75,   191.21]V[   626.58,   191.21]
;V[   617.75,   191.21]V[   617.75,   294.17]V[   626.58,   294.17]
;V[   617.75,   294.17]V[   617.75,   397.13]V[   626.58,   397.13]
;V[   617.75,   397.13]P[   635.40,    88.25]
;P[-0.0000034,-4.5000000]P[+0.0000000,+      0.0000000]T(I 0)T(D 90,S 1)V
;T'0'
;T(A0)
;P[   635.40,   191.21]
;P[-      0.0000067,-      9.0000000]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D 90,S 1)V
;T'10'
;T(A0)
;P[   635.40,   294.17]
;P[-      0.0000067,-      9.0000000]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D 90,S 1)V
;T'20'
;T(A0)
;P[   635.40,   397.13]
;P[-      0.0000067,-      9.0000000]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D 90,S 1)V
;T'30'
;T(A0)
;P[   660.11,   242.69]
;P[-      0.0001213,-    162.0000000]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D 90,S 2)V
;T'AXLEN,NCH negative'
;T(A0)
;P[   176.50,   397.13]
;V[   176.50,   405.95]
;V[   176.50,   397.13]
;V[   264.75,   397.13]
;V[   264.75,   405.95]
;V[   264.75,   397.13]
;V[   353.00,   397.13]
;V[   353.00,   405.95]
;V[   353.00,   397.13]
;V[   441.25,   397.13]
;V[   441.25,   405.95]
;V[   441.25,   397.13]
;V[   529.50,   397.13]
;V[   529.50,   405.95]
;V[   529.50,   397.13]
;V[   617.75,   397.13]
;V[   617.75,   405.95]
;V[   617.75,   397.13]
;P[   176.50,   414.77]
;P[-     18.0000000,-      0.0000135]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'0.00'
;T(A0)
;P[   264.75,   414.77]
;P[-     22.5000000,-      0.0000169]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'10.00'
;T(A0)
;P[   353.00,   414.77]
;P[-     22.5000000,-      0.0000169]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'20.00'
;T(A0)
;P[   441.25,   414.77]
;P[-     22.5000000,-      0.0000169]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'30.00'
;T(A0)
;P[   529.50,   414.77]
;P[-     22.5000000,-      0.0000169]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'40.00'
;T(A0)
;P[   617.75,   414.77]
;P[-     22.5000000,-      0.0000169]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'50.00'
;T(A0)
;P[   397.13,   439.49]
;P[-    171.0000000,-      0.0001281]
;P[-      0.0000084,+     24.0000038]T(I 0)T(D  0,S 2)V
;T'All positive values'
;T(A0)
;P[   176.50,    88.25]
;V[   167.68,    88.25]
;V[   176.50,    88.25]
;V[   176.50,   191.21]
;V[   167.68,   191.21]
;V[   176.50,   191.21]
;V[   176.50,   294.17]
;V[   167.68,   294.17]
;V[   176.50,   294.17]
;V[   176.50,   397.13]
;V[   167.68,   397.13]
;V[   176.50,   397.13]
;P[   158.85,    81.63]
;P[-     36.0000000,-      0.0000270]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'0.00'
;T(A0)
;P[   158.85,   184.59]
;P[-     45.0000000,-      0.0000337]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'10.00'
;T(A0)
;P[   158.85,   287.55]
;P[-     45.0000000,-      0.0000337]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'20.00'
;T(A0)
;P[   158.85,   390.51]
;P[-     45.0000000,-      0.0000337]
;P[-      0.0000042,+     12.0000019]T(I 0)T(D  0,S 1)V
;T'30.00'
;T(A0)
;P[    91.78,   242.69]
;P[-      0.0001146,-    153.0000000]
;P[-     24.0000038,+      0.0000000]T(I 0)T(D 90,S 2)V
;T'ANGLE is negative'
;T(A0)
;\
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;				Other routines:
;
;CALL ARC6(RAD,BANG,ANG)
;
;  This subroutine draws an arc starting at the current beam position with an
;arc radius of RAD,the current position representing the beginning angle(BANG)
;in degrees from the positive X axis,and the arc sweeping for plus or minus ANG
;degrees.
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPpS(I0,E)S(A[0,479][799,0])P[264.75,264.75]
;C(A135.0000000C)[139.9455872,139.9457245]\
;[1;1Heg.call arc6(2.,45.,135.)
; This draws an arc at the current beam position,eg.2.,2. of radius 2.
;The starting position is defined to be the starting angle of 45 degrees
;and the arc is swept in the CCW direction for 135 degree.
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL CIRCLE(X,Y,RAD)
;
; This subroutine draws a circle centered at X,Y with a radius of RAD.
;
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;[0m[H[JPpS(I0,E)S(A[0,479][799,0])P[264.75,264.75]C[+88.2500000]\
;[1;1Heg.call circle(3.,3.,1.)
;will draw a circle centered at 3.,3. with a radius of 1 inch
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL CSLANT(ANGLE)
;
; This subroutine set the angle(ANGLE) in degrees which to slant the 
;characters,eg -45 degrees for Italics. Negative angles cause a forward
;slant,positive angles a negative slant. See p.5-175 VT-240 Programmer
;Reference manual.
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPpS(I0,E)S(A[0,479][799,0])P[-0.0000042,+24.0000000]
;T(I0)T(D0,S2)V T'CSLANT=0'T(A0)P[176.50,176.50]P[-0.0000042,+24.0000000]
;T(I-45)T(D0,S2)V T'CSLANT=-45'T(A0)\
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;
;CALL LGAXS(X,Y,LABEL,NCHARS,AXLEN,ANGLE,XMIN,DELTA)
; 
; This subroutine generates a logarithmic axis starting at X,Y with an axis
;label LABEL of NCHARS long. The axis will be AXLEN inches long,rotated
;ANGLE degrees. XMIN represents the minimum exponent shown on the axis
;and DELTA represents the number of decades on the axis.
;
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])W(P1)
;P[   176.50,   105.90]V[   176.50,    88.25]V[   211.92,    88.25]
;V[   211.92,    97.08]V[   211.92,    88.25]V[   232.64,    88.25]
;V[   232.64,    97.08]
;V[   232.64,    88.25]
;V[   247.34,    88.25]
;V[   247.34,    97.08]
;V[   247.34,    88.25]
;V[   258.75,    88.25]
;V[   258.75,    97.08]
;V[   258.75,    88.25]
;V[   268.06,    88.25]
;V[   268.06,    97.08]
;V[   268.06,    88.25]
;V[   275.94,    88.25]
;V[   275.94,    97.08]
;V[   275.94,    88.25]
;V[   282.76,    88.25]
;V[   282.76,    97.08]
;V[   282.76,    88.25]
;V[   288.78,    88.25]
;V[   288.78,    97.08]
;V[   288.78,    88.25]
;V[   294.17,    88.25]
;V[   294.17,   105.90]
;V[   294.17,    88.25]
;V[   329.59,    88.25]
;V[   329.59,    97.08]
;V[   329.59,    88.25]
;V[   350.31,    88.25]
;V[   350.31,    97.08]
;V[   350.31,    88.25]
;V[   365.01,    88.25]
;V[   365.01,    97.08]
;V[   365.01,    88.25]
;V[   376.41,    88.25]
;V[   376.41,    97.08]
;V[   376.41,    88.25]
;V[   385.73,    88.25]
;V[   385.73,    97.08]
;V[   385.73,    88.25]
;V[   393.61,    88.25]
;V[   393.61,    97.08]
;V[   393.61,    88.25]
;V[   400.43,    88.25]
;V[   400.43,    97.08]
;V[   400.43,    88.25]
;V[   406.45,    88.25]
;V[   406.45,    97.08]
;V[   406.45,    88.25]
;V[   411.83,    88.25]
;V[   411.83,   105.90]
;V[   411.83,    88.25]
;V[   447.25,    88.25]
;V[   447.25,    97.08]
;V[   447.25,    88.25]
;V[   467.97,    88.25]
;V[   467.97,    97.08]
;V[   467.97,    88.25]
;V[   482.68,    88.25]
;V[   482.68,    97.08]
;V[   482.68,    88.25]
;V[   494.08,    88.25]
;V[   494.08,    97.08]
;V[   494.08,    88.25]
;V[   503.40,    88.25]
;V[   503.40,    97.08]
;V[   503.40,    88.25]
;V[   511.27,    88.25]
;V[   511.27,    97.08]
;V[   511.27,    88.25]
;V[   518.10,    88.25]
;V[   518.10,    97.08]
;V[   518.10,    88.25]
;V[   524.12,    88.25]
;V[   524.12,    97.08]
;V[   524.12,    88.25]
;V[   529.50,    88.25]
;V[   529.50,   105.90]
;P[   165.91,    70.60]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   185.32,    75.01]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'0'
;T(A0)
;P[   283.58,    70.60]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   302.99,    75.01]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'1'
;T(A0)
;P[   401.24,    70.60]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   420.66,    75.01]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'2'
;T(A0)
;P[   518.91,    70.60]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   538.33,    75.01]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'3'
;T(A0)
;P[   353.00,    52.95]
;P[-     81.0000000,-      0.0000607]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D  0,S 2)V
;
;T'TEST NO.1'
;T(A0)
;P[   511.85,    88.25]
;V[   529.50,    88.25]
;V[   529.50,   134.74]
;V[   520.67,   134.74]
;V[   529.50,   134.74]
;V[   529.50,   161.94]
;V[   520.67,   161.94]
;V[   529.50,   161.94]
;V[   529.50,   181.23]
;V[   520.67,   181.23]
;V[   529.50,   181.23]
;V[   529.50,   196.20]
;V[   520.67,   196.20]
;V[   529.50,   196.20]
;V[   529.50,   208.43]
;V[   520.67,   208.43]
;V[   529.50,   208.43]
;V[   529.50,   218.76]
;V[   520.67,   218.76]
;V[   529.50,   218.76]
;V[   529.50,   227.72]
;V[   520.67,   227.72]
;V[   529.50,   227.72]
;V[   529.50,   235.62]
;V[   520.67,   235.62]
;V[   529.50,   235.62]
;V[   529.50,   242.69]
;V[   511.85,   242.69]
;V[   529.50,   242.69]
;V[   529.50,   289.18]
;V[   520.67,   289.18]
;V[   529.50,   289.18]
;V[   529.50,   316.37]
;V[   520.67,   316.37]
;V[   529.50,   316.37]
;V[   529.50,   335.67]
;V[   520.67,   335.67]
;V[   529.50,   335.67]
;V[   529.50,   350.63]
;V[   520.67,   350.63]
;V[   529.50,   350.63]
;V[   529.50,   362.86]
;V[   520.67,   362.86]
;V[   529.50,   362.86]
;V[   529.50,   373.20]
;V[   520.67,   373.20]
;V[   529.50,   373.20]
;V[   529.50,   382.16]
;V[   520.67,   382.16]
;V[   529.50,   382.16]
;V[   529.50,   390.06]
;V[   520.67,   390.06]
;V[   529.50,   390.06]
;V[   529.50,   397.13]
;V[   511.85,   397.13]
;P[   533.91,    82.07]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   553.33,    86.49]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'0'
;T(A0)
;P[   533.91,   236.51]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   553.33,   240.92]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'1'
;T(A0)
;P[   533.91,   390.95]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   553.33,   395.36]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'2'
;T(A0)
;P[   600.10,   242.69]
;P[-      0.0000607,-     81.0000000]
;P[+      0.0000000,+      0.0000000]T(I 0)T(D 90,S 2)V
;
;T'TEST NO.2'
;T(A0)
;P[   176.50,   379.48]
;V[   176.50,   397.13]
;V[   197.75,   397.13]
;V[   197.75,   388.30]
;V[   197.75,   397.13]
;V[   210.18,   397.13]
;V[   210.18,   388.30]
;V[   210.18,   397.13]
;V[   219.01,   397.13]
;V[   219.01,   388.30]
;V[   219.01,   397.13]
;V[   225.85,   397.13]
;V[   225.85,   388.30]
;V[   225.85,   397.13]
;V[   231.44,   397.13]
;V[   231.44,   388.30]
;V[   231.44,   397.13]
;V[   236.16,   397.13]
;V[   236.16,   388.30]
;V[   236.16,   397.13]
;V[   240.26,   397.13]
;V[   240.26,   388.30]
;V[   240.26,   397.13]
;V[   243.87,   397.13]
;V[   243.87,   388.30]
;V[   243.87,   397.13]
;V[   247.10,   397.13]
;V[   247.10,   379.48]
;V[   247.10,   397.13]
;V[   268.35,   397.13]
;V[   268.35,   388.30]
;V[   268.35,   397.13]
;V[   280.78,   397.13]
;V[   280.78,   388.30]
;V[   280.78,   397.13]
;V[   289.61,   397.13]
;V[   289.61,   388.30]
;V[   289.61,   397.13]
;V[   296.45,   397.13]
;V[   296.45,   388.30]
;V[   296.45,   397.13]
;V[   302.04,   397.13]
;V[   302.04,   388.30]
;V[   302.04,   397.13]
;V[   306.76,   397.13]
;V[   306.76,   388.30]
;V[   306.76,   397.13]
;V[   310.86,   397.13]
;V[   310.86,   388.30]
;V[   310.86,   397.13]
;V[   314.47,   397.13]
;V[   314.47,   388.30]
;V[   314.47,   397.13]
;V[   317.70,   397.13]
;V[   317.70,   379.48]
;V[   317.70,   397.13]
;V[   338.95,   397.13]
;V[   338.95,   388.30]
;V[   338.95,   397.13]
;V[   351.38,   397.13]
;V[   351.38,   388.30]
;V[   351.38,   397.13]
;V[   360.21,   397.13]
;V[   360.21,   388.30]
;V[   360.21,   397.13]
;V[   367.05,   397.13]
;V[   367.05,   388.30]
;V[   367.05,   397.13]
;V[   372.64,   397.13]
;V[   372.64,   388.30]
;V[   372.64,   397.13]
;V[   377.36,   397.13]
;V[   377.36,   388.30]
;V[   377.36,   397.13]
;V[   381.46,   397.13]
;V[   381.46,   388.30]
;V[   381.46,   397.13]
;V[   385.07,   397.13]
;V[   385.07,   388.30]
;V[   385.07,   397.13]
;V[   388.30,   397.13]
;V[   388.30,   379.48]
;V[   388.30,   397.13]
;V[   409.55,   397.13]
;V[   409.55,   388.30]
;V[   409.55,   397.13]
;V[   421.98,   397.13]
;V[   421.98,   388.30]
;V[   421.98,   397.13]
;V[   430.81,   397.13]
;V[   430.81,   388.30]
;V[   430.81,   397.13]
;V[   437.65,   397.13]
;V[   437.65,   388.30]
;V[   437.65,   397.13]
;V[   443.24,   397.13]
;V[   443.24,   388.30]
;V[   443.24,   397.13]
;V[   447.96,   397.13]
;V[   447.96,   388.30]
;V[   447.96,   397.13]
;V[   452.06,   397.13]
;V[   452.06,   388.30]
;V[   452.06,   397.13]
;V[   455.67,   397.13]
;V[   455.67,   388.30]
;V[   455.67,   397.13]
;V[   458.90,   397.13]
;V[   458.90,   379.48]
;V[   458.90,   397.13]
;V[   480.15,   397.13]
;V[   480.15,   388.30]
;V[   480.15,   397.13]
;V[   492.58,   397.13]
;V[   492.58,   388.30]
;V[   492.58,   397.13]
;V[   501.41,   397.13]
;V[   501.41,   388.30]
;V[   501.41,   397.13]
;V[   508.25,   397.13]
;V[   508.25,   388.30]
;V[   508.25,   397.13]
;V[   513.84,   397.13]
;V[   513.84,   388.30]
;V[   513.84,   397.13]
;V[   518.56,   397.13]
;V[   518.56,   388.30]
;V[   518.56,   397.13]
;V[   522.66,   397.13]
;V[   522.66,   388.30]
;V[   522.66,   397.13]
;V[   526.27,   397.13]
;V[   526.27,   388.30]
;V[   526.27,   397.13]
;V[   529.50,   397.13]
;V[   529.50,   379.48]
;P[   165.91,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   185.32,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'0'
;T(A0)
;P[   236.51,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   255.93,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'1'
;T(A0)
;P[   307.11,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   326.53,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'2'
;T(A0)
;P[   377.71,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   397.13,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'3'
;T(A0)
;P[   448.31,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   467.73,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'4'
;T(A0)
;P[   518.91,   402.42]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   538.33,   406.83]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'5'
;T(A0)
;P[   353.00,   432.43]
;P[-     81.0000000,-      0.0000607]
;P[-      0.0000084,+     24.0000038]T(I 0)T(D  0,S 2)V
;
;T'TEST NO.3'
;T(A0)
;P[   194.15,    88.25]
;V[   176.50,    88.25]
;V[   176.50,    99.87]
;V[   185.32,    99.87]
;V[   176.50,    99.87]
;V[   176.50,   106.67]
;V[   185.32,   106.67]
;V[   176.50,   106.67]
;V[   176.50,   111.50]
;V[   185.32,   111.50]
;V[   176.50,   111.50]
;V[   176.50,   115.24]
;V[   185.32,   115.24]
;V[   176.50,   115.24]
;V[   176.50,   118.29]
;V[   185.32,   118.29]
;V[   176.50,   118.29]
;V[   176.50,   120.88]
;V[   185.32,   120.88]
;V[   176.50,   120.88]
;V[   176.50,   123.12]
;V[   185.32,   123.12]
;V[   176.50,   123.12]
;V[   176.50,   125.09]
;V[   185.32,   125.09]
;V[   176.50,   125.09]
;V[   176.50,   126.86]
;V[   194.15,   126.86]
;V[   176.50,   126.86]
;V[   176.50,   138.48]
;V[   185.32,   138.48]
;V[   176.50,   138.48]
;V[   176.50,   145.28]
;V[   185.32,   145.28]
;V[   176.50,   145.28]
;V[   176.50,   150.10]
;V[   185.32,   150.10]
;V[   176.50,   150.10]
;V[   176.50,   153.85]
;V[   185.32,   153.85]
;V[   176.50,   153.85]
;V[   176.50,   156.90]
;V[   185.32,   156.90]
;V[   176.50,   156.90]
;V[   176.50,   159.49]
;V[   185.32,   159.49]
;V[   176.50,   159.49]
;V[   176.50,   161.73]
;V[   185.32,   161.73]
;V[   176.50,   161.73]
;V[   176.50,   163.70]
;V[   185.32,   163.70]
;V[   176.50,   163.70]
;V[   176.50,   165.47]
;V[   194.15,   165.47]
;V[   176.50,   165.47]
;V[   176.50,   177.09]
;V[   185.32,   177.09]
;V[   176.50,   177.09]
;V[   176.50,   183.89]
;V[   185.32,   183.89]
;V[   176.50,   183.89]
;V[   176.50,   188.71]
;V[   185.32,   188.71]
;V[   176.50,   188.71]
;V[   176.50,   192.46]
;V[   185.32,   192.46]
;V[   176.50,   192.46]
;V[   176.50,   195.51]
;V[   185.32,   195.51]
;V[   176.50,   195.51]
;V[   176.50,   198.10]
;V[   185.32,   198.10]
;V[   176.50,   198.10]
;V[   176.50,   200.34]
;V[   185.32,   200.34]
;V[   176.50,   200.34]
;V[   176.50,   202.31]
;V[   185.32,   202.31]
;V[   176.50,   202.31]
;V[   176.50,   204.08]
;V[   194.15,   204.08]
;V[   176.50,   204.08]
;V[   176.50,   215.70]
;V[   185.32,   215.70]
;V[   176.50,   215.70]
;V[   176.50,   222.50]
;V[   185.32,   222.50]
;V[   176.50,   222.50]
;V[   176.50,   227.32]
;V[   185.32,   227.32]
;V[   176.50,   227.32]
;V[   176.50,   231.06]
;V[   185.32,   231.06]
;V[   176.50,   231.06]
;V[   176.50,   234.12]
;V[   185.32,   234.12]
;V[   176.50,   234.12]
;V[   176.50,   236.71]
;V[   185.32,   236.71]
;V[   176.50,   236.71]
;V[   176.50,   238.95]
;V[   185.32,   238.95]
;V[   176.50,   238.95]
;V[   176.50,   240.92]
;V[   185.32,   240.92]
;V[   176.50,   240.92]
;V[   176.50,   242.69]
;V[   194.15,   242.69]
;V[   176.50,   242.69]
;V[   176.50,   254.31]
;V[   185.32,   254.31]
;V[   176.50,   254.31]
;V[   176.50,   261.11]
;V[   185.32,   261.11]
;V[   176.50,   261.11]
;V[   176.50,   265.93]
;V[   185.32,   265.93]
;V[   176.50,   265.93]
;V[   176.50,   269.67]
;V[   185.32,   269.67]
;V[   176.50,   269.67]
;V[   176.50,   272.73]
;V[   185.32,   272.73]
;V[   176.50,   272.73]
;V[   176.50,   275.32]
;V[   185.32,   275.32]
;V[   176.50,   275.32]
;V[   176.50,   277.56]
;V[   185.32,   277.56]
;V[   176.50,   277.56]
;V[   176.50,   279.53]
;V[   185.32,   279.53]
;V[   176.50,   279.53]
;V[   176.50,   281.30]
;V[   194.15,   281.30]
;V[   176.50,   281.30]
;V[   176.50,   292.92]
;V[   185.32,   292.92]
;V[   176.50,   292.92]
;V[   176.50,   299.72]
;V[   185.32,   299.72]
;V[   176.50,   299.72]
;V[   176.50,   304.54]
;V[   185.32,   304.54]
;V[   176.50,   304.54]
;V[   176.50,   308.28]
;V[   185.32,   308.28]
;V[   176.50,   308.28]
;V[   176.50,   311.34]
;V[   185.32,   311.34]
;V[   176.50,   311.34]
;V[   176.50,   313.93]
;V[   185.32,   313.93]
;V[   176.50,   313.93]
;V[   176.50,   316.16]
;V[   185.32,   316.16]
;V[   176.50,   316.16]
;V[   176.50,   318.14]
;V[   185.32,   318.14]
;V[   176.50,   318.14]
;V[   176.50,   319.91]
;V[   194.15,   319.91]
;V[   176.50,   319.91]
;V[   176.50,   331.53]
;V[   185.32,   331.53]
;V[   176.50,   331.53]
;V[   176.50,   338.33]
;V[   185.32,   338.33]
;V[   176.50,   338.33]
;V[   176.50,   343.15]
;V[   185.32,   343.15]
;V[   176.50,   343.15]
;V[   176.50,   346.89]
;V[   185.32,   346.89]
;V[   176.50,   346.89]
;V[   176.50,   349.95]
;V[   185.32,   349.95]
;V[   176.50,   349.95]
;V[   176.50,   352.53]
;V[   185.32,   352.53]
;V[   176.50,   352.53]
;V[   176.50,   354.77]
;V[   185.32,   354.77]
;V[   176.50,   354.77]
;V[   176.50,   356.75]
;V[   185.32,   356.75]
;V[   176.50,   356.75]
;V[   176.50,   358.52]
;V[   194.15,   358.52]
;V[   176.50,   358.52]
;V[   176.50,   370.14]
;V[   185.32,   370.14]
;V[   176.50,   370.14]
;V[   176.50,   376.94]
;V[   185.32,   376.94]
;V[   176.50,   376.94]
;V[   176.50,   381.76]
;V[   185.32,   381.76]
;V[   176.50,   381.76]
;V[   176.50,   385.50]
;V[   185.32,   385.50]
;V[   176.50,   385.50]
;V[   176.50,   388.56]
;V[   185.32,   388.56]
;V[   176.50,   388.56]
;V[   176.50,   391.14]
;V[   185.32,   391.14]
;V[   176.50,   391.14]
;V[   176.50,   393.38]
;V[   185.32,   393.38]
;V[   176.50,   393.38]
;V[   176.50,   395.36]
;V[   185.32,   395.36]
;V[   176.50,   395.36]
;V[   176.50,   397.13]
;V[   194.15,   397.13]
;P[   119.14,    82.07]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,    86.49]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-100'
;T(A0)
;P[   119.14,   120.68]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   125.09]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;T'-99'
;T(A0)
;P[   119.14,   159.29]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   163.70]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-98'
;T(A0)
;P[   119.14,   197.90]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   202.31]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-97'
;T(A0)
;P[   119.14,   236.51]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   240.92]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-96'
;T(A0)
;P[   119.14,   275.12]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   279.53]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-95'
;T(A0)
;P[   119.14,   313.73]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   318.14]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-94'
;T(A0)
;P[   119.14,   352.34]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   356.75]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-93'
;T(A0)
;P[   119.14,   390.95]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'10'
;T(A0)
;P[   138.55,   395.36]
;P[-      0.0000021,+     12.0000000]T(I 0)T(D  0,S 1)V
;
;T'-92'
;T(A0)
;P[    70.60,   242.69]
;P[-      0.0000607,-     81.0000000]
;P[-     24.0000038,+      0.0000000]T(I 0)T(D 90,S 2)V
;
;T'TEST NO.4'
;T(A0)
;\
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL LINTYP(ILINE)
;
;  This subroutine sets the line type pattern (solid,dotted,dashed,etc.)where
;line has a range of 0-8,0 being the default solid line type.
;
.asks ok [23;29H[1mHit return to continue[0m
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])W(P1)
;P[   176.50,    44.13]P[-0.0000042,+24.0000000]T(I 0)T(D  0,S 2)V
;T'0'T(A0)P[   353.00,    44.13]V[   441.25,    44.13]W(P2)
;P[   176.50,    88.25]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'1'T(A0)P[   353.00,    88.25]V[   441.25,    88.25]W(P3)
;P[   176.50,   132.38]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'2'T(A0)P[   353.00,   132.38]V[   441.25,   132.38]W(P4)
;P[   176.50,   176.50]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'3'T(A0)P[   353.00,   176.50]V[   441.25,   176.50]W(P5)
;P[   176.50,   220.63]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'4'T(A0)P[   353.00,   220.63]V[   441.25,   220.63]W(P6)
;P[   176.50,   264.75]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'5'T(A0)P[   353.00,   264.75]V[   441.25,   264.75]W(P7)
;P[   176.50,   308.88]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'6'T(A0)P[   353.00,   308.88]V[   441.25,   308.88]W(P8)
;P[   176.50,   353.00]P[-      0.0000042,+     24.0000000]T(I 0)T(D  0,S 2)V
;T'7'T(A0)P[   353.00,   353.00]V[   441.25,   353.00]\
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL OFFSET(XOFF,XFCT,YOFF,YFCT)
;
;  This subroutine sets a plotting offset when subroutine PLOT is used,
;where XOFF and YOFF are the offsets to be subtracted from X and Y
;and XFCT and YFCT are the scale factors used to divide X and Y.
;
;CALL PENDN 
; This subroutine turns the beam on.
;
;CALL PENUP
; 
; This subroutine turns the beam off.
;
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL RECTS(X,Y,XW,YH)
;
; This subroutine generates a rectangle at X,Y XW inches wide and YH inches 
;high. 
;
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;[0m[H[JPp S(I0,E)  S(A[0,479][799,0])W(P1)
;P[   176.50,    88.25]V[   353.00,    88.25]V[   353.00,   264.75]
;V[   176.50,   264.75]V[   176.50,    88.25]P[   441.25,    88.25]
;V[   529.50,    88.25]V[   529.50,   441.25]V[   441.25,   441.25]
;V[   441.25,    88.25]\
.asks ok [23;29H[1mHit return to continue[0m
;[H[J
;CALL SCALG(ARRAY,AXLEN,NPTS,INC)
;
; This subroutine is used for transforming and scaling linear data into
;a base 10 array in conjunction with the LGAXS subroutine.
;ARRAY is the linear data array to be scaled and transformed into its base10
;equivalent, AXLEN in the axis length in inches,NPTS is the number of points in
;the array, and INC represents the index used to access the array (usually 1).
;The main program should DIMENSION ARRAY(NPTS+2) ie,2 larger than the number
;of points in that SCALG returns the minimum exponent into ARRAY(NPTS+1)
;and the number of decades into ARRAY(NPTS+2).
;
;CALL SPMODE(IMODE)
;
; This subroutine sets relative(IMODE=1) or absolute coordinate addressing
;(IMODE=0,default). Relative addressing is relative to the last defined beam
;position.
;
.stop
                                            