PASLIB.MAC
	.TITLE	PASLIB	-- RUN TIME SUPPORT
	.IDENT	/791112/
	.GLOBL	P$FPAD
	.MCALL	.TTYOUT,.PRINT,.EXIT,.READW,.WRITW,.CLOSE,.TTYIN
	.MCALL	.LOOKUP,.ENTER,.FETCH,.DSTATUS,.CSISPC,.SETTOP
;
;	PASCAL RUN-TIME SUPPORT
;	FILE SUPPORT AND INITIALIZATION
;
;	FOLLOWING SWITCH DETERMINES IF COMMAND LINE
;	PROCESSING IS TO BE DONE.
;	CMDLNE=0
;
;
	.PSECT  PASPAS,RW,GBL,OVR
PASPAS::
FILVAR:	.WORD	0		;CURRENT FILE VARIABLE
OUTPUT:	.WORD	.+BUFFER	;OUTPUT FILE BLOCK
	.BYTE	1		;EOF FLAG SET
	.BYTE	ISTTY+OUT	;TYPE OF FILE
	.WORD	1		;MAXSIZ IS 1 BYTE
	.WORD	5		;LOGICAL UNIT
	.WORD	0		;NO VALID DATA
	.BLKB	512.		;BUFFER AREA
INPUT:	.WORD	.+BUFFER	;INPUT FILE BLOCK
	.BYTE	0		;EOF FLAG NOT SET
	.BYTE	ISTTY+IN	;TYPE OF FILE
	.WORD	1		;MAXSIZ IS 1 BYTE
	.WORD	5		;LOGICAL UNIT
	.WORD	0		;NO VALID DATA
	.BLKB	512.		;BUFFER AREA
;
.PAGE
;
	.PSECT
;
; PASCAL FILE BLOCK DEFINITION
;
; FILE BLOCK CONSISTS OF:
; PASCAL HEADER:
;	BUFVAR -	POINTER TO CURRENT I/O VARIABLE
;	FLAGS/EOFF -	FILE TYPE FLAGS AND EOF FLAGS
;	MAXSIZ -	SIZE OF FILE VARIABLE
;	CHAN -		CHANNEL NUMBER OF THIS FILE
;	VALID -		NUMBER OF VALID BYTES IN BUFFER
; 512. BYTE BUFFER
;
BUFVAR	=0
EOFF	==2
	EOF	==1	;END OF FILE BIT
	DIRTY	=2	;BUFFER HAS BEEN CHANGED BIT
FLAGS	==3
	IN	=1	;OPEN FOR IN FLAG
	OUT	=2	;OPEN FOR OUT FLAG
	ISTTY	==4	;FILE IS TTY FLAG
	TEXT	==8.	;FILE IS A TEXT FILE
MAXSIZ	=4
CHAN	=6
VALID	=8.
BUFFER	=10.
BUFSIZ	=512.
FILSIZ	=BUFFER+BUFSIZ
;
;
;RT-11 SYSTEM COMMUNICATION AREA ADDRESSES
;
SRTJOB=	40	;START ADDRESS OF JOB
STKINT=	42	;INITIAL VALUE OF STACK POINTER
JSW=	44	;JOB STATUS WORD
USRLAD=	46	;USR LOAD ADDRESS
HGHMEM=	50	;HIGH MEMORY ADDRESS
ERRBYT=	52	;EMT ERROR CODE
USERRB=	53	;USER PROGRAM ERROR CODE
MONADR=	54	;BEGINNING OF RESIDENT MONITOR
	.PAGE
	.SBTTL	$$$000 - INIT
; INIT - INITIALIZE HEAP AND USERS CONSOLE
; PARMS
; REGISTER USAGE
;	R0 -> HEAP, SCRATCH
;	R1 - SCRATCH
;	R2 - SCRATCH
;	R3 -> (OUT,IN) FILE BLOCKS
;	R4 - SCRATCH
;	R5 - SCRATCH
; CALLS: P$FINT
;
$$$000::
	MOV	(SP)+,R4	;POP RETURN ADDRESS INTO R4
	.IF DF CMDLNE
	CLR	R2
	MOV	#STRING,R1
	MOV	#'*,R0
	.TTYOUT
; FIRST STRING WILL ALWAYS BE NULL SINCE RSX-11 VERSIONS
; USE IT TO INDICATE WHICH TASK IS RUNNING
	CLR	-(SP)		;NULL POINTER TO FIRST STRING
	INC	R2		;COUNT NULL STRING
1$:	MOV	R1,R3		;MARK BEGINNING OF STRING
2$:	.TTYIN			;GET A CHARACTER
	CMPB	R0,#15
	BEQ	4$
	CMPB	#' ,R0
	BEQ	3$
	MOVB	R0,(R1)+
	BR	2$
3$:	CMP	R1,R3		;ANYTHING ENTERED?
	BEQ	2$		;NO, KEEP LOOKING
	MOV	R3,-(SP)	;PUSH POINTER ON STACK
	CLRB	(R1)+		;PUT A ZERO BYTE ON END OF STRING
	INC	R2		;INCREASE COUNT
	BR	1$		;GET ANOTHER STRING
4$:	CMP	R1,R3		;ANYTHING ENTERED?
	BEQ	5$		;NO, DON'T COUNT
	CLRB	(R1)+		;TERMINATE STRING WITH ZERO BYTE
	INC	R2		;INCREASE COUNT
5$:	.TTYIN			;FLUSH INPUT OFLINE FEED
	MOV	R3,-(SP)	;PUSH LAST POINTER ON STACK
	MOV	R2,R0		;COUNT OF ARGUMENTS
	DEC	R0
	ASL	R0
	MOV	SP,R1
	ADD	R0,R1		;POINTER TO FIRST ARGUMENT
	MOV	R2,R0
	ASR	R0		;NUMBER OF POINTERS TO CHANGE
	MOV	SP,R3		;POINTER TO LAST ARGUMENT
6$:	MOV	(R3),R5		;SWAP FIRST AND LST
	MOV	(R1),(R3)	;;
	MOV	R5,(R1)		;;
	TST	(R3)+
	TST	-(R1)
	SOB	R0,6$
	MOV	SP,R1		;SAVE SP
	MOV	R2,-(SP)	;PUSH COUNT ON STACK
	MOV	R1,-(SP)	;PUSH POINTER ON STACK
	.IFF
	CLR	-(SP)		;ZERO ARGUMENTS ENTERED
	CLR	-(SP)		;POINTER TO NUL STRINGS
	.ENDC
	CLR	-(SP)		;BUILD DUMMY STACK FRAME
	CLR	-(SP)		;;
	CLR	-(SP)		;;
	MOV	SP,R5		;LEVEL ZERO STACK FRAME
; INITIALIZE HEAP
	MOV	@#HGHMEM,R1	;GET ADDRESS OF END OF PROG
	TST	(R1)+		;MAKE IT POINT TO PREV
	.SETTOP  R1
	CLR	(R1)		;MAKE PREV = ZERO
	MOV	R1,CURHP	;MAKE CURHP POINT TO PREV
	MOV	@#MONADR,MTOP	;CURRENT TOP OF MEMORY
; RETURN
	JMP	(R4)
.PAGE
	.SBTTL	$$$001 - EXIT
; EXIT - RETURN TO MONITOR
; PARMS
;	R5 -> GLOBALS
; REGISTER USAGE
;	R0,R1,R2,R3,R4 - NOT USED
;
$$$001::
	MOV	#OUTPUT,R1
	JSR	PC,P$FCLO	;FLUSH STANDARD OUTPUT AND CLOSE IT
	.SETTOP	#0		;FREE SPACE TO SAVE TIME
; EXIT TO MONITOR
	.EXIT
.PAGE
	.SBTTL	$$$004 - NEW
; GET A BLOCK FROM THE HEAP
; PARMS
;	1. POINTER TO CURRENT HEAP
;	2. SIZE REQUESTED (IN BYTES, WILL BE ROUNDED UP TO MULTIPLE OF FOUR)
; REGISTER USAGE
;	R0 = SIZE
;	R1 -> CURRENT HEAP
;	R2,R3,R4 - NOT USED
;
$$$004::
	MOV	@#HGHMEM,R0	;GET END OF HEAP
	TST	(R0)+		;SET TO NEXT FREE WORD
	MOV	R0,R1		;SAVE VALUE
	INC	2(SP)		;ROUND UP SIZE TO
	BIC	#1,2(SP)	;...A MULTIPLE OF TWO
	BLE	HERR		;VALID REQUEST?
	ADD	2(SP),R1	;FIND NEW END
	CLR	2(SP)		;CLEAR RETURN (FAKE ERROR)
	CMP	R1,MTOP		;SEE IF THERE'S ROOM
	BHIS	HERR		;NO ROOM PRINT ERROR
	MOV	R0,2(SP)	;RETURN ADDRESS (FIX FAKE ERROR)
	.SETTOP  R1
	CMP	R0,R1		;DID WE GET THE SPACE?
	BEQ	1$		;YES, PROCEED
	CLR	2(SP)		;NO, CLEAR RETURN VALUE
	BR	HERR		;REPORT THE ERROR
1$:	MOV	2(SP),R0	;START OF ALLOCATED HEAP SPACE
2$:	CLR	(R0)+		;ZERO IT OUT
	CMP	R0,R1		;DONE?
	BLE	2$		;NO, CONTINUE
	RTS	PC

HERR:	.PRINT #HERR0
	RTS	PC
HERR0:	.ASCIZ /?HEAP REQUEST OR OVERFLOW ERROR/
	.EVEN

.PAGE
	.SBTTL	$$$006 - MARK
; MARK THE HEAP
; PARMS
;	1. POINTER TO POINTER TO CURRENT HEAP
; REGISTER USAGE
;	R0 - SCRATCH
;	R1 -> CURRENT HEAP POINTER
;	R2,R3,R4 - NOT USED
;
$$$006::
	MOV	#2,-(SP)	;SIZE OF TWO
	JSR	PC,$$$004	;GET THE TWO BYTES FOR PREV
	MOV	(SP)+,R0	;GET ADDRESS OR ZERO(MEANS ERROR)
	BEQ	DONE		;ERROR
	MOV	CURHP,(R0)	;SET PREV
	MOV	R0,CURHP	;SET NEW CURHP
DONE:	RTS	PC

.PAGE
	.SBTTL	$$$007 - RELEASE
; CUT BACK HEAP TO LAST MARK
; PARMS
;	1. POINTER TO POINTER TO CURRENT HEAP
; REGISTER USAGE
;	R0 - NOT USED
;	R1 -> CURRENT/DISCARDED HEAP HEADER
;	R2,R3,R4 - NOT USED
;
$$$007::
	MOV	CURHP,R1	;GET PREV VALUE
	BEQ	RERR		;NO PREV
	MOV	(R1),CURHP	;MOVE OLD PREV TO CURHP
	TST	-(R1)		;BACKUP TO LAST WORD USED
	.SETTOP  R1
	RTS	PC

RERR:
	.PRINT #RERR0
	RTS	PC
RERR0:	.ASCIZ /?NO PREVIOUS HEAP/
	.EVEN

.PAGE
	.SBTTL	$$$016 - FILE BLOCK INIT
; FILE BLOCK INITIALIZATION
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. MAXIMUM SIZE OF BUFFER VARIABLE (BYTES)
; REGISTER USAGE
;	R0 = SCRATCH
;	R1 -> FILE VARIABLE
$$$016::
	MOV	4(SP),R1	;GET FIRST PARM
	MOV	(SP)+,2(SP)	;MOVE DOWN RETURN ADDRESS
;
	MOV	R1,R0
	MOV	R1,(R0)
	ADD	#BUFFER,(R0)+	;@BUFVAR
	MOV	#1,(R0)+	;EOF=TRUE
	MOV	(SP)+,(R0)+	;BUFVAR SIZE
	CLR	(R0)+		;CHAN
	CLR	(R0)+		;VALID
	CLR	(R0)		;CLEAR FIRST WORD IN BUFFER
	RTS	PC
.PAGE
	.SBTTL	$$$017 - OPEN_A_FILE
; PARMS:
;	1. POINTER TO PASCAL FILE BLOCK
;	2. POINTER TO ASCII STRING CONTAINING FILE NAME
;	3. FILE ATTRIBUTES
;	4. MODE 0=READ, 1=WRITE, 2=UPDATE
;
; REGISTER USAGE
;	R0 -> FILE BLOCK
;	R1 - SCRATCH
;	R2,R3 - SCRATCH (SAVED AND RESTORED)
;
MODES:	.BYTE	IN,OUT,IN+OUT
	.EVEN
;
$$$017::
	MOV	10(SP),R1	;GET FIRST PARM
	MOV	(SP)+,6(SP)	;MOVE DOWN RETURN ADDRESS
	MOV	(SP)+,R0	;GET FOURTH PARM
	MOVB	MODES(R0),R0	;INPUT/OUTPUT MODE
	ASL	(SP)
	ASL	(SP)
	BISB	(SP)+,R0	;GET THIRD PARAMETER
	MOV	R3,-(SP)
	MOV	2(SP),R3	;GET SECOND PARM
	MOV	R2,2(SP)
;
	TSTB	FLAGS(R1)	;ALREADY OPENED?
	BEQ	5$
	MOV	R0,-(SP)	;SAVE FLAGS WORD
	JSR	PC,P$FCLO	;YES, CLOSE IT.
	MOV	(SP)+,R0	;RESTORE FLAGS WORD
;
5$:	MOVB	R0,FLAGS(R1)
	MOV	#FILNAM,R2	;FILE NAME BUFFER
6$:	MOVB	(R3)+,(R2)+	;TRANSFER USER NAME TO BUFFER
	BNE	6$		;UNTIL ZERO BYTE FOUND
	MOV	#INNAM,R3	;LOCATION OF INPUT FILE NAME
	BITB	FLAGS(R1),#IN	;INPUT FILE?
	BNE	4$		;YES, SKIP EQUALS SIGN
	MOVB	#'=,-1(R2)	;PUT IN EQUALS SIGN FOR OUTPUT FILES
	MOV	#OTNAM,R3	;LOCATION OF OUTPUT FILE NAME
	CLRB	(R2)		;PLACE ZERO BYTE AT END
4$:	.CSISPC #OUTSPC,#DEF,#FILNAM
	TST	(SP)+		;POP SWITCH COUNT OFF
9$:	CMP	#100040,(R3)	;TT:?
	BEQ	TTOPN
	.DSTATUS #STATUS,R3
	BCS	ERR000
	TST	STATUS+4
	BNE	1$		;IS HANDLER LOADED?
	MOV	@#HGHMEM,R2
	SUB	STATUS+2,R2
	.FETCH	R2,R3
	BCS	ERR000
	MOV	R2,MTOP		;NEW TOP OF MEMORY
1$:	CLR	R2
2$:	TSTB	CHANLS(R2)	;FREE CHANNEL?
	BEQ	3$
	INC	R2
	CMP	R2,#15.		;ALL CHANNELS TRIED?
	BLE	2$
	.PRINT	#NOCHAN
	BR	EXT017
3$:	COMB	CHANLS(R2)	;FLAG CHANNEL AS USED
	MOV	R2,R3
	ASL	R3
	MOV	R2,CHAN(R1)
	BITB	FLAGS(R1),#IN
	BNE	7$
	.ENTER	#AREA,R2,#OTNAM,OTNAM+10
	BCS	ERR000
	CLRB	EOFF(R1)	;SET EOF TO FALSE
	CLR	BLOCK(R3)	;WRITING TO BLOCK ZERO
	MOV	#512.,VALID(R1)	;SPACE FOR 512. BYTES
	BR	EXT017
7$:	.LOOKUP	#AREA,R2,#INNAM
	BCS	ERR000
	CLRB	EOFF(R1)	;SET EOF TO FALSE
	MOV	#-1,BLOCK(R3)	;INITIALIZE BLOCK NUMBER
	JSR	PC,P$FFST	;FILL THE BUFFER
EXT017:	MOV	(SP)+,R3
	MOV	(SP)+,R2
	RTS	PC
TTOPN:	BISB	#ISTTY+TEXT,FLAGS(R1)
	BR	EXT017
ERR000:	.PRINT	#ERR0
	BR	EXT017
NOCHAN:	.ASCIZ "?NO CHANNELS AVAILABLE."
ERR0:	.ASCIZ "?ERROR WHILE OPENING A FILE."
	.EVEN
;
.PAGE
	.SBTTL	$$$018 - SEEK
; PARMS:
;	1. FILE BLOCK
;	2. RECORD TO SEEK
; REGISTER USAGE:
;	R0 - SCRATCH
;	R1 - FILE BLOCK POINTER
;	R2,R3,R4 - SCRATCH (SAVED/RSTORED)
;
$$$018::;SEEK(@FILVAR,RECORDNUMBER)
	MOV	4(SP),R1	;FILE BLOCK POINTER
	MOV	(SP)+,2(SP)	;MOVE DOWN RETURN
	MOV	(SP)+,R0	;RECORD NUMBER
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	R4,-(SP)	;SAVE R4
	CLR	R2		;EVENTUAL BLOCK NUMBER
	DEC	R0		;START BLOCK NUMBER FROM ZERO
	BEQ	1$		;FIRST RECORD
	MOV	#512.,R3	;NUMBER OF BYTES PER BLOCK
	DIV	MAXSIZ(R1),R2	;R2 = NUMBER OF RECORDS PER BLOCK
	MOV	R0,R3		;DESIRED RECORD
	MOV	R2,R0		;NUMBER OF RECORDS PER BLOCK
	CLR	R2
	DIV	R0,R2		;R2 = BLOCK NUMBER
				;R3 = RECORD IN BLOCK
	MUL	MAXSIZ(R1),R3	;R3 = POSITION OF RECORD IN BLOCK
	BR	2$
1$:	CLR	R3		;FIRST RECORD STARTS AT ZERO
2$:	MOV	CHAN(R1),R4	;CHANNEL NUMBER THIS FILE
	ASL	R4		;BLOCK INDEX
	CMP	BLOCK(R4),R2	;IS IT CURRENT BLOCK?
	BEQ	6$		;YES, SKIP WRITE/READ
	MOV	R1,(R1)		;RESET BUFFER POINTER
	ADD	#BUFFER,(R1)	;TO START OF BLOCK
	BITB	#DIRTY,EOFF(R1)	;CURRENT BLOCK DIRTY?
	BEQ	4$		;NO, SKIP WRITE
	.WRITW	#AREA,CHAN(R1),(R1),#256.,BLOCK(R4)
	BCC	4$
	.PRINT	#SWERR		;ERROR ON SEEK WRITE
4$:	MOV	R2,BLOCK(R4)	;NEW BLOCK NUMBER
	.READW	#AREA,CHAN(R1),(R1),#256.,R2
	BCC	5$
	.PRINT	#SRERR		;ERROR ON SEEK READ
5$:	BICB	#DIRTY,EOFF(R1)	;NEW BLOCK NOT DIRTY YET
6$:	BISB	#IN+OUT,FLAGS(R1);SET UPDATE MODE THIS FILE
	MOV	#512.,VALID(R1)	;CALCULATE REMAINING VALID BUFFER AREA
	SUB	R3,VALID(R1)	;;
	ADD	R1,R3		;CALCULATE RECORD POINTER
	ADD	#BUFFER,R3	;;
	MOV	R3,(R1)		;CURRENT RECORD POINTER
	MOV	(SP)+,R4	;RESTORE R4
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	RTS	PC
;
SWERR:	.ASCIZ	/?ERROR ON SEEK WRITE/
SRERR:	.ASCIZ	/?ERROR ON SEEK READ/
	.EVEN
.PAGE
	.SBTTL	$$$020 - CLOSE
; PARMS:
;	1. FILE BLOCK
; REGISTER USAGE
;	R0 - SCRATCH
;	R1 -> FILE BLOCK
;	R2,R3,R4 - NOT USED
; CALLS: P$FBRK
;
$$$020::
	MOV	2(SP),R1	;GET FILE POINTER
	MOV	(SP)+,(SP)	;PUSH DOWN RETURN ADDRESS
;
P$FCLO:	TSTB	FLAGS(R1)	;WAS FILE OPEN?
	BEQ	1$		;IF NOT, SKIP ALL OF THIS
	JSR	PC,P$FBRK	;YES, DUMP FINAL BUFFER(IF OUTPUT)
;
	BITB	#ISTTY,FLAGS(R1);IS IT A TTY??
	BNE	10$		;YES, CLEAR TTY FLAGS
	.CLOSE	CHAN(R1)	;CLOSE CHANNEL FOR THIS FILE POINTER
	MOV	CHAN(R1),R0	;CHANNEL NUMBER
	CLRB	CHANLS(R0)	;CLEAR CHANNEL TABLE ENTRY
	ASL	R0
	CLR	BLOCK(R0)	;CLEAR BLOCK COUNT
;
10$:	CLRB	FLAGS(R1)	;CLOSE TTY FILE
1$:	RTS	PC
.PAGE
	.SBTTL	$$$021 - GET
; PARMS
;	1. FILE BLOCK
;	2. SIZE OF LAST BUFFER VARIABLE
; REGISTER USAGE
;	R0 - SCRATCH
;	R1 -> FILE BLOCK
;	R2,R3 - SCRATCH
;	R4 - NOT USED
; CALLS: P$FNXT
;
$$$021::
	MOV	4(SP),R1	;FILE BLOCK POINTER
	MOV	(SP)+,2(SP)	;MOVE DOWN RETURN
	MOV	(SP)+,R0	;SIZE OF LAST VARIABLE
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
;
	BITB	#EOF,EOFF(R1)	;PASCAL EOF SET
	BNE	ERR001		;IT MUST NOT BE
	ADD	R0,(R1)		;BUMP BUFFER VARIABLE POINTER
	SUB	R0,VALID(R1)	;REDUCE SIZE OF REMAINING DATA
	CMP	VALID(R1),MAXSIZ(R1) ;IS THERE ENOUGH DATA FOR THIS
	BGE	EXT021		;...BUFFER VARIABLE
	MOV	R1,R0
	ADD	#BUFFER,R0	;R1 -> START OF BUFFER
	MOV	R0,(R1)		;NEW BUFFER VARIABLE POINTER
;
2$:	JSR	PC,P$FNXT	;GET NEXT BUFFERFULL
	BR	EXT021		;...AND RETURN
;
;
ERR001:	.PRINT	#ERR3
EXT021:	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	RTS	PC
ERR3:	.ASCIZ "?END OF FILE ENCOUNTERED WHILE DOING A GET."
	.EVEN
.PAGE
; SUBROUTINE TO GET (FIRST) NEXT BUFFERFULL
; EXPECTS
;	 R1 -> FILE BLOCK
; REGISTER USAGE
;	R0,R2,R3 - SCRATCH
;	R1 -> FILE BLOCK
;	R4 - NOT USED
;
P$FFST:
	MOV	R1,R0		;FILE POINTER
	ADD	#BUFFER,R0	;R0 -> START IF BUFFER
	MOV	R0,(R1)		;NEW BUFFER VARIABLE POINTER
P$FNXT:	BITB	#IN,FLAGS(R1)	;OPENED FOR INPUT?
	BEQ	GES01		;IF NOT, SKIP ALL OF THIS
	BITB	#ISTTY,FLAGS(R1);TERMINAL????
	BNE	GESTRM
	MOV	CHAN(R1),R2	;CHANNEL NUMBER
	ASL	R2		;CONVERTED TO WORD INDEX
	BITB	#OUT,FLAGS(R1)	;UPDATE MODE?
	BEQ	1$		;NO, SKIP BLOCK WRITE
	BITB	#DIRTY,EOFF(R1)	;IS BUFFER DIRTY?
	BEQ	1$		;NO, SKIP BLOCK WRITE
	MOV	R1,R3		;COMPUTE BUFFER START ADDRESS
	ADD	#BUFFER,R3	;;
	.WRITW	#AREA,CHAN(R1),R3,#256.,BLOCK(R2)
1$:	INC	BLOCK(R2)	;INCREMENT TO NEXT BLOCK
	.READW	#AREA,CHAN(R1),(R1),#256.,BLOCK(R2)
	BCS	GES3		;ERROR CHECK
	ASL	R0		;MAKE INTO NUMBER OF BYTES
	MOV	R0,VALID(R1)	;NUMBER OF BYTES READ IS VALID DATA
	BICB	#DIRTY,EOFF(R1)	;THIS BUFFER IS NOT DIRTY YET
	BITB	#TEXT,FLAGS(R1)	;TEXT FILE?
	BEQ	GES01		;NO, SKIP CR-NULL REMOVAL
	MOV	(R1),R0		;FIRST CHARACTER IN BUFFER
	MOV	R0,R2		;POSITION OF SCAN CHARACTER
	MOV	VALID(R1),R3	;NUMBER OF CHARACTERS TO SCAN
2$:	CMPB	#15,(R2)	;CARRIAGE RETURN?
	BEQ	3$		;YES, SKIP IT
	TSTB	(R2)		;ZERO BYTE?
	BEQ	3$		;YES, SKIP IT ALSO
	MOVB	(R2)+,(R0)+	;PUT CHARACTER IN BUFFER
	BR	4$		;CONTINUE SCANNING
3$:	INC	R2		;SKIP CR OR NULL
	DEC	VALID(R1)	;ONE LESS CHARACTER IN BUFFER
4$:	SOB	R3,2$		;SCAN ALL VALID DATA BYTES
GES01:	RTS	PC
;
GES3:	TSTB	@#ERRBYT	;SEE WHAT THE ERROR CODE IS
	BNE	ERR001
	CLR	VALID(R1)	;NO VALID DATA
GES2:	BISB	#EOF,EOFF(R1)	;SET PASCAL EOF TO TRUE
	MOVB	#12,@(R1)	;MAKE EOLN TRUE ALSO
	RTS	PC
;
GESTRM:	MOV 	(R1),R2		;LOCATION OF DATA
	CLR	VALID(R1)	;INITIALIZE CHARACTER COUNT
1$:	.TTYIN	(R2)		;GET ONE CHARACTER FROM INPUT TERMINAL
	CMPB	#15,R0		;IGNORE CARRIAGE RETURNS...
				;FOLLOWING LINE FEED TERMINATES LINE.
	BEQ	1$
	CMPB	#32,R0		;CHECK FOR CONTROL Z
	BEQ	GES2		;SET END OF FILE
	INC	VALID(R1)	;ONE CHARACTER INPUT
	CMPB	#12,R0		;LINE TERMINATED?
	BEQ	2$		;YES, RETURN
	INC	R2		;NEXT CHARACTER POSITION
	BR	1$		;KEEP GETTING CHARACTERS
2$:	RTS	PC
;
.PAGE
	.SBTTL	$$$022 - PUT
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. SIZE OF BUFFER VARIABLE TO PUT
; REGISTER USE
;	R0 = SIZE OF BUFFER VARIABLE
;	R1 -> FILE BLOCK
;	R2,R3,R4 - NOT USED
; CALLS: P$FBRK
;
$$$022::
	MOV	4(SP),R1	;FILE BLOCK POINTER
	MOV	(SP)+,2(SP)	;MOVE DOWN RETURN
	MOV	(SP)+,R0	;SIZE OF VARIABLE TO PUT
;
P$FPUT::
	BITB	#OUT,FLAGS(R1)	;IS OUT SET?
	BEQ	ERR002
	BISB	#DIRTY,EOFF(R1)	;INDICATE DIRTY BUFFER
	ADD	R0,(R1)		;BUMP BUFFER VARIABLE POINTER
	SUB	R0,VALID(R1)	;REMAINING SPACE
	CMP	VALID(R1),MAXSIZ(R1);ENOUGH ROOM FOR NEXT VARIABLE?
	BGE	RET		;YES
	BR	P$FBRK
;
;
ERR002:	.PRINT	#NOEND		;INDICATE ERROR ON PUT
RET:	RTS	PC
;
NOEND:	.ASCIZ	"?NO OUT WHEN DOING A PUT."
	.EVEN
.PAGE
	.SBTTL	$$$023 - BREAK
; PARMS
;	1. POINTER TO FILE BLOCK
; REGISTER USE
;	R0,R2,R3,R4 - SCRATCH
;	R1 -> FILE BLOCK
;
$$$023::
	MOV	2(SP),R1
	MOV	(SP)+,(SP)
;
P$FBRK:	MOV	R2,-(SP)
	MOV	R3,-(SP)
	MOV	R4,-(SP)
	BITB	#OUT,FLAGS(R1)	;OPENED FOR OUTPUT?
	BEQ	1$
	MOV	(R1),R0		;CURRENT BUFFER POSITION
	SUB	R1,R0		;CALCULATE VALID DATA
	SUB	#BUFFER,R0	;IN BUFFER
	MOV	R0,VALID(R1)	;SET VALID FOR OUTPUT
	BLE	1$		;NO DATA TO OUTPUT
	MOV	R1,R4		;POINTER TO FILE BLOCK
	ADD	#BUFFER,R4	;POINTER TO START OF BUFFER
	BITB	#ISTTY,FLAGS(R1);TERMINAL?
	BNE	2$
	BITB	#IN,FLAGS(R1)	;UPDATE MODE?
	BEQ	7$		;NO, PROCEED AS USUAL
	BITB	#DIRTY,EOFF(R1)	;IS BUFFER DIRTY?
	BEQ	3$		;NO, SKIP THE WRITE
	MOV	#512.,VALID(R1)	;MUST WRITE FULL BUFFER IF UPDATE
7$:	MOV	CHAN(R1),R2	;CHANNEL NUMBER THIS FILE
	ASL	R2		;WORD INDEX FOR BLOCK NUMBER
	MOV	VALID(R1),R3	;VALID NUMBER OF BYTES
	INC	R3		;MAKE INTO AN EVEN
	BIC	#1,R3		;NUMBER OF BYTES
	CMP	R3,VALID(R1)	;DIFFERENT?
	BEQ	6$		;NO
	CLRB	@(R1)		;YES, CLEAR ORPHAN BYTE
6$:	ASR	R3		;WORD COUNT
	.WRITW	#AREA,CHAN(R1),R4,R3,BLOCK(R2)
	BCS	5$		;WRITE ERROR
	INC	BLOCK(R2)	;INCREMENT TO NEXT BLOCK NUMBER
3$:	MOV	R1,(R1)		;RE-INITIALIZE BUFFER VARIABLE POINTER
	ADD	#BUFFER,(R1)
	MOV	#512.,VALID(R1)	;...AND COUNT
	BICB	#DIRTY,EOFF(R1)	;NEW BUFFER NOT DIRTY YET
	BITB	#IN,FLAGS(R1)	;UPDATE MODE?
	BEQ	1$		;NO, SKIP READ OF NEXT BLOCK
	.READW	#AREA,CHAN(R1),R4,R3,BLOCK(R2)
	ASL	R0		;NUMBER OF BYTES READ
	MOV	R0,VALID(R1)	;VALID DATA BYTES
;
1$:	MOV	(SP)+,R4
	MOV	(SP)+,R3
	MOV	(SP)+,R2
	RTS	PC
;
2$:	MOV	VALID(R1),R3
4$:	.TTYOUT (R4)+
	SOB	R3,4$
	BR	3$
5$:	.PRINT	#WTERR
	BR	3$
WTERR:	.ASCIZ	"?ERROR WHEN DOING A BREAK."
	.EVEN
.PAGE
	.SBTTL	$$$024 - READ CHARACTER
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. POINTER TO CHARACTER
; REGISTER USAGE
;	R3 - SIZE OF BUFFER VARIABLE
;	R1 -> FILE BLOCK
;	R4 - NOT USED
; CALLS: $$$021
;
$$$024::
	MOV	4(SP),R1
	MOV	(SP)+,2(SP)
;
P$FRDC:	BITB	#ISTTY,FLAGS(R1);TERMINAL?
	BNE	1$
;
	MOVB	@(R1),@(SP)+	;NO, MOVE THEN GET
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021
	BR	2$
;
1$:
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;YES, GET THEN MOVE
	MOVB	@(R1),@(SP)+
;
2$:	RTS	PC
.PAGE
	.SBTTL	$$$025 - WRITE CHARACTER
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. CHARACTER
;	3. WIDTH OF FIELD
; REGISTER USAGE
;	R2 - BUFFER VARIABLE SIZE
;	R0 - HOLDS PAD CHAR TO P$FPAD
;	R1 -> FILE BLOCK
;	R3,R4 - NOT USED
; CALLS: P$FPUT,P$FPAD
; RASH ASSUMPTION: P$FPUT DOES NOT DISTURB R2,R3
;
$$$025::
	MOV	6(SP),R1	;POINTER TO FILE BLOCK
	MOV	(SP)+,4(SP)	;MOVE DOWN RETURN ADDRESS
	MOVB	2(SP),@(R1)	;MOVE THE CHAR INTO THE BUFFER
	MOV	#1,R0		;AND PUT
	JSR	PC,P$FPUT
;
	MOV	(SP)+,R0	;FIELD WIDTH
	MOV	R2,(SP)		;SAVE R2 OVER CHARACTER ALREADY OUTPUT
	MOV	#' ,R2		; PAD CHAR IS BLANK
	DEC	R0		;WIDTH - 1 IS NR OF PADS
	JSR	PC,P$FPAD
	MOV	(SP)+,R2
;
	RTS	PC
.PAGE
	.SBTTL	RT-11 FILES INTERFACE AREA
	.PSECT	$VARBL
AREA:	.BLKW	6
OUTSPC:	.BLKW	39.
OTNAM=OUTSPC
INNAM=OUTSPC+36
STATUS:	.BLKW	4
BLOCK:	.BLKW	16.
CHANLS:	.BLKB	16.
DEF:	.WORD	0,0,0,0
STRING:	.BLKB	80.
FILNAM:	.BLKB	22.
CURHP:	.WORD	0
MTOP:	.WORD	0
;
	.END
****
PARCTA.MAC
	.TITLE P$ATAN - ARCTAN
	.IDENT	/790817/
; USAGE:
;	Y := ARCTAN(X)
;	REAL PARAMETER X ON TOP OF STACK
;	REAL RESULT RETURNED ON TOP OF STACK
; REGISTER USAGE:
;	R0,R1 - SCRATCH
;	R3,R4 - SCRATCH (SAVED/RESTORED)
;
$$$106::;ARCTAN(X)
	MOV	2(SP),R0	;HIGH ARG
	MOV	4(SP),R1	;LOW ARG
	MOV	R4,-(SP)	;SAVE R4
	MOV	R3,-(SP)	;SAVE R3
	CLR	-(SP)		;CLEAR SIGN FLAG
	CLR	-(SP)		;CLEAR QUADRANT BIAS
	CLR	-(SP)		;;
	MOV	R1,-(SP)	;LOW ORDER ARG
	MOV	R0,-(SP)	;HIGH ORDER ARG
	BGE	1$		;QUADRANT 1 OR 3
	ADD	#100000,(SP)	;GET ABS VALUE
	INC	10(SP)		;FLAG -
1$:	CMP	(SP),#40200	;CHECK IF < 1.
	BLO	3$		;< 1.
	BGT	2$		;> 1.
	TST	2(SP)		;CHECK LOW ORDER
	BEQ	3$		;= 1.
2$:	MOV	#140311,4(SP)	;-PI/2
	MOV	#7733,6(SP)	;ARCTAN(X)=PI/2-ARCTAN(1/X)
	DEC	10(SP)		;ADJUST SIGN
	MOV	2(SP),-(SP)	;COPY ARG
	MOV	2(SP),-(SP)	;;
	MOV	#40200,4(SP)	;INSERT 1.
	CLR	6(SP)		;;
	FDIV	SP		;1./X
3$:	MOV	2(SP),-(SP)	;COPY ARG
	MOV	2(SP),-(SP)	;;
	CLR	4(SP)		;INSERT 0.0
	CLR	6(SP)		;;
	CMP	(SP),#37661	;TAN(15)
	BLO	5$		;< TAN(15)
	BHI	4$		;> TAN(15)
	CMP	2(SP),#30243	;=?
	BLOS	5$
4$:	MOV	#40006,4(SP)	;INSERT PI/6
	MOV	#5222,6(SP)	;;
	MOV	(SP),R0		;ARG TO REGS
	MOV	2(SP),R1	;;
	MOV	#131727,-(SP)	;PUSH -ROOT3
	MOV	#140335,-(SP)	;;
	MOV	R1,-(SP)	;PUSH ARG
	MOV	R0,-(SP)	;;
	CLR	-(SP)		;PUSH 1.
	MOV	#40200,-(SP)	;;
	MOV	#131727,-(SP)	;PUSH ROOT3
	MOV	#40335,-(SP)	;;
	MOV	R1,-(SP)	;PUSH ARG
	MOV	R0,-(SP)	;;
	FMUL	SP		;(ROOT3*X-1.)/(ROOT3+X)
	FSUB	SP		;;
	MOV	(SP)+,10.(SP)	;MOVE STACK ITEM UP
	MOV	(SP)+,10.(SP)	;;
	FSUB	SP		;;
	FDIV	SP		;;
5$:	MOV	(SP),R0		;GET ARG
	MOV	2(SP),R1	;;
	MOV	R1,-(SP)	;GET THREE COPIES
	MOV	R0,-(SP)	;;
	MOV	R1,-(SP)	;;
	MOV	R0,-(SP)	;;
	FMUL	SP		;ARG**2
	MOV	(SP)+,R0	;POP POLY ARG
	MOV	(SP)+,R1	;;
	MOV	#CONSTS+4,R4	;POINT TO COEFFICIENT TABLE
	MOV	#5,R3		;LOOP 5
	BR	7$
6$:	MOV	R1,-(SP)	;PUSH ARG
	MOV	R0,-(SP)	;;
7$:	MOV	-(R4),-(SP)	;PUSH COEFFICIENT
	MOV	-(R4),-(SP)	;;
	SOB	R3,6$		;LOOP
	MOV	#5,R3		;LOOP 5
8$:	FMUL	SP
	FADD	SP
	SOB	R3,8$		;LOOP
	FADD	SP		;P(X)+0 IF X<=1., P(X)-PI/2 IF X>1.
	TST	4(SP)		;CHECK SIGN FLAG
	BEQ	9$
	ADD	#100000,(SP)	;NEGATE RESULT FOR (-1,0) AND (1,INF)
9$:	MOV	(SP)+,12(SP)	;POP RESULT
	MOV	(SP)+,12(SP)	;;
	TST	(SP)+		;REMOVE SIGN
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R4	;RESTORE R4
	RTS	PC		;RETURN
	.WORD	037305,035302	;.0963034789
	.WORD	137421,056514	;-.1419574624
	.WORD	037514,143333	;.1999773201
	.WORD	137652,125244	;-.3333331319
CONSTS:	.WORD	040200,000000	;.999999999999
	.END
****
PEXP.MAC
	.TITLE P$EXP - EXP
	.IDENT	/791112/
	.MCALL	.PRINT
; USAGE:
;	Y := EXP(X)
;	REAL PARAMETER X ON TOP OF STACK
;	REAL RESULT RETURNED ON TOP OF STACK
; REGISTER USAGE:
;	R0,R1 - SCRATCH
;	R4 - EXPONENT SCALE (SAVED/RESTORED)
;
; CALLS:
;	$$$098		TRUNC
;	$$$201		FLOAT
	.GLOBL	$$$098,$$$201
;
$$$103::;EXP(X)
	MOV	R4,-(SP)	;SAVE R4
	MOV	4(SP),R0	;HIGH ORDER ARG
	BGT	POS		;JUMP IF +
	CMP	R0,#141660	;ARG IS -
	BHI	ZERO		;ARG < -88.7
	BR	SMTST
POS:	CMP	R0,#041660
	BHI	OVER		;ARG > 87
SMTST:	ASL	R0		;DUMP SIGN
	CMP	R0,#063000
	BLO	ONE		;JUMP IF ARG MAGNITUDE <2**-28
	CLR	-(SP)		;PUSH A 1.
	MOV	#40200,-(SP)	;;
	MOV	12(SP),-(SP)	;GET ARGUMENT
	MOV	12(SP),-(SP)	;HIGH PART
	MOV	2(SP),-(SP)	;COPY IT
	MOV	2(SP),-(SP)	;;
	MOV	#125073,-(SP)	;GET LOG2(E)
	MOV	#40270,-(SP)	;HIGH PART
	FMUL	SP		;X * LOG2(E)
	TST	-(SP)		;MAKE SPACE FOR INTEGER
	MOV	4(SP),-(SP)	;COPY TOS
	MOV	4(SP),-(SP)	;;
	JSR	PC,$$$098	;TRUNC THE RESULT
	MOV	(SP),R4		;SAVE IT IN R4
	JSR	PC,$$$201	;FLOAT IT
	MOV	#125073,-(SP)	;GET LOG2(E)
	MOV	#40270,-(SP)	;;
	FDIV	SP
	FSUB	SP		;GET THE FRACTIONAL PART
	ROL	(SP)		;SHIFT MODIFIED ARG
	ROL	R0		;SAVE SIGN
	SUB	#400,(SP)	;DIVIDE BY 2
	BHI	3$		;OKAY
	CMP	(SP)+,(SP)+	;UNDERFLOW, MAKE ARG 0
	BR	4$
3$:	ROR	R0		;GET SIGN BACK
	ROR	(SP)
	MOV	(SP),R0		;GET MODIFIED ARGUMENT
	MOV	2(SP),R1	;IN REGISTERS
	MOV	#36602,-(SP)	;PUSH -12.01501675
	MOV	#141100,-(SP)	;;
	MOV	R1,-(SP)	;COPY ARGUMENT
	MOV	R0,-(SP)	;;
	MOV	#71571,-(SP)	;PUSH 601.8042667
	MOV	#42426,-(SP)	;;
	MOV	#56133,-(SP)	;PUSH 60.0901907
	MOV	#41560,-(SP)	;;
	MOV	R1,-(SP)	;COPY ARGUMENT
	MOV	R0,-(SP)	;;
	MOV	R1,-(SP)	;COPY ARGUMENT
	MOV	R0,-(SP)	;;
	FMUL	SP		;Y*Y
	FADD	SP		;B1+Y*Y
	FDIV	SP		;A1/(B1+Y*Y)
	FADD	SP		;Y+A1/(B1+Y*Y)
	FADD	SP		;A0+Y+A1/(B1+Y*Y)
	FDIV	SP		;Y/(A0+Y+A1/(B1+Y*Y))
	ADD	#100200,(SP)	;-2*Y/(A0+Y+A1/(B1+Y*Y))
	FADD	SP		;1-2*Y/(A0+Y+A1/(B1+Y*Y))
	MOV	2(SP),-(SP)	;DUPLICATE IT
	MOV	2(SP),-(SP)	;;
	FMUL	SP		;(1-2*Y/(A0+Y+A1/(B1+Y*Y)))**2
4$:
	MOV	(SP)+,R0	;GET APPROXIMATION RESULT
	MOV	(SP)+,R1	;;
	SWAB	R4		;MAKE INT(X*LOG2(E)) INTO
				;EXPONENT MODIFIER
	CLRB	R4		;;
	ASR	R4		;;
	ADD	R4,R0		;ADD IN EXPONENT MODIFIER
	BMI 	OVER		;TEST OVERFLOW
	MOV	R0,4(SP)	;RESULT IS RETURNED
	MOV	R1,6(SP)	;;
	BR	ENDEXP		;EXIT
ONE:	MOV	#040200,4(SP)	;RESULT IS 1.0
	CLR	6(SP)		;LOW PART TO 0
	BR	ENDEXP
OVER:	.PRINT	#OVRFLW		;FLOATING OVERFLOW
	BR	ERROR
ZERO:	.PRINT	#UNDFLW		;FLOATING UNDERFLOW
ERROR:	CLR	4(SP)		;SET HIGH PART TO 0
	CLR	6(SP)		;CLEAR LOW PART
;
ENDEXP:	MOV	(SP)+,R4	;POP R4
	RTS	PC
OVRFLW:	.ASCIZ	/? FEXP  FLOATING OVERFLOW IN FUNCTION EXP/
UNDFLW:	.ASCIZ	/? FEXP  FLOATING UNDERFLOW IN FUNCTION EXP/
	.EVEN
	.END
****
PFCMP.MAC
	.TITLE	PFCMP	FLOATING POINT COMPARE ROUTINE
	.IDENT	/790804/
	;FCMP COMPARES THE TWO FLOATING POINT VALUES ON THE
	;TOP OF THE STACK AND SETS THE CONDITION CODES
	;TO INDICATE EQUAL, NOT EQUAL, LESS THAN, GREATER THAN,
	;LESS THAN OR EQUAL, AND GREATER THAN OR EQUAL.
	;THIS ROUTINE DOES NOT USE ANY REGISTERS, AND EXPECTS
	;THE TWO FLOATING POINT ROUTINES TO BE ON TOP OF THE
	;STACK.  THEY WILL BE POPED WHEN THE ROUTINE EXITS.
	;
$$$097::;FCMP
	CLR	-(SP)		;START OUT EQUAL
	CMP	10(SP),4(SP)	;COMPARE THE HIGH PARTS
	BGT	CMP1		;SET GREATER THAN FLAG
	BLT	CMP2		;SET LESS THAN FLAG
	TST	4(SP)		;CHECK FOR A OVERFLOW
	BPL	CMP4		;THE NUMBER WAS POSITIVE
	CMP	12(SP),6(SP)	;COMPARE THE LOWER PARTS
	BHI	CMP2		;SET LESS THAN FLAG
	BLO	CMP1		;SET GREATER THAN FLAG
	BR	CMP3		;SET EQUAL
CMP4:	CMP	12(SP),6(SP)	;CHECK LOWER HALF
	BHI	CMP1		;SET GREATER THAN FLAG
	BLO	CMP2		;SET LESS THAN FLAG
CMP3:	MOV	(SP)+,6(SP)	;GET STACK READY FOR RETURN
	MOV	(SP)+,6(SP)	;;
	CMP	(SP)+,(SP)+	;;
	TST	(SP)+		;SET CONDITION CODES
	RTS	PC		;RETURN
CMP1:	INC	(SP)		;SET GREATER THAN
	BR	CMP3		;EXIT
CMP2:	DEC	(SP)		;SET LESS THAN
	BR	CMP3		;EXIT
	.END
****
PFISC.MAC
	.TITLE	PFISC - FIS CODE IMPLEMENTATION
	.IDENT	/790801/
	.MCALL	.PRINT
; REGISTER USAGE
;	R0,R1 - SCRATCH
;
$$$210::;POP THE FIS STACK TO THE ADDRESS AT SP+2
	;
	MOV	R0,-(SP)	;SAVE R0
	MOV	R1,-(SP)	;SAVE R1
	MOV	REG,R1		;CURRENT TOP OF FIS STACK
	CMP	R1,#FISHGH	;IS THE STACK EMPTY??
	BHI	FISERH
	MOV	6(SP),R0	;ADDRESS TO STORE TOP VALUE
	MOV	(R1)+,(R0)+	;MOVE HIGH PART
	MOV	(R1)+,(R0)+	;MOVE LOW PART
	MOV	R1,REG		;NEW CURRENT TOP OF FIS STACK
FISRET:
	MOV	(SP)+,R1	;RESTORE R1
	MOV	(SP)+,R0	;RESTORE R0
	MOV	(SP)+,(SP)	;PUSH DOWN RETURN ADDRESS
	RTS	PC		;RETURN TO CALLER
FISERH:	.PRINT	#ERHFIS		;STACK UNDERFLOW
	BR	FISRET
$$$211::;PUSH ON THE FIS STACK THE FLOATING OPERAND POINTED
	;TO BY THE ADDRESS AT SP+2
	;
	MOV	R0,-(SP)	;SAVE R0
	MOV	R1,-(SP)	;SAVE R1
	MOV	REG,R1		;CURRENT TOP OF FIS STACK
	CMP	R1,#FISLOW+4	;IS THERE ROOM FOR ANOTHER VALUE
	BLO	FISERL
	MOV	6(SP),R0	;ADDRESS OF VALUE
	MOV	2(R0),-(R1)	;PUSH LOW PART
	MOV	(R0),-(R1)	;PUSH HIGH PART
	MOV	R1,REG		;NEW CURRENT TOP OF FIS STACK
	BR	FISRET
FISERL:	.PRINT	#ERLFIS		;STACK OVERFLOW
	BR	FISRET
$$$212::;PUSH DOWN FIS STACK POINTER AND RETURN ADDRESS OF
	;THE CURRENT TOP OF THE FIS STACK
	;
	MOV	(SP),-(SP)	;PUSH UP RETURN TO MAKE ROOM 
	MOV	R0,-(SP)	;SAVE R0
	MOV	REG,R0		;CURRENT TOP OF FIS STACK
	CMP	R0,#FISLOW+4	;IS THERE ENOUGH ROOM FOR VALUE
	BLO	FISERL
	CMP	-(R0),-(R0)	;ADJUST FIS STACK POINTER
	MOV	R0,4(SP)	;RETURN THE ADDRESS OF TOP OF FIS STACK
	MOV	R0,REG		;NEW CURRENT TOP OF FIS STACK
	MOV	(SP)+,R0	;RESTORE R0
	RTS	PC
$$$213::;PUSH ON THE FIS STACK THE FLOATING OPERAND
	;ON TOP OF THE STACK
	MOV	R1,-(SP)	;SAVE R1
	MOV	REG,R1		;CURRENT TOP OF FIS STACK
	CMP	R1,#FISLOW+4	;IS THERE ROOM FOR ANOTHER VALUE
	BLO	FISERL		;NO
	MOV	6(SP),-(R1)	;PUSH LOW PART
	MOV	4(SP),-(R1)	;PUSH HIGH PART
	MOV	R1,REG		;NEW CURRENT TOP OF FIS STACK
	MOV	(SP)+,R1	;RESTORE R1
	MOV	(SP)+,2(SP)	;PUSH DOWN RETURN
	TST	(SP)+		;POP OFF OTHER WORD
	RTS	PC
$$$214::;POP FROM FIS STACK TO SP STACK
	MOV	(SP),-(SP)	;MAKE ROOM FOR VALUE
	MOV	(SP),-(SP)	;;
	MOV	R1,-(SP)	;SAVE R1
	MOV	REG,R1		;CURRENT TOP OF FIS STACK
	CMP	R1,#FISHGH	;IS THE STACK EMPTY?
	BHI	FISERH		;YES
	MOV	(R1)+,4(SP)	;MOVE HIGH PART
	MOV	(R1)+,6(SP)	;MOVE LOW PART
	MOV	R1,REG		;NEW CURRENT TOP OF FIS STACK
	MOV	(SP)+,R1	;RESTORE R1
	RTS	PC
	;FLOATING ADD,SUB,MUL,DIV, AND SQR OPERATIONS
	;THEY USE A COMMON ENTRY AND EXIT ROUTINE
FSET:	MOV	(SP),-(SP)	;MAKE PLACE TO STORE R0
	MOV	R0,2(SP)	;SAVE R0
	MOV	REG,R0		;CURRENT TOP OF FIS STACK
	RTS	PC
FRET:	MOV	R0,REG		;NEW CURRENT TOP OF FIS STACK
	MOV	(SP)+,R0	;RESTORE R0
	RTS	PC
$$$215::;FLOATING ADD
	JSR	PC,FSET		;SET UP FIS STACK POINTER
	FADD	R0		;ADD TWO TOP ELEMENTS OF STACK
	BR	FRET		;RETURN
$$$216::;FLOATING SUBTRACT
	JSR	PC,FSET		;SET UP FIS STACK POINTER
	FSUB	R0		;SUBTRACT TOP ELEMENT OF STACK
	BR	FRET		;RETURN
$$$217::;FLOATING MULTIPLY
	JSR	PC,FSET		;SET UP FIS STACK POINTER
	FMUL	R0		;MULTIPLY TOP ELEMENTS OF STACK
	BR	FRET		;RETURN
$$$218::;FLOATING DIVIDE
	JSR	PC,FSET		;SET UP FIS STACK POINTER
	FDIV	R0		;DIVIDE TOP ELEMENT OF STACK
	BR	FRET		;RETURN
$$$202::;FLOATING SQUARE
	JSR	PC,FSET
	MOV	2(R0),-(R0)	;ADD COPY OF VALUE TO STACK
	MOV	2(R0),-(R0)	;;
	FMUL	R0		;TOP VALUE IS NOW SQUARE OF FORMER
	BR	FRET		;RETURN
	.PAGE
; ERROR MESSGES
ERHFIS:	.ASCIZ	/? FISC FLOATING POINT STACK EMPTY ON POP/
ERLFIS:	.ASCIZ	/? FISC FLOATING POINT STACK FULL ON PUSH/
	.EVEN
; FOLLOWING PSECT DEFINES THE FIS STACK STRUCTURE
	.PSECT	$$$FIS,RW,GBL,OVR
REG:	.WORD	FISHGH
FISLOW:	.BLKW	100.
FISHGH=.
	.END
****
PFLOAT.MAC
	.TITLE	PFLOAT	FLOAT INTEGER VALUE
	.IDENT	/790803/
	;FLOAT DOES NOT USE ANY REGISTERS
	;
$$$201::;FLOAT( INTEGER )
	MOV	2(SP),6(SP)	;MOVE INTEGER TO LOWER HALF
	CLR	4(SP)		;CLEAR UPPER HALF OF NUMBER
	TST	2(SP)		;TEST FOR ZERO AND NEGATIVE
	BGT	1$		;POSITIVE NUMBER
	BEQ	DONE		;ZERO
	NEG	6(SP)		;NEGATIVE
	BIS	#100000,4(SP)	;SET THE SIGN BIT
1$:	MOV	#230,2(SP)	;BASE EXPONENT VALUE
2$:	BIT	4(SP),#200	;CHECK IF WE ARE DONE
	BNE	3$		;FINISH UP
	ASL	6(SP)		;GET THE LEFT MOST BIT
	ROLB	4(SP)		;LOAD BIT INTO HIGH PART
	DEC	2(SP)		;DECREMENT THE EXPONENT
	BR	2$		;REPEAT
3$:	ASR	2(SP)		;SHIFT EXPONENT TO PROPER PLACE
	RORB	3(SP)		;AND GET LOWEST BIT ALSO
	SWAB	2(SP)		;GET EXPONENT IN UPPER HALF
	BIC	#200,4(SP)	;REMOVE HIDDEN BIT
	BIS	2(SP),4(SP)	;MOVE EXPONENT TO HIGH PART
DONE:	MOV	(SP)+,(SP)	;PREPARE THE STACK FOR RETURN
	RTS	PC
	.END
****
PFPAD.MAC
	.TITLE	PFPAD -- PUTS OUT PAD CHARACTERS
	.IDENT	/790717/
	.GLOBL P$FPUT
; P$FPAD - PUTS OUT PAD CHARACTERS
; EXPECTS
;	R0 = CHARACTER COUNT
;	R1 -> FILE BLOCK
;	R2 =PAD CHARACTER
; REGISTER USAGE
;	R0 - BUFFER VARIABLE SIZE
;	R1-> FILE BLOCK
;	R2 - CHARACTER FOR PAD
;	R3 - COUNTER
;	R4 - NOT USED
; CALLS: P$FPUT
; RASH ASSUMPTION: P$FPUT DOES NOT DISTURB R1, R2
;
P$FPAD::
	TST	R0
	BLE	1$
;
	MOV	R3,-(SP)
	MOV	R0,R3
2$:	MOVB	R2,@(R1)
	MOV	#1,R0
	JSR	PC,P$FPUT
	SOB	R3,2$
	MOV	(SP)+,R3
;
1$:	RTS	PC
	.END
****
PFREAD.MAC
	.TITLE	PFREAD - READ REAL
	.IDENT	/790822/
;  PARMS
;	1. POINTER TO FILE BLOCK
;	2. POINTER TO REAL VARIABLE
;  REGISTER USAGE
;	R0 - SCRATCH
;	R1 - POINTER TO FILE BLOCK
;  CALLS: $$SPCE, $$SGN, $$IGET, $$$201(FLOAT), $$$021
;
	.GLOBL	$$SPCE,$$SGN,$$IGET,$$$201,$$$021
$$$034::
	MOV	4(SP),R1	;POINTER TO FILE BLOCK
	MOV	(SP)+,2(SP)	;MOVE DOWN RETURN ADDRESS
	MOV	R3,-(SP)	;SAVE R3
	MOV	R2,-(SP)	;SAVE R2
	JSR	PC,$$SPCE	;CLEAN OUT WHITE SPACE
	JSR	PC,$$SGN	;GET ACTUAL SIGN
	SUB	#20,SP		;MAKE SOME SPACE ON THE STACK
	MOV	R0,SIGN		;SAVE SIGN
	CLR	2(SP)		;CLEAR FOR ACCUMULATED VALUE
	CLR	(SP)
	JSR	PC,$$RGET	;GET INTEGER PART
	CLR	R2		;INIT THE SCALE FACTOR
	CMPB	#56,@(R1)	;FRACTIONAL PART?
	BNE	1$		;...NO
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;PAST THE DOT
	JSR	PC,$$RGET	;GET FRACTIONAL PART
1$:	TST	SIGN		;CHECK THE SIGN
	BEQ	2$
	BIS	#100000,(SP)
2$:	CLR	R3		;INIT EXPONENT VALUE TO ZERO
	CMPB	#'E,@(R1)	;CHECK FOR EXPONENT
	BEQ	3$
	.ENABL	LC
	CMPB	#'e,@(R1)
	BNE	4$
3$:	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;SKIP THE 'E'
	JSR	PC,$$SGN	;COMPUTE THE SIGN
	MOV	R0,-(SP)	;SAVE THE SIGN
	JSR	PC,$$IGET	;COMPUTE THE EXPONENT
	TST	(SP)+		;CHECK THE SIGN
	BEQ	4$
	NEG	R3		;MAKE NEGATIVE
4$:	MOV	#ONE,10(SP)	;INITIALIZE SCALE FACTOR
	CLR	12(SP)
	MOV	#TEN,14(SP)	;AND THE MULTIPLIER
	CLR	16(SP)
	ADD	R3,R2		;COMPUTE # DECIMAL PLACES IN RESULT
	BEQ	9$		;STOP IF NO MOTION
	BGT	5$		;IF NEGATIVE
	NEG	R2		;MAKE THE COUNT POSITIVE
	MOV	#37314,14(SP)	;INVERT THE MULTIPLIER
	MOV	#146315,16(SP)
5$:	BIT	#1,R2
	BEQ	6$
	MOV	16(SP),-(SP)	;MULTIPLY UP THE SCALE FACTOR
	MOV	16(SP),-(SP)
	MOV	16(SP),-(SP)
	MOV	16(SP),-(SP)
	FMUL	SP
	MOV	(SP)+,12(SP)
	MOV	(SP)+,12(SP)
6$:	MOV	16(SP),-(SP)
	MOV	16(SP),-(SP)
	MOV	2(SP),-(SP)	;SQUARE THE MULTIPLIER
	MOV	2(SP),-(SP)
	FMUL	SP
	MOV	(SP)+,16(SP)
	MOV	(SP)+,16(SP)
	ASR	R2		;HALVE THE # DIGITS
	BNE	5$		;AND CONTINUE
9$:	MOV	12(SP),-(SP)	;FACTOR IN THE SCALE FACTOR
	MOV	12(SP),-(SP)
	FMUL	SP
	MOV	(SP)+,@22(SP)	;RETURN THE REAL NUMBER
	ADD	#2,22(SP)
	MOV	(SP)+,@20(SP)
	ADD	#14,SP
	MOV	(SP)+,R2	;RESTORE R2
	MOV	(SP)+,R3	;RESTORE R3
	TST	(SP)+		;POP SECOND PARAMETER
	RTS	PC
;
;	$$RGET: READ IN INTEGER AS FLOATING VALUE
;  REGISTER USAGE:
;	R1: POINTER TO FILE BLOCK
;	R0: SCRATCH
;	R2: DIGIT COUNT (FOR POSSIBLE SCALE FACTOR)
;
$$RGET::
	MOV	(SP)+,R3	;SAVE RETURN ADDRESS
2$:	MOVB	@(R1),R0	;GET DIGIT
	SUB	#'0,R0		;CHECK TO ASSURE
	BLT	1$		; THAT IT IS
	CMPB	#9.,R0		; REALLY
	BLT	1$		; A DIGIT
	CLR	-(SP)
	MOV	#TEN,-(SP)	;  AND COMPUTE
	FMUL	SP
	CMP	-(SP),-(SP)	;SPACE FOR A REAL
	MOV	R0,-(SP)	;FLOAT IT
	JSR	PC,$$$201
	FADD	SP
	DEC	R2		;COUNT THE DIGIT
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;BUMP TO THE NEXT DIGIT
	BR	2$
1$:	JMP	(R3)
; CONSTANTS AND DATA
ONE = 40200			; 1.0
TEN = 41040			; 10.0
	.PSECT	$VARBL
SIGN:	.WORD	0
	.END
****
PIGET.MAC
	.TITLE	PIGET -- READ IN INTEGER VALUE
	.IDENT	/790717/
	.GLOBL	$$$021
;
;	$$IGET: READ IN INTEGER VALUE
; REGISTER USAGE
;	R0: SCRATCH
;	R1: POINTER TO FILE BLOCK
;	R3: ACCUMULATED VALUE
;
$$IGET::
	MOVB	@(R1),R0	;EXAMINE NEXT CHARACTER
	SUB	#'0,R0
	BLT	1$		;SMALLER THAN '0'
	CMP	#9.,R0
	BLT	1$		;LARGER THAN '9'
	MUL	#10.,R3		;R3 = R3*10.
	ADD	R0,R3
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;GET NEXT CHARACTER
	BR	$$IGET
1$:	RTS	PC
	.END
****
PLN.MAC
	.TITLE	P$LN - NATURAL LOG
	.IDENT	/790817/
	.MCALL	.PRINT
; USAGE:
;	Y := LN(X)
;	REAL PARAMETER X ON TOP OF STACK
;	REAL RESULT RETURNED ON TOP OF STACK
; REGISTER USAGE:
;	R0,R1 - SCRATCH
;	R2,R3 - SCRATCH (SAVED/RESTORED)
;
; CALLS:
;	$$$201 - FLOAT
	.GLOBL	$$$201
;
$$$102::;LN(X)
	MOV	2(SP),R0	;HIGH OF ARG
	MOV	4(SP),R1	;LOW OF ARG
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	#71030,-(SP)	;PUSH -1/2*LN(2)
	MOV	#137661,-(SP)	;;
	CMP	-(SP),-(SP)	;GET WORK SPACE
	MOV	R1,-(SP)	;PUSH ARG
	MOV	R0,-(SP)	;;
	BLE	ERROR		;NOT POSITIVE, ERROR
	ASL	(SP)		;SHIFT OUT SIGN
	MOVB	1(SP),12.(SP)	;GET EXPONENT
	MOVB	#200,1(SP)	;TRANSFORM ARG TO (1/2,1)
	ROR	(SP)		;FIX SIGN OFFSET
	MOV	#2363,-(SP)	;PUSH 1/2*ROOT2
	MOV	#40065,-(SP)	;;
	MOV	6(SP),-(SP)	;PUSH ARG
	MOV	6(SP),-(SP)	;;
	MOV	#2363,-(SP)	;PUSH 1/2*ROOT2
	MOV	#40065,-(SP)	;;
	FSUB	SP		;GET (X-ROOT2)/(X+ROOT2)
	MOV	(SP)+,10.(SP)	;MOVE ITEM TO WORK SPACE
	MOV	(SP)+,10.(SP)	;;
	FADD	SP		;;
	FDIV	SP		;;
	MOV	2(SP),-(SP)	;COPY TOS
	MOV	2(SP),-(SP)	;;
	MOV	2(SP),-(SP)	;COPY TOS
	MOV	2(SP),-(SP)	;;
	FMUL	SP		;SQUARE IT
	MOV	(SP)+,R0	;POP Y
	MOV	(SP)+,R1	;;
	MOV	#CONSTS+4,R2	;POINT TO COEFFICIENTS
	MOV	#3,R3		;LOOP 3
1$:	MOV	-(R2),-(SP)	;PUSH COEFF
	MOV	-(R2),-(SP)	;;
	MOV	R1,-(SP)	;PUSH Y
	MOV	R0,-(SP)	;;
	SOB	R3,1$		;LOOP
	MOV	-(R2),-(SP)	;PUSH COEFF
	MOV	-(R2),-(SP)	;;
	MOV	#4,R2		;FOUR OPERATIONS REQUIRED TO
2$:	FMUL	SP		;EXPAND POLYNOMIAL
	FADD	SP
	SOB	R2,2$
	CMP	-(SP),-(SP)	;MAKE ROOM FOR REAL
	CLR	-(SP)		;SCALE
	BISB	12(SP),(SP)	;GET EXPONENT
	SUB	#200,(SP)	;REMOVE EXCESS 128
	JSR	PC,$$$201	;FLOAT
	MOV	#71030,-(SP)	;PUSH LN(2)
	MOV	#40061,-(SP)	;;
	FMUL	SP		;GET LN(EXP)
	FADD	SP		;COMBINE WITH FRACTION
	MOV	(SP)+,10(SP)	;POP RESULT
	MOV	(SP)+,10(SP)	;;
RET:	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	RTS	PC
ERROR:	.PRINT	#LOGERR
	ADD	#12.,SP
	BR	RET
;
; ORDER-DEPENDENT CONSTANTS FOR ROUTINE
	.WORD	037632,014525	;.300974506
	.WORD	037714,120036	;.399659100
	.WORD	040052,125332	;.666669471
CONSTS:	.WORD	040400,000000	;1.999999999
LOGERR:	.ASCIZ	/? LN ATTEMPT TO TAKE LOG OF NEG NUMBER/
	.EVEN
	.END
****
PRDEOL.MAC
	.TITLE	PRDEOLN - READENDOFLINE( @FILEVAR )
	.IDENT	/791112/
	.GLOBL $$$021,ISTTY,FLAGS
; PARMS
;	1. POINTER TO FILE BLOCK
; REGISTER USAGE
;	R1: POINTER TO FILE BLOCK
; CALLS: $$$021
;
;
$$$044::
	MOV	2(SP),R1	;POINTER TO FILE BLOCK
1$:	CMPB	#10.,@(R1)	;CHECK FOR LF
	BEQ	2$		;YES, LF INDICATES END OF LINE
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;GET NEXT CHARACTER
	BR	1$
2$:	BITB	#ISTTY,FLAGS(R1);IS THIS A TERMINAL?
	BEQ	3$
	CLRB	@(R1)		;CLEAR EOLN CHAR
	BR	4$
3$:	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;GET NEXT CHARACTER
4$:	MOV	(SP)+,(SP)	;POP OFF PARAMETER
	RTS	PC
	.END
****
PRINTG.MAC
	.TITLE	PRINTG - READ INTEGER
	.IDENT	/790717/
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. POINTER TO INTEGER VARIABLE
; REGISTERS
;	R1 -> FILE BLOCK
;	R0,R2,R3 - SCRATCH
; CALLS: $$$021, $$SPCE, $$SGN, $$IGET
	.GLOBL	$$$021,$$SPCE,$$SGN,$$IGET
$$$030::
	MOV 	4(SP),R1	; UNPACK PARMS--GET -> FILE BLOCK
	MOV	(SP)+,2(SP)	; SAVE RETURN ADDR.
	MOV	(SP)+,R0	; POINTER TO RESULT
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	R0,R2		;R2 -> RESULT
	JSR	PC,$$SPCE	;CLEAN OUT LEADING WHITE SPACE
	JSR	PC,$$SGN	;COMPUTE ACTUAL SIGN
	MOV	R0,-(SP)	;SAVE SIGN
	CLR	R3		;R3 = VALUE
	JSR	PC,$$IGET	;COMPUTE INT VALUE IN R3
	TST	(SP)+		;CHECK SIGN
	BEQ	1$
	NEG	R3		;IS < 0
1$:	MOV	R3,(R2)		;STORE RESULT
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	RTS	PC
	.END
****
PROUND.MAC
	.TITLE	PROUND -- ROUND AND TRUNC ROUTINES
	.IDENT	/790814/
	;ROUND ($$$099) USES R0 AS A SCRATCH REGISTER
	;TRUNC ($$$098) DOES NOT USE ANY REGISTERS
	;
	;BOTH ROUND AND TRUNC EXPECT A REAL VALUE ON TOP
	;OF THE STACK AND RETURN AN INTEGER VALUE ON TOP OF
	;THE STACK.
	;
$$$099::;ROUND
	MOV	(SP),R0		;SAVE RETURN ADDRESS
	CLR	-(SP)		;LOWER HALF OF 0.5
	MOV	#40000,-(SP)	;UPPER HALF OF 0.5
	TST	4(SP)		;IS OPERAND NEGATIVE
	BGE	1$		;NO
	BIS	#100000,(SP)	;ADD -0.5 IF NEGATIVE
1$:	FADD	SP		;ADD TO PASSED VALUE TO ROUND
				;THE VALUE.
	MOV	R0,-(SP)	;REPLACE RETURN ADDRESS
	;FALL INTO TRUNC HERE
$$$098::;TRUNC
	CLR	6(SP)		;CLEAR INTEGER RESULT
	MOV	2(SP),-(SP)	;COPY HIGH PART OF VALUE
	BEQ	2$		;ZERO VALUE
	BIC	#100000,(SP)	;CLEAR SIGN BIT
	ASL	(SP)		;PLACE EXPONENT IN PROPER POSITION
	SWAB	(SP)		;IN LOWER BYTE OF WORD
	BIS	#200,4(SP)	;INSERT HIDDEN BIT IN FRACTION
	CMPB	#200,(SP)	;CHECK IF NUMBER IS A FRACTION
	BHIS	3$		;IT IS
	CMPB	#220,(SP)	;CHECK IF OVERFLOW
	BLE	5$		;NUMBER IS TOO LARGE
1$:	CMPB	#200,(SP)	;ARE WE DONE SHIFTING?
	BEQ	2$		;YES, FINISH UP
	ROL	6(SP)		;GET BIT FROM LOW FRACTION INTO CARRY BIT
	ROLB	4(SP)		;INSERT INTO HIGH FRACTION
				;AND GET IT'S HIGH BIT INTO CARRY BIT
	ROL	10(SP)		;INSERT HIGHEST FRACTION BIT INTO INTEGER RESULT
	DECB	(SP)		;DECREMENT EXPONENT
	BR	1$		;REPEAT
5$:	MOV	#77777,10(SP)	;LARGEST VALUE
2$:	TST	4(SP)		;WAS VALUE NEGATIVE?
	BPL	3$		;NO
	TST	10(SP)		;IS RESULT ZERO
	BEQ	3$		;YES, DO NOT NEGATE ZERO
	NEG	10(SP)		;YES, NEGATE RESULT
3$:	MOV	2(SP),6(SP)	;GET STACK READY FOR RETURN
	ADD	#6,SP		;;;
	RTS	PC		;RETURN
	.END
****
PSGN.MAC
	.TITLE	PSGN -- COMPUTE SIGN FOR NUMERIC VALUE
	.IDENT	/790717/
	.GLOBL $$$021
;
;	$$SGN: COMPUTE SIGN FOR NUMERIC VALUE
;  REGISTER USAGE
;	R0: SIGN ON RETURN; 0=PLUS, 1=MINUS
;	R1: POINTER TO FILE BLOCK
;
$$SGN::
	CLR	-(SP)
	CMPB	#'+,@(R1)
	BEQ	1$
	CMPB	#'-,@(R1)
	BNE	2$
	INC	(SP)		;MAKE IT MINUS
1$:	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;SKIP OVER SIGN CHARACTER
2$:	MOV	(SP)+,R0	;RETURN VALUE
	RTS	PC
	.END
****
PSINCO.MAC
	.TITLE P$SINCOS - SIN AND COS
	.IDENT	/790821/
; USAGE:
;	Y := COS(X);  Y := SIN(X)
;	REAL PARAMETER X ON TOP OF STACK
;	REAL RESULT RETURNED ON TOP OF STACK
; REGISTER USAGE:
;	R0,R1 - SCRATCH
;	R2,R3 - SCRATCH (SAVED/RESTORED)
;
; CALLS
;	$$$098		TRUNC
;	$$$201		FLOAT
	.GLOBL	$$$098,$$$201
;
$$$105::;COS(X)
	MOV	(SP)+,R0	;SAVE RETURN
	MOV	#7733,-(SP)	;PUSH PI/2
	MOV	#40311,-(SP)	;;
	FADD	SP		;SHIFT AXIS TO MAKE IT =SIN(X)
	MOV	R0,-(SP)	;RESTORE RETURN
;
$$$104::;SIN(X)
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	CLR	-(SP)		;MAKE ROOM FOR QUADRANT FLAG
	MOV	12(SP),-(SP)	;PUSH ARG
	MOV	12(SP),-(SP)	;;
	ASL	(SP)		;REMOVE AND SAVE SIGN
	ROR	4(SP)		;IN QUADRANT FLAG
	ROR	(SP)		;;
	MOV	#7733,-(SP)	;PUSH 2*PI
	MOV	#40711,-(SP)	;;
	FDIV	SP		;X/2*PI
	CLR	-(SP)		;SPACE FOR INTEGER
	MOV	4(SP),-(SP)	;COPY ARG
	MOV	4(SP),-(SP)	;;
	JSR	PC,$$$098	;TRUNC
	MOV	(SP),-(SP)	;SPACE FOR REAL
	MOV	(SP),-(SP)	;;
	JSR	PC,$$$201	;FLOAT - INTR(X/2PI)
	FSUB	SP		;FRACT(X/2PI)
	TST	(SP)		;CHECK FOR ZERO FRACTION
	BEQ	RTN		;QUIT NOW
	INCB	1(SP)		;4*FRACT(X/2PI)
	CLR	-(SP)		;SPACE FOR INTEGER
	MOV	4(SP),-(SP)	;COPY ARG
	MOV	4(SP),-(SP)	;;
	JSR	PC,$$$098	;TRUNC
	MOV	(SP),-(SP)	;SPACE FOR REAL
	MOV	(SP),-(SP)	;;
	JSR	PC,$$$201	;FLOAT - INTR(4*FRACT(X/2PI))
	BIS	(SP),8.(SP)	;SAVE QUADRANT NO.
	FSUB	SP		;Y=FRACT(4*FRACT(X/2PI))
	TSTB	4(SP)		;TEST QUADRANT
	BEQ	1$		;FIRST OR THIRD QUAD
	ADD	#100000,(SP)	;NEGATE STACK ITEM
	CLR	-(SP)		;PUSH 1.
	MOV	#40200,-(SP)	;;
	FADD	SP		;X=1.-X
	BR	2$
1$:	ASRB	5(SP)		;TEST QUADRANT
	BCC	2$		;FIRST OR SECOND QUAD
	ADD	#100000,(SP)	;NEGATE STACK ITEM
2$:	MOV	2(SP),-(SP)	;COPY ARG
	MOV	2(SP),-(SP)	;;
	MOV	2(SP),-(SP)	;COPY ARG
	MOV	2(SP),-(SP)	;;
	FMUL	SP		;SQUARE IT
	MOV	(SP)+,R0	;SAVE Y*Y
	MOV	(SP)+,R1	;;
	MOV	#CONSTS+4,R2	;POINT TO LIST OF COEFFICIENTS
	MOV	#5,R3		;LOOP 5
	BR	4$
3$:	MOV	R1,-(SP)	;PUSH Y*Y
	MOV	R0,-(SP)	;;
4$:	MOV	-(R2),-(SP)	;PUSH COEFFICIENT
	MOV	-(R2),-(SP)	;;
	SOB	R3,3$		;LOOP
	MOV	#4,R3		;LOOP 4
5$:	FMUL	SP		;COMPUTE POLYNOMIAL
	FADD	SP		;;
	SOB	R3,5$		;;LOOP
	FMUL	SP		;;
RTN:	MOV	(SP)+,12(SP)	;POP RESULT
	MOV	(SP)+,12(SP)	;;
	TST	(SP)+		;POP QUADRANT FLAG
	BGE	6$
	ADD	#100000,6(SP)	;NEGATE RESULT
6$:	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	RTS	PC
	.WORD	035036,153672	;.00015148419
	.WORD	136231,023143	;-.00467376557
	.WORD	037243,032130	;.0796896793
	.WORD	140045,056741	;-.645963711
CONSTS:	.WORD	040311,007733	;1.570796318
	.END
****
PSPCE.MAC

	.TITLE	PSPCE -- SKIP OVER LEADING CTRL CHARS AND SPACES
	.IDENT	/790717/
;	$$SPCE:	SKIP OVER LEADING CTRL CHARS AND SPACES
; REGISTER USAGE
;	R0: SCRATCH
;	R1: POINTER TO FILE BLOCK
;
	.GLOBL	$$$021,EOF,EOFF
$$SPCE::
	CMPB	#' ,@(R1)	;SKIP OVER SPACES AND CONTROL CHARS
	BLO	1$
	MOV	R1,-(SP)
	MOV	#1,-(SP)
	JSR	PC,$$$021	;BUMP TO NEXT CHARACTER
	BITB	#EOF,EOFF(R1)	;EOF SET?
	BNE	1$		;YES, ABORT SCAN
	BR	$$SPCE
1$:	RTS	PC
	.END
****
PSQRT.MAC
	.TITLE P$SQRT - SQUARE ROOT
	.IDENT	/790802/
	.MCALL	.PRINT
; USAGE:
;	Y := SQRT(X)
;	REAL PARAMETER X ON TOP OF STACK
;	  ASSUME HIGH PART AT SP+2 AND LOW AT SP+4
;	REAL RESULT RETURNED ON TOP OF STACK
; REGISTER USAGE:
;	R0,R1 - SCRATCH
;
$$$101::
	TST	2(SP)		;HIGH ORDER ARG
	BMI	3$		;ARGUMENT MUST BE >= 0
	BEQ	ZERSQR		;ZERO RESULT
	MOV	4(SP),-(SP)	;COPY THE LOW PART TO TOS
	MOV	4(SP),-(SP)	;COPY HIGH PART
	ASR	(SP)
	ADD	#020100,(SP)	;INITIAL ESTIMATE OF E
	MOV	#3,R0		;SET ITERATION COUNTER
2$:	MOV	10(SP),-(SP)	;GET WORKING COPY OF THE ARG
	MOV	10(SP),-(SP)	;HIGH PART
	MOV	6(SP),-(SP)	;WORKING COPY OF E
	MOV	6(SP),-(SP)
	FDIV	SP		;X/E
	FADD	SP		;X/E + E
	CLR	-(SP)		;
	MOV	#040400,-(SP)	;LOAD 2.0
	FDIV	SP		;(X/E+E)/2.0
	SOB	R0,2$
	BR	ENDSQT
3$:	.PRINT	#NSQRER		;ERROR , SQRT OF A NEGATIVE
	CLR	2(SP)		;RETURN ZERO
	CLR	4(SP)		;HIGH PART ZERO
	RTS	PC
ENDSQT:	MOV	(SP)+,4(SP)	;RETURN HIGH PART
	MOV	(SP)+,4(SP)	;RETURN LOW PART
ZERSQR:				;SQRT OF 0 IS 0
	RTS	PC
NSQRER:	.ASCIZ/? FSQRT  ATTEMPT TO TAKE SQRT OF NEGATIVE NUMBER/
	.END
****
PWBOOL.MAC
	.TITLE	PWBOOL - WRITE BOOLEAN(@FILEVAR,BOOLEAN,FIELD WIDTH)
	.IDENT	/780705/
;  PARMS
;	1. POINTER TO FILE BLOCK
;	2. BOOLEAN VALUE
;	3 FIELD WIDTH
;  REGISTERS
;
;  CALLS: $$$027 (MODIFIES STACK AND FAKES A CALL)
	.GLOBL	$$$027
$$$029::
	MOV	(SP),-(SP)	;JACK UP RETURN ADDRESS
	MOV	4(SP),2(SP)	;MOVE UP FIELD WIDTH
	MOV	#5,4(SP)	;STRING LENGTH 5
	TST	6(SP)		;CHECK WHICH STRING
	BEQ	1$		; TO PRINT
	MOV	#TSTR,6(SP)	; "TRUE"
	BR	2$
1$:	MOV	#FSTR,6(SP)	; "FALSE"
2$:	JMP	$$$027		;PRINT THE STRING
TSTR:	.ASCII	/TRUE /
FSTR:	.ASCII	/FALSE/
	.END
****
PWEOLN.MAC
	.TITLE	PWEOLN - WRITEENDOFLINE( @FILEVAR )
	.IDENT	/790717/
	.GLOBL P$FPUT
; PARMS
;	1. POINTER TO FILE BLOCK
; REGISTER USAGE
;	R0: SCRATCH
;	R1: POINTER TO FILE BLOCK
; CALLS: P$FPUT
;
$$$045::
	MOV	2(SP),R1	;POINTER TO FILE BLOCK
	MOV	(SP)+,(SP)	;MOVE DOWN RETURN ADDRESS
	MOVB	#15,@(R1)	;SYSTEM LIKES TO SEE A
	MOV	#1,R0		;...CR BEFORE EVERY LF
	JSR	PC,P$FPUT
1$:	MOVB	#12,@(R1)	;INSERT LF IN BUFFER
	MOV	#1,R0
	JMP	P$FPUT		;JMP INSTEAD OF JSR, RTS
	.END
****
PWEXP.MAC
	.TITLE	PWEXP - WRITE SHORT EXPONENTIAL
	.IDENT	/790822/
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. REAL VALUE
;	3. FIELD WIDTH
; REGISTER USAGE
;	R1:	@FILEBLOCK, @BUFFER
;	R0:	SCRATCH
;	R2:	SCRATCH
;	R3:	@BUFFER, SCRATCH
;	R4:	SCRATCH
; CALLS: P$FPUT,$$$098(TRUNC),$$$201(FLOAT)
;
	.GLOBL	P$FPUT,$$$098,$$$201
$$$041::
	MOV	8.(SP),R1	;SWAP @FILEVAR
	MOV	(SP),8.(SP)	; WITH THE RETURN ADDRESS
	MOV	R1,(SP)
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	R4,-(SP)	;SAVE R4
	MOV	SP,R3		;R3 -> END OF BUFFER+1
	SUB	#BSIZ,SP	;MAKE ROOM FOR BUFFER IN STACK
	MOV	SP,R1		;R1 -> START OF BUFFER
	SUB	#10,SP
	MOV	22+BSIZ(SP),4(SP)
	MOV	24+BSIZ(SP),6(SP)
	CLR	R2		;CLEAR EXPONENT
	CLR	SIGN		;ASSUME > 0.0
	TST	4(SP)
	BGT	1$		;IF > 0.0
	BEQ	3$		;IF = 0.0
	BIC	#100000,4(SP)	;R<0.0  MAKE IT POSITIVE
	INC 	SIGN		;MAKE < 0.0
1$:	MOV	6(SP),2(SP)	;SAVE NUMBER FOR LATER
	MOV	4(SP),(SP)
	CLR	-(SP)
	MOV	#ONE,-(SP)	;IS NUMBER < 1.0
	FSUB	SP
	TST	(SP)
	BLT	2$		;YES, NUMBER < 1.0
	INC	R2		;NO, INCREMENT EXPONENT
	MOV	6(SP),-(SP)	;DIVIDE NUMBER BY 10
	MOV	6(SP),-(SP)
	MOV	#146315,-(SP)
	MOV	#37314,-(SP)
	FMUL	SP
	MOV	(SP)+,6(SP)
	MOV	(SP)+,6(SP)
	BR	1$		;CONTINUE LOOP
2$:	MOV	6(SP),2(SP)	;SAVE NUMBER FOR LATER
	MOV	4(SP),(SP)
	MOV	#146315,-(SP)
	MOV	#37314,-(SP)	;IS NUMBER >= 0.1
	FSUB	SP
	TST	(SP)
	BGE	3$		;YES, NUMBER >= 0.1
	DEC	R2		;NO, DECREMENT EXPONENT
	MOV	6(SP),-(SP)
	MOV	6(SP),-(SP)
	CLR	-(SP)
	MOV	#TEN,-(SP)	;MULTIPLY NUMBER BY 10
	FMUL	SP
	MOV	(SP)+,6(SP)
	MOV	(SP)+,6(SP)
	BR	2$		;CONTINUE LOOP
3$:	MOV	R2,EXP		;SAVE EXPONENT
	MOV	20+BSIZ(SP),R4	;GET FIELDWIDTH FROM STACK
	SUB	#7,R4		;IS IT > 7
	BGT	4$		;YES
	MOV	#7,R4		;NO, SET IT TO DEFAULT (7)
4$:	INC	R4		;ALLOW FOR EXTRA DIGIT
	MOV	R4,NRDIG	;SAVE NUMBER OF DIGITS IN FRACTION
5$:	MOV	6(SP),-(SP)
	MOV	6(SP),-(SP)
	CLR	-(SP)
	MOV	#TEN,-(SP)
	FMUL	SP
	CLR	-(SP)
	MOV	4(SP),-(SP)
	MOV	4(SP),-(SP)
	JSR	PC,$$$098
	MOV	(SP),R0
	MOV	(SP),-(SP)
	MOV	(SP),-(SP)
	JSR	PC,$$$201
	FSUB	SP
	MOV	(SP)+,6(SP)
	MOV	(SP)+,6(SP)
	ADD	#'0,R0		;CONVERT DIGIT TO CHARACTER
	MOVB	R0,(R1)+	;PUT DIGIT INTO BUFFER
	SOB	R4,5$		;ANY DIGITS LEFT
	ADD	#10,SP
	MOV	R1,R2		;SAVE CURRENT DIGIT POINTER
	DEC	R2		;SHOULD POINT AT LAST DIGIT
	MOV	NRDIG,R4	;GET NUMBER OF DIGITS
	MOVB	(R2),R1		;GET LAST (EXTRA) DIGIT
	ADD	#5,R1		;ROUND IT UP
	MOVB	R1,(R2)		;PUT IT BACK IN THE BUFFER
6$:	CMPB	(R2),#'9	;DIGIT > 9?
	BLE	7$		;NO, ROUNDING UP IS DONE
	MOVB	#'0,(R2)	;MAKE DIGIT A ZERO
	INCB	-(R2)		;AND PROPAGATE CARRY, WHILE BACKING UP 
	SOB	R4,6$		;PTR, CONTINUE FOR WHOLE STRING
7$:	MOV	NRDIG,R4	;GET NUMBER OF DIGITS
	MOV	6+BSIZ(SP),R1	;GET FILE VARIABLE
	MOVB	#' ,@(R1)	;PRINT THE
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;LEADING BLANK
	TST	SIGN		;IS THE NUMBER NEGATIVE
	BEQ	8$		;IF NO, THEN
	MOVB	#'-,@(R1)	;PRINT A '-'
	BR	9$		;ELSE
8$:	MOVB	#' ,@(R1)	;PRINT A ' '
9$:	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;PRINT THE SIGN CHARACTER
	MOV	SP,R3		;R3 -> START OF BUFFER
	MOVB	(R3)+,@(R1)	;GET THE FIRST DIGIT
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;AND PRINT IT
	DEC	R4		;DECREMENT COUNT OF NUMBER OF DIGITS
	MOVB	#'.,@(R1)	;PRINT A '.'
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;IN FRONT OF THE NUMBER
	DEC	R4		;DON'T PRINT EXTRA DIGIT
	TST	R4		;CHECK TO SEE IF WE ARE TO PRINT
	BLE	13$		;A FRACTIONAL PART
10$:	MOVB	(R3)+,@(R1)	;GET DIGIT
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;PRINT CHARACTER
	SOB	R4,10$		;CONTINUE FOR ALL DIGITS
13$:	MOVB	#'E,@(R1)	;PRINT THE 'E'
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;NEXT
	MOV	EXP,R4		;GET EXPONENT
	DEC	R4		;ACCOUNT FOR DIGIT BEFORE THE '.'
	BLT	11$		;IS EXPONENT NEGATIVE
	MOVB	#'+,@(R1)	;NO, '+' SIGN TO BE PRINTED
	BR	12$		;ELSE
11$:	MOVB	#'-,@(R1)	;'-' SIGN TO BE PRINTED
	NEG	R4		;MAKE EXPONENT POSITIVE
12$:	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;PRINT THE SIGN OF THE EXPONENT
	MOV	R4,R3		;SAVE EXPONENT FOR LATER
	CLR	R2		;GET FIRST DIGIT
	DIV	#10.,R2		;OF EXPONENT
	ADD	#'0,R2		;CONVERT IT TO CHARACTER
	MOVB	R2,@(R1)	;PRINT THE FIRST
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;DIGIT OF THE EXPONENT
	SUB	#'0,R2		;CONVERT THE FIRST DIGIT BACK TO INTEGER
	MOV	R2,R3		;PREPARE FOR MULTIPLY
	MUL	#10,R3		;GET THE SECOND
	SUB	R3,R4		;DIGIT OF THE EXPONENT
	ADD	#'0,R4		;CONVERT IT TO CHARACTER
	MOVB	R4,@(R1)	;PRINT THE SECOND
	MOV	#1,R0		;(ONE CHARACTER)
	JSR	PC,P$FPUT	;DIGIT OF THE EXPONENT
	ADD	#BSIZ,SP	;ERASE THE BUFFER
	MOV	(SP)+,R4	;RESTORE R4
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	ADD	#10,SP
	RTS	PC		;RETURN
BSIZ = 40.
ONE = 40200
TEN = 41040
	.PSECT	$VARBL
SIGN:	.WORD	0
NRDIG:	.WORD	0
EXP:	.WORD	0
	.END
****
PWINTG.MAC
	.TITLE	PWINTG - WRITE INTEGER
	.IDENT	/790717/
	.GLOBL P$FPAD,P$FPUT
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. INTEGER TO BE OUTPUT
;	3. WIDTH OF FIELD
; REGISTER USAGE
;	R0 - INPUT VALUE
;	R1 -> FILE BLOCK
;	R2 -> CONVERTED STRING
;	R3 - WIDTH, PAD CHAR TO P$FPAD
;	R4 - NOT USED
; CALLS: P$FPAD, P$FPUT
;
$$$031::
	MOV	6(SP),R1	; UNPACK STACK FRAME;  -> FILE BLOCK
	MOV	(SP)+,4(SP)	; RETURN ADDRESS
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	SP,R0		;R0 -> LOCAL WORK SPACE
	SUB	#6,SP		;SIZE OF WORKSPACE = 6 BYTES
	MOV	12.(SP),R2	;R2 = VALUE TO BE PRINTED
	BGE	1$
	NEG	R2		;GET ABSOLUTE VALUE
1$:	MOV	R2,R3		;PREPARE FOR DIVIDE
	CLR	R2
	DIV	#10.,R2		;DIVIDE VALUE BY 10
	ADD	#'0,R3		;MAKE ASCII DIGIT OF REMAINDER
	MOVB	R3,-(R0)	;STORE IT IN WORKSPACE
	TST	R2		;IS ANYTHING LEFT
	BNE	1$		;YES, LOOP ON
	TST	12.(SP)		;WAS ORINGINAL VALUE <0
	BGE	2$
	MOVB	#'-,-(R0)	;YES, MOVE IN A MINUS SIGN
2$:	MOV	10.(SP),R3	;GET FIELD LENGTH
	MOV	SP,R2		;COMPUTE LENGTH OF STRING BUILT
	ADD	#6,R2
	SUB	R0,R2		;R2 = LENGTH OF STRING
	MOV	R0,-(SP)	;SAVE POINTER TO STRING
	MOV	R2,-(SP)	;SAVE LENGTH OF STRING
	SUB	R2,R3		;COMPUTE PADDING NEEDED
	BLE	3$		;BRANCH IF NONE NEEDED
	MOVB	#40,R2
	MOV	R3,R0
	JSR	PC,P$FPAD	;OUTPUT PAD CHARACTERS
3$:	MOV	(SP)+,R3	;RESTORE LENGTH OF STRING TO R3
	MOV	(SP)+,R2	;RESTORE ADDRESS OF STRING TO R2
4$:	MOVB	(R2)+,@(R1)	;PUT OUT STRING
	MOV	#1,R0
	JSR	PC,P$FPUT
	SOB	R3,4$
5$:	ADD	#6,SP		;DELETE WORKSPACE
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	CMP	(SP)+,(SP)+	;POP OFF REMAINING PARAMTERS
	RTS	PC
	.END
****
PWOCTL.MAC
	.TITLE	PWOCTL - WRITE OCTAL
	.IDENT	/791112/
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. INTEGER TO BE OUTPUT
;	3. WIDTH OF FIELD (>= 6)
; REGISTER USAGE
;	R0 - PAD COUNT
;	R1 -> FILE BLOCK
;	R2 - PAD CHARACTER, VALUE TO CONVERT
;	R3 - LOOP COUNT
;	R4 - NOT USED
; CALLS: P$FPAD, P$FPUT
	.GLOBL	P$FPAD,P$FPUT
;
$$$039::
	MOV	6(SP),R1	; UNPACK STACK FRAME; -> FILE BLOCK
	MOV	(SP)+,4(SP)	; RETURN ADDRESS
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	R4,-(SP)	;SAVE R4
	MOV	6(SP),R0	; WIDTH OF FIELD
	BLE	2$
	SUB	#6,R0
	BGT	1$		; PAD WITH BLANKS
	BEQ	2$		; NO PADDING
	MOV	#'*,R2		; PAD WITH *'S
	NEG	R0
	JSR	PC,P$FPAD
	BR	3$
1$:	MOV	#' ,R2
	JSR	PC,P$FPAD	; OUTPUT BLANKS
2$:	MOV	#6,R4
	MOV	8.(SP),R3	; INTEGER VALUE
	CLR	R2
	ASHC	#1,R2		; 1ST DIGIT IS ONE BIT
4$:	ADD	#'0,R2		; CONVERT TO DIGIT
	MOVB	R2,@(R1)
	MOV	#1,R0		; UPDATE ONE BYTE
	JSR	PC,P$FPUT
	CLR	R2
	ASHC	#3,R2		; NEXT DIGIT
	SOB	R4,4$
3$:	MOV	(SP)+,R4	;RESTORE R4
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	CMP	(SP)+,(SP)+	;POP OFF PARAMETERS
	RTS	PC
	.END
****
PWREAL.MAC
	.TITLE	PWREAL - WRITESHORTFLOATING(@FILEVAR,REAL,FIEDLWIDTH,FRACTIONWIDTH)
;  PARMS
;	1. POINTER TO FILE BLOCK
;	2. REAL VALUE (SINGLE)
;	3. FIELD WIDTH
;	4. FRACTION WIDTH
;  REGISTER USAGE
;	R1: POINTER TO FILE BLOCK
;	R0,R2,R3,R4: SCRATCH
;
;	CALLS
;	P$FPAD
;	P$FPUT
;	$$$098	TRUNC
;	$$$201	FLOAT
	.GLOBL	P$FPAD,P$FPUT,$$$098,$$$201
$$$035::
	MOV	10.(SP),R1	;SWAP @FILEVAR
	MOV	(SP),10.(SP)	; WITH THE
	MOV	R1,(SP)		; RETURN ADDRESS
	MOV	R2,-(SP)	;SAVE R2
	MOV	R3,-(SP)	;SAVE R3
	MOV	R4,-(SP)	;SAVE R4
	MOV	SP,R3		;R3 -> END OF BUFFER+1
	SUB	#BSIZ,SP	;MAKE ROOM FOR BUFFER IN STACK
	MOV	SP,R1		;R1 -> START OF BUFFER
	SUB	#14,SP
	CLR	SIGN		;ASSUME>0.0
	MOV	32+BSIZ(SP),2(SP)
	MOV	30+BSIZ(SP),(SP)
	BGT	1$		;IF > 0.0
	BEQ	4$		;IF = 0.0
	BIC	#100000,(SP)	;R < 0.0 MAKE IT POSITIVE
	INC	SIGN		;MAKE < 0.0
1$:	CLR	-(SP)
	MOV	4(SP),-(SP)
	MOV	4(SP),-(SP)
	JSR	PC,$$$098
	MOV	(SP),-(SP)
	MOV	(SP),-(SP)
	JSR	PC,$$$201
	MOV	SP,R4
	FSUB	R4
	MOV	(SP)+,6(SP)
	MOV	(SP)+,6(SP)
	TST	4(SP)
	BEQ	5$		;IT IS
	CLR	R2		;R2 = NR DIGITS IN INTEGER PART
	MOV	(SP),10(SP)
	MOV	2(SP),12(SP)
	MOV	4(SP),(SP)
	MOV	6(SP),2(SP)
2$:	MOV	#146315,-(SP)	;PUSH 0.1
	MOV	#37314,-(SP)
	FMUL	SP
	CLR	-(SP)
	MOV	4(SP),-(SP)
	MOV	4(SP),-(SP)
	JSR	PC,$$$098
	MOV	(SP),-(SP)
	MOV	(SP),-(SP)
	JSR	PC,$$$201
	MOV	SP,R4
	FSUB	R4
	MOV	(SP)+,6(SP)
	MOV	(SP)+,6(SP)
	MOV	2(SP),-(SP)
	MOV	2(SP),-(SP)
	MOV	12(SP),6(SP)
	MOV	10(SP),4(SP)
	CLR	-(SP)
	MOV	#NOISE,-(SP)	;BECAUSE 0.1 IS NOTERMINATING BINARY
	FADD	SP
	CLR	-(SP)
	MOV	#TEN,-(SP)
	FMUL	SP
	MOV	(SP),-(SP)
	MOV	4(SP),2(SP)
	JSR	PC,$$$098
	MOV	(SP)+,R0
	ADD	#'0,R0
	MOVB	R0,-(R3)	;PUT INTO BUFFER BACKWARDS
	INC	R2		;BUMP INTEGER FIELD COUNTER
	TST	(SP)		;ANYTHING LEFT IN INTEGER PART?
	BNE	2$		;IF SO, CONTINUE
	MOV	R2,R0		;NUMBER OF DIGITS PRODUCED SO FAR
3$:	MOVB	(R3)+,(R1)+	;MOVE THEM TO HEAD OF BUFFER
	SOB	R0,3$
	MOV	12(SP),2(SP)	;RESTORE FRACTIONAL PART
	MOV	10(SP),(SP)
	BR	5$
4$:	INC	R2		;R = 0.0
	MOVB	#'0,(R1)+
5$:	MOV	24+BSIZ(SP),R4	;NR FRACTIONAL DIGIST REQUESTED
	BLE	7$
	INC	R4		;MAKE ONE MORE FOR ROUND UP
	MOV	R4,NRDIG	;AND SAVE FOR LATER
6$:	CLR	-(SP)
	MOV	#TEN,-(SP)
	FMUL	SP
	CLR	-(SP)
	MOV	4(SP),-(SP)
	MOV	4(SP),-(SP)
	JSR	PC,$$$098
	MOV	(SP),R0
	MOV	(SP),-(SP)
	MOV	(SP),-(SP)
	JSR	PC,$$$201
	FSUB	SP
	ADD	#'0,R0
	MOVB	R0,(R1)+
	SOB	R4,6$
7$:	ADD	#14,SP		;REMOVE TEMPORARY SPACE
	TST	NRDIG		;FRACTIONAL PART?
	BLE	9$		; NO
	MOV	R1,R2		;SAVE PTR TO LAST DIGIT
	MOV	R1,R4
	SUB	SP,R4		;COMPUTE TOTAL DIGITS
	MOVB	(R2),R0		;GET LAST (EXTRA) DIGIT
	ADD	#5,R0		;ROUND IT UP
	MOVB	R0,(R2)		; AND REPLACE
8$:	CMPB	(R2),#'9	;BIGGER THAN A NINE?
	BLE	9$		; NO ROUND UP DONE
	MOVB	#'0,(R2)	;MAKE THIS A ZERO AND
	INCB	-(R2)		; PROPAGATE CARRY, WHILE BACKING
	SOB	R4,8$		; UP PTR; DO THE WHOLE STRING
9$:	MOV	R1,R4		;CALCULATE NR CHARS IN BUFFER
	SUB	SP,R4
	MOV	6+BSIZ(SP),R1	;R1 -> FILE VARIABLE
	MOV	12+BSIZ(SP),R0
	SUB	R4,R0		;COMPUTE PAD COUNT
	TST	SIGN		;AND POSSIBLE SIGN
	BEQ	10$
	DEC	R0
10$:	MOV	#' ,R2
	JSR	PC,P$FPAD	;PAD WITH BLANKS
	MOV	SP,R3		;START OF BUFFER
	TST	SIGN
	BEQ	11$		;SIGN?
	MOVB	#'-,@(R1)	;YES.. WRITE IT OUT
	MOV	#1,R0
	JSR	PC,P$FPUT
11$:	SUB	NRDIG,R4	;COMPUTE LENGTH OF INTEGER PART
	BLE	12$		;NONE
	JSR	PC,$$ODIG	;WRITE OUTTHE STING OF DIGITS
12$:	MOVB	#56,@(R1)	;PUT OUT '.'
	MOV	#1,R0
	JSR	PC,P$FPUT
	MOV	NRDIG,R4
	DEC	R4		;ACCOUNT FOR EXTRA DIGIT
	BLE	13$		;THERE IS NO FRACTIONAL PART
	JSR	PC,$$ODIG	;OUTPUT FRACTIONAL PART
13$:	ADD	#BSIZ,SP
	MOV	(SP)+,R4	;RESTORE R4
	MOV	(SP)+,R3	;RESTORE R3
	MOV	(SP)+,R2	;RESTORE R2
	ADD	#12,SP
	RTS	PC
	.PAGE
;
;	$$ODIG: WRITE OUT A STRING OF DIGITS
; REGISTER USAGE
;	R1: POINTER TO FILE BLOCK
;	R0: SCRATCH
;	R3: @BUFFER
;	R4: BUFFER LENGTH
;
$$ODIG::
	MOVB	(R3)+,@(R1)
	MOV	#1,R0
	JSR	PC,P$FPUT
	SOB	R4,$$ODIG
	RTS	PC
;
;
NOISE = 37114		;LARGEST WORD LESS THAN 0.05
BSIZ = 40.		;MAX NR DIGITS BEFORE DECIMAL POINT +1
ONE = 40200		; 1.0
TEN = 41040		; 10.0
	.PSECT	$VARBL
SIGN:	.WORD	0	;FLAG FOR PRESENCE OF MINUS SIGN ON OUTPUT
NRDIG:	.WORD	0	;LOCAL STORAGE FOR NUMBER OF DIGITS IN FRACTION
	.END
****
PWSTRG.MAC
	.TITLE	PWSTRG - WRITE STRING
	.IDENT	/790717/
	.GLOBL	P$FPAD,P$FPUT
; PARMS
;	1. POINTER TO FILE BLOCK
;	2. POINTER TO STRING
;	3. LENGTH OF STRING
;	4. WIDTH OF FIELD
; REGISTER USAGE
;	R0 - SCRATCH
;	R1 -> FILE BLOCK
;	R2 - HOLDS PAD CHAR TO P$FPAD
;	R3 - SIZE OF BUFFER VARIABLE
;	R4 - NOT USED
; CALLS: P$FPUT,P$FPAD
; RASH ASSUMPTION: P$FPUT DOES NOT DISTURB R2,R3
;
$$$027::
	MOV	8.(SP),R1	;POINTER TO FILE BLOCK
	MOV	(SP)+,6(SP)	;PUSH DOWN RETURN ADDRESS
;
	TST	(SP)		;WIDTH > 0?
	BGT	1$
;
	MOV	2(SP),(SP)	;NO, MAKE IT SAME AS LENGTH
1$:	SUB	2(SP),(SP)	;WIDTH NOW IS NR OF BLANKS FOR PADDING
	BGE	4$
	ADD	(SP),2(SP)	;LENGTH IS NOW FIELD WIDTH
4$:
	MOV	2(SP),R0	;GET LENGTH
	BLT	2$		;IF LENGTH <= 0, SKIP STRING OUTPUT
;
	MOV	R3,-(SP)	;SAVE R3
	MOV	R0,R3
3$:	MOVB	@6(SP),@(R1)	;MOVE A CHAR
	INC	6(SP)		;BUMP POINTER
	MOV	#1,R0		;AND PUT
	JSR	PC,P$FPUT
	SOB	R3,3$
	MOV	(SP)+,R3	;RESTORE R3
;
2$:
	MOV	(SP)+,R0	;GET WIDTH OF PAD
	CMP	(SP)+,(SP)+	;DISCARD LENGTH AND POINTER TO STRING
	MOV	R2,-(SP)	;SAVE R2
	MOV	#' ,R2		; PAD CHAR IS BLANK
	JSR	PC,P$FPAD	;OUTPUT TRAILING BLANKS (IF ANY)
	MOV	(SP)+,R2	;RESTORE R2
;
	RTS	PC
	.END
****
                                                                                                                                                                                                                                                                                                                                                                                                                                         