C GAUSS.FTN   --   PDP-11 FORTRAN BENCHMARK
      DIMENSION Y(6),UP(5)
      COMMON /EVERY/ R,BET,E,VE,AH,XU,XL
      COMMON /LUNS/ ICRD,ILPT,IKBD,ITTY
      R = 24.84375
      BET = 0.850
      E = 0.0174533
      UP(1) = 41.67
      UP(2) = 138.33
      UP(3) = 221.67
      UP(4) = 318.33
      UP(5) = 360.00
      VE = 13.5/R
      VE = VE*VE
      AH = 12.0/R
      AH = AH*AH
      WRITE(ITTY,40)
C     ***** BEGINNING OF TIMED INTERVAL *****
            CALL TIMRB
      DO 7 JK=1,100
      Y(6) = 0.0
      XL = 0.0
      DO 1 I=1,4,2
      XU = UP(I)
      CALL GAS(Z)
      Y(I) = Z
      XL = XU
      XU = UP(I+1)
      CALL GAST(W)
      Y(I+1) = W
      XL = XU
 1    CONTINUE
      XU = UP(5)
      CALL GAS(Z)
      Y(5) = Z
      DO 2 I=1,5
      Y(6) = Y(6) + Y(I)
 2    CONTINUE
      ANM = (1.0 - BET*BET)/(6.28318536*BET)
      Y(6) = ANM*Y(6)
 7    CONTINUE
C     ***** END OF TIMED INTERVAL       *****
            CALL TIMRE
      WRITE(ITTY,30)
 30   FORMAT(7X,' THE SIX Y VALUES ARE:'//)
 20   FORMAT(3(3X,E13.7)/)
      WRITE(ITTY,20) Y
 40   FORMAT(' 10 POINT GAUSSIAN QUADRATURE NUMERICAL INTEGRATION')
      STOP
      END
      SUBROUTINE GAS(Y)
      COMMON /EVERY/ R,BET,E,VE,AH,XU,XL
      EXTERNAL FUN
      A = 0.5*(XU + XL)
      B = XU - XL
      C = 0.4869533*B
      AD = FUN(A+C,E,VE,BET) + FUN(A-C,E,VE,BET)
      Y = 0.03333567*AD
      C = 0.4325317*B
      AD = FUN(A+C,E,VE,BET) + FUN(A-C,E,VE,BET)
      Y = Y + 0.07472567*AD
      C = 0.3397048 * B
      AD = FUN(A+C,E,VE,BET) + FUN(A-C,E,VE,BET)
      Y = Y + 0.1095432*AD
      C = 0.2166977*B
      AD = FUN(A+C,E,VE,BET) + FUN(A-C,E,VE,BET)
      Y = Y + 0.1346334*AD
      C = 0.07443717*B
      AD = FUN(A+C,E,VE,BET) + FUN(A-C,E,VE,BET)
      Y = B*E*(Y + 0.1477621*AD)
      RETURN
      END
      SUBROUTINE GAST(W)
      COMMON /EVERY/ R,BET,E,VE,AH,XU,XL
      EXTERNAL FTC
      A = 0.5*(XU + XL)
      B = XU - XL
      C = 0.4869533*B
      AB = FTC(A+C,E,AH,BET) + FTC(A-C,E,AH,BET)
      W = 0.03333567*AB
      C = 0.4325317*B
      AB = FTC(A+C,E,AH,BET) + FTC(A-C,E,AH,BET)
      W = W + 0.07472567*AB
      C = 0.3397048*B
      AB = FTC(A+C,E,AH,BET) + FTC(A-C,E,AH,BET)
      W = W + 0.1095432*AB
      C = 0.2166977*B
      AB = FTC(A+C,E,AH,BET) + FTC(A-C,E,AH,BET)
      W = W + 0.1346334*AB
      C = 0.07443717*B
      AB = FTC(A+C,E,AH,BET) + FTC(A-C,E,AH,BET)
      W = B*E*(W + 0.1477621*AB)
      RETURN
      END
      FUNCTION FUN(X,E,VE,BET)
      F = COS(E*X)
      FUN = 1.0/(1.0 - BET*F/SQRT(F*F + VE))
      RETURN
      END
      FUNCTION FTC(X,E,AH,BET)
      G = SIN(E*X)
      FTC = 1.0/(1.0 - BET*G/SQRT(G*G + AH))
      RETURN
      END
                                                                                                                                                                                                                                                                                               