	SUBROUTINE DEFINE(INM,ONM)
C          **************************************************
C          *                                                *
C          *               S U P E R - M A C                *
C          *                                                *
C          *                  PREPROCESSOR                  *
C          *                                                *
C          *                 FORTRAN VERSION                *
C          *                                                *
C          *     AUTHORS:        Thomas J. Weslowski        *
C          *                     Computer Science Dept.     *
C          *                     SUNY at Oswego             *
C          *                     Oswego, NY  13126          *
C          *                                                *
C          *                     and                        *
C          *                                                *
C          *                     Richard R. DeMidio         *
C          *                     Instructional Comp. Ctr.   *
C          *                     Snygg Hall                 *
C          *                     SUNY at Oswego             *
C          *                     Oswego, NY  13126          *
C          *                                                *
C          *     MAINTAINER:     Edward F. Beadel, Jr.      *
C          *                     Manager                    *
C          *                     Instructional Comp. Ctr.   *
C          *                     Snygg Hall                 *
C          *                     SUNY at Oswego             *
C          *                     Oswego, NY  13126          *
C          *                                                *
C          *     PHONE:          (315) 341-3305             *
C          *                                                *
C          **************************************************
C
C
C                    COPYRIGHT (c) 1981, 1982, 1983
C                                  BY
C                    Instructional Computing Center
C                State University of New York at Oswego
C                          Oswego, NY   13126
C
C               contact:	Edward F. Beadel, Jr., Manager
C                         phone:		315/341-3055
C
C
C          This software is furnished in an as-is  condition,
C          with  no committments of support or updates.  This
C          software or any other copies thereof  may  NOT  be
C          sold  for  profit  nor  can  it be included in any
C          package to be sold for profit without the  written
C          consent  of  the  author and the coppyright owner.
C          This software may be used and copied only  in  ac-
C          cordance  with  the terms set forth above and with
C          the inclusion of the above copyright notice.
C
C               The information in this software  is  subject
C          to  change  without  notice and should not be con-
C          strued as a commitment by The State University  of
C          New  York, The C.A.U.S.E.  Instructional Computing
C          Center, the author(s)  or  maintainer(s)  of  this
C          software.
C
C               The  State  University  of  New   York,   The
C          C.A.U.S.E.   Instructional  Computing  Center, the
C          author(s), and the maintainer(s) of this  software
C          collectively  and individually assume no responsi-
C          bility  for  the  use  or  reliability   of   this
C          software.
C
C
C


C	   This one involves a little more work than includ.
C	The routine will process all # Define directives.
C	All this involves is a simple substitution of code 
C	for each define option.

C	DEFINE declarations

	BYTE INST(80),STK(10,10),DNM(12),CODE(80,20)
	BYTE CSTR(80),EMITS(80),OUTSTR(30)
	INTEGER STKPTR,INM,ONM,CODPTR,TMP,P
	LOGICAL DFLAG,COMPRS

C	DEFINE code

1	DFLAG=.FALSE.
	STKPTR=1
	CODPTR=1

C	    Set up input and output files and set our flag

C	   This scheme will consist of first finding a # define,
C	then building up an array which will store all the in-
C	structions, then searching throughout the file for the
C	references to the define, and finally substituting the
C	code for the define.  After which the files will be reset
C	and another define looked for.

2	CALL GETSTR(INM,INST,79,ERR)
	IF(ERR)GOTO 150
	IF(COMPRS(INST,1))GOTO 20
	WRITE(ONM,160)(INST(I),I=1,LEN(INST))
	GOTO 2

C	    Input a line and search for a # define.  If found go
C	process it, otherwise copy line into output file and
C	continue on looking for more # define's.  Also trap and
C	End of file, if one occurs.

20	CALL EXNAME(INST,DNM,DELIM,CSTR)
	TYPE 21,(DNM(I),I=1,LEN(DNM))
21	FORMAT(1X,' DEFINE -- ',20A1)
	DO 25 K=1,STKPTR
	   IF(ISCOMP(DNM,STK(1,K)) .EQ. 0) GOTO 165
25	CONTINUE
	CALL SCOPY(DNM,STK(1,STKPTR))
	STKPTR=STKPTR+1

C	    Extract the define name and it's delimeter.
C	Next see if this define has already been taken
C	care of.  If so, ERROR, we will not allow dup-
C	licate defines.  Otherwise, put the name of the
C	define into an array and process it.

C	   This next part will break apart the define and
C	build up the the code array which will contain all
C	the instructions for the define.  In doing we must
C	search for the delimeter (signifies end).

30	CALL REVBLK(CSTR,EMITS)
	CALL CONCAT('	',EMITS,CODE(1,CODPTR))
	CODPTR=CODPTR+1
	IF(CODPTR .EQ. 21) GOTO 170

C	    See if continuation, if so, goto part that handles this

33	L=INDEX(CSTR,DELIM)
	IF(L .NE. 0)GOTO 45
	CALL GETSTR(INM,CSTR,79)
	GOTO 30

C	    Build up the code array  each time checking for the
C	terminating delimeter.  If the user attempts to have more
C	than 21 lines for a define, an error is emitted.  We will
C	allow only 21 lines.  This also enables to trap an error
C	in which the terminating delimeter is not found.

45	CALL REVBLK(CSTR,EMITS)
	CALL CONCAT('	',EMITS,CODE(1,CODPTR))

C	   Put in the last line of the define 

50	CALL GETSTR(INM,INST,79,ERR)
	IF(ERR)GOTO 60
	P=INDEX(INST,DNM)
	IF(P .EQ. 0) GOTO 55
	CALL SUBSTR(INST,OUTSTR,P,LEN(DNM))
	IF(ISCOMP(DNM,OUTSTR) .NE. 0) GOTO 55

C	    Search the file for the reference to the define.
C	Go to the part that substitutes the code for the define
C	if it is found.

	DO 52 K=1,CODPTR-1
	   CALL SCOPY(CODE(1,K),EMITS)
	   L=INDEX(EMITS,DELIM)
	   IF(L .NE. 0) EMITS(L)=' '
	   IF(K .EQ. 1) CALL REVBLK(INST,OUTSTR)
	   IF((K .EQ. 1) .AND. (ISCOMP(OUTSTR,DNM) .NE. 0)) GOTO 51

C	   See if the define is the only thing on
C	   this line

	   WRITE(ONM,160)(EMITS(J),J=1,LEN(EMITS))
	   GOTO 52

C	   Concatanate the string here

51	   KU=LEN(INST)-LEN(DNM)
	   CALL SEG(INST,INST,1,KU)
	   CALL CONCAT(INST,EMITS,INST)
	   CALL SCOPY(INST,EMITS)
	   WRITE(ONM,160)(EMITS(J),J=1,LEN(EMITS))
52	CONTINUE
	GOTO 50
55	WRITE(ONM,160)(INST(I),I=1,LEN(INST))
	GOTO 50

C	    Copy the code array for the define, if found.  Otherwise,
C	write the input line to the output file and continue on.

60	REWIND INM
	REWIND ONM
	TMP=INM
	INM=ONM
	ONM=TMP
	GOTO 1

C	    Swap the filenames and continue on looking
C	for more defines.

150	REWIND INM
	REWIND ONM
	TMP=INM
	INM=ONM
	ONM=TMP
	IF(.NOT.(DFLAG))RETURN
	GOTO 1

C	Formats and error messages

160	FORMAT(1X,80A1)
165	TYPE *,'Duplicate defines not allowed...'
	GOTO 60
170	TYPE *,'Define too long or terminating delimeter not found'
	RETURN
	END
                                                                                   