/*
 *			s t r n e q . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	strneq	String Equality Test With Count
index		String equality test with count

synopsis
	.s.nf
	int
	strneq(s1, s2, count);
	char		*s1;
	char		*s2;
	unsigned int	count;
	.s.f
Description

	Compare at most count bytes between two strings, returning TRUE
	if the the strings are equal.

Bugs

#endif

#define	EOS	0
#define	FALSE	0
#define	TRUE	1

int
strneq(s1, s2, count)
register char		*s1;
register char		*s2;
register unsigned int	count;
/*
 * Return TRUE if equal up to count bytes.
 */
{
	if (count == 0)
	    return (TRUE);
	else {
	    while (*s1++ == *s2) {
		if (*s2++ == EOS || --count == 0)
		    return (TRUE);
	    }
	    return (FALSE);
	}
}
                                                                                                                                                                                                                                                     