/*)BUILD	$(PROGRAM)	=	ftest1
		$(INCLUDE)	=	pml.h
		$(DTOA)		=	1
		$(UTLIB)	=	C:PML
		$(TKBOPTIONS)	= {
			STACK	=	2000
			TASK	=	...FT1
		}
*/

#include <stdio.h>
#include <pmluse.h>
#include "pml.h"

#define dsin_table dsntb
#define dcos_table dcstb
#define dtan_table dtant
#define dasin_table dastb
#define dacos_table dacst
#define datan_table datnt
#define datan2_table dat2t
#define dsinh_table dsnht
#define dcosh_table dcsht
#define dtanh_table dtnht
#define dasinh_table dasht
#define dacosh_table dacht
#define datanh_table datht
#define dexp_table dxptb
#define dln_table dlntb
#define dlog_table dlogt
#define dsqrt_table dsqtb
double datan2_table[] = {
   -6.000000000000e-01, -5.000000000000e-01, -2.44685437739309e00,
    0.000000000000e00, -1.000000000000e00, -1.57079632679490e00,
    6.000000000000e-01, -5.000000000000e-01, -6.94738276196703e-01,
    1.000000000000e00,  0.000000000000e00,  0.00000000000000e00,
    6.000000000000e-01,  5.000000000000e-01,  6.94738276196703e-01,
    0.000000000000e00,  1.000000000000e00,  1.57079632679490e00,
   -6.000000000000e-01,  5.000000000000e-01,  2.44685437739309e00,
   -1.000000000000e00,  0.000000000000e00,  -3.14159265358979e00
};
double datanh_table [] = {
   -9.999899999999999999e-01, -6.103033822758835533e00,
   -5.000000000000000000e-01, -5.493061443340548457e-01,
   -2.500000000000000000e-01, -2.554128118829953416e-01,
    0.000000000000000000e00,  0.000000000000000000e00,
    2.500000000000000000e-01,  2.554128118829953415e-01,
    5.000000000000000000e-01,  5.493061443340548457e-01,
    9.999899999999999999e-01,  6.103033822758835533e00
};
double dacosh_table[] = {
    1.000000000000000000e00, 0.000000000000000000e00,
    2.000000000000000000e00, 1.316957896924816708e00,
    1.000000000000000000e01, 2.993222846126380897e00,
    2.000000000000000000e02, 5.991458297049387423e00,
    1.000000000000000000e03, 7.600902209541988611e00,
    1.000000000000000000e05, 1.220607264550517372e01,
    1.000000000000000000e18, 4.213967885445276762e01,
};
double dasinh_table[] = {
   -8.000000000000000000e01, -5.075212875445203927e00,
   -1.000000000000000000e01, -2.998222950297969704e00,
   -5.000000000000000000e-01, -4.812118250596034474e-01,
    0.000000000000000000e00,  0.000000000000000000e00,
    1.500000000000000000e00,  1.194763217287109304e00,
    1.000000000000000000e01,  2.998222950297969738e00,
    8.000000000000000000e01,  5.075212875445207223e00,
};
double dtanh_table[] = {
   -8.000000000000000000e01, -1.000000000000000000e00,
   -1.000000000000000000e01, -9.999999958776927635e-01,
   -5.000000000000000000e-01, -4.621171572600097586e-01,
    0.000000000000000000e00,  0.000000000000000000e00,
    1.500000000000000000e00,  9.051482536448664383e-01,
    1.000000000000000000e01,  9.999999958776927635e-01,
    8.000000000000000000e01,  1.000000000000000000e00
};
double dsinh_table[] = {
   -8.000000000000000000e01, -2.770311192196755026e34,
   -1.000000000000000000e01, -1.101323287470339337e04,
   -5.000000000000000000e-01, -5.210953054937473615e-01,
    0.000000000000000000e00,  0.000000000000000000e00,
    1.500000000000000000e00,  2.129279455094817497e00,
    1.000000000000000000e01,  1.101323287470339337e04,
    8.000000000000000000e01,  2.770311192196755026e34
};
double dcosh_table[] = {
   -8.000000000000000000e01, 2.770311192196755026e34,
   -1.000000000000000000e01, 1.101323292010332313e04,
   -5.000000000000000000e-01, 1.127625965206380785e00,
    0.000000000000000000e00, 1.000000000000000000e00,
    1.500000000000000000e00, 2.352409615243247325e00,
    1.000000000000000000e01, 1.101323292010332313e04,
    8.000000000000000000e01, 2.770311192196755026e34
};
double dlog_table[] = {
    1.000000000000000000e-20,-2.000000000000000000e01,
    1.000000000000000000e-05,-5.000000000000000000e00,
    5.000000000000000000e-01,-3.010299956639811952e-01,
    1.000000000000000000e00, 0.000000000000000000e00,
    1.500000000000000000e00, 1.760912590556812420e-01,
    1.000000000000000000e05, 5.000000000000000000e00,
    1.000000000000000000e20, 2.000000000000000000e01
};

double dtan_table[] = {
   -2.000000000000000000e00, 2.185039863261518991e00,
   -1.000000000000000000e00,-1.557407724654902230e00,
   -5.000000000000000000e-01,-5.463024898437905132e-01,
    0.000000000000000000e00, 0.000000000000000000e00,
    5.000000000000000000e-01, 5.463024898437905132e-01,
    1.000000000000000000e00, 1.557407724654902230e00,
    2.000000000000000000e00,-2.185039863261518991e00
};
double dasin_table[] = {
   -1.000000000000000000e00, -1.570796326794896619e00,
   -7.000000000000000000e-01, -7.753974966107530636e-01,
   -1.999999999999999999e-01, -2.013579207903307914e-01,
    0.000000000000000000e00,  0.000000000000000000e00,
    1.999999999999999999e-01,  2.013579207903307914e-01,
    7.000000000000000000e-01,  7.753974966107530636e-01,
    1.000000000000000000e00,  1.570796326794896619e00
};
double dacos_table[] = {
   -1.000000000000000000e00, 3.141592653589793238e00,
   -7.000000000000000000e-01, 2.346193823405649682e00,
   -1.999999999999999999e-01, 1.772154247585227410e00,
    0.000000000000000000e00, 1.570796326794896619e00,
    1.999999999999999999e-01, 1.369438406004565827e00,
    7.000000000000000000e-01, 7.953988301841435554e-01,
    1.000000000000000000e00, 0.000000000000000000e00,
};
double dln_table[] = {
    4.999999999999999999e-02, -2.995732273553990993e00,
    2.500000000000000000e-01, -1.386294361119890618e00,
    5.000000000000000000e-01, -6.931471805599453094e-01,
    1.000000000000000000e00,  0.000000000000000000e00,
    2.000000000000000000e00,  6.931471805599453094e-01,
    1.000000000000000000e01,  2.302585092994045684e00,
    3.000000000000000000e01,  3.401197381662155375e00,
    5.000000000000000000e01,  3.912023005428146058e00,
    2.000000000000000000e02,  5.298317366548036677e00,
    1.999999999999999999e32,  7.437587015636940721e01,
    1.999999999999999999e-28, -6.377923542327333383e01
};
double dsqrt_table[] = {
    0.0, 0.0,
    4.999999999999999999e-02, 2.236067977499789696e-01,
    2.500000000000000000e-01, 5.000000000000000000e-01,
    5.000000000000000000e-01, 7.071067811865475243e-01,
    1.000000000000000000e00, 1.000000000000000000e00,
    2.000000000000000000e00, 1.414213562373095048e00,
    1.000000000000000000e01, 3.162277660168379332e00,
    3.000000000000000000e01, 5.477225575051661134e00,
    7.000000000000000000e01, 8.366600265340755481e00,
    2.000000000000000000e02, 1.414213562373095049e01,
    1.999999999999999999e32, 1.414213562373095048e16,
    1.999999999999999999e-28, 1.414213562373095048e-14
};
double dsin_table [] = {
    5.00e-11, 5.000000000000000000e-11,
    0.0,0.0,
    5.00e-01, 4.794255386042030002e-01,
    1.00e00, 8.414709848078965066e-01,
    2.00e00, 9.092974268256816953e-01,
    2.50e00, 5.984721441039564939e-01,
    3.50e00,-3.507832276896198480e-01,
    4.00e00,-7.568024953079282514e-01,
    5.00e00,-9.589242746631384689e-01,
    6.00e00,-2.794154981989258727e-01,
    7.50e00, 9.379999767747388579e-01,
    8.00e00, 9.893582466233817778e-01,
    9.00e00, 4.121184852417565697e-01,
    9.50e00,-7.515112046180930728e-02,
   -5.00e-01,-4.794255386042030000e-01,
   -1.00e00,-8.414709848078965066e-01,
   -2.00e00,-9.092974268256816953e-01,
   -2.50e00,-5.984721441039564939e-01,
   -3.50e00, 3.507832276896198480e-01,
   -4.00e00, 7.568024953079282514e-01,
   -5.00e00, 9.589242746631384689e-01,
   -5.50e00, 7.055403255703919063e-01,
   -6.50e00,-2.151199880878155242e-01,
   -7.50e00,-9.379999767747388579e-01,
   -8.00e00,-9.893582466233817778e-01,
   -9.00e00,-4.121184852417565697e-01,
   -9.50e00, 7.515112046180930728e-02,
};
double dcos_table [] = {
    5.00e-11, 9.999999999999999997e-01,
    0.00e00, 9.999999999999999997e-01,
    5.00e-01, 8.77582561890372716e-01,
    1.00e00, 5.403023058681397173e-01,
    2.00e00,-4.161468365471423870e-01,
    2.50e00,-8.011436155469337148e-01,
    3.50e00,-9.364566872907963376e-01,
    4.00e00,-6.536436208636119144e-01,
    5.00e00, 2.836621854632262644e-01,
    5.50e00, 7.086697742912599999e-01,
    6.50e00, 9.765876257280234999e-01,
    7.50e00, 3.466353178350258109e-01,
    8.00e00,-1.455000338086135258e-01,
    9.00e00,-9.111302618846769882e-01,
    9.50e00,-9.971721561963784728e-01,
   -5.00e-01, 8.775825618903727160e-01,
   -1.00e00, 5.403023058681397173e-01,
   -2.00e00,-4.161468365471423870e-01,
   -2.50e00,-8.011436155469337148e-01,
   -3.50e00,-9.364566872907963376e-01,
   -4.00e00,-6.536436208636119144e-01,
   -5.00e00, 2.836621854632262644e-01,
   -6.00e00, 9.601702866503660205e-01,
   -6.50e00, 9.765876257280234999e-01,
   -7.50e00, 3.466353178350258109e-01,
   -8.00e00,-1.455000338086135258e-01,
   -9.00e00,-9.111302618846769882e-01,
   -9.50e00,-9.971721561963784728e-01,
};
double datan_table [] = {
    0.000000000000e00, 0.000000000000e00,
    4.999999999999e-02, 4.995839572194e-02,
    2.500000000000e-01, 2.449786631268e-01,
    3.500000000000e-01, 3.366748193867e-01,
    7.000000000000e-01, 6.107259643892e-01,
    1.000000000000e00, 7.85398163397e-01,
    2.000000000000e00, 1.10714871779e00,
    1.400000000000e01, 1.49948886200e00,
    3.000000000000e01, 1.53747533091e00,
    5.000000000000e01, 1.55079899282e00,
    7.000000000000e01, 1.55651158420e00,
    9.000000000000e01, 1.55968567289e00,
    2.000000000000e02, 1.56579636846e00
};
double dexp_table[] = {
    -40.0, 4.248354255291e-18,
    -30.0, 9.357622968840e-14,
    -20.0, 2.061153622438e-09,
    -10.0, 4.539992976248e-05,
     -2.0, 1.353352832366e-01,
      0.0, 1.000000000000e00,
      2.0, 7.389056098930e00,
     10.0, 2.202646579480e04,
     20.0, 4.851651954097e08,
     30.0, 1.068647458152e13,
     40.0, 2.353852668370e17,
};
struct test {
    double (*func)();
    double *table;
    int entries;
    char *name;
};
eval(fpntr)
register struct test *fpntr;
{
    double rval, sval, svalref, zerr, kerr, errmax, dabs();
    register double *tblpntr;
    register int idx;

    errmax = 0.0;
    tblpntr = fpntr->table;
    for (idx = 0; idx < fpntr->entries; idx++ ) {
	rval = *tblpntr++;
	sval = (*fpntr->func)(rval);
	svalref = *tblpntr++;
	zerr = (sval-svalref)/svalref;
	kerr = dabs(zerr);
	if (kerr > 1.0e-4) {
#ifdef PDP10
	    printf ("%s error for %f\n",fpntr->name,rval);
	    printf ("\tComputed value = %f\n",sval);
	    printf ("\tReference value = %f\n",svalref);
	    printf ("\tRelative error = %f\n\n",zerr);
#else
	    printf ("%s error for %le\n",fpntr->name,rval);
	    printf ("\tComputed value = %le\n",sval);
	    printf ("\tReference value = %le\n",svalref);
	    printf ("\tRelative error = %le\n\n",zerr);
#endif
	}
	if (kerr > errmax) {
	    errmax = kerr;
	}
    }
#ifdef PDP10
    printf ("\t%s:\terrmax = %f\n",fpntr->name,errmax);
#else
    printf ("\t%s:\terrmax = %le\n",fpntr->name,errmax);
#endif
}
struct test tests[] = {
    &dsin,dsin_table,27,"DSIN",
    &dcos,dcos_table,28,"DCOS",
    &dtan,dtan_table,7,"DTAN",
    &dsinh,dsinh_table,7,"DSINH",
    &dcosh,dcosh_table,7,"DCOSH",
    &dtanh,dtanh_table,7,"DTANH",
    &dasin,dasin_table,7,"DASIN",
    &dacos,dacos_table,7,"DACOS",
    &datan,datan_table,13,"DATAN",
    &dasinh,dasinh_table,7,"DASINH",
    &dacosh,dacosh_table,7,"DACOSH",
    &datanh,datanh_table,7,"DATANH",
    &dsqrt,dsqrt_table,12,"DSQRT",
    &dexp,dexp_table,11,"DEXP",
    &dln,dln_table,11,"DLN",
    &dlog,dlog_table,7,"DLOG",
    0,0,0,0
};

main()
{
    register struct test *tp;

    tp = &tests[0];
    while (tp->func) {
	eval(tp);
	tp++;
    }
    do_datan2();
}

do_datan2()
{
    double x, y, z, datan2();
    register double *tblpntr;
    double zref, zerr, kerr, errmax, dabs();
    register int idx;

    errmax = 0.0;
    tblpntr = datan2_table;
    for (idx = 0; idx < 8; idx++ ) {
	x = *tblpntr++;
	y = *tblpntr++;
	z = datan2(x,y);
	zref = *tblpntr++;
	zerr = (z-zref)/zref;
	kerr = dabs(zerr);
	if (kerr > 1.0e-4) {
#ifdef PDP10
	    printf ("%s error for %f %f\n","DATAN2",x,y);
	    printf ("\tComputed value = %f\n",z);
	    printf ("\tReference value = %f\n",zref);
	    printf ("\tRelative error = %f\n\n",zerr);
#else
	    printf ("%s error for %le ","DATAN2",x);
	    printf ("%le\n",y);
	    printf ("\tComputed value = %le\n",z);
	    printf ("\tReference value = %le\n",zref);
	    printf ("\tRelative error = %le\n\n",zerr);
#endif
	}
	if (kerr > errmax) {
	    errmax = kerr;
	}
    }
#ifdef PDP10
    printf ("\t%s:\terrmax = %f\n","DATAN2",errmax);
#else
    printf ("\t%s:\terrmax = %le\n","DATAN2",errmax);
#endif
}
                                                                                                                                                                                                                                                                                                                                                                                                                         