/*
 *	+++ NAME +++
 *
 *	 DATAN2   Double precision arc tangent of two arguments
 *
 *	+++ INDEX +++
 *
 *	 DATAN2
 *	 machine independent routines
 *	 trigonometric functions
 *	 math libraries
 *
 *	+++ DESCRIPTION +++
 *
 *	Returns double precision arc tangent of two
 *	double precision floating point arguments ( DATAN(Y/X) ).
 *
 *	+++ USAGE +++
 *
 *	 double datan2(x,y)
 *	 double x;
 *	 double y;
 *
 *	+++ REFERENCES +++
 *
 *	Fortran 77 user's guide, Digital Equipment Corp. pp B-4.
 *
 *	+++ RESTRICTIONS +++
 *
 *	Note that the argument usage is exactly the reverse of the
 *	common FORTRAN usage where DATAN2(x,y) computes DATAN(x/y).
 *	The usage here is less confusing than remembering that x is
 *	really y and y is really x.
 *
 *	For precision information refer to documentation of the
 *	other floating point library routines called.
 *
 *	+++ PROGRAMMER +++
 *
 *	 Fred Fish
 *	 Goodyear Aerospace Corp, Arizona Div.
 *	 (602) 932-7000 work
 *	 (602) 894-6881 home
 *
 *	+++ INTERNALS +++
 *
 *	Computes DATAN(Y/X) from:
 *
 *		1.	If X = 0 then
 *			DATAN(X,Y) = PI/2 * (SIGN(Y))
 *
 *		2.	If X > 0 then
 *			DATAN(X,Y) = DATAN(Y/X)
 *
 *		3.	If X < 0 then DATAN2(X,Y) =
 *			PI*(SIGN(Y)) + DATAN(Y/X)
 *
 *	---
 */

/*)LIBRARY
*/

#include <stdio.h>
#include <pmluse.h>
#include "pml.h"

double datan2(x,y)
double x;
double y;
{
    double dsign(), datan();

    if (x == 0.0) {
	return (dsign(HALFPI,y));
    } else if (x > 0.0) {
	return (datan(y/x));
    } else {
	return (datan(y/x) + dsign(PI,y));
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                  