  (*$A-*)
CONST
  directoryfile =         'SYSAVE.DIR';
  commandfile =           'SYSAVE.CMD';
  promptcommand =         'EDIT/TECO SYSAVE/EXEC:';
  initcommand =           'INIT/VOL/NOQ/SEG:1 ';
  listcommand =           'DIR/VOL ';
  numberdisks =           20;
  numberfiles =           100;
TYPE
  alpha4  = ARRAY [1 ..  4] OF char;
  alpha12 = ARRAY [1 .. 12] OF char;
  alpha25 = ARRAY [1 .. 25] OF char;
  diskrecordty = RECORD
		   blkcnt,
		   filecnt:        integer;
		   name:           ARRAY [1 .. numberfiles] OF alfa;
		 END;

LABEL
  01;
VAR
  outdev,
  outdev1,
  outdev2:          alpha4;
  volid,
  ownerid:          alpha12;
  listoptions,
  filename:       alpha25;
  lastdisk,
  size:           integer;
  workfile:       alfa;
  diskrecord:     ARRAY [1 .. numberdisks] OF diskrecordty;
  i,
  j,
  k:              integer;
  input,
  output:       text;
  initdisk,
  listdisk,
  compactdisk:  boolean;
  ch:             char;

BEGIN

  reset (input, directoryfile);
  i := -1;
  rewrite (output, commandfile,, i);

  write ('Output Drive #1?   '); readln (OUTDEV1);
  outdev1[4] := ':';
  WRITE ('Output Drive #2?   '); READLN (OUTDEV2);
  outdev2[4] := ':';

  write ('Device Size?       '); readln (i);
  FOR j := 1 TO numberdisks DO WITH diskrecord[j] DO BEGIN
      blkcnt := i;
      filecnt := 0;
      END;

  write ('Best Fit?          '); readln (ch);
  compactdisk := (ch = 'y') OR (ch = 'Y');

  write ('Initialize Output? '); readln (ch);
  initdisk := (ch = 'y') OR (ch = 'Y');
  IF initdisk
    THEN BEGIN
      write ('    Volume ID?     ');
      readln (volid);
      write ('    Owner ID?      ');
      readln (ownerid);
      END;
  write ('Output Directory?  '); readln (ch);
  listdisk := (ch = 'y') OR (ch = 'Y');
  IF listdisk
    THEN BEGIN
      write ('Directory Options? '); readln (listoptions);
      END;

  lastdisk := 0;
  i := 1;
  WHILE NOT eof (input) DO BEGIN {build file name}
    FOR k := 1 TO alfaleng DO read (input, workfile[k]);
    IF workfile[1] <> ' ' {not garbage line}
      THEN BEGIN
	IF compactdisk
	  THEN i := 1;
	FOR j :=1 TO numberdisks DO WITH diskrecord[j] DO FOR k := 1 TO filecnt DO {check for duplicate filename}
	      IF workfile = name[k]
		THEN GOTO 01;
	read (input,size); {read file size}
	FOR i := i TO numberdisks DO WITH diskrecord[i] DO
	  BEGIN {find a disk to put it on}
	    IF (size < blkcnt) AND (filecnt < numberfiles)
	      THEN BEGIN {found one, enter in table}
		blkcnt := blkcnt - size;
		filecnt := filecnt + 1;
		name[filecnt] := workfile;
		IF i > lastdisk
		  THEN lastdisk := i;
		EXIT;
		END
	    ELSE IF i = numberdisks
	      THEN writeln (' * ERROR * - FILE:       ', workfile, ' NOT SAVED.');
	    END;
01:
	END;
    readln (input);
    END;
  close (input);

  {write out disk tables}
  FOR i := 1 TO lastdisk DO WITH diskrecord[i] DO BEGIN
      IF (i MOD 2 = 0)
	THEN outdev := outdev2
	ELSE outdev := outdev1;
      writeln (' Output Volume #', i:2, ' on ', outdev, ' has ', filecnt:2,
	       ' Files and ', blkcnt:4, ' Empty blocks.');
      writeln (output, promptcommand, '''SETUP VOLUME ', i:2, ' ON ', outdev, '''');
      IF initdisk
	THEN BEGIN
	  writeln (output, initcommand, outdev);
	  writeln (output, i:1, '/', lastdisk:1, ' ', volid);
	  writeln (output, ownerid);
	  write   (output, 'R PIP');
	  END
	else begin
	  writeln (output, 'R PIP');
	  write   (output, outdev, '*.*/D/Y');
	  end;
      FOR j := 1 TO filecnt DO BEGIN
	if j mod 5 = 1
	  then begin
	    writeln (output);
	    write (output, outdev, '*.*/Y=IN:')
	    end
	  else write (output, ',');
	FOR k := 1 TO alfaleng DO
	  IF name [j,k] <> ' '
	    THEN write (output, name[j,k]);
	END;
      writeln (output);
      writeln (output, '^C');
      IF listdisk
	THEN writeln (output, listcommand, outdev, listoptions);
      END;

  close (output);

  END.
                                                                                       