
/*
 *                      ***************
 *                      * X R F I . C *
 *                      ***************
 *
 * Do initialization things.
 * NOTE: This is once-only code. It should be run in an overlay,
 *       along with FOPEN. The root need only contain XRF0 and XRFD.
 *
 * Version V1.4                  1-Jul-80
 * Version V1.5                  3-Jul-80  Conditionaled date/time stuff.
 * Version V1.6 MM		 9-Jul-80  Changed date/time stuff
 * Version V1.7 MM		10-Jul-80  File name changes
 * Version V1.8 MM		21-Jul-80  Ctime() changed
 * Version V1.9 MM		22-Jul-80  Redid initialization
 * Version V1.10 RBD		14-Oct-80  Allow wildcards in RT11
 */

#include <stdio.h>
#include "xrf.h"


static int time_of_day[8];
/*
 * Set up RSX file names, open them, and initialize the page header strings
 */


initinfile(in)
char *in;

   {
   char wrkbuf[40];                             /* Working string buffer */

   name(wrkbuf, in, "c", 0);               /* Make input file name */
   if((src = fwild(wrkbuf, "r")) == NULL)
      error("Cannot open %s\n", wrkbuf);
   if (time_of_day[0] == 0)
      rtime(&time_of_day);
   }

initoutfile(out)
char	*out;
   {
   char wrkbuf[40];
   char firstin[40];

   if (out != NULL)
      {
      name(wrkbuf, out, "x", 0);
      }
   else
      {
      iovtoa(src, firstin);
      name(wrkbuf, firstin, "x", 1);            /* Make list file name */
      }
   if((lst = fopen(wrkbuf, "w")) == NULL)       /* Try to open it */
      error("Cannot open listing file %s\n", wrkbuf);

   }

nextinfile()
   {
   register char	*wp;
   register int		c;
   char			wrkbuf[40];

   if (fnext(src) == NULL)
      return(0);
   iovtoa(src, wrkbuf);
   for (wp = wrkbuf; (c = *wp++) && c != ':';);
   if (c == 0)
      wp = wrkbuf;
   concat(pghead, "\fCross Reference of: ",
 		wp, "\t", ctime(&time_of_day), "\tPage ", 0);
   return(1);
   }

/*
 * Make a file name.
 * The mode argument is either 0 which means use type as default extension,
 * or 1, which means force the extension to be type. Argument file is the
 * 'raw' file name, sysnam is the final filename string. All arg's except
 * mode are pointers, as usual.
 *
 */

name(sysnam, file, type, mode)
char *sysnam, *file, *type;

int mode;

   {
   register char *p1, *p2;                      /* Fast pointers */
   register int c;                              /* Fast char. buffer */

   p1 = sysnam;                                 /* p1 --> output string */
   p2 = file;                                   /* p2 --> input string */
   while((c = *p2++) && c != '.')               /* Copy up to '.' */
      *p1++ = c;
   if( mode == 0 )                              /* Default extension */
      {
      if( c == '.' )                            /* Extension explicitly given */
         {
           do                                   /* Copy '.' + any ext. */
              {
              *p1++ = c;
              } while( c = *p2++ );
         }
      else                                      /* No ext. given, default */
         {
         *p1++ = '.';
         p2 = type;
         while( c = *p2++ )
            *p1++ = c;
         }
      }
   else                                 /* Force extension */
      {
      *p1++ = '.';
      p2 = type;
      while( c = *p2++ )
         *p1++ = c;
      }
   *p1 = '\0';                          /* Terminate with eos */
   }
/*
 *****************************************************************************
 *
 * Give user help on program useage.
 */

useage()
   {
   fprintf(stderr, "Usage:  xrf [-s] [-n] [-o outfile] infiles\n");
   fprintf(stderr, "  -s   Spool output (native RSX only)\n");
   fprintf(stderr, "  -n   Narrow (80 column) output\n");
   fprintf(stderr, "  -o   Output to \"outfile\", default is first infile\n");
   fprintf(stderr, "       Default output is first input file, .x filetype\n");
   fprintf(stderr, "Input files may have wild-card names\n");
   error("?XRF-E-parameter error");
   }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            