	SUBROUTINE SYAXIS(YLOW,YHIGH,YLAB,IAXES)
	LOGICAL*1 LOGX, LOGY
	COMMON /PLTCOM/ UX0, UDX, UY0, UDY, LOGX, LOGY
	COMMON /PLTSIZ/ XVSTRT, YVSTRT, XVLEN, YVLEN
	COMMON /PLTCLP/ XMIN,XMAX,YMIN,YMAX
	COMMON /PLTPRM/ CXSIZE, CYSIZE, TICKLN, YVINI
C
	EXTERNAL LEN
	BYTE YLAB(2)
	BYTE NUMBR(14)
	LOGICAL*1 LOGYY, LOGT, LRMTEX, LSHORT, LRAGGD
	DIMENSION ZLOG(8)
C
	DATA ZLOG /0.3010, 0.4771, 0.6021, 0.6990, 0.7782, 0.8451,
	1   0.9031, 0.9542 /
	DATA TMINLD /0.1/	!MINIMUM DISTANCE BETWEEN SHORT TICKS (1 MM)
	DATA SHORTF /2.0/	!SHORT TICKS = TICKLN/SHORTF
C
	YVLEN = YVINI			!PROTECT MAPPRM INFO THIS WAY
C
C
C	SET LOGY TO FALSE FOR OUR USAGE OF SCALE
C
	LOGY = .FALSE.
C
C	SEE WHAT TYPE OF AXIS IS DESIRED
C
	LOGYY = IAND(IAXES,2) .NE. 0
	LRAGGD = IAND(IAXES,256) .NE. 0
C
C	DO THE AXES SCALING
C
	NUMTK = MIN0(10,INT(YVLEN/(3.0*CYSIZE)))
	IF (LOGYY) GO TO 60
	LSHORT = IAND(IAXES,32) .NE. 0
	CALL AXIS(YLOW,YHIGH,NUMTK,LSHORT,LRAGGD,YMIN,YMAX,YTMIN,YTMAX,
	1   YTICK,IYPWR)
	GO TO 80
60	CALL LAXIS(YLOW,YHIGH,NUMTK,YMIN,YMAX,YTICK)
	YTMIN = YMIN
	YTMAX = YMAX
	IYPWR = 0
80	CONTINUE
C
C	SET UP TEMPORARY SCALING FACTORS
C
	UY0 = YMIN
	UDY = YMAX - YMIN
C
C	********** DRAW Y AXES **********
C
	CALL GSSETC(CYSIZE,0.0)
	LOGT = .FALSE.
	IF (.NOT. LOGYY .OR. YTICK .NE. 1.0) GO TO 90
	CALL SCALE(XMIN,YMIN,VX,TEMP)
	CALL SCALE(XMIN,YMIN+1.0-ZLOG(8),VX,VY)
	IF ((VY-TEMP) .GE. TMINLD) LOGT = .TRUE.
90	CONTINUE
C
C	DRAW Y AXIS LINE
C
	MXLAB = 3
	TENEXP = 10.0**IYPWR
	X = XMAX
	TICKSP = AMAX1(0.0,TICKLN)	!TICK SPACING
	IF (IAND(IAXES,64) .NE. 0) YVLEN = YVLEN - TICKSP
	TCKSGN = -TICKLN
100	CONTINUE
	CALL SCALE(X,YMAX,VX,VY)
	CALL GSMOVE(VX,VY)
	CALL SCALE(X,YMIN,VX,VY)
	CALL GSDRAW(VX,VY)
C
C	DRAW AND LABEL Y AXIS TICKS
C
	DELMX = 0.0
	Y = YTMIN
	N = (YTMAX-YTMIN)/YTICK + 1.1
110	CONTINUE
	CALL SCALE(X,Y*TENEXP,VX,VY)
	CALL GSMOVE(VX,VY)
	CALL GSDRAW(VX+TICKLN,VY)
C
C	PLACE THE APPROPIATE LABEL
C
	IF (IAND(IAXES,1024) .NE. 0) GO TO 183
	IF (LOGYY) GO TO 160
	CALL LINLAB(INT(Y),IYPWR,NUMBR,LRMTEX)
	GO TO 180
160	CALL LOGLAB(INT(Y),NUMBR)
180	DEL = GSLENS(NUMBR)
	DELMX = AMAX1(DEL,DELMX)
	CALL GSMOVE(VX+TICKSP+0.5*CXSIZE,VY-CYSIZE/2.0)
	CALL GSPSTR(NUMBR)
183	CONTINUE
C
C	ADD GRID LINE AT TICK IF DESIRED
C
	IF (IAND(IAXES,8) .EQ. 0) GO TO 185
	CALL GSLTYP(3)
	CALL GSMOVE(VX,VY)
	CALL SCALE(XMIN,Y*TENEXP,VX,VY)
	CALL GSDRAW(VX,VY)
	CALL GSLTYP(1)
185	CONTINUE
C
C	DO EXTRA TICKING IF EXTRA TICKS WILL BE FAR ENOUGH APART
C
	IF ((.NOT. LOGT) .OR. (Y .EQ. YTMAX)) GO TO 200
	DO 190 J = 1, 8
	CALL SCALE(X,Y+ZLOG(J),VX,VY)
	CALL GSMOVE(VX,VY)
190	CALL GSDRAW(VX+TICKLN/SHORTF,VY)
200	CONTINUE
	Y = Y + YTICK
	N = N-1
	IF (N .GT. 0) GO TO 110
C
C	IF LINEAR AXIS, PLACE REMOTE EXPONENT IF NEEDED
C
	IF (LOGYY .OR. (.NOT. LRMTEX)) GO TO 260
	IF (IAND(IAXES,1024) .NE. 0) GO TO 260
	CALL SCALE(XMAX,(YTMIN+YTICK/2.0)*TENEXP,VX,VY)
	CALL SCOPY('E',NUMBR)
	CALL NUMSTR(IYPWR,NUMBR(2))
	CALL GSMOVE(VX+0.5*CXSIZE,VY-CYSIZE/2.0)
	CALL GSPSTR(NUMBR)
C
C	NOW PLACE Y LABLE
C
260	CALL SCALE(X,(YMIN+YMAX)/2.0,VX,VY)
	CALL GSMOVE(VX+0.5*CXSIZE+DELMX+TICKSP+1.5*CYSIZE,
	1   VY-GSLENS(YLAB)/2.0)
	CALL GSSETC(CYSIZE,90.0)
	CALL GSPSTR(YLAB)
	CALL GSSETC(CYSIZE,0.0)
300	CONTINUE
C
C	TELL USER THE SCALING LIMITS
C
	IF (.NOT. LOGYY) GO TO 320
		YMIN = 10.0**YMIN
		YMAX = 10.0**YMAX
320	CONTINUE
C
C	TELL SCALE ABOUT LOG AXIS SCALING NOW
C
	LOGY = LOGYY
	RETURN
	END
                                                                              