	SUBROUTINE KUTSIM (H, X, N, Y1, Y2, F, G)
C
C---------------------------------------------------------------------
C
C	Subroutine for performing one step in the solution of a
C	system of first-order differential equations by the
C	Kutta-Simpson method.
C
C	H  is the step size
C	X  is the initial value of the independent variable
C	N  is the number of dependent variables (or equations)
C	Y1 is an array of initial values of the dependent variables
C	Y2 is an array of final values of the dependent variables
C	F,G are arrays dimensioned at least N to be supplied by
C	   the calling program.  They are scratch arrays used for
C	   intermediate calculations.
C
C	The user must supply a function evaluation routine
C		SUBROUTINE FUNC (F, X, Y)
C	that returns the values of the N derivative functions in 
C	the vector F.
C
C	Written by Robert Walraven		9 Oct 81
C	           Applied Science
C	           Univ. of Calif., Davis 95616
C	           (916) 752-0360
C
C---------------------------------------------------------------------
C
	DIMENSION Y1(1),Y2(1),F(1),G(1)
C
	CALL FUNC (F,X,Y1)
	DO 10 I=1,N
	G(I) = H * F(I)
	Y2(I) = G(I)
10	G(I) = Y1(I) + 0.5 * G(I)
	CALL FUNC (F, X+0.5*H, G)
	DO 20 I=1,N
	G(I) = H * F(I)
	Y2(I) = Y2(I) + 2. * G(I)
20	G(I) = Y1(I) + 0.5 * G(I)
	CALL FUNC (F, X+0.5*H, G)
	DO 30 I=1,N
	G(I) = H * F(I)
	Y2(I) = Y2(I) + 2. * G(I)
30	G(I) = Y1(I) + G(I)
	CALL FUNC (F, X+H, G)
	DO 40 I=1,N
40	Y2(I) = Y1(I) + (Y2(I)+H*F(I))/6.
	RETURN
	END
               