	PROGRAM FLTPLT
C
C**********************************************************************
C
C    PLOTS FREQUENCY RESPONSE OF NON-RECURSIVE DIGITIAL FILTER
C
C     FILTER DESIGN PARAMETERS:
C       NTERMS - NUMBER OF FILTER TERMS
C       A      - SIZE OF GIBBS PHENOMENON RIPPLES IN -DB
C       FLOW   - LOWER CUTOFF OF FILTER AS MULTIPLE OF NYQUIST FREQ.
C       FHIGH  - UPPER CUTOFF OF FILTER AS MULTIPLE OF NYQUIST FREQ.
C
C     PROGRAMMER:  ROBERT WALRAVEN     27 SEP 80
C
C**********************************************************************
C
	DIMENSION X(201), Y(201), COEF(100)
	DATA PI/3.14159265/
C
C--------------------INITIALIZE X ARRAY--------------------------------
C
	DO 10 I=1,201
10	X(I)=FLOAT(I-1)/200.
C
C--------------------GET DESIGN PARAMETERS-----------------------------
C
20	WRITE(5,30)
30	FORMAT(1X'NTERMS, A, FLOW, FHIGH: '$)
	READ(5,*) NTERMS, A, FLOW, FHIGH
C
C--------------------COMPUTE H(F)--------------------------------------
C
	CALL H OF Z NR (Y, 201, NTERMS, A, FLOW, FHIGH)
C
C--------------------PLOT RESULTS--------------------------------------
C
	CALL ITTOUR("32)
	CALL ERASE
	CALL BINIT
	CALL NPTS(201)
	CALL CHECK(X,Y)
	CALL DSPLY(X,Y)
	CALL MOVABS(0,402)
	CALL HLABL('H(F)',4)
	CALL MOVABS(504,50)
	CALL HLABL('2TF',3)
	CALL MOVABS(0,750)
	CALL ALFMOD
	WRITE(5,60) NTERMS,FLOW,A,FHIGH
60	FORMAT(12X'N = 'I3,25X'LOWER CUTOFF = 'F6.3/
     #	12X'A = 'F6.1' DB '18X'UPPER CUTOFF = 'F6.3)
C
C---------------------TYPE ANYTHING TO CONTINUE-------------------------
C
70	IF (ITTINR().LT.0) GO TO 70
80	IF (ITTINR().GE.0) GO TO 80
	CALL ITTOUR("33)
	CALL ITTOUR("14)
	CALL ITTOUR("30)
	GO TO 20
	STOP
	END
                                                                                                                                                                                                                                                                                                                                                   