	SUBROUTINE ENCASH(JCASH,QSTRNG,IWIDTH,IDP,QTRAIL)
C 
C 
C	Copyright (C) Shell Research Ltd. 1983
C 
C 
C The copyright in this computer program and associated  user 
C instructions contained in this document is the property of  
C Shell Research Ltd.. No guarantee is given or may be implied 
C as to the adequacy of the program or its suitability for any 
C particular purpose and no liability is accepted for any loss 
C or damage arising out of its use. 
C 
C 
C 
C Version: 	Y07.00
C 
C 
C Author:	Ray Carpenter	14-Jul-83
C 
C Revised:	Ray Carpenter	29-Feb-84
C 
C***********************************************************************
C
C Function:
C
C	Converts an integer*4 representing money into ASCII.
C
C Parameter inputs:
C
C	jcash -	the integer*4 to be printed
C	iwidth -an integer*2 representing the overall number of characters
C		to be printed, (including the sign and the decimal point.
C	idp -	an integer*2 representing the number of decimal places both
C		implicit in the integer*4 and to be printed.
C	qtrail -A logical*1 variable. If true, any minus sign is printed 
C		AFTER the number.
C
C Global inputs:
C
C	None
C
C Parameter outputs:
C
C	qstrng -the ASCII string
C
C Global outputs:
C
C
C	None
C
C Errors:
C
C	None
C
C***********************************************************************
C
C	Code begins :-
C
C
	implicit byte (q)
	implicit integer*4 (j)
C
	dimension qstrng(iwidth)
C
	nchar=iwidth-(idp+1)
	jdiv=10**idp
C
	j=1
C
	if(.not. qtrail) goto 10
C
	nchar=nchar-1		!don't leave space for leading sign
C
	if(jcash .lt. 0) then
C
		j=-1
		qminus=.true.
C
	else
		qminus=.false.
C
	end if
C
10	j=j*jcash/jdiv
C
	encode(nchar,11,qstrng(1))j
11	format(i<nchar>)
C
	nchar=nchar+1
C
	qstrng(nchar)='.'
C
	nchar=nchar+1
C
	j=jiabs(jmod(jcash,jdiv))
C
	encode(idp,21,qstrng(nchar)) j
21	format(i<idp>.<idp>)
C
	if(.not. qtrail) goto 99
C
	if(qminus) then
		 qstrng(nchar+idp) = '-'
	else
		 qstrng(nchar+idp) = ' '
	end if
C
99	return
C
C
	end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             