	integer function iskfio (qdummy,i,imin,imax,idflt)
C 
C 
C	Copyright (C) Shell Research Ltd. 1983
C 
C 
C The copyright in this computer program and associated  user 
C instructions contained in this document is the property of  
C Shell Research Ltd.. No guarantee is given or may be implied 
C as to the adequacy of the program or its suitability for any 
C particular purpose and no liability is accepted for any loss 
C or damage arising out of its use. 
C 
C 
C 
C Version: 	Y07.00
C 
C 
C Author:	Ray Carpenter	22-Mar-83
C 
C Revised:	Ray Carpenter	29-Feb-84
C 
C***********************************************************************
C
C Function:
C
C	Prints a user suppiled question and seeks an integer answer.
C
C Parameter inputs:
C
C	qdummy - the user's question. Not referenced by this routine.
C	imin -	optional minimum value for input
C	imax -	optional maximum value for input
C	idflt -	optional default value for input
C
C
C Global inputs:
C
C	iparam - decimal/octal flag. If 'iparam' eq 2 the input is required
C		in octal else it is in decimal.
C	qmin -	true if imin supplied
C	qmax -	true if imax supplied
C	qdlft -	true if idflt supplied
C	qdsply - true is display is not required.
C
C Parameter outputs:
C
C	i -	the returned value
C	iskfio	- Function value. If +ve (or 0) = number of ASCII
c		  characters entered by user. If -ve error status flag.
C
C Global outputs:
C
C	none
C
C Errors:
C
C	None
C
C***********************************************************************
C
C	Code begins :-
C
C

	implicit logical*1 (q)
C
C
	common	/askcom/
	1 iparam		!parameter word used by some routines
	2,ipoint		!output terminal buffer pointer
	3,iplen			!prompt length
	4,qlin(82)		!terminal I/O buffer
	5,qmin			!set if user supplied minimum value
	6,qmax			!set if user supplied maximum value
	7,qdflt			!set if user supplied default
	8,qctrlz		!set if ^Z is invalid
	9,qclc			!set if lower to upper case conversion reqd.
	1,qdsply		!set if no display of current fields reqd.
	2,qspc			!set if special characters valid
	3,qvtmd			!set if user wants video mode
	4,qprmpt(3)		!prompt character (default is '?')
	5,qs(12)		!temporary string storage
C
C
	dimension qt(2)
C
	data qt(1)/'I'/,qt(2)/'O'/
C
	if((.not. qmin) .or. (.not. qmax)) goto 5
C
	if (imin .le. imax) goto 5
C
	qmin = .false.
	qmax = .false.
C
5	if (qdsply) goto 40
C
	call askfpb(2,' [')
C
	call askfpb(1,qt(iparam))
C
	if(qmin .eq. .false. .and. qmax .eq. .false.) goto 20
C
	call askfpb(3,' R:')
C
	if (qmin .eq. .false.) goto 10
C
	call askfni(imin)
C
10	call askfpb(1,':')
C
	if( qmax .eq. .false.) goto 20
C
	call askfni(imax) 
C
20	if (.not. qdflt) goto 30
C
	call askfpb(3,' D:')
C
	call askfni(idflt)
C
30	call askfpb(1,']')
C
40	call asktto
C
50	call asktti
C
	if(ipoint)999,100,110
C
100	if(qdflt) i=idflt
	goto 999
C
110	call errset(64,,,,.false.,)
C
	goto(120,130) iparam
C
120	decode(ipoint,121,qlin,err=150) i
121	format(i6)
	goto 200
C
C
130	decode(ipoint,131,qlin,err=150) i
131	format(o6)
	goto 200
C
C
150	ipoint = -1
	goto 900
C
C
200	if (qmin .eq. .false. ) goto 210
	if (i .ge. imin) goto 210
	ipoint = -2
	goto 900
C
C
210	if(qmax .eq. .false.) goto 300
	if( i .le. imax) goto 300
	ipoint = -2
	goto 900
C
300	call errset(64,,,,.true.,)
	goto 999
c
900	if(qvtmd) goto 999
c
	call askerr(ipoint)
	goto 50
c
999	iskfio = ipoint
c
	return
C
C
	end
                                                            