#include "stdio.h"	/* RETRN2.C  RECOVER FILES FROM TAPE */
int blkf;		/* blkf= blocking factor */
int chan ;		/* chan= tape channel number */
char buf[20][512];	/* buf= data buffer array */
int *bpt;		/* bpt= pointer to buffer buf */
char pfn[15], date[12];	/* pfn= current file name */
			/* date= file creation date */
int size,blk,sub;	/* size= file size in disk blocks */
			/* blk= location .. tope block number */
			/* sub= location .. tape sub block */
int tblk,rec;		/* tblk= current tape block location */
			/* rec= number blocks skipped */



main()
{	FILE *fopen(), *fp;
	int err;
	char line[50];
	int nfiles, nrec, nfail;
	nfiles=0; nrec=0; nfail=0;

	bpt=buf[0];
	tblk=0;
	blkf=20;
	
	printf("FILE RECOVERY ...\n");
	printf("BUSINESS ANALYSIS TAPE BACKUP SYSTEM \n\n");

	/* open tape channel */
	if(magtpe(1)==-1) exit();

	/* skip over tapes directory file */
	rec=0;
	if(magtpe(7)==-1) exit();

	/* open directory file ..conrtains pfn names and locations */
	fp=fopen("dk:backup.get","rn");

	/* get file names, sizes, and locations */
	while(fgetss(line,42,fp)!=NULL)
	{	err=sscanf(line,"%14s%5d%5d-%2d%9s",pfn,&size,&blk,&sub,date);
		if(err<0)break;
		err=gtfile();
		nfiles++;
		if(err==0)nrec++; else nfail++;
	}
	magtpe(2);
	printf("\nSUMMARY OF FILES RECOVERED ....\n\n");
	printf("     %5d files recovered correctly\n",nrec);
	printf("     %5d files NOT recovered correctly\n",nfail);
	printf("     -----\n     %5d TOTAL number files",nfiles);
}

magtpe(fun)	/* MAGNETIC TAPE HANDLER */
int fun;	/* fun= function called */
{
	extern int ispfnw(),igetc(),lookup(),iaddr();	/* special functions */
	int code, err, ddev[4], wcnt, eblk[4];
	int erradr;
	char *dev ;

	dev="mt0" ;
	ascr50(3,dev,&ddev[0]);	/* define lookup pfn */
	eblk[0]=0; eblk[1]=0; eblk[2]=0; eblk[3]=0;
	erradr=call(iaddr,1,eblk);

	/* WHAT FUNCTION HAS BEEN CHOSEN */
	if(fun==1)	/* open channel */
	{	if((chan=call(igetc,0))==-1)
		{	printf("TAPE CHANNEL NOT OPENED \n"); return(-1);}
		else
		{	if((err=call(lookup,2,&chan,ddev))!=0)
			{	printf("LOOKUP ERROR : %d\n",err); return(-1);}
			else return(0);
		}
	}
	else if(fun==2)	/* rewind tape */
	{	code='\373';
		if((err=call(ispfnw,2,&code,&chan))!=0)
		{	printf("REWIND ERROR : %d\n",err); return(-1);}
		else return(0);
	}
	else if(fun==6)	/* read tape block */
	{	code='\370'; wcnt=256*blkf;
		if((err=call(ispfnw,5,&code,&chan,&wcnt,buf[0],&erradr))>2)
		{	printf("TAPE READ ERROR: %d %d %d\n",err,eblk[0],eblk[1]);
			return(-1);
		}
		if(err==2)
		{	if(eblk[0]==6){	blkf=(wcnt-eblk[1])/256; return(0);}
			else
			{	printf("HARD TAPE ERROR : %d %d \n",eblk[0],eblk[1]);
				return(-1);
			}
		}
		if(err==1){printf("READ PAST EOF ***\n"); return(-1);}
		return(0);
	}	
	else if(fun==7)	/* skip foward 'rec' blocks */
	{	code='\376';
		if((err=call(ispfnw,5,&code,&chan,&rec,buf[0],&erradr))>1)
		{	printf("SKIP FORWARD ERROR : %d\n",err); return(-1);}
		else return(0);
	}
	else if(fun==8)	/* skip backward 'rec' blocks */
	{	code='\375';
		if((err=call(ispfnw,5,&code,&chan,&rec,bpt,&erradr))!=0)
		{	printf("SKIP BACKWARD ERROR : %d\n",err); return(-1);}
		else return(0);
	}
	else{	printf("BAD magtpe() CALL!!!\n"); return(-1);}
}

gtfile()	/* GET FILE FROM TAPE */
{
	int nblks, loc, amt, wcnt;	/* nblks= file size on tape block */
					/* loc= current sub-block location */
					/* amt= max amount of file on block */
					/* wcnt= words to be written to disk */
	FILE *fopen(),*fpt;
	int bcnt, err, err1;		/* bcnt= block count for 'iwritw()' */
	int ichn;			/* ichn= RT11 channel number */
	extern int iwritw();

	/* OPEN FILE TO BE RESTORED */

	if((fpt=fopen(pfn,"rn"))!=NULL)
	{
	bcnt=0;
	ichn=flun(fpt);

	/* WHERE IS THE FILE LOCATED ON THE TAPE */
	
	if(tblk<blk)		/* must skip forward to find file */
	{	rec=blk-tblk;
		if(magtpe(7)==-1) return(-1);
		tblk=blk;
	}
	else if(tblk>blk)	/* must skip backward to find file */
	{	rec=tblk-blk;
		/* IF rec=1 .. then info is on last block read */
		/*          .. need not reread block */
		err=0;
		if(rec==1)rec=-1;	else err=magtpe(8);
		if(err==-1)return(-1);
		tblk=blk;
	}

	/* READY TO READ TAPE BLOCK .. FILE SHOULD BE HERE */

	nblks=size;
	loc=sub;
	while(nblks>0)	/* must read until file is completely read */
	{
		/* read block only if rec!=1 */
		if(rec>=0)err1=magtpe(6);
		if(err1!=-1)
		{
		tblk++;
		rec=0;
		amt=blkf-loc;		/* how much could be on this block */

		if(amt>=nblks)		/* remainder on this block */
		{	wcnt=256*nblks;
			nblks=0;
		}
		else 			/* only part on this block */
		{	wcnt=256*amt;	/* remainder on blocks that follow */
			nblks-=amt;
		}

		/* write file to disk */
		bpt=buf[loc];
		loc=0;
		err=call(iwritw,4,&wcnt,bpt,&bcnt,&ichn);
		if(err<0)
		{	printf("DISK WRITE ERROR : %d\n",err); return(-1);}
		bpt=buf[0];
		bcnt+=wcnt/256;
		}
		else
		{	printf("*** TAPE READ ERROR !! in block %d\n",tblk);
			printf("     file '%s' not recovered correctly\n",pfn);
			printf("... must continue with next file ...\n\n");
			tblk++;
			fclose(fpt);
			return(-1);
		}
	}
	fclose(fpt);
	return(0);
	}
	else
	{
	printf("*** FILE '%-14s' not opened properly\n\n",pfn);
	return(-1);
	}
}
                                                                                                                                                                                                                                                                                                             